/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.model.clustering;

import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.zip.ZipFile;

public class ClusteringScatterplotSample {
    List<ClusteringScatterplotPoint> points;

    private static <T> Map<T, Integer> zipWithIndex(List<T> list) {
        HashMap<T, Integer> map = new HashMap<T, Integer>();
        int i = 0;
        for (T t : list) {
            map.put(t, i);
            ++i;
        }
        return map;
    }

    private static <T> List<T> parseEntryAs(ZipFile zip, String entry, Class<T> clazz) throws IOException {
        ArrayList<Object> res = new ArrayList<Object>();
        try (InputStream is = zip.getInputStream(zip.getEntry(entry));
             InputStreamReader isr = new InputStreamReader(is);
             BufferedReader reader = new BufferedReader(isr);){
            String line;
            while ((line = reader.readLine()) != null) {
                if (clazz.equals(String.class)) {
                    res.add(line);
                    continue;
                }
                if (clazz.equals(Double.class)) {
                    Double result;
                    try {
                        result = Double.parseDouble(line);
                    }
                    catch (NumberFormatException e) {
                        result = Double.NaN;
                    }
                    res.add(result);
                    continue;
                }
                if (clazz.equals(Integer.class)) {
                    res.add(Integer.parseInt(line));
                    continue;
                }
                throw new UnsupportedOperationException("Cannot parse zip entry of " + clazz.getName());
            }
        }
        return res;
    }

    public static ClusteringScatterplotSample build(String folder, String v1, String v2) throws IOException {
        ZipFile zip = new ZipFile(new File(folder, "scatter_sample.zip"));
        Map<String, Integer> h = ClusteringScatterplotSample.zipWithIndex(ClusteringScatterplotSample.parseEntryAs(zip, "header", String.class));
        Integer i1 = h.get(v1);
        Integer i2 = h.get(v2);
        if (i1 == null) {
            throw new NoSuchElementException("Could not find variable " + v1 + " in the scatterplot data.");
        }
        if (i2 == null) {
            throw new NoSuchElementException("Could not find variable " + v2 + " in the scatterplot data.");
        }
        List<Double> s1 = ClusteringScatterplotSample.parseEntryAs(zip, i1.toString(), Double.class);
        List<Double> s2 = ClusteringScatterplotSample.parseEntryAs(zip, i2.toString(), Double.class);
        List<String> clusters = ClusteringScatterplotSample.parseEntryAs(zip, "cluster", String.class);
        List<Integer> c2 = ClusteringScatterplotSample.parseEntryAs(zip, "c", Integer.class);
        zip.close();
        if (s1.size() != s2.size() || s1.size() != clusters.size() || s1.size() != c2.size()) {
            throw new IOException("Invalid scatter sample format, columns had different lenghts.");
        }
        ArrayList<ClusteringScatterplotPoint> points = new ArrayList<ClusteringScatterplotPoint>();
        for (int i = 0; i < s1.size(); ++i) {
            Double x = s1.get(i);
            Double y = s2.get(i);
            if (Double.isNaN(x) || Double.isNaN(y)) continue;
            ClusteringScatterplotPoint point = new ClusteringScatterplotPoint();
            point.x = x;
            point.y = y;
            point.cluster = clusters.get(i);
            point.c = c2.get(i);
            points.add(point);
        }
        ClusteringScatterplotSample sample = new ClusteringScatterplotSample();
        sample.points = points;
        return sample;
    }

    private static void writeStringsAsJson(String fieldName, List<String> values, Writer writer, boolean first) throws IOException {
        if (!first) {
            writer.write(",");
        }
        writer.write(JSON.json((Object)fieldName));
        writer.write(":");
        writer.write(JSON.json(values));
    }

    private static void writeIntegersAsJson(String fieldName, List<Integer> values, Writer writer, boolean first) throws IOException {
        if (!first) {
            writer.write(",");
        }
        writer.write(JSON.json((Object)fieldName));
        writer.write(":");
        writer.write(JSON.json(values));
    }

    private static void writeDoublesAsJson(String fieldName, List<Double> values, Writer writer, boolean first) throws IOException {
        if (!first) {
            writer.write(",");
        }
        writer.write(JSON.json((Object)fieldName));
        writer.write(":");
        ArrayList clean = Lists.newArrayList();
        for (Double d : values) {
            if (d != null && (Double.isNaN(d) || Double.isInfinite(d))) {
                clean.add(null);
                continue;
            }
            clean.add(d);
        }
        writer.write(JSON.json((Object)clean));
    }

    public static void streamAsJson(String folder, Writer writer) throws IOException {
        writer.write("{");
        try (ZipFile zip = new ZipFile(new File(folder, "scatter_sample.zip"));){
            List<String> clusters = ClusteringScatterplotSample.parseEntryAs(zip, "cluster", String.class);
            ClusteringScatterplotSample.writeStringsAsJson("cluster", clusters, writer, true);
            List<Integer> c2 = ClusteringScatterplotSample.parseEntryAs(zip, "c", Integer.class);
            ClusteringScatterplotSample.writeIntegersAsJson("c", c2, writer, false);
            Map<String, Integer> h = ClusteringScatterplotSample.zipWithIndex(ClusteringScatterplotSample.parseEntryAs(zip, "header", String.class));
            writer.write(",\"features\":{");
            boolean firstFeature = true;
            for (Map.Entry<String, Integer> header : h.entrySet()) {
                List<Double> feature = ClusteringScatterplotSample.parseEntryAs(zip, header.getValue().toString(), Double.class);
                ClusteringScatterplotSample.writeDoublesAsJson(header.getKey(), feature, writer, firstFeature);
                firstFeature = false;
            }
            writer.write("}");
            writer.write("}");
        }
    }

    public static class ClusteringScatterplotPoint {
        public double x;
        public double y;
        public int c;
        public String cluster;
    }

    public static class FullClusteringScatter {
        List<String> header;
        List<FullClusteringScatterPoint> scatter_points;

        public ClusteringScatterplotSample extract(String variable1, String variable2) {
            ArrayList points = Lists.newArrayList();
            if (!this.scatter_points.isEmpty()) {
                int i = this.header.indexOf(variable1);
                int j = this.header.indexOf(variable2);
                if (i < 0) {
                    throw new NoSuchElementException("Could not find variable " + variable1 + " in the scatterplot data.");
                }
                if (j < 0) {
                    throw new NoSuchElementException("Could not find variable " + variable2 + " in the scatterplot data.");
                }
                for (FullClusteringScatterPoint point : this.scatter_points) {
                    ClusteringScatterplotPoint pt = new ClusteringScatterplotPoint();
                    pt.c = point.c;
                    pt.cluster = point.cluster;
                    pt.x = point.values.get(i);
                    pt.y = point.values.get(j);
                    points.add(pt);
                }
            }
            ClusteringScatterplotSample sample = new ClusteringScatterplotSample();
            sample.points = points;
            return sample;
        }

        public static class FullClusteringScatterPoint {
            public String cluster;
            public int c;
            public List<Double> values;
        }
    }
}

