/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.model.prediction;

import com.dataiku.dip.analysis.model.CompatibilityWithReason;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.prediction.CalibrationParams;
import com.dataiku.dip.analysis.model.prediction.ResolvedPredictionPreprocessingParams;
import com.dataiku.dip.analysis.model.preprocessing.CatFeaturePreprocessingParams;
import com.dataiku.dip.analysis.model.preprocessing.FeatureGenerationParams;
import com.dataiku.dip.analysis.model.preprocessing.FeaturePreprocessingParams;
import com.dataiku.dip.analysis.model.preprocessing.NumFeaturePreprocessingParams;
import com.dataiku.dip.analysis.model.preprocessing.TabularPredictionPreprocessingParams;
import com.dataiku.dip.analysis.model.preprocessing.TextFeaturePreprocessingParams;
import com.dataiku.dip.analysis.model.preprocessing.VectorFeaturePreprocessingParams;
import java.util.Map;

public class ResolvedClassicalPredictionPreprocessingParams
extends ResolvedPredictionPreprocessingParams {
    public TabularPredictionPreprocessingParams.FeatureSelectionParams feature_selection_params = new TabularPredictionPreprocessingParams.FeatureSelectionParams();
    public double preprocessingFitSampleRatio = 1.0;
    public long preprocessingFitSampleSeed = 1337L;

    private String getJavaIncompatibility(FeaturePreprocessingParams p, MLTask.BackendType backendType) {
        if (p.role != FeaturePreprocessingParams.Role.INPUT) {
            return null;
        }
        switch (p.type) {
            case NUMERIC: {
                NumFeaturePreprocessingParams num = (NumFeaturePreprocessingParams)p;
                if (num.numerical_handling == NumFeaturePreprocessingParams.NumericalHandlingMethod.QUANTILE_BIN) {
                    return "Quantization of numeric input into bins";
                }
                if (num.numerical_handling != NumFeaturePreprocessingParams.NumericalHandlingMethod.CUSTOM) break;
                return "Custom handling of numeric input";
            }
            case CATEGORY: {
                CatFeaturePreprocessingParams cat = (CatFeaturePreprocessingParams)p;
                if (cat.category_handling == CatFeaturePreprocessingParams.CategoryHandlingMethod.DUMMIFY || cat.category_handling == CatFeaturePreprocessingParams.CategoryHandlingMethod.FLAG_PRESENCE || cat.category_handling == CatFeaturePreprocessingParams.CategoryHandlingMethod.IMPACT || cat.category_handling == CatFeaturePreprocessingParams.CategoryHandlingMethod.ORDINAL || cat.category_handling == CatFeaturePreprocessingParams.CategoryHandlingMethod.FREQUENCY) break;
                return "Categorical handled other than dummify, flag presence, impact coding, ordinal, frequency";
            }
            case VECTOR: {
                VectorFeaturePreprocessingParams vec = (VectorFeaturePreprocessingParams)p;
                if (vec.vector_handling == VectorFeaturePreprocessingParams.VectorHandlingMethod.UNFOLD) break;
                return "Vector handling other than unfold";
            }
            case IMAGE: {
                return "Image input";
            }
            case TEXT: {
                TextFeaturePreprocessingParams text = (TextFeaturePreprocessingParams)p;
                if (backendType == MLTask.BackendType.PY_MEMORY) {
                    if (text.text_handling == TextFeaturePreprocessingParams.TextHandlingMethod.TOKENIZE_HASHING || text.text_handling == TextFeaturePreprocessingParams.TextHandlingMethod.TOKENIZE_HASHING_SVD) {
                        return "Text handling uses hashing on a Python model";
                    }
                    if (text.text_handling == TextFeaturePreprocessingParams.TextHandlingMethod.SENTENCE_EMBEDDING) {
                        return "Text handling uses text embedding";
                    }
                    if (text.text_handling != TextFeaturePreprocessingParams.TextHandlingMethod.CUSTOM) break;
                    return "Custom handling of text input";
                }
                if (backendType.isSparkBased()) {
                    if (text.text_handling == TextFeaturePreprocessingParams.TextHandlingMethod.TOKENIZE_HASHING) break;
                    return "Text handling other than tokenize + hash on a MLlib model";
                }
                return "Backend is not supported: " + String.valueOf((Object)backendType);
            }
            default: {
                return "Unsupported feature type: " + String.valueOf((Object)p.type);
            }
        }
        return null;
    }

    public CompatibilityWithReason getJavaCompatibility(MLTask.BackendType backendType) {
        if (backendType == MLTask.BackendType.VERTICA || backendType == MLTask.BackendType.KERAS) {
            return CompatibilityWithReason.nok("Model backend not supported: " + String.valueOf((Object)backendType));
        }
        if (this.feature_generation.pairwise_linear.behavior != FeatureGenerationParams.GeneratorBehavior.DISABLED || this.feature_generation.polynomial_combinations.behavior != FeatureGenerationParams.GeneratorBehavior.DISABLED) {
            return CompatibilityWithReason.nok("Preprocessing has generated combination features");
        }
        if (this.reduce.enabled) {
            return CompatibilityWithReason.nok("Dimensionality reduction activated");
        }
        for (Map.Entry p : this.per_feature.entrySet()) {
            String reason = this.getJavaIncompatibility((FeaturePreprocessingParams)p.getValue(), backendType);
            if (reason == null) continue;
            return CompatibilityWithReason.nok("Feature '" + (String)p.getKey() + "' cannot be preprocessed in Java (" + reason + ")");
        }
        return CompatibilityWithReason.ok();
    }

    private String getSQLIncompatibility(FeaturePreprocessingParams p) {
        if (p.role != FeaturePreprocessingParams.Role.INPUT) {
            return null;
        }
        switch (p.type) {
            case NUMERIC: {
                NumFeaturePreprocessingParams num = (NumFeaturePreprocessingParams)p;
                if (num.numerical_handling == NumFeaturePreprocessingParams.NumericalHandlingMethod.QUANTILE_BIN) {
                    return "Quantization of numeric input into bins";
                }
                if (num.numerical_handling == NumFeaturePreprocessingParams.NumericalHandlingMethod.CUSTOM) {
                    return "Custom handling of numeric input";
                }
                if (num.generate_derivative) {
                    return "Numeric derivatives";
                }
                if (num.missing_handling != NumFeaturePreprocessingParams.MissingHandlingMethod.KEEP_NAN_OR_DROP && num.missing_handling != NumFeaturePreprocessingParams.MissingHandlingMethod.KEEP_NAN_OR_IMPUTE) break;
                return "Numerical with non-imputed missing values";
            }
            case CATEGORY: {
                CatFeaturePreprocessingParams cat = (CatFeaturePreprocessingParams)p;
                if (cat.category_handling == CatFeaturePreprocessingParams.CategoryHandlingMethod.DUMMIFY || cat.category_handling == CatFeaturePreprocessingParams.CategoryHandlingMethod.FLAG_PRESENCE || cat.category_handling == CatFeaturePreprocessingParams.CategoryHandlingMethod.IMPACT || cat.category_handling == CatFeaturePreprocessingParams.CategoryHandlingMethod.ORDINAL || cat.category_handling == CatFeaturePreprocessingParams.CategoryHandlingMethod.FREQUENCY) break;
                return "Categorical handled other than dummify, flag presence, impact coding, ordinal, frequency";
            }
            default: {
                return "Unsupported input type " + String.valueOf((Object)p.type);
            }
        }
        return null;
    }

    public CompatibilityWithReason getSQLCompatibility(MLTask.BackendType backendType, CalibrationParams calibration) {
        CompatibilityWithReason javaCompat = this.getJavaCompatibility(backendType);
        if (!javaCompat.compatible) {
            return CompatibilityWithReason.nok("Not compatible with optimized scoring: " + javaCompat.reason);
        }
        if (this.feature_generation.pairwise_linear.behavior != FeatureGenerationParams.GeneratorBehavior.DISABLED || this.feature_generation.polynomial_combinations.behavior != FeatureGenerationParams.GeneratorBehavior.DISABLED) {
            return CompatibilityWithReason.nok("Preprocessing has generated combination features");
        }
        if (this.reduce.enabled) {
            return CompatibilityWithReason.nok("Dimensionality reduction activated");
        }
        if (calibration.isEnabled()) {
            return CompatibilityWithReason.nok("Calibration is activated");
        }
        if (this.feature_selection_params.method == TabularPredictionPreprocessingParams.FeatureSelectionMethod.PCA) {
            return CompatibilityWithReason.nok("PCA feature selection activated");
        }
        for (Map.Entry p : this.per_feature.entrySet()) {
            String reason = this.getSQLIncompatibility((FeaturePreprocessingParams)p.getValue());
            if (reason == null) continue;
            return CompatibilityWithReason.nok("Feature '" + (String)p.getKey() + "' cannot be preprocessed in SQL (" + reason + ")");
        }
        return CompatibilityWithReason.ok();
    }

    private String getPMMLIncompatibility(FeaturePreprocessingParams p) {
        if (p.role != FeaturePreprocessingParams.Role.INPUT) {
            return null;
        }
        switch (p.type) {
            case NUMERIC: {
                NumFeaturePreprocessingParams num = (NumFeaturePreprocessingParams)p;
                if (num.numerical_handling != NumFeaturePreprocessingParams.NumericalHandlingMethod.REGULAR) {
                    return "Numerical handling other than regular";
                }
                if (num.generate_derivative) {
                    return "Numerical derived features";
                }
                if (num.missing_handling == NumFeaturePreprocessingParams.MissingHandlingMethod.DROP_ROW) {
                    return "Numerical with missing handling drop rows";
                }
                if (num.missing_handling != NumFeaturePreprocessingParams.MissingHandlingMethod.KEEP_NAN_OR_DROP && num.missing_handling != NumFeaturePreprocessingParams.MissingHandlingMethod.KEEP_NAN_OR_IMPUTE) break;
                return "Numerical with non-imputed missing values";
            }
            case CATEGORY: {
                CatFeaturePreprocessingParams cat = (CatFeaturePreprocessingParams)p;
                if (cat.category_handling != CatFeaturePreprocessingParams.CategoryHandlingMethod.DUMMIFY && cat.category_handling != CatFeaturePreprocessingParams.CategoryHandlingMethod.IMPACT && cat.category_handling != CatFeaturePreprocessingParams.CategoryHandlingMethod.ORDINAL && cat.category_handling != CatFeaturePreprocessingParams.CategoryHandlingMethod.FREQUENCY) {
                    return "Categorical handling other than dummify, impact coding, ordinal or frequency";
                }
                if (cat.missing_handling != CatFeaturePreprocessingParams.MissingHandlingMethod.DROP_ROW) break;
                return "Categorical with missing handling drop rows";
            }
            default: {
                return "Unsupported input type " + String.valueOf((Object)p.type);
            }
        }
        return null;
    }

    public CompatibilityWithReason getPMMLCompatibility(MLTask.BackendType backendType, CalibrationParams calibration) {
        CompatibilityWithReason javaCompat = this.getJavaCompatibility(backendType);
        if (!javaCompat.compatible) {
            return CompatibilityWithReason.nok(javaCompat.reason);
        }
        if (this.feature_generation.pairwise_linear.behavior != FeatureGenerationParams.GeneratorBehavior.DISABLED || this.feature_generation.polynomial_combinations.behavior != FeatureGenerationParams.GeneratorBehavior.DISABLED) {
            return CompatibilityWithReason.nok("Preprocessing has generated combination features");
        }
        if (this.reduce.enabled) {
            return CompatibilityWithReason.nok("Dimensionality reduction activated");
        }
        if (calibration.isEnabled()) {
            return CompatibilityWithReason.nok("Calibration is activated");
        }
        for (Map.Entry p : this.per_feature.entrySet()) {
            String reason = this.getPMMLIncompatibility((FeaturePreprocessingParams)p.getValue());
            if (reason == null) continue;
            return CompatibilityWithReason.nok("Feature '" + (String)p.getKey() + "' cannot be preprocessed in PMML (" + reason + ")");
        }
        return CompatibilityWithReason.ok();
    }

    private String getPythonIncompatibility(FeaturePreprocessingParams p, MLTask.BackendType backendType) {
        if (p.role != FeaturePreprocessingParams.Role.INPUT) {
            return null;
        }
        switch (p.type) {
            case NUMERIC: {
                NumFeaturePreprocessingParams num = (NumFeaturePreprocessingParams)p;
                if (num.numerical_handling == NumFeaturePreprocessingParams.NumericalHandlingMethod.QUANTILE_BIN) {
                    return "Quantization of numeric input into bins";
                }
                if (num.numerical_handling != NumFeaturePreprocessingParams.NumericalHandlingMethod.CUSTOM) break;
                return "Custom handling of numeric input";
            }
            case CATEGORY: {
                CatFeaturePreprocessingParams cat = (CatFeaturePreprocessingParams)p;
                if (cat.category_handling == CatFeaturePreprocessingParams.CategoryHandlingMethod.DUMMIFY || cat.category_handling == CatFeaturePreprocessingParams.CategoryHandlingMethod.FLAG_PRESENCE || cat.category_handling == CatFeaturePreprocessingParams.CategoryHandlingMethod.IMPACT || cat.category_handling == CatFeaturePreprocessingParams.CategoryHandlingMethod.ORDINAL || cat.category_handling == CatFeaturePreprocessingParams.CategoryHandlingMethod.FREQUENCY) break;
                return "Categorical handled other than dummify, flag presence, impact coding, ordinal, frequency";
            }
            case VECTOR: {
                VectorFeaturePreprocessingParams vec = (VectorFeaturePreprocessingParams)p;
                if (vec.vector_handling == VectorFeaturePreprocessingParams.VectorHandlingMethod.UNFOLD) break;
                return "Vector handling other than unfold";
            }
            case IMAGE: {
                return "Image input";
            }
            case TEXT: {
                TextFeaturePreprocessingParams text = (TextFeaturePreprocessingParams)p;
                if (backendType == MLTask.BackendType.PY_MEMORY) {
                    if (text.text_handling == TextFeaturePreprocessingParams.TextHandlingMethod.TOKENIZE_HASHING || text.text_handling == TextFeaturePreprocessingParams.TextHandlingMethod.TOKENIZE_HASHING_SVD) {
                        return "Text handling uses hashing on a Python model";
                    }
                    if (text.text_handling == TextFeaturePreprocessingParams.TextHandlingMethod.SENTENCE_EMBEDDING) {
                        return "Text handling uses text embedding";
                    }
                    if (text.text_handling != TextFeaturePreprocessingParams.TextHandlingMethod.CUSTOM) break;
                    return "Custom handling of text input";
                }
                if (backendType.isSparkBased()) {
                    if (text.text_handling == TextFeaturePreprocessingParams.TextHandlingMethod.TOKENIZE_HASHING) break;
                    return "Text handling other than tokenize + hash on a MLlib model";
                }
                return "Backend is not supported: " + String.valueOf((Object)backendType);
            }
            default: {
                return "Unsupported feature type: " + String.valueOf((Object)p.type);
            }
        }
        return null;
    }

    private static String getPythonApiNodeScoreIncompatibility(FeaturePreprocessingParams p) {
        if (p.role != FeaturePreprocessingParams.Role.INPUT) {
            return null;
        }
        switch (p.type) {
            case TEXT: {
                TextFeaturePreprocessingParams textPreprocessing = (TextFeaturePreprocessingParams)p;
                if (!TextFeaturePreprocessingParams.TextHandlingMethod.SENTENCE_EMBEDDING.equals((Object)textPreprocessing.text_handling) || !textPreprocessing.isStructuredRef) break;
                return "Text embedding preprocessing using connections cannot be used on the API nodes";
            }
            case NUMERIC: 
            case CATEGORY: 
            case VECTOR: 
            case IMAGE: {
                break;
            }
            default: {
                return "Unsupported feature type: " + String.valueOf((Object)p.type);
            }
        }
        return null;
    }

    public CompatibilityWithReason getPythonApiNodeScoreCompatibility() {
        for (Map.Entry p : this.per_feature.entrySet()) {
            String reason = ResolvedClassicalPredictionPreprocessingParams.getPythonApiNodeScoreIncompatibility((FeaturePreprocessingParams)p.getValue());
            if (reason == null) continue;
            return CompatibilityWithReason.nok("Feature '" + (String)p.getKey() + "' is not compatible with Python scoring on API nodes (" + reason + ")");
        }
        return CompatibilityWithReason.ok();
    }

    public CompatibilityWithReason getPythonCompatibility(MLTask.BackendType backendType) {
        if (backendType == MLTask.BackendType.VERTICA || backendType == MLTask.BackendType.KERAS) {
            return CompatibilityWithReason.nok("Model backend not supported: " + String.valueOf((Object)backendType));
        }
        if (this.feature_generation.pairwise_linear.behavior != FeatureGenerationParams.GeneratorBehavior.DISABLED || this.feature_generation.polynomial_combinations.behavior != FeatureGenerationParams.GeneratorBehavior.DISABLED) {
            return CompatibilityWithReason.nok("Preprocessing has generated combination features");
        }
        if (this.reduce.enabled) {
            return CompatibilityWithReason.nok("Dimensionality reduction activated");
        }
        for (Map.Entry p : this.per_feature.entrySet()) {
            String reason = this.getPythonIncompatibility((FeaturePreprocessingParams)p.getValue(), backendType);
            if (reason == null) continue;
            return CompatibilityWithReason.nok("Feature '" + (String)p.getKey() + "' cannot be preprocessed in Python (" + reason + ")");
        }
        return CompatibilityWithReason.ok();
    }
}

