/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.model.prediction.algorithms.python;

import com.dataiku.dip.analysis.model.ModelTrainInfo;
import com.dataiku.dip.analysis.model.core.WorkSet;
import com.dataiku.dip.analysis.model.prediction.CategoricalHyperparameterDimension;
import com.dataiku.dip.analysis.model.prediction.PostTrainPredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.PreTrainPredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.analysis.model.prediction.PredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.PredictionParameterChecks;
import com.dataiku.dip.analysis.model.prediction.algorithms.python.PyMemoryAlgorithmMeta;
import java.util.Collections;
import java.util.List;

public class GluonTSMXNetTransformerMeta
extends PyMemoryAlgorithmMeta {
    @Override
    public String generateName(PreTrainPredictionModelingParams rpmp) {
        return "Transformer";
    }

    @Override
    public ModelTrainInfo.PreSearchDescription generatePreTrainDescription(PreTrainPredictionModelingParams rpmp) {
        PredictionModelingParams.GluonTSMXNetTransformerSpace space = rpmp.gluonts_transformer_timeseries_grid;
        ModelTrainInfo.PreSearchDescription description = new ModelTrainInfo.PreSearchDescription(rpmp).withGridLength(this.getSearchSize(rpmp.grid_search_params, space)).withMVParam("Learning rate", space.learning_rate).withMVParam("Output distribution", space.distr_output).withMVParam("Transformer network dimension", space.model_dim).withMVParam("Hidden layer dimension scale", space.inner_ff_dim_scale).withMVParam("Nb. heads in multi-head attention", space.num_heads).withMVParam("Dropout rate", space.dropout_rate);
        if (!space.full_context) {
            description = description.withMVParam("Context length", space.context_length);
        }
        return description;
    }

    @Override
    public ModelTrainInfo.PostSearchDescription generatePostTrainDescription(ModelTrainInfo.PreSearchDescription descBefore, PreTrainPredictionModelingParams before, PostTrainPredictionModelingParams after) {
        PredictionModelingParams.GluonTSMXNetTransformerSpace space = before.gluonts_transformer_timeseries_grid;
        PostTrainPredictionModelingParams.GluonTSMXNetTransformerParams params = after.gluonts_transformer_timeseries_params;
        ModelTrainInfo.PostSearchDescription description = new ModelTrainInfo.PostSearchDescription().withSVParam("Learning rate", params.learning_rate).withSVParam("Output distribution", params.distr_output).withSVParam("Transformer network dimension", params.model_dim).withSVParam("Hidden layer dimension scale", params.inner_ff_dim_scale).withSVParam("Nb. heads in multi-head attention", params.num_heads).withSVParam("Epochs", params.epochs);
        if (!space.full_context) {
            description = description.withSVParam("Context length", params.context_length);
        }
        return description;
    }

    @Override
    public void validateParameters(PredictionModelingParams pmp, PredictionMLTask.TabularPredictionMLTask task, PredictionParameterChecks checks) {
        PredictionModelingParams.GluonTSMXNetTransformerSpace space = pmp.gluonts_transformer_timeseries;
        if (space == null || !space.enabled) {
            return;
        }
        checks.checkPositive(space.distr_output.getLength(), "At least one output distribution must be selected (Transformer)");
        if (!space.full_context) {
            checks.checkNumericalDimension(space.context_length, "Context length (Transformer)");
        }
        checks.checkNumericalDimension(space.learning_rate, "Learning rate (Transformer)");
        checks.checkNumericalDimension(space.model_dim, "Dimension of the transformer network (Transformer)");
        checks.checkNumericalDimension(space.inner_ff_dim_scale, "Dimension scale of the inner hidden layer of the transformer's feedforward network (Transformer)");
        checks.checkNumericalDimension(space.num_heads, "Number of heads in the multi-head attention (Transformer)");
        checks.checkNumericalDimension(space.dropout_rate, "Dropout regularization parameter (Transformer)");
    }

    @Override
    public List<WorkSet.ModelingSet> expandModeling(PredictionModelingParams pmp, PredictionMLTask.TabularPredictionMLTask task, int gsFolds) {
        PredictionModelingParams.GluonTSMXNetTransformerSpace space = pmp.gluonts_transformer_timeseries;
        if (space == null || !space.enabled) {
            return Collections.emptyList();
        }
        PreTrainPredictionModelingParams preTrainParams = new PreTrainPredictionModelingParams(PreTrainPredictionModelingParams.Algorithm.GLUONTS_TRANSFORMER, pmp);
        preTrainParams.gluonts_transformer_timeseries_grid = space;
        this.checkAndUpdateSearchStrategy(pmp, preTrainParams);
        preTrainParams.gridLength = this.getSearchSize(preTrainParams.grid_search_params, space);
        WorkSet.ModelingSet modelingSet = new WorkSet.ModelingSet(preTrainParams);
        if (preTrainParams.gridLength > 1) {
            modelingSet.estimatedTrains = preTrainParams.gridLength * gsFolds + 1;
        }
        return Collections.singletonList(modelingSet);
    }

    @Override
    public PreTrainPredictionModelingParams regridifyToPreTrain(PostTrainPredictionModelingParams optimized, PreTrainPredictionModelingParams usedToTrain) {
        PostTrainPredictionModelingParams.GluonTSMXNetTransformerParams optimizedParameters = optimized.gluonts_transformer_timeseries_params;
        PreTrainPredictionModelingParams preTrainParams = this.getCopyWithGridStrategy(usedToTrain);
        PredictionModelingParams.GluonTSMXNetTransformerSpace space = preTrainParams.gluonts_transformer_timeseries_grid;
        if (!preTrainParams.gluonts_transformer_timeseries_grid.full_context) {
            space.context_length.setToSingleValueGrid(optimizedParameters.context_length);
        }
        space.learning_rate.setToSingleValueGrid(optimizedParameters.learning_rate);
        space.distr_output = CategoricalHyperparameterDimension.create(optimizedParameters.distr_output, "StudentTOutput", "GaussianOutput", "NegativeBinomialOutput");
        space.model_dim.setToSingleValueGrid(optimizedParameters.model_dim);
        space.inner_ff_dim_scale.setToSingleValueGrid(optimizedParameters.inner_ff_dim_scale);
        space.num_heads.setToSingleValueGrid(optimizedParameters.num_heads);
        space.dropout_rate.setToSingleValueGrid(optimizedParameters.dropout_rate);
        return preTrainParams;
    }

    @Override
    public void regridifyToMLTask(PredictionModelingParams target, PostTrainPredictionModelingParams optimized, PreTrainPredictionModelingParams usedToTrain) {
        PreTrainPredictionModelingParams preTrainParams = this.regridifyToPreTrain(optimized, usedToTrain);
        target.gluonts_transformer_timeseries = preTrainParams.gluonts_transformer_timeseries_grid;
        target.gluonts_transformer_timeseries.enabled = true;
    }

    @Override
    public void refreshMLTask(PredictionModelingParams target, PreTrainPredictionModelingParams usedToTrain) {
        target.gluonts_transformer_timeseries = usedToTrain.gluonts_transformer_timeseries_grid;
        target.gluonts_transformer_timeseries.enabled = true;
    }

    @Override
    public boolean hasProbabilities(PreTrainPredictionModelingParams rpmp) {
        return true;
    }

    @Override
    protected int getGridLength(PredictionModelingParams.HyperparametersSpace space) {
        PredictionModelingParams.GluonTSMXNetTransformerSpace gluonTSMXNetTransformerSpace = (PredictionModelingParams.GluonTSMXNetTransformerSpace)space;
        int gridLength = gluonTSMXNetTransformerSpace.learning_rate.getLength() * gluonTSMXNetTransformerSpace.model_dim.getLength() * gluonTSMXNetTransformerSpace.distr_output.getLength() * gluonTSMXNetTransformerSpace.inner_ff_dim_scale.getLength() * gluonTSMXNetTransformerSpace.num_heads.getLength() * gluonTSMXNetTransformerSpace.dropout_rate.getLength();
        if (!gluonTSMXNetTransformerSpace.full_context) {
            gridLength *= gluonTSMXNetTransformerSpace.context_length.getLength();
        }
        return gridLength;
    }

    @Override
    public PredictionModelingParams.GridSearchParams.Strategy getMaximumSupportedSearchStrategy() {
        return PredictionModelingParams.GridSearchParams.Strategy.RANDOM;
    }
}

