/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.apideployer.datamodel.actual.snowpark;

import com.dataiku.dip.apideployer.datamodel.config.SnowparkAPIDeployment;
import com.dataiku.dip.apideployer.datamodel.config.SnowparkAPIDeploymentInfra;
import com.dataiku.dip.apideployer.deployments.SnowparkDeploymentConfigManager;
import com.dataiku.dip.externalinfras.snowpark.datamodel.SnowparkDetailedService;
import com.dataiku.dip.externalinfras.snowpark.datamodel.SnowparkMachineConfig;
import com.dataiku.dip.variables.VariablesContext;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SnowparkDataModelBuilder {
    private SnowparkDataModelBuilder() {
    }

    @Nonnull
    public static SnowparkDetailedService buildDetailedService(@Nonnull SnowparkAPIDeployment deployment, @Nonnull SnowparkAPIDeploymentInfra infra, @Nonnull VariablesContext vc, @Nonnull String serviceName, @Nonnull String databaseName, @Nonnull String schemaName, @Nullable String containerImageUri) {
        String serviceId = deployment.basicInfoUnsafe().getDeployedItemId();
        String healthUrl = String.format("/monitoring/api/%s/isAliveSimple", serviceId);
        SnowparkDeploymentConfigManager configManager = new SnowparkDeploymentConfigManager(deployment, infra, vc);
        SnowparkMachineConfig machineConfig = infra.machineConfig;
        Map<String, String> environmentVariables = configManager.getEnvironmentVariablesMap();
        return new SnowparkDetailedService(serviceName, databaseName, schemaName, infra.computePoolName, machineConfig.minInstances, machineConfig.maxInstances, environmentVariables, healthUrl, containerImageUri, infra.publicEndpoint, machineConfig.requests, machineConfig.limits, deployment.getEventTableLogLevel(infra));
    }
}

