/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.apideployer.deployments;

import com.dataiku.common.server.APIError;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.apideployer.DeployerCodes;
import com.dataiku.dip.apideployer.datamodel.actual.AbstractDeploymentBasicInfo;
import com.dataiku.dip.apideployer.datamodel.actual.AbstractDeploymentHeavyStatus;
import com.dataiku.dip.apideployer.datamodel.actual.AbstractDeploymentLightStatus;
import com.dataiku.dip.apideployer.datamodel.actual.AbstractInfraBasicInfo;
import com.dataiku.dip.apideployer.datamodel.actual.AbstractPublishedItemBasicInfo;
import com.dataiku.dip.apideployer.datamodel.actual.PublishedPackageInfo;
import com.dataiku.dip.apideployer.datamodel.config.AbstractDeployment;
import com.dataiku.dip.apideployer.datamodel.config.AbstractDeploymentInfra;
import com.dataiku.dip.apideployer.datamodel.config.PublishedItem;
import com.dataiku.dip.apideployer.deployments.AbstractPublishedPackageInfoForGovernIdentification;
import com.dataiku.dip.apideployer.deployments.DeploymentsDAO;
import com.dataiku.dip.apideployer.deployments.EmbeddedModelVersionIdentifier;
import com.dataiku.dip.apideployer.deployments.PublishedApiServicePackageInfoForGovernIdentification;
import com.dataiku.dip.apideployer.deployments.actions.DeploymentAction;
import com.dataiku.dip.apideployer.deployments.actions.DeploymentActionHandle;
import com.dataiku.dip.apideployer.deployments.actions.DeploymentActionsService;
import com.dataiku.dip.apideployer.deployments.actions.DeploymentUpdate;
import com.dataiku.dip.apideployer.deployments.actions.FullDeploymentUpdate;
import com.dataiku.dip.apideployer.deployments.actions.updates.DeploymentUpdateDiff;
import com.dataiku.dip.apideployer.deployments.actions.updates.DeploymentUpdateService;
import com.dataiku.dip.apideployer.infra.AbstractInfrasService;
import com.dataiku.dip.apideployer.infra.DeploymentInfrasDAO;
import com.dataiku.dip.apideployer.published.AbstractPublishedItemsService;
import com.dataiku.dip.apideployer.published.FileBasedPublishedItemsDAO;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.FutureThread;
import com.dataiku.dip.gh.GovernIntegrationCodes;
import com.dataiku.dip.gh.GovernIntegrationService;
import com.dataiku.dip.logging.AutoClosableAppenderWrapper;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.model.PublicUser;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.services.LogsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.SmartLogTail;
import com.dataiku.dss.shadelib.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.com.google.common.collect.Lists;
import com.dataiku.dss.shadelib.javax.annotation.Nonnull;
import com.dataiku.dss.shadelibgcp.com.google.api.client.util.IOUtils;
import com.dataiku.dss_gh.api.models.governance_status.DSSItemGovernanceStatus;
import com.dataiku.dss_gh.api.models.governance_status.DSSItemGovernanceStatusList;
import com.dataiku.dss_gh.api.models.governance_status.GovernanceStatus;
import com.dataiku.dss_gh.api.models.identifiers.DSSBundleIdentifier;
import com.dataiku.dss_gh.api.models.identifiers.DSSSavedModelVersionIdentifier;
import com.google.common.base.MoreObjects;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.directory.api.util.Strings;
import org.intellij.lang.annotations.PrintFormat;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractDeploymentsService<D extends AbstractDeployment, I extends AbstractPublishedItemBasicInfo, N extends AbstractDeploymentInfra> {
    @Autowired
    protected TransactionService transactionService;
    @Autowired
    protected UsersService usersService;
    @Autowired
    protected GovernIntegrationService governIntegrationService;
    @Autowired
    protected FutureService futureService;
    @Autowired
    protected DeploymentActionsService deploymentActionsService;
    @Autowired
    protected DeploymentUpdateService deploymentUpdateService;
    private static final String SYSTEM_METRICS_SUBFOLDER = "system-metrics";
    public static final String DEPLOYMENTS_SYSTEM_METRICS_PATH = "run/endpoint-activity-metrics/deployments";

    protected abstract DeploymentsDAO<D> getDeploymentDAO();

    protected abstract DeploymentInfrasDAO<N> getInfrasDAO();

    protected abstract AbstractPublishedItemsService<D, I, N> getPublishedItemsService();

    protected abstract AbstractInfrasService<D, I, N> getInfrasService();

    public abstract FileBasedPublishedItemsDAO getPublishedItemsDAO();

    protected abstract Set<String> getNeverEverDeployedSet();

    protected abstract void publishDeploymentConfigChangedEventAfterTransaction(String var1, String var2);

    protected abstract void publishDeploymentDeletedEventAfterTransaction(String var1, String var2);

    protected abstract void publishDeploymentCopiedEventAfterTransaction(String var1);

    abstract AbstractDeploymentBasicInfo getDeploymentBasicInfo(D var1) throws IOException;

    abstract List<? extends AbstractDeploymentBasicInfo> getDeploymentBasicInfoList(List<D> var1) throws IOException;

    protected void addAuthorsNames(AbstractDeploymentBasicInfo deploymentBasicInfo) throws IOException {
        PublicUser pu;
        if (deploymentBasicInfo.creationTag != null && StringUtils.isNotBlank((String)deploymentBasicInfo.creationTag.getLastAuthor()) && (pu = this.usersService.getPublicUser(deploymentBasicInfo.creationTag.getLastAuthor())) != null) {
            deploymentBasicInfo.createdByDisplayName = pu.displayName;
        }
        if (deploymentBasicInfo.versionTag != null && StringUtils.isNotBlank((String)deploymentBasicInfo.versionTag.getLastAuthor()) && (pu = this.usersService.getPublicUser(deploymentBasicInfo.versionTag.getLastAuthor())) != null) {
            deploymentBasicInfo.lastModifiedByDisplayName = pu.displayName;
        }
    }

    public Set<String> listTags() throws IOException {
        HashSet<String> tags = new HashSet<String>();
        for (AbstractDeployment depl : this.getDeploymentDAO().listUnsafe()) {
            if (depl.tags == null) continue;
            tags.addAll(depl.tags);
        }
        return tags;
    }

    public List<AbstractDeploymentLightStatus> listLightStatusUnsafe_NT_Check(AuthCtx authCtx) throws IOException {
        List allDeployments;
        ArrayList<AbstractDeploymentLightStatus> ret = new ArrayList<AbstractDeploymentLightStatus>();
        try (Transaction t = this.transactionService.beginRead();){
            allDeployments = this.getDeploymentDAO().listUnsafe();
        }
        HashMap<String, PublishedItem> publishedItemMap = new HashMap<String, PublishedItem>();
        HashMap<String, AbstractInfraBasicInfo> infraInfoMap = new HashMap<String, AbstractInfraBasicInfo>();
        HashMap<String, AbstractDeploymentInfra> infraMap = new HashMap<String, AbstractDeploymentInfra>();
        for (AbstractDeployment deployment : allDeployments) {
            try {
                PublishedItem publishedItem;
                AbstractDeploymentInfra infra;
                Transaction t;
                String publishedItemId = deployment.getPublishedItemId();
                if (!publishedItemMap.containsKey(publishedItemId)) {
                    PublishedItem item;
                    t = this.transactionService.beginRead();
                    try {
                        item = (PublishedItem)this.getPublishedItemsDAO().getMandatoryUnsafe(publishedItemId);
                    }
                    finally {
                        if (t != null) {
                            t.close();
                        }
                    }
                    publishedItemMap.put(publishedItemId, item);
                }
                if (!infraInfoMap.containsKey(deployment.infraId)) {
                    t = this.transactionService.beginRead();
                    try {
                        infra = (AbstractDeploymentInfra)this.getInfrasDAO().getMandatoryUnsafe(deployment.infraId);
                        infraInfoMap.put(deployment.infraId, this.getInfrasService().basicInfoUnsafe(infra));
                        infraMap.put(deployment.infraId, infra);
                    }
                    finally {
                        if (t != null) {
                            t.close();
                        }
                    }
                } else {
                    infra = (AbstractDeploymentInfra)infraMap.get(deployment.infraId);
                }
                if (!AbstractPublishedItemsService.hasReadPermission(publishedItem = (PublishedItem)publishedItemMap.get(publishedItemId), authCtx) || !AbstractInfrasService.hasReadPermission(infra, authCtx)) continue;
                I publishedItemBI = this.getPublishedItemsService().basicInfoUnsafe(publishedItem);
                List<PublishedPackageInfo> publishedPackageInfo = this.getPublishedItemsService().listPublishedPackages_Check_Unsafe_NT(publishedItemId, authCtx);
                AbstractInfraBasicInfo infraBI = (AbstractInfraBasicInfo)infraInfoMap.get(deployment.infraId);
                ret.add(this.getDeploymentLightStatus_NT(deployment, infraBI, publishedItemBI, publishedPackageInfo, AbstractDeploymentsService.hasFullDeployPermissions(infra, publishedItem, authCtx), AbstractInfrasService.hasAdminPermission(infra, authCtx)));
            }
            catch (Exception e) {
                this.getLogger().error((Object)("Failed to get deployment light status for " + deployment.id), (Throwable)e);
            }
        }
        return ret;
    }

    abstract AbstractDeploymentLightStatus getDeploymentLightStatus_NT(D var1, AbstractInfraBasicInfo var2, I var3, List<PublishedPackageInfo> var4, boolean var5, boolean var6) throws IOException;

    abstract AbstractDeploymentHeavyStatus getHeavyStatus_Unsafe_NT_Check(AuthCtx var1, String var2) throws Exception;

    public boolean hasDeploymentForItemAndPackageVersion(String publishedItemId, String packageId) throws IOException {
        for (AbstractDeployment depl : this.getDeploymentDAO().listUnsafe()) {
            if (!depl.hasPublishedItemAndPackageVersion(publishedItemId, packageId)) continue;
            return true;
        }
        return false;
    }

    public boolean hasDeploymentForItem(String publishedItemId) throws IOException {
        for (AbstractDeployment depl : this.getDeploymentDAO().listUnsafe()) {
            if (!depl.getPublishedItemId().equals(publishedItemId)) continue;
            return true;
        }
        return false;
    }

    public boolean hasDeploymentForInfra(String infraId) throws IOException {
        for (AbstractDeployment depl : this.getDeploymentDAO().listUnsafe()) {
            if (!depl.infraId.equals(infraId)) continue;
            return true;
        }
        return false;
    }

    public abstract List<? extends AbstractDeploymentBasicInfo> listBasicInfoUnsafe_Check(AuthCtx var1) throws IOException;

    protected List<D> listDeploymentsUnsafe_Check(AuthCtx authCtx) throws IOException {
        ArrayList<AbstractDeployment> deployments = new ArrayList<AbstractDeployment>();
        for (AbstractDeployment depl : this.getDeploymentDAO().listUnsafe()) {
            PublishedItem item = (PublishedItem)this.getPublishedItemsDAO().getMandatoryUnsafe(depl.getPublishedItemId());
            AbstractDeploymentInfra infra = (AbstractDeploymentInfra)this.getInfrasDAO().getMandatoryUnsafe(depl.infraId);
            if (!AbstractInfrasService.hasReadPermission(infra, authCtx) || !AbstractPublishedItemsService.hasReadPermission(item, authCtx)) continue;
            deployments.add(depl);
        }
        return deployments;
    }

    public abstract List<? extends AbstractDeploymentBasicInfo> listBasicInfoForItemUnsafe_Check(String var1, AuthCtx var2) throws IOException;

    protected List<D> listLastSuccessfulDeploymentsForItemUnsafe_Check(String publishedItemId, AuthCtx authCtx) throws IOException {
        ArrayList<AbstractDeployment> deployments = new ArrayList<AbstractDeployment>();
        PublishedItem item = (PublishedItem)this.getPublishedItemsDAO().getMandatoryUnsafe(publishedItemId);
        if (!AbstractPublishedItemsService.hasReadPermission(item, authCtx)) {
            return deployments;
        }
        for (AbstractDeployment depl : this.getDeploymentDAO().listUnsafe()) {
            AbstractDeploymentInfra infra = (AbstractDeploymentInfra)this.getInfrasDAO().getMandatoryUnsafe(depl.infraId);
            if (!depl.getPublishedItemId().equals(publishedItemId) || !AbstractInfrasService.hasReadPermission(infra, authCtx)) continue;
            AbstractDeployment lastUpdateDeployment = Optional.ofNullable(this.deploymentUpdateService.getLastSuccessfulUpdate(infra, depl, AbstractInfrasService.hasAdminPermission(infra, authCtx))).map(du -> {
                AbstractDeployment lastDeployment = du.getDeployment();
                lastDeployment.id = depl.id;
                return lastDeployment;
            }).orElse(depl);
            deployments.add(lastUpdateDeployment);
        }
        return deployments;
    }

    protected List<D> listDeploymentsForInfraUnsafe_Check(String infraId, AuthCtx authCtx) throws IOException {
        this.getInfrasDAO().getMandatoryUnsafe(infraId);
        ArrayList<AbstractDeployment> deployments = new ArrayList<AbstractDeployment>();
        for (AbstractDeployment depl : this.getDeploymentDAO().listUnsafe()) {
            PublishedItem item;
            if (!depl.infraId.equals(infraId) || !AbstractPublishedItemsService.hasReadPermission(item = (PublishedItem)this.getPublishedItemsDAO().getMandatoryUnsafe(depl.getPublishedItemId()), authCtx)) continue;
            deployments.add(depl);
        }
        return deployments;
    }

    public abstract List<? extends AbstractDeploymentBasicInfo> listBasicInfoForInfraUnsafe_Check(String var1, AuthCtx var2) throws IOException;

    public AbstractDeploymentLightStatus getLightStatusMandatoryUnsafe_NT_Check(String deploymentId, AuthCtx authCtx) throws UnauthorizedException, IOException {
        PublishedItem retrievedPublishedItem;
        AbstractDeploymentInfra retrievedInfra;
        AbstractDeployment retrievedDeployment;
        try (Transaction t = this.transactionService.beginRead();){
            retrievedDeployment = (AbstractDeployment)this.getDeploymentDAO().getMandatoryUnsafe(deploymentId);
            retrievedInfra = (AbstractDeploymentInfra)this.getInfrasDAO().getMandatoryUnsafe(retrievedDeployment.infraId);
            retrievedPublishedItem = (PublishedItem)this.getPublishedItemsDAO().getMandatoryUnsafe(retrievedDeployment.getPublishedItemId());
            this.checkReadPermissions(retrievedInfra, retrievedPublishedItem, authCtx);
        }
        I publishedItemBI = this.getPublishedItemsService().basicInfoUnsafe(retrievedPublishedItem);
        List<PublishedPackageInfo> publishedPackageInfo = this.getPublishedItemsService().listPublishedPackages_Check_Unsafe_NT(retrievedDeployment.getPublishedItemId(), authCtx);
        AbstractInfraBasicInfo infraBI = this.getInfrasService().basicInfoUnsafe(retrievedInfra);
        return this.getDeploymentLightStatus_NT(retrievedDeployment, infraBI, publishedItemBI, publishedPackageInfo, AbstractDeploymentsService.hasFullDeployPermissions(retrievedInfra, retrievedPublishedItem, authCtx), AbstractInfrasService.hasAdminPermission(retrievedInfra, authCtx));
    }

    public D getSettingsMandatoryUnsafe_Check(String id, AuthCtx authCtx) throws UnauthorizedException, IOException {
        AbstractDeployment depl = (AbstractDeployment)this.getDeploymentDAO().getMandatoryUnsafe(id);
        PublishedItem item = (PublishedItem)this.getPublishedItemsDAO().getMandatoryUnsafe(depl.getPublishedItemId());
        AbstractDeploymentInfra infra = (AbstractDeploymentInfra)this.getInfrasDAO().getMandatoryUnsafe(depl.infraId);
        this.checkReadPermissions(infra, item, authCtx);
        return (D)depl;
    }

    public D getSettingsMandatory_Check(String id, AuthCtx authCtx) throws UnauthorizedException, IOException {
        AbstractDeployment depl = (AbstractDeployment)this.getDeploymentDAO().getMandatory(id);
        PublishedItem item = (PublishedItem)this.getPublishedItemsDAO().getMandatoryUnsafe(depl.getPublishedItemId());
        AbstractDeploymentInfra infra = (AbstractDeploymentInfra)this.getInfrasDAO().getMandatoryUnsafe(depl.infraId);
        this.checkReadPermissions(infra, item, authCtx);
        return (D)depl;
    }

    protected void finalizeCreation(D deployment) throws IOException {
        this.getDeploymentDAO().save(deployment);
        this.getNeverEverDeployedSet().add(((AbstractDeployment)deployment).id);
    }

    public void switchVersion(String deploymentId, String packageId, AuthCtx user) throws UnauthorizedException, IOException {
        D deployment = this.getSettingsMandatory_Check(deploymentId, user);
        String publishedItemId = ((AbstractDeployment)deployment).getPublishedItemId();
        if (!this.getPublishedItemsService().publishedPackageFile(publishedItemId, packageId).exists()) {
            throw new NotFoundException(String.format("%s %s does not exist for this published %s %s", this.getPublishedItemsService().getPackageType(), packageId, this.getPublishedItemsService().getType(), publishedItemId));
        }
        ((AbstractDeployment)deployment).switchVersion(packageId);
        this.save_Check(deployment, user, true);
    }

    abstract void additionalSaveSteps(D var1, D var2) throws IOException;

    abstract boolean isDeployed(D var1) throws IOException;

    public void save_Check(D newDeployment, AuthCtx authCtx, boolean shouldVerify) throws UnauthorizedException, IOException {
        AbstractDeployment oldDeployment = (AbstractDeployment)this.getDeploymentDAO().getMandatory(((AbstractDeployment)newDeployment).id);
        PublishedItem item = (PublishedItem)this.getPublishedItemsDAO().getMandatoryUnsafe(oldDeployment.getPublishedItemId());
        AbstractDeploymentInfra infra = (AbstractDeploymentInfra)this.getInfrasDAO().getMandatoryUnsafe(oldDeployment.infraId);
        this.checkDeployPermissions(infra, item, authCtx);
        if (shouldVerify) {
            ((AbstractDeployment)newDeployment).verifyFields(infra, oldDeployment, this.isDeployed(oldDeployment));
        }
        this.additionalSaveSteps(oldDeployment, newDeployment);
        ((AbstractDeployment)newDeployment).creationTag = oldDeployment.creationTag;
        ((AbstractDeployment)newDeployment).versionTag = VersionTag.increment(oldDeployment.versionTag, authCtx.getIdentifier());
        this.getDeploymentDAO().save(newDeployment);
        this.publishDeploymentConfigChangedEventAfterTransaction(((AbstractDeployment)newDeployment).id, infra.id);
    }

    protected void preDeleteActions_NT(AuthCtx authCtx, N infra, D deployment) throws CodedException, IOException, SQLException, InterruptedException {
        this.getLogger().debugV("No pre-delete action performed for deployment %s.", new Object[]{((AbstractDeployment)deployment).id});
    }

    public DeploymentDeletionReport delete_NT_Check(final String deploymentType, final String deploymentId, final AuthCtx authCtx, final boolean ignorePreDeleteErrors) throws Exception {
        AbstractDeploymentInfra infra;
        PublishedItem item;
        AbstractDeployment deployment;
        TransactionContext.assertNoAttachedTransaction();
        try (Transaction t = this.transactionService.beginRead();){
            deployment = (AbstractDeployment)this.getDeploymentDAO().getMandatoryUnsafe(deploymentId);
            item = (PublishedItem)this.getPublishedItemsDAO().getMandatoryUnsafe(deployment.getPublishedItemId());
            infra = (AbstractDeploymentInfra)this.getInfrasDAO().getMandatoryUnsafe(deployment.infraId);
        }
        this.checkDeployPermissions(infra, item, authCtx);
        return (DeploymentDeletionReport)this.futureService.runAndWait(new FutureThread<DeploymentDeletionReport>((DSSAuthCtx)authCtx){
            DeploymentDeletionReport report;

            public FuturePayload getPayload() {
                return FuturePayload.newSimple((String)"delete_deployment", (String)("Delete deployment: " + deploymentId));
            }

            public double getDangerosity() {
                return 0.0;
            }

            public DeploymentDeletionReport getResult() {
                return this.report;
            }

            public void execute() throws Exception {
                try (DeploymentActionHandle ignored = AbstractDeploymentsService.this.deploymentActionsService.deleteDeployment(deployment, infra, this);){
                    CodedException preDeleteError = null;
                    try {
                        AbstractDeploymentsService.this.preDeleteActions_NT(authCtx, infra, deployment);
                    }
                    catch (CodedException e) {
                        preDeleteError = e;
                    }
                    catch (Exception e) {
                        preDeleteError = new CodedException((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_PRE_DELETE_ACTION, "Error while deleting external resources.", (Throwable)e);
                    }
                    if (!ignorePreDeleteErrors && preDeleteError != null) {
                        throw new APIError.APIErrorException(new APIError((Throwable)preDeleteError, false));
                    }
                    try (RWTransaction t = AbstractDeploymentsService.this.transactionService.beginWriteAsLoggedInUser(authCtx);){
                        AbstractDeploymentsService.this.getDeploymentDAO().delete(deployment.id);
                        AbstractDeploymentsService.this.publishDeploymentDeletedEventAfterTransaction(deploymentId, infra.id);
                        t.commitV("Deleted %s deployment: %s", new Object[]{deploymentType, deploymentId});
                    }
                    this.report = new DeploymentDeletionReport();
                    if (preDeleteError != null) {
                        this.report.withPreDeleteError = new APIError((Throwable)preDeleteError, false);
                    }
                }
            }
        }, (TypeToken)new TypeToken<FutureResponse<DeploymentDeletionReport>>(){});
    }

    @Nullable
    public DeploymentAction getLastDeploymentAction_Check(String deploymentId, AuthCtx authCtx) throws IOException, UnauthorizedException {
        AbstractDeploymentInfra infra;
        AbstractDeployment deployment;
        try (Transaction ignored = this.transactionService.retrieveOrBeginRead();){
            deployment = (AbstractDeployment)this.getDeploymentDAO().getMandatoryUnsafe(deploymentId);
            PublishedItem item = (PublishedItem)this.getPublishedItemsDAO().getMandatoryUnsafe(deployment.getPublishedItemId());
            infra = (AbstractDeploymentInfra)this.getInfrasDAO().getMandatoryUnsafe(deployment.infraId);
            this.checkReadPermissions(infra, item, authCtx);
        }
        return this.deploymentActionsService.getLastDeploymentActionForUser(authCtx, deployment, infra);
    }

    public FullDeploymentUpdate getDeploymentUpdate_Check_NT(String deploymentId, String startTimestamp, AuthCtx authCtx) throws Exception {
        N infra;
        D deployment;
        long timestamp;
        try {
            timestamp = Long.parseLong(startTimestamp);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid timestamp format: " + startTimestamp, e);
        }
        try (Transaction ignored = this.transactionService.beginRead();){
            deployment = this.getSettingsMandatory_Check(deploymentId, authCtx);
            infra = this.getInfrasService().getSettingsMandatoryUnsafe(((AbstractDeployment)deployment).infraId);
        }
        boolean includesAdminInfo = AbstractInfrasService.hasAdminPermission(infra, authCtx);
        return this.deploymentUpdateService.getFullUpdate((AbstractDeploymentInfra)infra, (AbstractDeployment)deployment, timestamp, includesAdminInfo);
    }

    public DeploymentUpdate getLastDeploymentUpdate_Check_NT(String deploymentId, AuthCtx authCtx) throws Exception {
        N infra;
        D deployment;
        try (Transaction ignored = this.transactionService.beginRead();){
            deployment = this.getSettingsMandatory_Check(deploymentId, authCtx);
            infra = this.getInfrasService().getSettingsMandatoryUnsafe(((AbstractDeployment)deployment).infraId);
        }
        return this.deploymentUpdateService.getLastUpdate((AbstractDeploymentInfra)infra, (AbstractDeployment)deployment, AbstractInfrasService.hasAdminPermission(infra, authCtx));
    }

    public List<DeploymentUpdate.Head> listDeploymentUpdateHeads_Check_NT(String deploymentId, AuthCtx authCtx) throws Exception {
        N infra;
        D deployment;
        try (Transaction ignored = this.transactionService.beginRead();){
            deployment = this.getSettingsMandatory_Check(deploymentId, authCtx);
            infra = this.getInfrasService().getSettingsMandatoryUnsafe(((AbstractDeployment)deployment).infraId);
        }
        return this.deploymentUpdateService.listLastUpdatesHeads((AbstractDeploymentInfra)infra, (AbstractDeployment)deployment);
    }

    public DeploymentUpdateDiff getUpdateSettingsDiff_Check_NT(String deploymentId, String startTimestamp, AuthCtx authCtx) throws Exception {
        N infra;
        D deployment;
        long timestamp;
        try {
            timestamp = Long.parseLong(startTimestamp);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid timestamp format: " + startTimestamp, e);
        }
        try (Transaction ignored = this.transactionService.beginRead();){
            deployment = this.getSettingsMandatory_Check(deploymentId, authCtx);
            infra = this.getInfrasService().getSettingsMandatoryUnsafe(((AbstractDeployment)deployment).infraId);
        }
        return this.deploymentUpdateService.getUpdateSettingsDiff((AbstractDeploymentInfra)infra, (AbstractDeployment)deployment, timestamp, AbstractInfrasService.hasAdminPermission(infra, authCtx));
    }

    public void checkDeployPermissions(String deploymentId, AuthCtx authCtx) throws IOException, UnauthorizedException {
        AbstractDeployment depl = (AbstractDeployment)this.getDeploymentDAO().getMandatoryUnsafe(deploymentId);
        AbstractDeploymentInfra infra = (AbstractDeploymentInfra)this.getInfrasDAO().getMandatoryUnsafe(depl.infraId);
        PublishedItem item = (PublishedItem)this.getPublishedItemsDAO().getMandatoryUnsafe(depl.getPublishedItemId());
        this.checkDeployPermissions(infra, item, authCtx);
    }

    public void checkDeployPermissions(String infraId, String publishedItemId, AuthCtx authCtx) throws UnauthorizedException, IOException {
        AbstractDeploymentInfra infra = (AbstractDeploymentInfra)this.getInfrasDAO().getMandatoryUnsafe(infraId);
        PublishedItem item = (PublishedItem)this.getPublishedItemsDAO().getMandatoryUnsafe(publishedItemId);
        this.checkDeployPermissions(infra, item, authCtx);
    }

    void checkDeployPermissions(AbstractDeploymentInfra infra, PublishedItem item, AuthCtx authCtx) throws UnauthorizedException {
        if (!AbstractInfrasService.hasDeployPermission(infra, authCtx)) {
            throw new UnauthorizedException("Permission denied: unable to deploy on this infra", "deployment-action-denied");
        }
        if (!AbstractPublishedItemsService.hasDeployPermission(item, authCtx)) {
            throw new UnauthorizedException("Permission denied: unable to deploy this published " + this.getPublishedItemsDAO().getType(), "deployment-action-denied");
        }
    }

    public static boolean hasFullDeployPermissions(AbstractDeploymentInfra infra, PublishedItem item, AuthCtx authCtx) {
        return AbstractInfrasService.hasDeployPermission(infra, authCtx) && AbstractPublishedItemsService.hasDeployPermission(item, authCtx);
    }

    public void checkReadPermissions(AbstractDeploymentInfra infra, PublishedItem item, AuthCtx authCtx) throws UnauthorizedException {
        if (!AbstractInfrasService.hasReadPermission(infra, authCtx)) {
            throw new UnauthorizedException("Permission denied: unable to view deployments on this infrastructure", "deployment-action-denied");
        }
        if (!AbstractPublishedItemsService.hasReadPermission(item, authCtx)) {
            throw new UnauthorizedException("Permission denied: unable to view deployments of this published " + this.getPublishedItemsDAO().getType(), "deployment-action-denied");
        }
    }

    public void checkInfraAdminPermissions(AbstractDeploymentInfra infra, PublishedItem item, AuthCtx authCtx) throws UnauthorizedException {
        if (!AbstractInfrasService.hasAdminPermission(infra, authCtx)) {
            throw new UnauthorizedException("Permission denied: unable to manage deployments on this infrastructure", "deployment-action-denied");
        }
    }

    void checkIdValidity(String deploymentId, String publishedItemId, String infraId) throws IOException {
        if (StringUtils.isBlank((String)deploymentId)) {
            throw ErrorContext.iae((String)"Deployment ID cannot be empty");
        }
        if (!deploymentId.matches("^[a-zA-Z0-9_ -]+$")) {
            throw ErrorContext.iaef((String)"Deployment ID is invalid: %s", (Object)deploymentId, (Object[])new Object[0]);
        }
        if (this.getDeploymentDAO().getOrNullUnsafe(deploymentId) != null) {
            throw ErrorContext.iaef((String)"Deployment ID already exists: %s", (Object)deploymentId, (Object[])new Object[0]);
        }
        if (StringUtils.isBlank((String)publishedItemId)) {
            throw ErrorContext.iae((String)("Published " + this.getPublishedItemsDAO().getType() + " ID cannot be empty"));
        }
        if (StringUtils.isBlank((String)infraId)) {
            throw ErrorContext.iae((String)"Infra ID cannot be empty");
        }
    }

    public void doGovernanceCheck_NT(AbstractInfraBasicInfo infraBasicInfo, String publishedItemId, List<String> packageIds) throws IOException, CodedException {
        this.doGovernanceCheck_NT(infraBasicInfo, publishedItemId, packageIds, true);
    }

    public void doGovernanceCheck_NT(AbstractInfraBasicInfo infraBasicInfo, String publishedItemId, List<String> packageIds, boolean ignoreWarnings) throws IOException, CodedException {
        TransactionContext.assertNoAttachedTransaction();
        if (GovernIntegrationService.enabledNoChecks() && (AbstractDeploymentInfra.GovernCheckPolicy.PREVENT.equals((Object)infraBasicInfo.governCheckPolicy) || AbstractDeploymentInfra.GovernCheckPolicy.WARN.equals((Object)infraBasicInfo.governCheckPolicy) && !ignoreWarnings)) {
            InfoMessage.InfoMessages messages = this.getGovernanceMessages_NT(infraBasicInfo, publishedItemId, packageIds);
            if (messages.error || !ignoreWarnings && messages.warning) {
                throw new CodedException((InfoMessage.MessageCode)DeployerCodes.ERR_DEPLOYER_INVALID_GOVERNANCE_STATUS, messages.report());
            }
        }
    }

    public InfoMessage.InfoMessages getGovernanceMessages_NT(AbstractInfraBasicInfo infraBasicInfo, String publishedItemId, List<String> packageIds) throws IOException {
        DSSItemGovernanceStatusList dssItemGovernanceStatusList;
        if (!GovernIntegrationService.enabledNoChecks()) {
            InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
            ret.withInfo((InfoMessage.MessageCode)GovernIntegrationCodes.ERR_GOVERN_DISABLED, "The Dataiku Govern integration is disabled.");
            return ret;
        }
        if (AbstractDeploymentInfra.GovernCheckPolicy.NO_CHECK.equals((Object)infraBasicInfo.governCheckPolicy)) {
            InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
            ret.withInfo((InfoMessage.MessageCode)DeployerCodes.INFO_DEPLOYER_GOVERNANCE_NO_CHECK_ON_INFRA, "The configuration of this infra allows to deploy without checking the governance status, so no check has been done.");
            return ret;
        }
        InfoMessage.InfoMessages infoMessages = new InfoMessage.InfoMessages();
        ArrayList<AbstractPublishedPackageInfoForGovernIdentification> publishedPackages = new ArrayList<AbstractPublishedPackageInfoForGovernIdentification>();
        for (String packageId : packageIds) {
            InfoMessage.InfoMessages identifiersError;
            try {
                AbstractPublishedPackageInfoForGovernIdentification ppGovern = this.getPublishedItemsService().getPublishedPackageInfoForGovernIdentification_NT(publishedItemId, packageId);
                publishedPackages.add(ppGovern);
            }
            catch (CodedException e) {
                identifiersError = this.buildUnexpectedErrorGovernanceMessage(infraBasicInfo.governCheckPolicy, e.code, "Cannot build item identifiers for Govern: " + ExceptionUtils.getMessageWithCauses((Throwable)e));
                infoMessages.mergeFrom(identifiersError);
            }
            catch (Exception e) {
                identifiersError = this.buildUnexpectedErrorGovernanceMessage(infraBasicInfo.governCheckPolicy, DeployerCodes.ERR_GOVERN_FAILED_ACCESS_ITEM_INFO, "Cannot build item identifiers for Govern: " + ExceptionUtils.getMessageWithCauses((Throwable)e));
                infoMessages.mergeFrom(identifiersError);
            }
        }
        try {
            dssItemGovernanceStatusList = this.getGovernanceStatus_NT(publishedPackages);
        }
        catch (CodedException e) {
            InfoMessage.InfoMessages callError = this.buildUnexpectedErrorGovernanceMessage(infraBasicInfo.governCheckPolicy, e.code, "Cannot get governance statuses from Govern: " + ExceptionUtils.getMessageWithCauses((Throwable)e));
            infoMessages.mergeFrom(callError);
            return infoMessages;
        }
        String nodeExternalUrl = GovernIntegrationService.getNodeExternalUrlOrNullIfDisabled();
        InfoMessage.InfoMessages computedMessages = this.computeInfoMessagesForGovernanceStatus_NT(dssItemGovernanceStatusList, infraBasicInfo, nodeExternalUrl, publishedPackages);
        infoMessages.mergeFrom(computedMessages);
        return infoMessages;
    }

    private InfoMessage.InfoMessages buildUnexpectedErrorGovernanceMessage(AbstractDeploymentInfra.GovernCheckPolicy governCheckPolicy, InfoMessage.MessageCode messageCode, String message) {
        InfoMessage.InfoMessages infoMessages = new InfoMessage.InfoMessages();
        switch (governCheckPolicy) {
            case PREVENT: {
                infoMessages.withError(messageCode, message);
                break;
            }
            case WARN: {
                infoMessages.withWarning(messageCode, message);
                break;
            }
            default: {
                infoMessages.withInfo(messageCode, message);
            }
        }
        return infoMessages;
    }

    protected abstract DSSItemGovernanceStatusList getGovernanceStatus_NT(List<AbstractPublishedPackageInfoForGovernIdentification> var1) throws IOException, CodedException;

    protected abstract String getPublishedItemType();

    private InfoMessage.InfoMessages computeInfoMessagesForGovernanceStatus_NT(DSSItemGovernanceStatusList dssItemGovernanceStatusList, AbstractInfraBasicInfo infraBasicInfo, @Nullable String nodeExternalUrl, List<AbstractPublishedPackageInfoForGovernIdentification> publishedPackages) {
        String baseErrorMessage;
        InfoMessage.Severity severity;
        InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
        String itemType = this.getPublishedItemType();
        if (AbstractDeploymentInfra.GovernCheckPolicy.WARN.equals((Object)infraBasicInfo.governCheckPolicy)) {
            severity = InfoMessage.Severity.WARNING;
            baseErrorMessage = "The " + itemType + " should be approved before being deployed to this infrastructure, but ";
        } else if (AbstractDeploymentInfra.GovernCheckPolicy.PREVENT.equals((Object)infraBasicInfo.governCheckPolicy)) {
            severity = InfoMessage.Severity.ERROR;
            baseErrorMessage = "The " + itemType + " must be approved before being deployed to this infrastructure, but ";
        } else {
            ret.withErrorV((InfoMessage.MessageCode)DeployerCodes.ERR_DEPLOYER_GOVERNANCE_INVALID_CONFIGURATION, "Invalid Dataiku Govern policy \"%s\" for infra \"%s\"", new Object[]{infraBasicInfo.governCheckPolicy, infraBasicInfo.id});
            return ret;
        }
        block7: for (DSSItemGovernanceStatus dssItemGovernanceStatus : dssItemGovernanceStatusList.dssItemGovernanceStatuses) {
            if (dssItemGovernanceStatus == null) {
                this.addInvalidGovernanceStatusMessage(nodeExternalUrl, ret, severity, "%s we could not retrieve the governance status.", baseErrorMessage);
                continue;
            }
            if (!(dssItemGovernanceStatus.dssItemIdentifier instanceof DSSSavedModelVersionIdentifier) && !(dssItemGovernanceStatus.dssItemIdentifier instanceof DSSBundleIdentifier)) {
                this.addInvalidGovernanceStatusMessage(nodeExternalUrl, ret, severity, "%s we retrieved an unexpected DSS identifier type.", baseErrorMessage);
                continue;
            }
            String displayableIdentifier = dssItemGovernanceStatus.dssItemIdentifier instanceof DSSSavedModelVersionIdentifier ? this.getDisplayableIdentifierForSavedModelVersion(dssItemGovernanceStatus, publishedPackages) : ((DSSBundleIdentifier)dssItemGovernanceStatus.dssItemIdentifier).bundleId;
            if (dssItemGovernanceStatus.governanceStatus == null) {
                this.addInvalidGovernanceStatusMessage(nodeExternalUrl, ret, severity, "%s we could not retrieve the governance status of %s \"%s\".", baseErrorMessage, itemType, displayableIdentifier);
                continue;
            }
            if (!dssItemGovernanceStatus.governanceStatus.governed) {
                this.addInvalidGovernanceStatusMessage(nodeExternalUrl, ret, severity, dssItemGovernanceStatus.governanceStatus, "%s %s \"%s\" is not governed.", baseErrorMessage, itemType, displayableIdentifier);
                continue;
            }
            if (dssItemGovernanceStatus.governanceStatus.validationStatus == null) {
                this.addInvalidGovernanceStatusMessage(nodeExternalUrl, ret, severity, dssItemGovernanceStatus.governanceStatus, "%s %s \"%s\" is not approved.", baseErrorMessage, itemType, displayableIdentifier);
                continue;
            }
            String governanceMessage = ((List)MoreObjects.firstNonNull((Object)dssItemGovernanceStatus.governanceStatus.governanceComments, new ArrayList())).stream().map(comment -> String.format("Message from \"%s\" on \"%s\" for %s \"%s\": \"%s\"", comment.user, comment.statusDate, itemType, displayableIdentifier, comment.comment)).collect(Collectors.joining(", "));
            String endOfMessage = (String)(StringUtils.isNotBlank((String)governanceMessage) ? ": " + governanceMessage : "") + ".";
            switch (dssItemGovernanceStatus.governanceStatus.validationStatus) {
                case NOT_APPLICABLE: {
                    this.addInvalidGovernanceStatusMessage(nodeExternalUrl, ret, severity, dssItemGovernanceStatus.governanceStatus, "%s the governance configuration of %s \"%s\" does not allow it to be validated%s", baseErrorMessage, itemType, displayableIdentifier, endOfMessage);
                    continue block7;
                }
                case REJECTED: {
                    this.addInvalidGovernanceStatusMessage(nodeExternalUrl, ret, severity, dssItemGovernanceStatus.governanceStatus, "%s the governance status of %s \"%s\" is rejected%s", baseErrorMessage, itemType, displayableIdentifier, endOfMessage);
                    continue block7;
                }
                case NOT_VALIDATED: 
                case IN_VALIDATION: {
                    this.addInvalidGovernanceStatusMessage(nodeExternalUrl, ret, severity, dssItemGovernanceStatus.governanceStatus, "%s %s \"%s\" has not been approved yet%s", baseErrorMessage, itemType, displayableIdentifier, endOfMessage);
                    continue block7;
                }
                case APPROVED: {
                    this.addApprovedGovernanceStatusMessage(nodeExternalUrl, ret, dssItemGovernanceStatus.governanceStatus, "The %s \"%s\" was approved%s", itemType, displayableIdentifier, endOfMessage);
                    continue block7;
                }
                case ABANDONED: {
                    this.addInvalidGovernanceStatusMessage(nodeExternalUrl, ret, severity, dssItemGovernanceStatus.governanceStatus, "%s the governance status of %s \"%s\" is abandoned%s", baseErrorMessage, itemType, displayableIdentifier, endOfMessage);
                    continue block7;
                }
            }
            this.addInvalidGovernanceStatusMessage(nodeExternalUrl, ret, severity, dssItemGovernanceStatus.governanceStatus, "%s we received an unexpected validation status %s for %s \"%s\"%s", baseErrorMessage, itemType, dssItemGovernanceStatus.governanceStatus.validationStatus.toString(), displayableIdentifier, endOfMessage);
        }
        return ret;
    }

    private String getDisplayableIdentifierForSavedModelVersion(DSSItemGovernanceStatus dssItemGovernanceStatus, List<AbstractPublishedPackageInfoForGovernIdentification> publishedPackages) {
        DSSSavedModelVersionIdentifier dssSavedModelVersionIdentifier = (DSSSavedModelVersionIdentifier)dssItemGovernanceStatus.dssItemIdentifier;
        String dssItemIdentifierId = dssSavedModelVersionIdentifier.fullModelVersionId;
        for (AbstractPublishedPackageInfoForGovernIdentification publishedPackage : publishedPackages) {
            if (!(publishedPackage instanceof PublishedApiServicePackageInfoForGovernIdentification)) continue;
            PublishedApiServicePackageInfoForGovernIdentification apiPackage = (PublishedApiServicePackageInfoForGovernIdentification)publishedPackage;
            for (EmbeddedModelVersionIdentifier embeddedModelVersionIdentifier : apiPackage.embeddedModelVersionIdentifiers) {
                if (!Strings.equals((String)embeddedModelVersionIdentifier.originalFullModelId, (String)dssItemIdentifierId) || !Strings.equals((String)publishedPackage.originalNodeId, (String)dssSavedModelVersionIdentifier.nodeId) || embeddedModelVersionIdentifier.originalSavedModelVersionName == null) continue;
                return embeddedModelVersionIdentifier.originalSavedModelVersionName;
            }
        }
        if (dssItemGovernanceStatus.governanceStatus != null && dssItemGovernanceStatus.governanceStatus.governArtifactName != null) {
            return dssItemGovernanceStatus.governanceStatus.governArtifactName;
        }
        return dssItemIdentifierId;
    }

    private void addApprovedGovernanceStatusMessage(@Nullable String nodeExternalUrl, InfoMessage.InfoMessages infoMessages, GovernanceStatus governanceStatus, @PrintFormat String message, Object ... args) {
        this.addGovernanceMessage(nodeExternalUrl, infoMessages, InfoMessage.Severity.INFO, DeployerCodes.INFO_DEPLOYER_APPROVED_GOVERNANCE_STATUS, governanceStatus, message, args);
    }

    private void addInvalidGovernanceStatusMessage(@Nullable String nodeExternalUrl, InfoMessage.InfoMessages infoMessages, InfoMessage.Severity severity, @PrintFormat String message, Object ... args) {
        this.addInvalidGovernanceStatusMessage(nodeExternalUrl, infoMessages, severity, null, message, args);
    }

    private void addInvalidGovernanceStatusMessage(@Nullable String nodeExternalUrl, InfoMessage.InfoMessages infoMessages, InfoMessage.Severity severity, GovernanceStatus governanceStatus, @PrintFormat String message, Object ... args) {
        this.addGovernanceMessage(nodeExternalUrl, infoMessages, severity, DeployerCodes.ERR_DEPLOYER_INVALID_GOVERNANCE_STATUS, governanceStatus, message, args);
    }

    private void addGovernanceMessage(@Nullable String nodeExternalUrl, InfoMessage.InfoMessages infoMessages, InfoMessage.Severity severity, DeployerCodes deployerCode, GovernanceStatus governanceStatus, @PrintFormat String message, Object ... args) {
        InfoMessage infoMessage = new InfoMessage(severity, (InfoMessage.MessageCode)deployerCode, String.format(message, args));
        if (governanceStatus != null && governanceStatus.governArtifactId != null && StringUtils.isNotBlank((String)nodeExternalUrl)) {
            String governLink = nodeExternalUrl + (nodeExternalUrl.endsWith("/") ? "" : "/") + "artifact/" + governanceStatus.governArtifactId;
            infoMessage.withGovernLink(governLink);
        }
        infoMessages.addMessage(infoMessage);
    }

    public List<LogsService.LogDesc> getLogsList_Check(String id, AuthCtx authCtx) throws UnauthorizedException, IOException {
        AbstractDeployment depl = (AbstractDeployment)this.getDeploymentDAO().getMandatory(id);
        PublishedItem item = (PublishedItem)this.getPublishedItemsDAO().getMandatoryUnsafe(depl.getPublishedItemId());
        AbstractDeploymentInfra infra = (AbstractDeploymentInfra)this.getInfrasDAO().getMandatoryUnsafe(depl.infraId);
        this.checkInfraAdminPermissions(infra, item, authCtx);
        return this.listLogs(depl);
    }

    public SmartLogTail getLog_Check(String id, String logName, AuthCtx authCtx) throws UnauthorizedException, IOException {
        AbstractDeployment depl = (AbstractDeployment)this.getDeploymentDAO().getMandatory(id);
        PublishedItem item = (PublishedItem)this.getPublishedItemsDAO().getMandatoryUnsafe(depl.getPublishedItemId());
        AbstractDeploymentInfra infra = (AbstractDeploymentInfra)this.getInfrasDAO().getMandatoryUnsafe(depl.infraId);
        this.checkInfraAdminPermissions(infra, item, authCtx);
        return this.getLog(depl, logName);
    }

    public D streamLog_Check(String id, AuthCtx authCtx) throws UnauthorizedException, IOException {
        AbstractDeployment depl = (AbstractDeployment)this.getDeploymentDAO().getMandatory(id);
        PublishedItem item = (PublishedItem)this.getPublishedItemsDAO().getMandatoryUnsafe(depl.getPublishedItemId());
        AbstractDeploymentInfra infra = (AbstractDeploymentInfra)this.getInfrasDAO().getMandatoryUnsafe(depl.infraId);
        this.checkInfraAdminPermissions(infra, item, authCtx);
        return (D)depl;
    }

    protected File getLogsDir(D depl) {
        return DKUFileUtils.getWithin((File)new File(System.getenv("DIP_HOME"), "run"), (String[])new String[]{"deployment-logs", this.getInfrasDAO().getTypeSubdirectoryString(), ((AbstractDeployment)depl).infraId, this.getPublishedItemsDAO().getTypeSubdirectoryString(), ((AbstractDeployment)depl).getPublishedItemId(), ((AbstractDeployment)depl).id});
    }

    public static File getManagedApiEndpointActivityRrd(String deploymentId, String endpointId) {
        return DKUFileUtils.getWithin((File)AbstractDeploymentsService.getDeployedApiEndpointActivityBaseDir(deploymentId), (String[])new String[]{endpointId + ".rrd"});
    }

    public static File getDeploymentSystemMetricRrd(String deploymentId) {
        return DKUFileUtils.getWithin((File)AbstractDeploymentsService.getDeploymentSystemMetricsBaseDir(deploymentId), (String[])new String[]{"system-metrics.rrd"});
    }

    public static List<File> listApiEndpointsActivityRrds(@Nonnull String deploymentId) {
        Preconditions.checkNotNull((Object)deploymentId, (Object)"The deploymentId can not be null.");
        ArrayList<File> result = new ArrayList<File>();
        File endpointMonitoringDir = AbstractDeploymentsService.getDeployedApiEndpointActivityBaseDir(deploymentId);
        if (endpointMonitoringDir.exists() && endpointMonitoringDir.isDirectory()) {
            Collections.addAll(result, Objects.requireNonNull(endpointMonitoringDir.listFiles(f -> f.getName().endsWith(".rrd"))));
        }
        return result;
    }

    private static File getDeployedApiEndpointActivityBaseDir(String deploymentId) {
        return DKUFileUtils.getWithin((File)ApplicationConfigurator.getFile((String)DEPLOYMENTS_SYSTEM_METRICS_PATH), (String[])new String[]{deploymentId});
    }

    public static File getDeploymentSystemMetricsBaseDir(String deploymentId) {
        return DKUFileUtils.getWithin((File)ApplicationConfigurator.getFile((String)DEPLOYMENTS_SYSTEM_METRICS_PATH), (String[])new String[]{deploymentId, SYSTEM_METRICS_SUBFOLDER});
    }

    public List<Path> listLogFiles(D depl) {
        File logsDir = this.getLogsDir(depl);
        ArrayList<Path> logFiles = new ArrayList<Path>();
        try {
            if (logsDir.exists() && logsDir.isDirectory()) {
                EnumSet<FileVisitOption> opts = EnumSet.of(FileVisitOption.FOLLOW_LINKS);
                Files.walkFileTree(logsDir.toPath(), opts, 5, new LogsService.LogFilesVisitor(logFiles));
            }
        }
        catch (IOException e) {
            this.getLogger().warn((Object)"Listing log files failed", (Throwable)e);
        }
        return logFiles;
    }

    public List<LogsService.LogDesc> listLogs(D depl) throws IOException {
        ArrayList logs = Lists.newArrayList();
        File logsDir = this.getLogsDir(depl);
        if (logsDir.exists() && logsDir.isDirectory()) {
            for (File logFile : DKUFileUtils.recursiveListFiles((File)logsDir)) {
                logs.add(new LogsService.LogDesc(logFile, logsDir));
            }
        }
        return logs;
    }

    public File getLogFile(D depl, String logName) throws IOException {
        File logsDir = this.getLogsDir(depl);
        File logFile = DKUApp.getFile((File)logsDir, (String[])new String[]{logName});
        if (logFile.exists() && logFile.isFile()) {
            return logFile;
        }
        return null;
    }

    public File getDeploymentLogFile(D depl) throws IOException {
        return this.getLogFile(depl, "deployment-" + ((AbstractDeployment)depl).id + ".log");
    }

    public SmartLogTail getLog(D depl, String logName) throws IOException {
        File logFile = this.getLogFile(depl, logName);
        if (logFile != null) {
            return DKUtils.smartTailFile((File)logFile, (int)500);
        }
        throw new IOException("Log file " + logName + " doesn't exist");
    }

    public void streamLog(D depl, String logName, OutputStream os) throws IOException {
        block11: {
            File logFile = this.getLogFile(depl, logName);
            if (logFile != null) {
                this.getLogger().info((Object)("Start compressed stream for " + logName));
                try (GZIPOutputStream zos = new GZIPOutputStream(os);
                     FileInputStream is = new FileInputStream(logFile);){
                    IOUtils.copy((InputStream)is, (OutputStream)zos);
                    break block11;
                }
            }
            throw new IOException("Log file " + logName + " doesn't exist");
        }
    }

    public void getAllLogsZip(D depl, OutputStream os) throws IOException {
        this.zip(this.listLogFiles(depl), os, this.getLogsDir(depl));
    }

    void zip(Iterable<Path> paths, OutputStream out, File baseFolder) throws IOException {
        this.getLogger().info((Object)"Start compressed stream");
        try (ZipArchiveOutputStream zos = new ZipArchiveOutputStream(out);){
            for (Path path : paths) {
                this.getLogger().info((Object)("Adding " + path.toString()));
                File file = path.toFile();
                LogsService.LogDesc desc = new LogsService.LogDesc(file, baseFolder);
                ZipArchiveEntry ae = zos.createArchiveEntry(file, desc.name);
                zos.putArchiveEntry(ae);
                try (FileInputStream is = new FileInputStream(file);){
                    IOUtils.copy((InputStream)is, (OutputStream)zos);
                }
                zos.closeArchiveEntry();
            }
        }
    }

    private AutoClosableAppenderWrapper appendThreadLogsToLogFile(D deployment, File logFile) {
        try {
            return DKUtils.appendCurrentThreadLogsToLogFile((File)logFile);
        }
        catch (Exception e) {
            String message = "Error setting saving of log of deployment " + ((AbstractDeployment)deployment).id;
            if (logFile != null) {
                message = message + " in " + logFile.getAbsolutePath();
            }
            this.getLogger().error((Object)message, (Throwable)e);
            return null;
        }
    }

    public AutoClosableAppenderWrapper appendThreadLogsToDeploymentLogFile(D deployment) {
        File logDir = this.getLogsDir(deployment);
        try {
            DKUFileUtils.mkdirs((File)logDir);
        }
        catch (IOException e) {
            this.getLogger().errorV("Error creating log directory %s for deployment %s ", new Object[]{logDir, ((AbstractDeployment)deployment).id});
        }
        String logName = "deployment-" + ((AbstractDeployment)deployment).id + ".log";
        return this.appendThreadLogsToLogFile(deployment, new File(logDir, logName));
    }

    public AutoClosableAppenderWrapper appendThreadLogsToUpdateLogFile(N infra, D deployment) {
        File logFile = this.deploymentUpdateService.getLastUpdateLogsFile((AbstractDeploymentInfra)infra, (AbstractDeployment)deployment);
        return this.appendThreadLogsToLogFile(deployment, logFile);
    }

    public AutoClosableAppenderWrapper appendThreadLogsToUpdateLogFile(N infra, D deployment, long startTimestamp) {
        File logFile = this.deploymentUpdateService.getUpdateLogsFile((AbstractDeploymentInfra)infra, (AbstractDeployment)deployment, startTimestamp);
        return this.appendThreadLogsToLogFile(deployment, logFile);
    }

    protected abstract DKULogger getLogger();

    public static class DeploymentDeletionReport {
        APIError withPreDeleteError = null;

        public boolean hasFailure() {
            return this.withPreDeleteError != null;
        }
    }
}

