/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.apideployer.deployments;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.apideployer.DeployerCodes;
import com.dataiku.dip.apideployer.datamodel.actual.APIServiceDeploymentHeavyStatus;
import com.dataiku.dip.apideployer.datamodel.actual.AbstractDeploymentLightStatus;
import com.dataiku.dip.apideployer.datamodel.actual.DeploymentStatusReport;
import com.dataiku.dip.apideployer.datamodel.actual.vertexai.VertexAIDataModelBuilder;
import com.dataiku.dip.apideployer.datamodel.actual.vertexai.VertexAIDeploymentHeavyStatus;
import com.dataiku.dip.apideployer.datamodel.actual.vertexai.VertexAIDeploymentLocalSummary;
import com.dataiku.dip.apideployer.datamodel.actual.vertexai.VertexAIDeploymentRemoteSummary;
import com.dataiku.dip.apideployer.datamodel.actual.vertexai.VertexAIDeploymentStatusReporter;
import com.dataiku.dip.apideployer.datamodel.actual.vertexai.comparator.VertexAIDeployedModelComparator;
import com.dataiku.dip.apideployer.datamodel.actual.vertexai.comparator.VertexAIEndpointComparator;
import com.dataiku.dip.apideployer.datamodel.config.VertexAIAPIDeployment;
import com.dataiku.dip.apideployer.datamodel.config.VertexAIAPIDeploymentInfra;
import com.dataiku.dip.apideployer.deploymentinfo.VertexAIDeploymentInfo;
import com.dataiku.dip.apideployer.deployments.APIDeployerImageBuilderService;
import com.dataiku.dip.apideployer.deployments.AbstractFullyManagedAPIServiceDeploymentManager;
import com.dataiku.dip.apideployer.deployments.VertexAIDeploymentConfigManager;
import com.dataiku.dip.apideployer.infra.AbstractInfrasService;
import com.dataiku.dip.connections.VertexAIModelDeploymentConnection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.externalinfras.ExternalInfrasUtils;
import com.dataiku.dip.externalinfras.vertexai.VertexAIUtils;
import com.dataiku.dip.externalinfras.vertexai.datamodel.VertexAICreateEndpointRequest;
import com.dataiku.dip.externalinfras.vertexai.datamodel.VertexAICreateModelRequest;
import com.dataiku.dip.externalinfras.vertexai.datamodel.VertexAIDeployedModel;
import com.dataiku.dip.externalinfras.vertexai.datamodel.VertexAIDeployedModelConfig;
import com.dataiku.dip.externalinfras.vertexai.datamodel.VertexAIEndpoint;
import com.dataiku.dip.externalinfras.vertexai.datamodel.VertexAIEndpointConfig;
import com.dataiku.dip.externalinfras.vertexai.datamodel.VertexAIModel;
import com.dataiku.dip.externalinfras.vertexai.datamodel.VertexAIModelConfig;
import com.dataiku.dip.externalinfras.vertexai.datamodel.VertexAIModelInternalConfig;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureThreadBase;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.dataiku.dss.shadelibgcp.com.google.auth.oauth2.GoogleCredentials;
import com.dataiku.dss.shadelibgcp.com.google.cloud.aiplatform.v1.DeployedModel;
import com.dataiku.dss.shadelibgcp.com.google.cloud.aiplatform.v1.Endpoint;
import com.dataiku.dss.shadelibgcp.com.google.cloud.aiplatform.v1.Model;
import com.dataiku.lambda.client.BaseLambdaAPIClient;
import com.dataiku.lambda.client.VertexAILambdaAPIClient;
import com.dataiku.lambda.model.studioconfig.ApiEndpointQuery;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;

public class VertexAIDeploymentManager
extends AbstractFullyManagedAPIServiceDeploymentManager {
    private static final int ENDPOINT_ID_MAX_LENGTH = 63;
    private static final int MODEL_DISPLAY_NAME_MAX_LENGTH = 128;
    private final VertexAIAPIDeployment deployment;
    private final VertexAIAPIDeploymentInfra infra;
    private final VertexAIDeploymentConfigManager deploymentConfigManager;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.deployer.deployment.vertexai.manager");

    public VertexAIDeploymentManager(AuthCtx authCtx, VertexAIAPIDeployment deployment, VertexAIAPIDeploymentInfra infra, int connectTimeout, int socketTimeout) {
        super(authCtx, connectTimeout, socketTimeout);
        this.deployment = deployment;
        this.deployment.overrideSettings.applyToDeployment(this.deployment, infra);
        this.infra = infra;
        this.deploymentConfigManager = new VertexAIDeploymentConfigManager(deployment, this.infra, this.getVariablesContext());
        SpringUtils.getInstance().autowire((Object)this);
    }

    @Override
    protected DKULogger getLogger() {
        return logger;
    }

    @Override
    protected VertexAIAPIDeployment getDeployment() {
        return this.deployment;
    }

    @Override
    protected VertexAIDeploymentConfigManager getConfigManager() {
        return this.deploymentConfigManager;
    }

    @Override
    protected VertexAIAPIDeploymentInfra getInfra() {
        return this.infra;
    }

    @Override
    protected VertexAIDeploymentHeavyStatus createNewHeavyStatus(String deploymentId, String infraId) {
        return new VertexAIDeploymentHeavyStatus(deploymentId, infraId);
    }

    @Override
    protected int numberOfDeploymentSteps() {
        return this.deployment.enabled ? 8 : 1;
    }

    @Override
    @Nonnull
    protected FuturePayload getDeploymentPayload() {
        return FuturePayload.newSimple((String)"sync_vertexai_api_deployment", (String)("Sync Vertex AI deployment: " + this.deployment.id));
    }

    @Override
    @Nonnull
    protected String getInfraPrettyName() {
        return "Vertex AI";
    }

    @Override
    protected VertexAIDeploymentStatusReporter getDeploymentStatusReporter() {
        return new VertexAIDeploymentStatusReporter(this.deployment.id, this.deployment.infraId);
    }

    @Nonnull
    private VertexAIDeploymentInfo getDeploymentInfo() throws IOException {
        VertexAIDeploymentInfo existingReferences = this.deploymentInfoCRUDService.get(this.getInfra().id, this.getDeployment().id, VertexAIDeploymentInfo.class);
        return (VertexAIDeploymentInfo)ObjectUtils.defaultIfNull((Object)existingReferences, (Object)new VertexAIDeploymentInfo(this.infra, this.deployment));
    }

    @Override
    public DeploymentStatusReport getFullCheckReport_NT() throws IOException, URISyntaxException, DKUSecurityException {
        GoogleCredentials credentials;
        VertexAIModelDeploymentConnection connection = (VertexAIModelDeploymentConnection)ExternalInfrasUtils.getAndCheckConnection(this.authCtx, this.infra.authConnection);
        try {
            credentials = VertexAIUtils.getGoogleCredentials_NT(this.authCtx, connection);
        }
        catch (Exception e) {
            this.getLogger().error((Object)"Error while trying to get Google credentials.", (Throwable)e);
            throw e;
        }
        VertexAIDeploymentInfo deploymentInfo = this.getDeploymentInfo();
        VertexAIDeploymentLocalSummary localSummary = VertexAIDeploymentLocalSummary.buildFromLocalConfig(this.deployment, this.infra, this.getVariablesContext(), deploymentInfo);
        VertexAIDeploymentRemoteSummary remoteSummary = VertexAIDeploymentRemoteSummary.buildFromRemoteConfig_NT(deploymentInfo, credentials, connection);
        return this.getDeploymentStatusReporter().computeFullCheck(localSummary, remoteSummary, this.deployment.enabled);
    }

    @Override
    public VertexAIDeploymentHeavyStatus getStatus_Unsafe_NT(boolean withPackageExtraInfo, @Nullable String overridingConnectionName) throws IOException, DKUSecurityException, URISyntaxException {
        VertexAIDeploymentHeavyStatus status = new VertexAIDeploymentHeavyStatus(this.deployment.id, this.deployment.infraId);
        status.packages = this.publishedAPIServicesService.listPublishedPackages_Check_Unsafe_NT(this.deployment.publishedServiceId, this.authCtx);
        String usedConnection = overridingConnectionName != null ? overridingConnectionName : this.infra.authConnection;
        VertexAIDeploymentInfo deploymentInfo = this.getDeploymentInfo();
        VertexAIModelDeploymentConnection connection = (VertexAIModelDeploymentConnection)ExternalInfrasUtils.getAndCheckConnection(this.authCtx, usedConnection);
        GoogleCredentials credentials = VertexAIUtils.getGoogleCredentials_NT(this.authCtx, connection);
        VertexAIDeploymentLocalSummary localSummary = VertexAIDeploymentLocalSummary.buildFromLocalConfig(this.deployment, this.infra, this.getVariablesContext(), deploymentInfo);
        Endpoint remoteEndpoint = VertexAIUtils.from(deploymentInfo.gcpRegion, deploymentInfo.gcpProjectId, credentials, connection).getEndpoint_NT(deploymentInfo.vertexAIEndpointId).orElse(null);
        status.endpoints = status.summarizeEndpoints_NT(this.deployment, withPackageExtraInfo);
        status.checkEndpointHealth(localSummary, remoteEndpoint, this.deployment.enabled);
        return status;
    }

    @Override
    public void deleteResources_NT() throws CodedException, IOException {
        GoogleCredentials credentials;
        VertexAIModelDeploymentConnection connection;
        VertexAIDeploymentInfo deploymentInfo = this.getDeploymentInfo();
        try {
            connection = (VertexAIModelDeploymentConnection)ExternalInfrasUtils.getAndCheckConnection(this.authCtx, this.infra.authConnection);
        }
        catch (DKUSecurityException e) {
            String message = "Error while accessing connection details";
            logger.error((Object)message, (Throwable)e);
            throw new CodedException((InfoMessage.MessageCode)(e.getCode() != null ? e.getCode() : DeployerCodes.ERR_API_DEPLOYER_FULLY_MANAGED_INVALID_CONNECTION), message, (Throwable)e);
        }
        try {
            credentials = VertexAIUtils.getGoogleCredentials_NT(this.authCtx, connection);
        }
        catch (DKUSecurityException | IOException | URISyntaxException e) {
            String message = "Error while trying to acquire credentials for GCP.";
            logger.error((Object)message, e);
            throw new CodedException((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_VERTEXAI_GET_CREDENTIALS_FAILED, message, e);
        }
        this.deleteDeployedModelsAndEndpointResources(deploymentInfo, credentials, connection);
        this.deleteModelResource(deploymentInfo, credentials, connection);
        this.deploymentInfoCRUDService.delete(this.deployment.infraId, this.deployment.id);
    }

    @Override
    @Nonnull
    protected InfoMessage.InfoMessages doDeployment(@Nonnull DKUtils.SmartLogTailBuilder logTailBuilder) throws Exception {
        logger.infoV("Prepare sync of deployment %s", new Object[]{this.deployment.id});
        logger.info((Object)"Summary of the DSS resources used to update the deployment:");
        logger.infoV("Vertex AI infra: %s", new Object[]{JSON.json((Object)this.infra)});
        logger.infoV("Vertex AI deployment: %s", new Object[]{JSON.json((Object)this.deployment)});
        InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
        try (AutoDelete tmpDir = DSSTempUtils.getTempFolder((String)"api_deployer", (String)this.deployment.id, (boolean)true);){
            DeployedModel deployedModel;
            FutureProgress.AutocloseableFutureProgressState ignored;
            Endpoint endpoint;
            Model model;
            VertexAIDeploymentInfo deploymentInfo = this.getDeploymentInfo();
            VertexAIModelDeploymentConnection connection = (VertexAIModelDeploymentConnection)ExternalInfrasUtils.getAndCheckConnection(this.authCtx, this.infra.authConnection);
            GoogleCredentials credentials = VertexAIUtils.getGoogleCredentials_NT(this.authCtx, connection);
            if (!this.deployment.enabled) {
                this.disableDeployment(credentials, connection, deploymentInfo, logTailBuilder);
                FutureProgress.incrementState((double)1.0);
                InfoMessage.InfoMessages infoMessages = ret;
                return infoMessages;
            }
            this.deployment.verifyPackageCompatibility(this.getPackageInfo_NT());
            VertexAIDeploymentLocalSummary localSummary = VertexAIDeploymentLocalSummary.buildFromLocalConfig(this.deployment, this.infra, this.getVariablesContext(), deploymentInfo);
            logger.debug((Object)"Gathering the information of the deployment from GCP");
            VertexAIDeploymentRemoteSummary remoteSummary = VertexAIDeploymentRemoteSummary.buildFromRemoteConfig_NT(deploymentInfo, credentials, connection);
            this.createDeployerKeyIfAuthorizationToQueryThroughDeployer(this.deployment, ret);
            File contextDir = this.apiDeployerImageBuilderService.prepareDockerImageContext(this.authCtx, this.infra, this.deployment, this.deployment.getTargetId(), (File)tmpDir);
            HashMap<String, String> additionalEnv = new HashMap<String, String>();
            VertexAIUtils.prepareEnvForPush_NT(contextDir, credentials, additionalEnv);
            FutureProgress.incrementState((double)1.0);
            ProxySettings proxySettings = ExternalInfrasUtils.getProxy(connection);
            APIDeployerImageBuilderService.ImageNameTags imageNameTags = new APIDeployerImageBuilderService.ImageNameTags(this.infra, this.deployment, this.getVariablesContext());
            String buildMessage = "Building Docker image" + (DKUApp.isDataikuCloud() ? " and pushing it to registry" : "");
            try (FutureProgress.AutocloseableFutureProgressState ignored2 = FutureProgress.pushAutoCloseableState((String)buildMessage);){
                if (DKUApp.isDataikuCloud()) {
                    this.apiDeployerImageBuilderService.executePrePushScript(this.authCtx, this.infra, imageNameTags, proxySettings, additionalEnv, logTailBuilder);
                    additionalEnv.putAll(this.apiDeployerImageBuilderService.getCraneAuthToken(this.infra.getRegistryHost(), additionalEnv));
                }
                this.apiDeployerImageBuilderService.buildDockerImage(this.infra, imageNameTags, logTailBuilder, this.rebuildCodeEnv, contextDir, additionalEnv);
            }
            FutureProgress.incrementState((double)1.0);
            if (!DKUApp.isDataikuCloud()) {
                ignored2 = FutureProgress.pushAutoCloseableState((String)"Pushing image to repository");
                try {
                    if (StringUtils.isBlank((String)this.getInfra().getRegistryHost())) {
                        throw ErrorContext.ice((String)"The 'Registry host' is not defined in the infrastructure settings.");
                    }
                    this.apiDeployerImageBuilderService.tagAndPushImage(this.authCtx, this.infra, logTailBuilder, imageNameTags, proxySettings, additionalEnv);
                }
                finally {
                    if (ignored2 != null) {
                        ignored2.close();
                    }
                }
            }
            FutureProgress.incrementState((double)1.0);
            neverEverDeployed.remove(this.getDeployment().id);
            try (FutureProgress.AutocloseableFutureProgressState ignored3 = FutureProgress.pushAutoCloseableState((String)"Creating Vertex AI Model");){
                logTailBuilder.appendLine("Creating Vertex AI Model...");
                model = this.createModel(credentials, connection, imageNameTags);
                logTailBuilder.appendLine(String.format("Vertex AI model created with name %s", model.getName()));
            }
            FutureProgress.incrementState((double)1.0);
            try (FutureProgress.AutocloseableFutureProgressState ignored4 = FutureProgress.pushAutoCloseableState((String)"Creating Vertex AI Endpoint");){
                logTailBuilder.appendLine("Creating/Updating Vertex AI Endpoint...");
                endpoint = this.createOrUpdateEndpoint(localSummary.endpoint, remoteSummary.endpoint, credentials, connection);
                logTailBuilder.appendLine(String.format("Vertex AI Endpoint created/updated with name %s", endpoint.getName()));
            }
            catch (Exception e) {
                this.deleteNewModelAfterFailure(model, localSummary.model, credentials, connection);
                throw e;
            }
            FutureProgress.incrementState((double)1.0);
            try {
                ignored = FutureProgress.pushAutoCloseableState((String)"Creating Vertex AI DeployedModel");
                try {
                    logTailBuilder.appendLine("Creating/Updating Vertex AI DeployedModel...");
                    deployedModel = this.createOrUpdateDeployedModel(localSummary.deployedModel, model, endpoint, credentials, connection);
                    logTailBuilder.appendLine(String.format("Vertex AI DeployedModel created/updated with id %s", deployedModel.getId()));
                }
                finally {
                    if (ignored != null) {
                        ignored.close();
                    }
                }
            }
            catch (Exception e) {
                this.deleteNewEndpointAfterFailure(endpoint, localSummary.endpoint, credentials, connection);
                this.deleteNewModelAfterFailure(model, localSummary.model, credentials, connection);
                throw e;
            }
            FutureProgress.incrementState((double)1.0);
            ignored = FutureProgress.pushAutoCloseableState((String)"Saving changes");
            try {
                logTailBuilder.appendLine("Updating deployment changes...");
                VertexAIDeploymentInfo newDeploymentInfo = new VertexAIDeploymentInfo(this.infra, this.deployment, model, endpoint, deployedModel);
                this.deploymentInfoCRUDService.save(newDeploymentInfo);
                logTailBuilder.appendLine(String.format("Changes saved for deployment with id %s.", this.deployment.id));
            }
            finally {
                if (ignored != null) {
                    ignored.close();
                }
            }
            FutureProgress.incrementState((double)1.0);
            ignored = FutureProgress.pushAutoCloseableState((String)"Delete old Vertex resources");
            try {
                logTailBuilder.appendLine("Deleting previous Vertex resources...");
                this.deletePreviousEndpoint(localSummary.endpoint, endpoint, credentials, connection);
                this.deletePreviousModel(localSummary.model, model, credentials, connection);
                logTailBuilder.appendLine("Previous Vertex resources deleted.");
            }
            finally {
                if (ignored != null) {
                    ignored.close();
                }
            }
            FutureProgress.incrementState((double)1.0);
        }
        return ret;
    }

    @Override
    protected String diagnosisInternal(File tmpDir, String fileFriendlyLocalNow, FutureThreadBase<?> future) throws Exception {
        JsonObject gcloudVersion;
        GoogleCredentials credentials;
        VertexAIModelDeploymentConnection connection;
        logger.infoV("Generating diagnostic of  %s...", new Object[]{this.deployment.id});
        VertexAIDeploymentInfo deploymentInfo = this.getDeploymentInfo();
        try {
            connection = (VertexAIModelDeploymentConnection)ExternalInfrasUtils.getAndCheckConnection(this.authCtx, this.infra.authConnection);
        }
        catch (DKUSecurityException e) {
            String message = "Error while accessing connection details";
            logger.error((Object)message, (Throwable)e);
            throw new CodedException((InfoMessage.MessageCode)(e.getCode() != null ? e.getCode() : DeployerCodes.ERR_API_DEPLOYER_FULLY_MANAGED_INVALID_CONNECTION), message, (Throwable)e);
        }
        try {
            credentials = VertexAIUtils.getGoogleCredentials_NT(this.authCtx, connection);
        }
        catch (DKUSecurityException | IOException | URISyntaxException e) {
            String message = "Error while trying to acquire credentials for GCP.";
            logger.error((Object)message, e);
            throw new CodedException((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_VERTEXAI_GET_CREDENTIALS_FAILED, message, e);
        }
        JSON.prettyToFile((Object)this.deployment, (File)new File(tmpDir, "deployment.json"));
        JSON.prettyToFile((Object)deploymentInfo, (File)new File(tmpDir, "deployment-info.json"));
        if (AbstractInfrasService.hasAdminPermission(this.infra, this.authCtx)) {
            logger.infoV("Diagnosis requested by a user with admin permissions on infra. Including %s configuration file.", new Object[]{"infra.json"});
            JSON.prettyToFile((Object)this.infra, (File)new File(tmpDir, "infra.json"));
        } else {
            logger.infoV("Diagnosis requested by a user without admin permissions on infra. Not including configuration file %s.", new Object[]{"infra.json"});
        }
        if (future.isAborted()) {
            throw new InterruptedException("Diagnosis aborted");
        }
        FutureProgress.incrementState((double)1.0);
        logger.info((Object)"Fetch summaries of Vertex AI resources");
        VertexAIDeploymentLocalSummary localSummary = VertexAIDeploymentLocalSummary.buildFromLocalConfig(this.deployment, this.infra, this.getVariablesContext(), deploymentInfo);
        VertexAIDeploymentRemoteSummary remoteSummary = VertexAIDeploymentRemoteSummary.buildFromRemoteConfig_NT(deploymentInfo, credentials, connection);
        if (AbstractInfrasService.hasAdminPermission(this.infra, this.authCtx)) {
            logger.info((Object)"Diagnosis requested by a user with admin permissions on infra. Including local and remote summary files.");
            JSON.prettyToFile((Object)localSummary, (File)new File(tmpDir, "local-summary.json"));
            JSON.prettyToFile((Object)remoteSummary, (File)new File(tmpDir, "remote-summary.json"));
        } else {
            logger.info((Object)"Diagnosis requested by a user without admin permissions on infra. Not including local and remote summary files.");
        }
        DeploymentStatusReport statusReport = this.getDeploymentStatusReporter().computeFullCheck(localSummary, remoteSummary, this.deployment.enabled);
        JSON.prettyToFile((Object)statusReport, (File)new File(tmpDir, "status-report.json"));
        if (future.isAborted()) {
            throw new InterruptedException("Diagnosis aborted");
        }
        FutureProgress.incrementState((double)1.0);
        logger.info((Object)"Fetch versions");
        JsonObject versions = new JsonObject();
        versions.addProperty("dss-version", DKUApp.getDSSVersion().product_version);
        DKUtils.ExecutionResults cmdResult = DKUtils.execAndGetOutputAndErrors((String[])new String[]{"gcloud", "version", "--format=json"}, System.getenv());
        if (cmdResult.rv != 0) {
            gcloudVersion = new JsonObject();
            gcloudVersion.addProperty("error", cmdResult.err);
            logger.warn((Object)("Failed to get gcloud version: " + JSON.json((Object)cmdResult)));
        } else {
            gcloudVersion = (JsonObject)JSON.parse((String)cmdResult.out, JsonObject.class);
        }
        versions.add("gcloud-cli-versions", (JsonElement)gcloudVersion);
        JSON.prettyToFile((Object)versions, (File)new File(tmpDir, "versions.json"));
        if (future.isAborted()) {
            throw new InterruptedException("Diagnosis aborted");
        }
        FutureProgress.incrementState((double)1.0);
        if (AbstractInfrasService.hasAdminPermission(this.infra, this.authCtx)) {
            logger.info((Object)"User has infra admin permissions ; adding deployment logs");
            File logsDir = DKUFileUtils.getWithin((File)tmpDir, (String[])new String[]{"deployment-logs"});
            DKUFileUtils.mkdirs((File)logsDir);
            for (Path path : this.apiServiceDeploymentsService.listLogFiles(this.deployment)) {
                FileUtils.copyFileToDirectory((File)path.toFile(), (File)logsDir);
            }
        } else {
            logger.info((Object)"User does not have infra admin permissions ; not adding deployment logs");
        }
        return tmpDir.getName();
    }

    @Override
    public BaseLambdaAPIClient.ApiEndpointResponses runQueries_NT(String deployedServiceId, APIServiceDeploymentHeavyStatus.EndpointSummary endpoint, AbstractDeploymentLightStatus.APIServiceDeploymentLightStatus lightStatus, APIServiceDeploymentHeavyStatus heavyStatus, List<ApiEndpointQuery> allQueries, boolean forTest) throws IOException, DKUSecurityException, URISyntaxException {
        VertexAIDeploymentInfo deploymentInfo = this.getDeploymentInfo();
        return VertexAILambdaAPIClient.runQueries_NT(this.authCtx, this.infra, deploymentInfo.gcpProjectId, deploymentInfo.gcpRegion, deploymentInfo.vertexAIEndpointId, endpoint, allQueries, forTest);
    }

    private static VertexAIUtils getUtils(VertexAIDeploymentInfo deploymentInfo, GoogleCredentials credentials, @Nullable VertexAIModelDeploymentConnection connection) {
        return VertexAIUtils.from(deploymentInfo.gcpRegion, deploymentInfo.gcpProjectId, credentials, connection);
    }

    private void disableDeployment(GoogleCredentials credentials, VertexAIModelDeploymentConnection connection, VertexAIDeploymentInfo deploymentInfo, DKUtils.SmartLogTailBuilder logTailBuilder) throws CodedException, IOException {
        String disablingMessage = String.format("Deployment %s disabled, removing deployed models.", this.deployment.id);
        logger.info((Object)disablingMessage);
        logTailBuilder.appendLine(disablingMessage);
        String endpointId = deploymentInfo.vertexAIEndpointId;
        this.undeployModels(endpointId, deploymentInfo, logTailBuilder, credentials, connection);
        logTailBuilder.appendLine("Saving deployment changes...");
        deploymentInfo.vertexAIDeployedModelId = null;
        this.deploymentInfoCRUDService.save(deploymentInfo);
        logTailBuilder.appendLine(String.format("Changes saved for deployment %s.", this.deployment.id));
    }

    private void deleteDeployedModelsAndEndpointResources(VertexAIDeploymentInfo deploymentInfo, GoogleCredentials credentials, VertexAIModelDeploymentConnection connection) throws CodedException {
        String endpointId = deploymentInfo.vertexAIEndpointId;
        if (StringUtils.isBlank((String)endpointId)) {
            logger.info((Object)"No endpoint resource to delete.");
            return;
        }
        try {
            logger.info((Object)("Deleting Vertex AI endpoint with id " + endpointId));
            VertexAIDeploymentManager.getUtils(deploymentInfo, credentials, connection).undeployModelsThenDeleteEndpoint_NT(endpointId);
            logger.info((Object)("Endpoint " + endpointId + " deleted."));
        }
        catch (Exception e) {
            String message = String.format("Error deleting Vertex AI Endpoint '%s' associated to the deployment '%s'.", endpointId, this.deployment.id);
            logger.error((Object)message, (Throwable)e);
            throw new CodedException((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_FULLY_MANAGED_DELETE_RESOURCE, message + " " + e.getMessage());
        }
    }

    private void deleteModelResource(VertexAIDeploymentInfo deploymentInfo, GoogleCredentials credentials, VertexAIModelDeploymentConnection connection) throws CodedException {
        String modelId = deploymentInfo.vertexAIModelId;
        if (StringUtils.isBlank((String)modelId)) {
            logger.info((Object)"No model resource to delete.");
            return;
        }
        try {
            logger.info((Object)("Deleting Vertex AI model with id " + modelId));
            VertexAIDeploymentManager.getUtils(deploymentInfo, credentials, connection).deleteModel_NT(modelId);
            logger.info((Object)("Model " + modelId + " deleted."));
        }
        catch (Exception e) {
            logger.error((Object)String.format("Error deleting Vertex AI Model '%s' associated to the deployment '%s'.", modelId, this.deployment.id), (Throwable)e);
            throw new CodedException((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_FULLY_MANAGED_DELETE_RESOURCE, String.format("Error deleting Vertex AI Model '%s' associated to the deployment '%s'.", modelId, this.deployment.id) + " " + e.getMessage());
        }
    }

    private void undeployModels(@Nullable String endpointId, @Nonnull VertexAIDeploymentInfo deploymentInfo, @Nullable DKUtils.SmartLogTailBuilder logTailBuilder, GoogleCredentials credentials, VertexAIModelDeploymentConnection connection) throws CodedException {
        if (StringUtils.isBlank((String)endpointId)) {
            String noDeleteMessage = "No Vertex AI endpoint found so no models to undeploy.";
            logger.info((Object)noDeleteMessage);
            if (logTailBuilder != null) {
                logTailBuilder.appendLine(noDeleteMessage);
            }
            return;
        }
        try {
            if (logTailBuilder != null) {
                logTailBuilder.appendLine("Undeploy models associated with Vertex AI endpoint " + endpointId);
            }
            VertexAIDeploymentManager.getUtils(deploymentInfo, credentials, connection).undeployModels_NT(endpointId);
            if (logTailBuilder != null) {
                logTailBuilder.appendLine("Models associated to Vertex AI endpoint " + endpointId + " undeployed.");
            }
        }
        catch (Exception e) {
            String message = String.format("Error undeploying models associated to Vertex AI Endpoint '%s' on the deployment '%s'.", endpointId, this.deployment.id);
            if (logTailBuilder != null) {
                logTailBuilder.appendLine(message);
            }
            logger.error((Object)message, (Throwable)e);
            throw new CodedException((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_FULLY_MANAGED_DELETE_RESOURCE, message + " " + e.getMessage());
        }
    }

    private void deleteNewModelAfterFailure(@Nonnull Model newModel, @Nullable VertexAIModel oldModel, GoogleCredentials credentials, VertexAIModelDeploymentConnection connection) {
        String newModelFullName = newModel.getName();
        try {
            if (oldModel == null || !VertexAIUtils.areModelFullNamesEqual(newModelFullName, oldModel.getFullName(), true)) {
                logger.debugV("Rolling back to previously created model. Deleting unused model %s", new Object[]{newModelFullName});
                String newModelId = VertexAIUtils.extractModelId(newModelFullName);
                VertexAIDeploymentManager.getUtils(this.getDeploymentInfo(), credentials, connection).deleteModel_NT(newModelId);
                logger.debug((Object)"Vertex AI model rollback successful.");
            }
        }
        catch (Exception rollbackException) {
            logger.errorV((Throwable)rollbackException, "Error deleting model %s", new Object[]{newModelFullName});
        }
    }

    private void deleteNewEndpointAfterFailure(@Nonnull Endpoint newEndpoint, @Nullable VertexAIEndpoint oldEndpoint, GoogleCredentials credentials, VertexAIModelDeploymentConnection connection) {
        String newEndpointFullName = newEndpoint.getName();
        try {
            if (oldEndpoint == null || !VertexAIUtils.areEndpointFullNamesEqual(newEndpointFullName, oldEndpoint.getFullName(), true)) {
                logger.debugV("Rolling back to previously created endpoint. Deleting unused endpoint %s", new Object[]{newEndpointFullName});
                String newEndpointId = VertexAIUtils.extractEndpointId(newEndpointFullName);
                VertexAIDeploymentManager.getUtils(this.getDeploymentInfo(), credentials, connection).undeployModelsThenDeleteEndpoint_NT(newEndpointId);
                logger.debug((Object)"Vertex AI endpoint rollback successful.");
            }
        }
        catch (Exception rollbackException) {
            logger.errorV((Throwable)rollbackException, "Error deleting endpoint %s", new Object[]{newEndpointFullName});
        }
    }

    private void deletePreviousModel(@Nullable VertexAIModel oldModel, @Nonnull Model newModel, GoogleCredentials credentials, VertexAIModelDeploymentConnection connection) {
        if (oldModel == null) {
            return;
        }
        try {
            if (!VertexAIUtils.areModelFullNamesEqual(newModel.getName(), oldModel.getFullName(), true)) {
                VertexAIDeploymentManager.getUtils(this.getDeploymentInfo(), credentials, connection).deleteModel_NT(oldModel.getId());
            }
        }
        catch (Exception e) {
            logger.errorV((Throwable)e, "Error deleting old model %s", new Object[]{oldModel.getFullName()});
        }
    }

    private void deletePreviousEndpoint(@Nullable VertexAIEndpoint oldEndpoint, @Nonnull Endpoint newEndpoint, GoogleCredentials credentials, VertexAIModelDeploymentConnection connection) {
        if (oldEndpoint == null) {
            return;
        }
        try {
            if (!VertexAIUtils.areEndpointFullNamesEqual(newEndpoint.getName(), oldEndpoint.getFullName(), true)) {
                VertexAIDeploymentManager.getUtils(this.getDeploymentInfo(), credentials, connection).undeployModelsThenDeleteEndpoint_NT(oldEndpoint.getId());
            }
        }
        catch (Exception e) {
            logger.errorV((Throwable)e, "Error deleting old endpoint %s", new Object[]{oldEndpoint.getFullName()});
        }
    }

    private DeployedModel createOrUpdateDeployedModel(@Nullable VertexAIDeployedModel storedDeployedModel, @Nonnull Model updatedModel, @Nonnull Endpoint endpoint, GoogleCredentials credentials, VertexAIModelDeploymentConnection connection) throws IOException, ExecutionException, InterruptedException {
        if (storedDeployedModel == null) {
            logger.debugV("Vertex Deployed Model id not found. Creating a new one.", new Object[0]);
            return this.replaceDeployedModels(updatedModel, endpoint, credentials, connection);
        }
        String deployedModelId = storedDeployedModel.getId();
        Optional<DeployedModel> deployedDeployedModelOpt = VertexAIUtils.getDeployedModel(deployedModelId, endpoint);
        if (!deployedDeployedModelOpt.isPresent()) {
            logger.warnV("Deployed model %s is not present on Vertex AI. It must have been deleted manually. Recreating a new one.", new Object[]{deployedModelId});
            return this.replaceDeployedModels(updatedModel, endpoint, credentials, connection);
        }
        DeployedModel deployedDeployedModel = deployedDeployedModelOpt.get();
        if (new VertexAIDeployedModelComparator(storedDeployedModel).isOutOfSync(deployedDeployedModel, updatedModel.getName())) {
            logger.debugV("Deployed Model %s is out of sync. Updating it.", new Object[]{deployedModelId});
            return this.replaceDeployedModels(updatedModel, endpoint, credentials, connection);
        }
        logger.debugV("Nothing to update in deployed model %s.", new Object[]{deployedModelId});
        return deployedDeployedModel;
    }

    private DeployedModel replaceDeployedModels(@Nonnull Model newModel, @Nonnull Endpoint endpoint, GoogleCredentials credentials, VertexAIModelDeploymentConnection connection) throws IOException, ExecutionException, InterruptedException {
        VertexAIDeployedModelConfig config = VertexAIDataModelBuilder.buildDeployedModelConfig(this.deployment, this.infra);
        return VertexAIDeploymentManager.getUtils(this.getDeploymentInfo(), credentials, connection).replaceDeployedModels_NT(newModel, endpoint, config);
    }

    private Endpoint createOrUpdateEndpoint(@Nullable VertexAIEndpoint storedEndpoint, @Nullable Endpoint deployedEndpoint, GoogleCredentials credentials, VertexAIModelDeploymentConnection connection) throws IOException, ExecutionException, InterruptedException {
        VertexAIEndpointConfig config = VertexAIDataModelBuilder.buildEndpointConfig(this.deployment, this.infra, this.getVariablesContext());
        if (storedEndpoint == null) {
            String endpointId;
            logger.debug((Object)"Vertex Endpoint id not found. Creating a new one.");
            String customEndpointId = this.deployment.getCustomEndpointId(this.infra);
            if (StringUtils.isNotBlank((String)customEndpointId)) {
                endpointId = customEndpointId;
                logger.debugV("Using customEndpointId with value %s", new Object[]{endpointId});
            } else {
                endpointId = this.getConfigManager().generateDeploymentConfigName(63, "dss", "-");
                logger.debugV("New endpointId generated with value %s", new Object[]{endpointId});
            }
            VertexAICreateEndpointRequest request = new VertexAICreateEndpointRequest(endpointId, config);
            return this.createEndpoint(request, credentials, connection);
        }
        String endpointId = storedEndpoint.getId();
        if (deployedEndpoint == null) {
            logger.warnV("Endpoint %s is not present on Vertex AI. It must have been deleted manually. Recreating a new one with same id.", new Object[]{endpointId});
            VertexAICreateEndpointRequest request = new VertexAICreateEndpointRequest(endpointId, config);
            return this.createEndpoint(request, credentials, connection);
        }
        VertexAIEndpointComparator endpointComparator = new VertexAIEndpointComparator(storedEndpoint);
        if (endpointComparator.isOutOfSyncUnrecoverable(deployedEndpoint)) {
            logger.infoV("Endpoint %s is out of sync but can't be updated. Deleting the old one then recreating a new one with same id.", new Object[]{endpointId});
            this.deleteEndpoint(storedEndpoint, credentials, connection);
            VertexAICreateEndpointRequest request = new VertexAICreateEndpointRequest(endpointId, config);
            return this.createEndpoint(request, credentials, connection);
        }
        if (endpointComparator.isOutOfSyncRecoverable(deployedEndpoint)) {
            logger.infoV("Endpoint %s is out of sync. Updating it.", new Object[]{endpointId});
            return this.updateEndpoint(storedEndpoint, credentials, connection);
        }
        logger.debugV("Nothing to update in endpoint %s.", new Object[]{endpointId});
        return deployedEndpoint;
    }

    private Endpoint updateEndpoint(VertexAIEndpoint storedEndpoint, GoogleCredentials credentials, VertexAIModelDeploymentConnection connection) throws IOException {
        return VertexAIDeploymentManager.getUtils(this.getDeploymentInfo(), credentials, connection).updateEndpoint_NT(storedEndpoint);
    }

    private void deleteEndpoint(VertexAIEndpoint storedEndpoint, GoogleCredentials credentials, VertexAIModelDeploymentConnection connection) throws IOException, ExecutionException, InterruptedException {
        VertexAIDeploymentManager.getUtils(this.getDeploymentInfo(), credentials, connection).undeployModelsThenDeleteEndpoint_NT(storedEndpoint.getId());
    }

    private Endpoint createEndpoint(@Nonnull VertexAICreateEndpointRequest requestedEndpoint, GoogleCredentials credentials, VertexAIModelDeploymentConnection connection) throws IOException, ExecutionException, InterruptedException {
        return VertexAIDeploymentManager.getUtils(this.getDeploymentInfo(), credentials, connection).createEndpoint_NT(requestedEndpoint);
    }

    @Nonnull
    private Model createModel(GoogleCredentials credentials, VertexAIModelDeploymentConnection connection, @Nonnull APIDeployerImageBuilderService.ImageNameTags imageNameTags) throws IOException, ExecutionException, InterruptedException {
        logger.debugV("Recreating a new model.", new Object[0]);
        return this.createModel_NT(credentials, connection, imageNameTags);
    }

    private Model createModel_NT(GoogleCredentials credentials, VertexAIModelDeploymentConnection connection, APIDeployerImageBuilderService.ImageNameTags imageNameTags) throws IOException, ExecutionException, InterruptedException {
        String modelDisplayName = this.getConfigManager().generateDeploymentConfigName(128, "dss", "-");
        String imageUri = this.infra.getImageAliasInRegistryHost(imageNameTags.imageName, imageNameTags.imageVersion);
        VertexAIModelConfig config = VertexAIDataModelBuilder.buildModelConfig(this.deployment, this.infra, this.getVariablesContext(), imageUri);
        VertexAIModelInternalConfig internalConfig = VertexAIDataModelBuilder.buildModelInternalConfig(this.deployment, this.infra);
        VertexAICreateModelRequest request = new VertexAICreateModelRequest(modelDisplayName, config, internalConfig);
        return VertexAIDeploymentManager.getUtils(this.getDeploymentInfo(), credentials, connection).createModel_NT(request);
    }
}

