/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.code;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvResolutionService;
import com.dataiku.dip.code.CodeEnvUtilsBase;
import com.dataiku.dip.code.JupyterCodeEnvUtils;
import com.dataiku.dip.containers.exec.ContainerExecImagesBuilder;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.CollectionUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class CodeEnvLanguages {
    public static final LanguageMeta PYTHON = new LanguageMeta(){

        @Override
        public void installJupyterSupport(AuthCtx authCtx, String envName, String projectKey, String bundleId, DKUtils.SmartLogTailBuilder tailBuilder, File log, String remoteBin, String containerConf) throws IOException, InterruptedException {
            String kernelName = JupyterCodeEnvUtils.getKernelName(CodeEnvModel.EnvLang.PYTHON, envName, projectKey, bundleId, containerConf);
            String displayName = JupyterCodeEnvUtils.getDisplayName(CodeEnvModel.EnvLang.PYTHON, envName, projectKey, bundleId, containerConf);
            List<String> jupyterCommand = new ArrayList<String>();
            jupyterCommand.add("-m");
            jupyterCommand.add("ipykernel");
            jupyterCommand.add("install");
            jupyterCommand.add("--user");
            jupyterCommand.add("--name");
            jupyterCommand.add(kernelName);
            jupyterCommand.add("--display-name");
            jupyterCommand.add(displayName);
            CodeEnvResolutionService codeEnvResolutionService = (CodeEnvResolutionService)SpringUtils.getBean(CodeEnvResolutionService.class);
            jupyterCommand = codeEnvResolutionService.getPythonCmdAndGetBundleIdIfNull(envName, projectKey, bundleId, jupyterCommand);
            ProcessBuilder pb = new ProcessBuilder(jupyterCommand);
            String kernelsDir = System.getenv("DIP_HOME") + "/jupyter-run/jupyter";
            pb.environment().put("JUPYTER_DATA_DIR", kernelsDir);
            CodeEnvUtilsBase.addLogHeader(authCtx, log, "install jupyter support", StringUtils.join(pb.command(), (String)" "));
            logger.info((Object)("Installing Jupyter kernel: " + StringUtils.join(pb.command(), (String)" ")));
            DKUtils.execAndLogThrowsMirror((ProcessBuilder)pb, (DKUtils.SmartLogTailBuilder)tailBuilder, (File)log);
            CodeEnvLanguages.addEnvAndMetadataToKernel(kernelName, CodeEnvModel.EnvLang.PYTHON, envName, projectKey, bundleId, containerConf, CollectionUtils.appendableSSMap().put("PYSPARK_PYTHON", remoteBin).get());
        }

        @Override
        public void removeJupyterSupport(AuthCtx authCtx, String envName, String projectKey, String bundleId, DKUtils.SmartLogTailBuilder tailBuilder, File log, String containerConf) throws IOException, InterruptedException {
            String kernelName = JupyterCodeEnvUtils.getKernelName(CodeEnvModel.EnvLang.PYTHON, envName, projectKey, bundleId, containerConf);
            List<String> jupyterCommand = new ArrayList<String>();
            jupyterCommand.add("-m");
            jupyterCommand.add("jupyter_client.kernelspecapp");
            jupyterCommand.add("remove");
            jupyterCommand.add("-f");
            jupyterCommand.add(kernelName);
            CodeEnvResolutionService codeEnvResolutionService = (CodeEnvResolutionService)SpringUtils.getBean(CodeEnvResolutionService.class);
            jupyterCommand = codeEnvResolutionService.getPythonCmdAndGetBundleIdIfNull(envName, projectKey, bundleId, jupyterCommand);
            ProcessBuilder pb = new ProcessBuilder(jupyterCommand);
            pb.environment().put("JUPYTER_DATA_DIR", System.getenv("DIP_HOME") + "/jupyter-run/jupyter");
            CodeEnvUtilsBase.addLogHeader(authCtx, log, "remove jupyter support", StringUtils.join(pb.command(), (String)" "));
            logger.info((Object)("Removing Jupyter kernel: " + StringUtils.join(pb.command(), (String)" ")));
            DKUtils.execAndLogThrowsMirror((ProcessBuilder)pb, (DKUtils.SmartLogTailBuilder)tailBuilder, (File)log);
        }
    };
    public static final LanguageMeta R = new LanguageMeta(){

        @Override
        public void installJupyterSupport(AuthCtx authCtx, String envName, String projectKey, String bundleId, DKUtils.SmartLogTailBuilder tailBuilder, File log, String remoteBin, String containerConf) throws IOException, InterruptedException {
            CodeEnvResolutionService codeEnvResolutionService = (CodeEnvResolutionService)SpringUtils.getBean(CodeEnvResolutionService.class);
            List<String> rCommand = codeEnvResolutionService.getRCmdAndGetBundleIdIfNull(envName, projectKey, bundleId, new ArrayList<String>());
            String kernelName = JupyterCodeEnvUtils.getKernelName(CodeEnvModel.EnvLang.R, envName, projectKey, bundleId, containerConf);
            String displayName = JupyterCodeEnvUtils.getDisplayName(CodeEnvModel.EnvLang.R, envName, projectKey, bundleId, containerConf);
            ArrayList<String> jupyterCommand = new ArrayList<String>();
            jupyterCommand.add(System.getenv("DKUPYTHONBIN"));
            jupyterCommand.add(ApplicationConfigurator.getResourceFile((String[])new String[]{"code-envs", "r", "install-jupyter-irkernel.py"}).getAbsolutePath());
            jupyterCommand.add(rCommand.get(0));
            jupyterCommand.add(kernelName);
            jupyterCommand.add(displayName);
            ProcessBuilder pb = new ProcessBuilder(jupyterCommand);
            pb.environment().put("JUPYTER_DATA_DIR", System.getenv("DIP_HOME") + "/jupyter-run/jupyter");
            CodeEnvUtilsBase.addLogHeader(authCtx, log, "install jupyter support", StringUtils.join(pb.command(), (String)" "));
            logger.info((Object)("Installing Jupyter IR kernel: " + StringUtils.join(pb.command(), (String)" ")));
            DKUtils.execAndLogThrowsMirror((ProcessBuilder)pb, (DKUtils.SmartLogTailBuilder)tailBuilder, (File)log);
            CodeEnvLanguages.addEnvAndMetadataToKernel(kernelName, CodeEnvModel.EnvLang.R, envName, projectKey, bundleId, containerConf, CollectionUtils.appendableSSMap().put("SPARKR_R", remoteBin).get());
        }

        @Override
        public void removeJupyterSupport(AuthCtx authCtx, String envName, String projectKey, String bundleId, DKUtils.SmartLogTailBuilder tailBuilder, File log, String containerConf) throws IOException, InterruptedException {
            String kernelName = JupyterCodeEnvUtils.getKernelName(CodeEnvModel.EnvLang.R, envName, projectKey, bundleId, containerConf);
            ArrayList<String> jupyterCommand = new ArrayList<String>();
            jupyterCommand.add(System.getenv("DKUPYTHONBIN"));
            jupyterCommand.add("-m");
            jupyterCommand.add("jupyter_client.kernelspecapp");
            jupyterCommand.add("remove");
            jupyterCommand.add("-f");
            jupyterCommand.add(kernelName);
            ProcessBuilder pb = new ProcessBuilder(jupyterCommand);
            pb.environment().put("JUPYTER_DATA_DIR", System.getenv("DIP_HOME") + "/jupyter-run/jupyter");
            CodeEnvUtilsBase.addLogHeader(authCtx, log, "remove jupyter support", StringUtils.join(pb.command(), (String)" "));
            logger.info((Object)("Removing Jupyter kernel: " + StringUtils.join(pb.command(), (String)" ")));
            DKUtils.execAndLogThrowsMirror((ProcessBuilder)pb, (DKUtils.SmartLogTailBuilder)tailBuilder, (File)log);
        }
    };
    public static final LanguageMeta REMOTE_PYTHON = new RemoteLanguageMeta(CodeEnvModel.EnvLang.PYTHON){};
    public static final LanguageMeta REMOTE_R = new RemoteLanguageMeta(CodeEnvModel.EnvLang.R){};
    private static final DKULogger logger = DKULogger.getLogger((String)"dip.code-envs.languages");

    public static void installJupyterSupport(AuthCtx authCtx, LanguageMeta languageMeta, CodeEnvModel.AbstractEnvDesc desc, String envName, String projectKey, String bundleId, DKUtils.SmartLogTailBuilder tailBuilder, File log, String remoteBin) throws IOException, InterruptedException {
        IOException caught = null;
        try {
            if (StringUtils.isNotBlank((String)envName) && !"__BUILTIN__".equals(envName)) {
                languageMeta.installJupyterSupport(authCtx, envName, projectKey, bundleId, tailBuilder, log, remoteBin, null);
            }
        }
        catch (IOException e) {
            logger.error((Object)"Failed to install kernel for local env", (Throwable)e);
            caught = e;
        }
        LanguageMeta remoteLanguageMeta = languageMeta;
        if (languageMeta == PYTHON) {
            remoteLanguageMeta = REMOTE_PYTHON;
        }
        if (languageMeta == R) {
            remoteLanguageMeta = REMOTE_R;
        }
        for (String containerConf : ContainerExecImagesBuilder.getContainerConfs(desc, envName)) {
            try {
                remoteLanguageMeta.installJupyterSupport(authCtx, envName, projectKey, bundleId, tailBuilder, log, remoteBin, containerConf);
            }
            catch (IOException e) {
                logger.error((Object)("Failed to install kernel for containerized env in " + containerConf), (Throwable)e);
                caught = e;
            }
        }
        if (caught != null) {
            throw caught;
        }
    }

    public static void removeJupyterSupport(AuthCtx authCtx, LanguageMeta languageMeta, CodeEnvModel.AbstractEnvDesc desc, String envName, String projectKey, String bundleId, DKUtils.SmartLogTailBuilder tailBuilder, File log) throws IOException, InterruptedException {
        IOException caught = null;
        try {
            if (StringUtils.isNotBlank((String)envName) && !"__BUILTIN__".equals(envName)) {
                languageMeta.removeJupyterSupport(authCtx, envName, projectKey, bundleId, tailBuilder, log, null);
            }
        }
        catch (IOException e) {
            logger.error((Object)"Failed to remove kernel for local env", (Throwable)e);
            caught = e;
        }
        LanguageMeta remoteLanguageMeta = languageMeta;
        if (languageMeta == PYTHON) {
            remoteLanguageMeta = REMOTE_PYTHON;
        }
        if (languageMeta == R) {
            remoteLanguageMeta = REMOTE_R;
        }
        for (String containerConf : ContainerExecImagesBuilder.getContainerConfs(desc, envName)) {
            try {
                remoteLanguageMeta.removeJupyterSupport(authCtx, envName, projectKey, bundleId, tailBuilder, log, containerConf);
            }
            catch (IOException e) {
                logger.error((Object)("Failed to remove kernel for containerized env in " + containerConf), (Throwable)e);
                caught = e;
            }
        }
        if (caught != null) {
            throw caught;
        }
    }

    private static void addEnvAndMetadataToKernel(String kernelName, CodeEnvModel.EnvLang envLang, String envName, String projectKey, String bundleId, String containerConf, Map<String, String> env) throws IOException {
        String kernelsDir = System.getenv("DIP_HOME") + "/jupyter-run/jupyter";
        File kernelFile = new File(new File(new File(kernelsDir, "kernels"), kernelName), "kernel.json");
        JsonObject kernelJson = (JsonObject)JSON.parseFile((File)kernelFile, JsonObject.class);
        if (!kernelJson.has("env")) {
            kernelJson.add("env", (JsonElement)new JsonObject());
        }
        if (!kernelJson.has("metadata")) {
            kernelJson.add("metadata", (JsonElement)new JsonObject());
        }
        JsonObject envObject = kernelJson.get("env").getAsJsonObject();
        for (Map.Entry<String, String> kv : env.entrySet()) {
            if (kv.getValue() == null) continue;
            envObject.addProperty(kv.getKey(), kv.getValue());
        }
        JsonObject metadataObject = kernelJson.get("metadata").getAsJsonObject();
        metadataObject.addProperty("envName", envName);
        metadataObject.addProperty("envLang", envLang.getLanguageInfo());
        metadataObject.addProperty("bundleId", bundleId);
        metadataObject.addProperty("projectKey", projectKey);
        metadataObject.addProperty("containerConf", containerConf);
        JSON.prettyToFile((Object)kernelJson, (File)kernelFile);
    }

    public static void addEnvToKernel(String kernelName, Map<String, String> env) throws IOException {
        String kernelsDir = System.getenv("DIP_HOME") + "/jupyter-run/jupyter";
        File kernelFile = DKUFileUtils.getWithin((File)new File(kernelsDir), (String[])new String[]{"kernels", kernelName, "kernel.json"});
        JsonObject kernelJson = (JsonObject)JSON.parseFile((File)kernelFile, JsonObject.class);
        if (!kernelJson.has("env")) {
            kernelJson.add("env", (JsonElement)new JsonObject());
        }
        JsonObject envObject = kernelJson.get("env").getAsJsonObject();
        for (Map.Entry<String, String> kv : env.entrySet()) {
            if (kv.getValue() == null) continue;
            envObject.addProperty(kv.getKey(), kv.getValue());
        }
        JSON.prettyToFile((Object)kernelJson, (File)kernelFile);
    }

    public static interface LanguageMeta {
        public void installJupyterSupport(AuthCtx var1, String var2, String var3, String var4, DKUtils.SmartLogTailBuilder var5, File var6, String var7, String var8) throws IOException, InterruptedException;

        public void removeJupyterSupport(AuthCtx var1, String var2, String var3, String var4, DKUtils.SmartLogTailBuilder var5, File var6, String var7) throws IOException, InterruptedException;
    }

    public static abstract class RemoteLanguageMeta
    implements LanguageMeta {
        private final CodeEnvModel.EnvLang envLang;

        RemoteLanguageMeta(CodeEnvModel.EnvLang envLang) {
            this.envLang = envLang;
        }

        @Override
        public void installJupyterSupport(AuthCtx authCtx, String envName, String projectKey, String bundleId, DKUtils.SmartLogTailBuilder tailBuilder, File log, String remoteBin, String containerConf) throws IOException, InterruptedException {
            String kernelName = JupyterCodeEnvUtils.getKernelName(this.envLang, envName, projectKey, bundleId, containerConf);
            String displayName = JupyterCodeEnvUtils.getDisplayName(this.envLang, envName, projectKey, bundleId, containerConf);
            ArrayList<String> jupyterCommand = new ArrayList<String>();
            jupyterCommand.add(System.getenv("DKUPYTHONBIN"));
            jupyterCommand.add("-m");
            jupyterCommand.add("dataiku.notebook.remote_kernel");
            jupyterCommand.add("--user");
            jupyterCommand.add("--name");
            jupyterCommand.add(kernelName);
            jupyterCommand.add("--display-name");
            jupyterCommand.add(displayName);
            if (StringUtils.isNotBlank((String)projectKey)) {
                jupyterCommand.add("--project-key");
                jupyterCommand.add(projectKey);
            }
            if (StringUtils.isNotBlank((String)bundleId)) {
                jupyterCommand.add("--bundle-id");
                jupyterCommand.add(bundleId);
            }
            jupyterCommand.add("--env-lang");
            jupyterCommand.add(this.envLang.getLanguageInfo());
            jupyterCommand.add("--env-name");
            jupyterCommand.add(StringUtils.defaultIfBlank((String)envName, (String)"__BUILTIN__"));
            if (StringUtils.isNotBlank((String)containerConf)) {
                jupyterCommand.add("--container-conf");
                jupyterCommand.add(containerConf);
            }
            ProcessBuilder pb = new ProcessBuilder(jupyterCommand);
            String kernelsDir = System.getenv("DIP_HOME") + "/jupyter-run/jupyter";
            pb.environment().put("JUPYTER_DATA_DIR", kernelsDir);
            CodeEnvUtilsBase.addLogHeader(authCtx, log, "install jupyter support", StringUtils.join(pb.command(), (String)" "));
            logger.info((Object)("Installing Jupyter kernel: " + StringUtils.join(pb.command(), (String)" ")));
            DKUtils.execAndLogThrowsMirror((ProcessBuilder)pb, (DKUtils.SmartLogTailBuilder)tailBuilder, (File)log);
            CodeEnvLanguages.addEnvAndMetadataToKernel(kernelName, this.envLang, envName, projectKey, bundleId, containerConf, new HashMap<String, String>());
        }

        @Override
        public void removeJupyterSupport(AuthCtx authCtx, String envName, String projectKey, String bundleId, DKUtils.SmartLogTailBuilder tailBuilder, File log, String containerConf) throws IOException, InterruptedException {
            String kernelName = JupyterCodeEnvUtils.getKernelName(this.envLang, envName, projectKey, bundleId, containerConf);
            ArrayList<String> jupyterCommand = new ArrayList<String>();
            jupyterCommand.add(System.getenv("DKUPYTHONBIN"));
            jupyterCommand.add("-m");
            jupyterCommand.add("jupyter_client.kernelspecapp");
            jupyterCommand.add("remove");
            jupyterCommand.add("-f");
            jupyterCommand.add(kernelName);
            ProcessBuilder pb = new ProcessBuilder(jupyterCommand);
            pb.environment().put("JUPYTER_DATA_DIR", System.getenv("DIP_HOME") + "/jupyter-run/jupyter");
            CodeEnvUtilsBase.addLogHeader(authCtx, log, "remove jupyter support", StringUtils.join(pb.command(), (String)" "));
            logger.info((Object)("Removing Jupyter kernel: " + StringUtils.join(pb.command(), (String)" ")));
            DKUtils.execAndLogThrowsMirror((ProcessBuilder)pb, (DKUtils.SmartLogTailBuilder)tailBuilder, (File)log);
        }
    }
}

