/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.code;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.code.CodeEnvCodes;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvSettingsProvider;
import com.dataiku.dip.code.CodeEnvUtilsBase;
import com.dataiku.dip.code.StandardPythonInterpreter;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.CodedIOException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class CodeEnvPackageSystems {
    public static final PipPackageSystemMeta PIP;
    public static final PackageSystemMeta R;
    public static final PyCondaPackageSystemMeta CONDA_PYTHON;
    public static final RCondaPackageSystemMeta CONDA_R;
    static final String pythonBinary;
    public static final String createVirtualEnvScript;
    private static final String installPackagesIfNeededScript;
    private static final String listPackagesScript;
    private static final DKULogger logger;

    public static GeneralSettingsDAO.AbstractCodeEnvExtraSettings getCodeEnvSettings(CodeEnvModel.AbstractEnvDesc envDesc) {
        return ((CodeEnvSettingsProvider)SpringUtils.getBean(CodeEnvSettingsProvider.class)).getCodeEnvSettings(envDesc);
    }

    private static CodeEnvModel.PythonEnvDesc.CorePythonPackagesSet getCPPSFromEnvDesc(CodeEnvModel.PythonEnvDesc envDesc) {
        if (envDesc.corePackagesSet == null) {
            return CodeEnvModel.PythonEnvDesc.CorePythonPackagesSet.LEGACY_PANDAS023;
        }
        if (envDesc.corePackagesSet == CodeEnvModel.PythonEnvDesc.CorePythonPackagesSet.DEFAULT) {
            CodeEnvModel.PythonEnvDesc.CorePythonPackagesSet cpps = CodeEnvModel.getDefaultCorePackagesSet(envDesc.pythonInterpreter);
            logger.info((Object)("CorePythonPackagesSet DEFAULT resolved to " + String.valueOf((Object)cpps)));
            return cpps;
        }
        if (envDesc.corePackagesSet == CodeEnvModel.PythonEnvDesc.CorePythonPackagesSet.AUTO) {
            CodeEnvModel.PythonEnvDesc.CorePythonPackagesSet cpps = CodeEnvModel.getAutoCorePackagesSet(envDesc.pythonInterpreter, envDesc.conda);
            logger.info((Object)("CorePythonPackagesSet AUTO resolved to " + String.valueOf((Object)cpps)));
            return cpps;
        }
        return envDesc.corePackagesSet;
    }

    public static boolean shouldUseUVInsteadOfPip() {
        try {
            return Boolean.parseBoolean(DKUApp.getProperty((String)"dku.codeenv.uv.enabled", (String)"false"));
        }
        catch (RuntimeException e) {
            logger.warn((Object)"failed to read uv dip property, not using uv by default", (Throwable)e);
            return false;
        }
    }

    private static List<String> filterOutBlankOptions(List<String> options) {
        return options.stream().filter(option -> !StringUtils.isBlank((String)option)).collect(Collectors.toList());
    }

    static {
        if (DKUtils.isOsWindows()) {
            installPackagesIfNeededScript = "install-packages-if-needed.cmd";
            pythonBinary = "Scripts/python.exe";
            listPackagesScript = "list-packages.cmd";
            createVirtualEnvScript = "_create-virtualenv.cmd";
        } else {
            installPackagesIfNeededScript = "install-packages-if-needed.sh";
            pythonBinary = "bin/python";
            listPackagesScript = "list-packages.sh";
            createVirtualEnvScript = "_create-virtualenv.sh";
        }
        PIP = new PipPackageSystemMeta();
        R = new NoCondaPackageSystemMeta(){

            @Override
            public String getMandatoryPackageList(CodeEnvModel.AbstractEnvDesc abstractDesc) throws IOException {
                CodeEnvModel.REnvDesc envDesc = (CodeEnvModel.REnvDesc)abstractDesc;
                Object ret = "";
                if (envDesc.conda) {
                    if (envDesc.installCorePackages) {
                        ret = (String)ret + "\n" + CodeEnvUtilsBase.readCodeEnvStaticResourceFile(CodeEnvModel.EnvLang.R, "minimal-packages-conda.txt");
                    }
                    if (envDesc.installJupyterSupport) {
                        ret = (String)ret + "\n" + CodeEnvUtilsBase.readCodeEnvStaticResourceFile(CodeEnvModel.EnvLang.R, "irkernel-packages-conda.txt");
                    }
                } else {
                    if (envDesc.installCorePackages) {
                        ret = (String)ret + "\n" + CodeEnvUtilsBase.readCodeEnvStaticResourceFile(CodeEnvModel.EnvLang.R, "minimal-packages-noconda.txt");
                    }
                    if (envDesc.installJupyterSupport) {
                        ret = (String)ret + "\n" + CodeEnvUtilsBase.readCodeEnvStaticResourceFile(CodeEnvModel.EnvLang.R, "irkernel-packages-noconda.txt");
                    }
                }
                return ret;
            }

            @Override
            public String getPackageList(AuthCtx authCtx, File envRootFolder, DKUtils.SmartLogTailBuilder logTailBuilder, File log) throws IOException, InterruptedException {
                ProcessBuilder pb = new ProcessBuilder(ApplicationConfigurator.getResourceFile((String[])new String[]{"code-envs", "r", listPackagesScript}).toString(), envRootFolder.getAbsolutePath());
                CodeEnvUtilsBase.addLogHeader(authCtx, log, "list packages", StringUtils.join(pb.command(), (String)" "));
                return new String(DKUtils.execAndLogAndGetOutput((ProcessBuilder)pb, (DKUtils.SmartLogTailBuilder)logTailBuilder, (File)log), StandardCharsets.UTF_8);
            }

            @Override
            public void createEmpty(AuthCtx authCtx, CodeEnvModel.AbstractEnvDesc abstractDesc, File envRootFolder, DKUtils.SmartLogTailBuilder logTailBuilder, File log, GeneralSettingsDAO.AbstractCodeEnvExtraSettings envSettings) throws IOException, InterruptedException {
                DKUFileUtils.mkdirs((File)envRootFolder);
                DKUFileUtils.mkdirs((File)CodeEnvUtilsBase.f(envRootFolder, "R.lib"));
                DKUFileUtils.mkdirs((File)CodeEnvUtilsBase.f(envRootFolder, "bin"));
                DKUFileUtils.mkdirs((File)CodeEnvUtilsBase.f(envRootFolder, "lib/R/library"));
                if (DKUtils.isOsWindows()) {
                    File wrapper = CodeEnvUtilsBase.f(envRootFolder, "bin", "R.cmd");
                    FileUtils.write((File)wrapper, (CharSequence)"@echo off\n");
                    FileUtils.write((File)wrapper, (CharSequence)"powershell.exe -ExecutionPolicy Bypass -File %~dp0.\\R-wrapper-script.ps1 %*", (boolean)true);
                    FileUtils.copyFile((File)ApplicationConfigurator.getResourceFile((String[])new String[]{"code-envs", "r", "R-wrapper-script.ps1"}), (File)CodeEnvUtilsBase.f(envRootFolder, "bin", "R-wrapper-script.ps1"));
                } else {
                    File linkTgt = ApplicationConfigurator.getResourceFile((String[])new String[]{"code-envs", "r", "R-wrapper-script.sh"});
                    File linkSrc = CodeEnvUtilsBase.f(envRootFolder, "bin", "R");
                    Files.createSymbolicLink(linkSrc.toPath(), linkTgt.toPath(), new FileAttribute[0]);
                    linkTgt = ApplicationConfigurator.getResourceFile((String[])new String[]{"code-envs", "r", "Rscript-wrapper-script.sh"});
                    linkSrc = CodeEnvUtilsBase.f(envRootFolder, "bin", "Rscript");
                    Files.createSymbolicLink(linkSrc.toPath(), linkTgt.toPath(), new FileAttribute[0]);
                }
            }

            @Override
            public void install(AuthCtx authCtx, File envRootFolder, CodeEnvModel.AbstractEnvDesc abstractDesc, boolean addMandatory, String requirements, boolean upgradeIfNeeded, boolean condaMode, DKUtils.SmartLogTailBuilder logTailBuilder, File log, GeneralSettingsDAO.AbstractCodeEnvExtraSettings envSettings) throws IOException, InterruptedException {
                Object cleanPackages = "";
                for (String line : requirements.split("\n")) {
                    if (StringUtils.isWhitespace((String)(line = line.trim()))) continue;
                    cleanPackages = (String)cleanPackages + line + "\n";
                }
                logger.info((Object)("Installing from R packages list :\n" + (String)cleanPackages));
                if (addMandatory) {
                    for (String line : this.getMandatoryPackageList(abstractDesc).split("\n")) {
                        if (StringUtils.isWhitespace((String)(line = line.trim()))) continue;
                        cleanPackages = (String)cleanPackages + line + "\n";
                    }
                    logger.info((Object)("Completed R packages list :\n" + (String)cleanPackages));
                }
                logTailBuilder.appendLine("Installing from R packages list");
                FileUtils.writeStringToFile((File)log, (String)("Installing from R packages list\n" + (String)cleanPackages + "\n"), (Charset)StandardCharsets.UTF_8, (boolean)true);
                try (AutoDelete tmpFile = DSSTempUtils.getTempFile((String)"r-packages-install", (String)"packages", (String)"txt");){
                    FileUtils.writeStringToFile((File)tmpFile, (String)cleanPackages, (Charset)StandardCharsets.UTF_8);
                    this.installRPkgsFromPackagesList(authCtx, envRootFolder, (File)tmpFile, condaMode, logTailBuilder, log, envSettings);
                }
            }

            private void installRPkgsFromPackagesList(AuthCtx authCtx, File envRootFolder, File requirementsFile, boolean condaMode, DKUtils.SmartLogTailBuilder logTailBuilder, File log, GeneralSettingsDAO.AbstractCodeEnvExtraSettings envSettings) throws IOException, InterruptedException {
                String[] cmd = new String[]{ApplicationConfigurator.getResourceFile((String[])new String[]{"code-envs", "r", installPackagesIfNeededScript}).toString(), envRootFolder.getAbsolutePath(), Boolean.toString(condaMode), requirementsFile.getAbsolutePath(), envSettings.cranMirrorURL};
                ProcessBuilder pb = new ProcessBuilder(cmd);
                CodeEnvUtilsBase.addLogHeader(authCtx, log, "install packages", StringUtils.join(pb.command(), (String)" "));
                DKUtils.execAndLogThrowsMirror((ProcessBuilder)pb, (DKUtils.SmartLogTailBuilder)logTailBuilder, (File)log);
            }
        };
        CONDA_PYTHON = new PyCondaPackageSystemMeta();
        CONDA_R = new RCondaPackageSystemMeta();
        logger = DKULogger.getLogger((String)"dip.code-envs.package-systems");
    }

    public static class PipPackageSystemMeta
    extends NoCondaPackageSystemMeta {
        private void clearPythonPath(ProcessBuilder pb) {
            if (!ApplicationConfigurator.getParams().getBoolParam("dku.codeenvs.pip.zapPythonPath", true)) {
                return;
            }
            if (pb.environment().containsKey("PYTHONPATH")) {
                pb.environment().remove("PYTHONPATH");
            }
        }

        @Override
        public String getMandatoryPackageList(CodeEnvModel.AbstractEnvDesc abstractDesc) throws IOException {
            CodeEnvModel.PythonEnvDesc envDesc = (CodeEnvModel.PythonEnvDesc)abstractDesc;
            Object ret = "";
            if (envDesc.conda) {
                if (envDesc.installCorePackages) {
                    // empty if block
                }
                if (envDesc.installJupyterSupport) {
                    ret = (String)ret + "\n" + CodeEnvUtilsBase.readCodeEnvStaticResourceFileWithVersionOverride(CodeEnvModel.EnvLang.PYTHON, envDesc.pythonInterpreter.toString(), "ipykernel-requirements-conda.txt");
                }
            } else {
                if (envDesc.installCorePackages) {
                    CodeEnvModel.PythonEnvDesc.CorePythonPackagesSet cpps = CodeEnvPackageSystems.getCPPSFromEnvDesc(envDesc);
                    ret = (String)ret + "\n" + CodeEnvUtilsBase.readCodeEnvStaticResourceFileWithVersionOverride(CodeEnvModel.EnvLang.PYTHON, envDesc.pythonInterpreter.toString(), "minimal-requirements-" + String.valueOf((Object)cpps) + "-noconda.txt");
                }
                if (envDesc.installJupyterSupport) {
                    ret = (String)ret + "\n" + CodeEnvUtilsBase.readCodeEnvStaticResourceFileWithVersionOverride(CodeEnvModel.EnvLang.PYTHON, envDesc.pythonInterpreter.toString(), "ipykernel-requirements-noconda.txt");
                }
            }
            return ret;
        }

        @Override
        public String getPackageList(AuthCtx authCtx, File envRootFolder, DKUtils.SmartLogTailBuilder logTailBuilder, File log) throws IOException, InterruptedException {
            ProcessBuilder pb = new ProcessBuilder(new File(envRootFolder, pythonBinary).getAbsolutePath(), "-m", "pip", "freeze", "-l");
            this.clearPythonPath(pb);
            CodeEnvUtilsBase.addLogHeader(authCtx, log, "list packages", StringUtils.join(pb.command(), (String)" "));
            return new String(DKUtils.execAndLogAndGetOutput((ProcessBuilder)pb, (DKUtils.SmartLogTailBuilder)logTailBuilder, (File)log), StandardCharsets.UTF_8);
        }

        @Override
        public void createEmpty(AuthCtx authCtx, CodeEnvModel.AbstractEnvDesc abstractDesc, File envRootFolder, DKUtils.SmartLogTailBuilder logTailBuilder, File log, GeneralSettingsDAO.AbstractCodeEnvExtraSettings envSettings) throws IOException, InterruptedException {
            CodeEnvModel.PythonEnvDesc envDesc = (CodeEnvModel.PythonEnvDesc)abstractDesc;
            List<String> venvCommand = this.getVirtualenvCreationCommand(envRootFolder.getAbsolutePath(), envDesc, envSettings.virtualenvCreateExtraOptions, System.getenv("DKUPYTHONBIN"), ApplicationConfigurator.getInstallFile((String[])new String[]{"scripts", createVirtualEnvScript}).getAbsolutePath(), System.getenv("DSS_DEV") == null || System.getenv("DSS_DEV_CODEENV_USE_ZIPAPP") != null);
            ProcessBuilder pb = new ProcessBuilder(venvCommand);
            CodeEnvUtilsBase.addLogHeader(authCtx, log, "create empty env", StringUtils.join(pb.command(), (String)" "));
            try {
                DKUtils.execAndLogThrowsMirror((ProcessBuilder)pb, (DKUtils.SmartLogTailBuilder)logTailBuilder, (File)log);
            }
            catch (Exception e) {
                boolean pythonNotFound = logTailBuilder.get().getLines().stream().anyMatch(l -> l.contains("failed to find interpreter for Builtin discover"));
                if (pythonNotFound) {
                    Object interpreter = envDesc.pythonInterpreter == StandardPythonInterpreter.CUSTOM ? envDesc.customInterpreter : "Python " + StandardPythonInterpreter.getPythonVersion(envDesc.pythonInterpreter);
                    throw new CodedIOException((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_CREATION_FAILED, "Requested python '" + (String)interpreter + "' not found in PATH, it probably needs to be installed at the OS level.");
                }
                throw e;
            }
        }

        @Override
        public void install(AuthCtx authCtx, File envRootFolder, CodeEnvModel.AbstractEnvDesc abstractDesc, boolean addMandatory, String requirements, boolean upgradeIfNeeded, boolean condaMode, DKUtils.SmartLogTailBuilder logTailBuilder, File log, GeneralSettingsDAO.AbstractCodeEnvExtraSettings envSettings) throws IOException, InterruptedException {
            if (CodeEnvPackageSystems.shouldUseUVInsteadOfPip()) {
                String pythonInterpreterPath = envRootFolder.getAbsolutePath() + "/" + pythonBinary;
                int exit_code = DKUtils.execAndLog((String[])new String[]{pythonInterpreterPath, "-m", "pip", "show", "uv"}, null);
                if (exit_code != 0) {
                    List<String> uvInstallCommand = List.of(pythonInterpreterPath, "-m", "pip", "install", "uv");
                    ProcessBuilder pb = new ProcessBuilder(uvInstallCommand);
                    CodeEnvUtilsBase.addLogHeader(authCtx, log, "install uv in code env", StringUtils.join(pb.command(), (String)" "));
                    DKUtils.execAndLogThrowsMirror((ProcessBuilder)pb, (DKUtils.SmartLogTailBuilder)logTailBuilder, (File)log);
                }
            }
            logger.info((Object)("Installing from py requirements :\n" + (String)requirements));
            if (addMandatory) {
                requirements = (String)requirements + this.getMandatoryPackageList(abstractDesc);
                logger.info((Object)("Completed requirements :\n" + (String)requirements));
            }
            logTailBuilder.appendLine("Installing from Pip requirements");
            FileUtils.writeStringToFile((File)log, (String)("Installing from Pip requirements:\n" + (String)requirements + "\n"), (Charset)StandardCharsets.UTF_8, (boolean)true);
            try (AutoDelete tmpFile = DSSTempUtils.getTempFile((String)"pip-requirements-install", (String)"req", (String)"txt");){
                FileUtils.writeStringToFile((File)tmpFile, (String)requirements, (Charset)StandardCharsets.UTF_8);
                ProcessBuilder pb = new ProcessBuilder(this.getPipInstallCommand(envRootFolder.getAbsolutePath(), envSettings.pipInstallExtraOptions, upgradeIfNeeded, false, tmpFile.getAbsolutePath()));
                this.clearPythonPath(pb);
                CodeEnvUtilsBase.addLogHeader(authCtx, log, "install packages", StringUtils.join(pb.command(), (String)" "));
                DKUtils.execAndLogThrowsMirror((ProcessBuilder)pb, (DKUtils.SmartLogTailBuilder)logTailBuilder, (File)log, (String)"Failed to install pip packages");
            }
        }

        public List<String> getVirtualenvCreationCommand(String envRootPath, CodeEnvModel.PythonEnvDesc envDesc, List<String> virtualenvCreateExtraOptions, String pythonBin, String virtualenvCreateScript, boolean useVirtualEnvScript) {
            ArrayList<String> venvCommand = new ArrayList<String>();
            if (useVirtualEnvScript) {
                venvCommand.add(virtualenvCreateScript);
                venvCommand.add(pythonBin);
            } else {
                venvCommand.add("virtualenv");
            }
            venvCommand.add("-p");
            if (envDesc.pythonInterpreter == StandardPythonInterpreter.CUSTOM) {
                venvCommand.add(envDesc.customInterpreter);
            } else {
                venvCommand.add("python" + StandardPythonInterpreter.getPythonVersion(envDesc.pythonInterpreter));
            }
            venvCommand.addAll(CodeEnvPackageSystems.filterOutBlankOptions(virtualenvCreateExtraOptions));
            venvCommand.add(envRootPath);
            return venvCommand;
        }

        public List<String> getPipInstallCommand(String envRootPath, List<String> pipInstallExtraOptions, boolean upgradeIfNeeded, boolean disablePipCache, String file) {
            ArrayList<String> pipCommand = new ArrayList<String>();
            pipCommand.add(envRootPath + "/" + pythonBinary);
            pipCommand.add("-m");
            if (CodeEnvPackageSystems.shouldUseUVInsteadOfPip()) {
                pipCommand.add("uv");
            }
            pipCommand.add("pip");
            pipCommand.add("install");
            if (upgradeIfNeeded) {
                pipCommand.add("--upgrade");
            }
            if (disablePipCache) {
                pipCommand.add("--no-cache-dir");
            }
            pipCommand.addAll(CodeEnvPackageSystems.filterOutBlankOptions(pipInstallExtraOptions));
            pipCommand.add("-r");
            pipCommand.add(file);
            return pipCommand;
        }
    }

    public static interface PackageSystemMeta {
        public String getMandatoryPackageList(CodeEnvModel.AbstractEnvDesc var1) throws IOException;

        public String getPackageList(AuthCtx var1, File var2, DKUtils.SmartLogTailBuilder var3, File var4) throws IOException, InterruptedException;

        public void createEmpty(AuthCtx var1, CodeEnvModel.AbstractEnvDesc var2, File var3, DKUtils.SmartLogTailBuilder var4, File var5, GeneralSettingsDAO.AbstractCodeEnvExtraSettings var6) throws IOException, InterruptedException;

        public void install(AuthCtx var1, File var2, CodeEnvModel.AbstractEnvDesc var3, boolean var4, String var5, boolean var6, boolean var7, DKUtils.SmartLogTailBuilder var8, File var9, GeneralSettingsDAO.AbstractCodeEnvExtraSettings var10) throws IOException, InterruptedException;
    }

    public static class PyCondaPackageSystemMeta
    extends CondaPackageSystemMeta {
        @Override
        public String getMandatoryPackageList(CodeEnvModel.AbstractEnvDesc abstractDesc) throws IOException {
            CodeEnvModel.PythonEnvDesc envDesc = (CodeEnvModel.PythonEnvDesc)abstractDesc;
            Object ret = "";
            if (envDesc.installCorePackages) {
                CodeEnvModel.PythonEnvDesc.CorePythonPackagesSet cpps = CodeEnvPackageSystems.getCPPSFromEnvDesc(envDesc);
                ret = (String)ret + "\n" + CodeEnvUtilsBase.readCodeEnvStaticResourceFileWithVersionOverride(CodeEnvModel.EnvLang.PYTHON, envDesc.pythonInterpreter.toString(), "minimal-packages-" + String.valueOf((Object)cpps) + ".spec");
            }
            if (envDesc.installJupyterSupport) {
                ret = (String)ret + "\n" + CodeEnvUtilsBase.readCodeEnvStaticResourceFileWithVersionOverride(CodeEnvModel.EnvLang.PYTHON, envDesc.pythonInterpreter.toString(), "ipykernel-packages.spec");
            }
            return ret;
        }

        @Override
        public void createEmpty(AuthCtx authCtx, CodeEnvModel.AbstractEnvDesc abstractDesc, File envRootFolder, DKUtils.SmartLogTailBuilder logTailBuilder, File log, GeneralSettingsDAO.AbstractCodeEnvExtraSettings envSettings) throws IOException, InterruptedException {
            CodeEnvModel.PythonEnvDesc envDesc = (CodeEnvModel.PythonEnvDesc)abstractDesc;
            Preconditions.checkArgument((envDesc.pythonInterpreter != StandardPythonInterpreter.CUSTOM ? 1 : 0) != 0, (Object)"Can't use custom interpreter with conda");
            ArrayList<String> condaCommand = new ArrayList<String>(1);
            condaCommand.add("python=" + StandardPythonInterpreter.getPythonVersion(envDesc.pythonInterpreter));
            this.createEmpty(authCtx, condaCommand, envRootFolder, logTailBuilder, log, envSettings);
        }

        @Override
        public void install(AuthCtx authCtx, File envRootFolder, CodeEnvModel.AbstractEnvDesc abstractDesc, boolean addMandatory, String condaSpec, boolean upgradeIfNeeded, boolean condaMode, DKUtils.SmartLogTailBuilder logTailBuilder, File log, GeneralSettingsDAO.AbstractCodeEnvExtraSettings envSettings) throws IOException, InterruptedException {
            logger.info((Object)("Installing from conda spec:\n" + (String)condaSpec));
            if (addMandatory) {
                condaSpec = (String)condaSpec + this.getMandatoryPackageList(abstractDesc);
                logger.info((Object)("Completed conda spec:\n" + (String)condaSpec));
            }
            logTailBuilder.appendLine("Installing from Conda spec file");
            this.install(authCtx, "file://" + ApplicationConfigurator.getInstallFolder() + "/conda.packages", envRootFolder, (String)condaSpec, logTailBuilder, log, envSettings);
        }
    }

    public static class RCondaPackageSystemMeta
    extends CondaPackageSystemMeta {
        @Override
        public String getMandatoryPackageList(CodeEnvModel.AbstractEnvDesc abstractDesc) throws IOException {
            CodeEnvModel.REnvDesc envDesc = (CodeEnvModel.REnvDesc)abstractDesc;
            Object ret = "";
            if (envDesc.installCorePackages) {
                ret = (String)ret + "\n" + CodeEnvUtilsBase.readCodeEnvStaticResourceFile(CodeEnvModel.EnvLang.R, "minimal-packages.spec");
            }
            if (envDesc.installJupyterSupport) {
                ret = (String)ret + "\n" + CodeEnvUtilsBase.readCodeEnvStaticResourceFile(CodeEnvModel.EnvLang.R, "irkernel-packages.spec");
            }
            return ret;
        }

        @Override
        public void createEmpty(AuthCtx authCtx, CodeEnvModel.AbstractEnvDesc abstractDesc, File envRootFolder, DKUtils.SmartLogTailBuilder logTailBuilder, File log, GeneralSettingsDAO.AbstractCodeEnvExtraSettings envSettings) throws IOException, InterruptedException {
            ArrayList<String> condaCommand = new ArrayList<String>();
            condaCommand.add("--channel");
            condaCommand.add("r");
            condaCommand.add("r-base");
            this.createEmpty(authCtx, condaCommand, envRootFolder, logTailBuilder, log, envSettings);
            String rEnvironSite = "R_LIBS=${R_HOME}/library:${DKURLIB}:${R_LIBS}";
            FileUtils.writeStringToFile((File)CodeEnvUtilsBase.f(envRootFolder, "lib/R/etc/Renviron.site"), (String)rEnvironSite, (Charset)StandardCharsets.UTF_8);
        }

        @Override
        public void install(AuthCtx authCtx, File envRootFolder, CodeEnvModel.AbstractEnvDesc abstractDesc, boolean addMandatory, String condaSpec, boolean upgradeIfNeeded, boolean condaMode, DKUtils.SmartLogTailBuilder logTailBuilder, File log, GeneralSettingsDAO.AbstractCodeEnvExtraSettings envSettings) throws IOException, InterruptedException {
            logger.info((Object)("Installing from conda spec:\n" + (String)condaSpec));
            if (addMandatory) {
                condaSpec = (String)condaSpec + this.getMandatoryPackageList(abstractDesc);
                logger.info((Object)("Completed conda spec:\n" + (String)condaSpec));
            }
            logTailBuilder.appendLine("Installing from Conda spec file");
            this.install(authCtx, "r", envRootFolder, (String)condaSpec, logTailBuilder, log, envSettings);
        }
    }

    public static abstract class CondaPackageSystemMeta
    implements PackageSystemMeta {
        @Override
        public String getPackageList(AuthCtx authCtx, File envRootFolder, DKUtils.SmartLogTailBuilder logTailBuilder, File log) throws IOException, InterruptedException {
            ProcessBuilder pb = new ProcessBuilder("conda", "list", "--prefix", envRootFolder.getAbsolutePath(), "--export");
            CodeEnvUtilsBase.addLogHeader(authCtx, log, "list packages", StringUtils.join(pb.command(), (String)" "));
            return new String(DKUtils.execAndLogAndGetOutput((ProcessBuilder)pb, (DKUtils.SmartLogTailBuilder)logTailBuilder, (File)log), StandardCharsets.UTF_8);
        }

        public void createEmpty(AuthCtx authCtx, List<String> extraParams, File envRootFolder, DKUtils.SmartLogTailBuilder logTailBuilder, File log, GeneralSettingsDAO.AbstractCodeEnvExtraSettings envSettings) throws IOException, InterruptedException {
            ArrayList<String> condaCommand = new ArrayList<String>();
            condaCommand.add("conda");
            condaCommand.add("create");
            condaCommand.add("--prefix");
            condaCommand.add(envRootFolder.getAbsolutePath());
            condaCommand.add("--yes");
            condaCommand.addAll(extraParams);
            condaCommand.addAll(envSettings.condaCreateExtraOptions);
            ProcessBuilder pb = new ProcessBuilder(condaCommand);
            CodeEnvUtilsBase.addLogHeader(authCtx, log, "create empty env", StringUtils.join(pb.command(), (String)" "));
            DKUtils.execAndLogThrowsMirror((ProcessBuilder)pb, (DKUtils.SmartLogTailBuilder)logTailBuilder, (File)log);
        }

        public void install(AuthCtx authCtx, String channel, File envRootFolder, String condaSpec, DKUtils.SmartLogTailBuilder logTailBuilder, File log, GeneralSettingsDAO.AbstractCodeEnvExtraSettings envSettings) throws IOException, InterruptedException {
            logger.info((Object)("Installing from conda spec:\n" + condaSpec));
            logTailBuilder.appendLine("Installing from Conda spec file");
            try (AutoDelete tmpFile = DSSTempUtils.getTempFile((String)"conda-spec-install", (String)"packages", (String)"spec");){
                FileUtils.writeStringToFile((File)tmpFile, (String)condaSpec, (Charset)StandardCharsets.UTF_8);
                ProcessBuilder pb = new ProcessBuilder(this.getCondaInstallCommand(envRootFolder.getAbsolutePath(), channel, envSettings.condaInstallExtraOptions, tmpFile.getAbsolutePath()));
                CodeEnvUtilsBase.addLogHeader(authCtx, log, "install packages", StringUtils.join(pb.command(), (String)" "), condaSpec);
                DKUtils.execAndLogThrowsMirror((ProcessBuilder)pb, (DKUtils.SmartLogTailBuilder)logTailBuilder, (File)log, (String)"Failed to install Conda packages");
            }
        }

        public List<String> getCondaInstallCommand(String envRootPath, String channel, List<String> condaInstallExtraOptions, String file) {
            ArrayList<String> condaCommand = new ArrayList<String>();
            condaCommand.add("conda");
            condaCommand.add("install");
            condaCommand.add("--prefix");
            condaCommand.add(envRootPath);
            condaCommand.add("--yes");
            if (channel != null) {
                condaCommand.add("--channel");
                condaCommand.add(channel);
            }
            condaCommand.addAll(CodeEnvPackageSystems.filterOutBlankOptions(condaInstallExtraOptions));
            condaCommand.add("--file");
            condaCommand.add(file);
            return condaCommand;
        }
    }

    public static abstract class NoCondaPackageSystemMeta
    implements PackageSystemMeta {
    }
}

