/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.code;

import com.dataiku.dip.plugins.dev.FolderEditorService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.controllers.admin.AdminEditionController;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.git.DSSGitModel;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.utils.JSON;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProjectLibrariesEditionService {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private FolderEditorService folderEditorService;

    public List<FolderEditorService.FolderContent> autocompleteProjectLibrariesContent_NT(AuthCtx authCtx, String projectKey, List<FolderEditorService.FolderContent> originalContent) throws Exception {
        boolean pythonExists = false;
        boolean rExists = false;
        boolean elJsonExists = false;
        for (FolderEditorService.FolderContent fc : originalContent) {
            if ("external-libraries.json".equals(fc.name)) {
                elJsonExists = true;
                continue;
            }
            if ("python".equals(fc.name)) {
                pythonExists = true;
                continue;
            }
            if (!"R".equals(fc.name)) continue;
            rExists = true;
        }
        if (!(pythonExists && rExists && elJsonExists)) {
            try (RWTransaction rwt = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
                this.generateProjectLibrariesContent((RWTransactionRef)rwt, projectKey, pythonExists, rExists, elJsonExists);
                RelFile zonePath = AdminEditionController.GlobalCodeZone.LIB.getPath(projectKey);
                originalContent = this.folderEditorService.getFolderContent(zonePath, (TransactionRef)rwt);
                rwt.commit("Initialized library content for " + projectKey);
            }
        }
        return originalContent;
    }

    public void generateProjectLibrariesContent(RWTransactionRef rwt, String projectKey) throws Exception {
        this.generateProjectLibrariesContent(rwt, projectKey, false, false, false);
    }

    private void generateProjectLibrariesContent(RWTransactionRef rwt, String projectKey, boolean pythonExists, boolean rExists, boolean elJsonExists) throws Exception {
        RelFile zonePath = AdminEditionController.GlobalCodeZone.LIB.getPath(projectKey);
        if (!pythonExists && !this.folderEditorService.existsFolderContent(zonePath, "python", rwt)) {
            this.folderEditorService.addFolderContent(zonePath, "python", true, rwt);
        }
        if (!rExists && !this.folderEditorService.existsFolderContent(zonePath, "R", rwt)) {
            this.folderEditorService.addFolderContent(zonePath, "R", true, rwt);
        }
        if (!elJsonExists && !this.folderEditorService.existsFolderContent(zonePath, "external-libraries.json", rwt)) {
            String json = JSON.pretty((Object)new DSSGitModel.ExternalLibraries());
            this.folderEditorService.addFolderContent(zonePath, "external-libraries.json", false, rwt);
            this.folderEditorService.setFolderContent(zonePath, "external-libraries.json", json, rwt);
        }
    }
}

