/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.connections.AbstractCloudStorageConnection;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.ConnectionWithGoogleAuthCredentials;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.FSProviderizableConnection;
import com.dataiku.dip.connections.GoogleCredentialsBuilder;
import com.dataiku.dip.connections.HDFSConnection;
import com.dataiku.dip.connections.VectorStoreConnection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.datasets.fs.GCSclient;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledge;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.model.OAuth2Client;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.connections.ConnectionCodes;
import com.dataiku.dip.server.services.ConnectionsTestService;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.PathUtils;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dss.shadelibgcp.com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.dataiku.dss.shadelibgcp.com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;

public class GCSConnection
extends AbstractCloudStorageConnection
implements VectorStoreConnection,
ConnectionWithGoogleAuthCredentials {
    public static final String connectionType = "GCS";
    public Params params = new Params();
    private static final String PSC_ENDPOINT_URL_PATTERN = "https://storage-%s.p.googleapis.com/";
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.gcs");

    @Override
    public RetrievableKnowledge.VectorStoreType getVectorStoreType() {
        return RetrievableKnowledge.VectorStoreType.VERTEX_AI_GCS_BASED;
    }

    @Override
    public String getConnectionName() {
        return this.name;
    }

    @Override
    @Nonnull
    public ConnectionWithGoogleAuthCredentials.GoogleAuth2Params getGoogleAuth2NonResolvedParams() {
        return this.params;
    }

    @Override
    public ProxySettings getProxySettingsFromConnection() {
        return this.getProxySettings();
    }

    @Override
    public boolean actuallyHasPerUserOAuth2Credential() {
        return this.credentialsMode == DSSConnection.CredentialsMode.PER_USER && this.params.authType == ConnectionWithGoogleAuthCredentials.AuthType.OAUTH;
    }

    @Override
    public String getType() {
        return connectionType;
    }

    @Override
    public void expandParametersInPlaceAtDAOLevelUsingGlobalContextOnly(VariablesContext vc) {
        this.params.bucket = vc.expand(this.params.bucket);
        this.params.appSecretContent = vc.expand(this.params.appSecretContent);
        this.params.projectId = vc.expand(this.params.projectId);
        this.params.defaultManagedBucket = vc.expand(this.params.defaultManagedBucket);
        this.params.defaultManagedPath = vc.expand(this.params.defaultManagedPath);
        this.params.chbucket = vc.expand(this.params.chbucket);
        this.params.chroot = vc.expand(this.params.chroot);
        this.params.pscEndpointId = vc.expand(this.params.pscEndpointId);
    }

    @Override
    public String getMainManagedDatasetType() {
        return connectionType;
    }

    @Override
    public boolean isFSLike() {
        return true;
    }

    @Override
    public boolean isFS() {
        return true;
    }

    @Override
    public List<String> getProviderTypes() {
        return Lists.newArrayList((Object[])new String[]{connectionType});
    }

    @Override
    public boolean allowManagedFolders() {
        return this.allowManagedFolders;
    }

    @Override
    public List<AbstractSQLConnection.CustomDatabaseProperty> getDkuProperties() {
        return this.params.dkuProperties;
    }

    @Override
    public boolean mustResolveOnDSSHost() {
        return this.mustResolveGoogleAuthOnDSSHost();
    }

    @Override
    public boolean mustResolveOnBackend() {
        return this.hasRefreshTokenRotation() || super.mustResolveOnBackend();
    }

    @Override
    protected <T> T getFullyResolvedCredentials_internal(ConnectionWithBasicCredential.CredentialResolutionContext ctx, Class<T> clazz) throws DKUSecurityException, IOException, SQLException {
        assert (clazz.isAssignableFrom(ConnectionWithGoogleAuthCredentials.SerializableGoogleAuthCredentials.class));
        ConnectionWithGoogleAuthCredentials.SerializableGoogleAuthCredentials creds = this.getResolvedCredential(ctx.authCtx);
        return clazz.cast(creds);
    }

    public GCSclient getClient(AuthCtx authCtx, String userAgent) throws DKUSecurityException, IOException {
        ConnectionWithBasicCredential.CredentialResolutionContext ctx = new ConnectionWithBasicCredential.CredentialResolutionContext(authCtx, null);
        ConnectionWithGoogleAuthCredentials.SerializableGoogleAuthCredentials creds = this.getFullyResolvedCredentials_fsLike(ctx, ConnectionWithGoogleAuthCredentials.SerializableGoogleAuthCredentials.class);
        Object endpointBase = "";
        if (StringUtils.isNotBlank((String)this.params.pscEndpointId)) {
            endpointBase = String.format(PSC_ENDPOINT_URL_PATTERN, this.params.pscEndpointId.trim());
        } else if (StringUtils.isNotBlank((String)this.params.customEndpoint) && !((String)(endpointBase = this.params.customEndpoint)).endsWith("/")) {
            endpointBase = (String)endpointBase + "/";
        }
        return new GCSclient(this.params.projectId, creds.toGoogleCredential(ctx, this), this.getProxySettings(), userAgent, (String)endpointBase);
    }

    public List<AbstractSQLConnection.CustomDatabaseProperty> getHadoopConfigForGCSAccess(AuthCtx authCtx) throws IOException, DKUSecurityException {
        PasswordEncryptionService cryptoService = (PasswordEncryptionService)SpringUtils.getBean(PasswordEncryptionService.class);
        ArrayList ret = Lists.newArrayList();
        if (StringUtils.isNotBlank((String)this.params.projectId)) {
            ret.add(new AbstractSQLConnection.CustomDatabaseProperty("fs.gs.project.id", this.params.projectId, false));
        }
        if (StringUtils.isNotBlank((String)this.params.customEndpoint)) {
            ret.add(new AbstractSQLConnection.CustomDatabaseProperty("fs.gs.storage.root.url", (String)(this.params.customEndpoint.endsWith("/") ? this.params.customEndpoint : this.params.customEndpoint + "/"), false));
        }
        ret.addAll(this.buildHadoopExtraConf(authCtx));
        this.addDisableCacheIfNeeded(ret, this.params.dkuProperties);
        this.addExtraHadoopConf(ret, this.params.dkuProperties);
        return ret;
    }

    private List<AbstractSQLConnection.CustomDatabaseProperty> buildHadoopExtraConf(AuthCtx authCtx) throws IOException, DKUSecurityException {
        ArrayList ret = Lists.newArrayList();
        ProxySettings proxySettings = this.getProxySettings();
        if (StringUtils.isNotBlank((String)this.params.pscEndpointId)) {
            ret.add(new AbstractSQLConnection.CustomDatabaseProperty("fs.gs.storage.root.url", String.format(PSC_ENDPOINT_URL_PATTERN, this.params.pscEndpointId), false));
        }
        if (proxySettings.hasProxy()) {
            ret.add(new AbstractSQLConnection.CustomDatabaseProperty("fs.gs.proxy.address", proxySettings.host + ":" + proxySettings.port, false));
            if (proxySettings.hasAuthentication()) {
                ret.add(new AbstractSQLConnection.CustomDatabaseProperty("fs.gs.proxy.username", proxySettings.username, false));
                ret.add(new AbstractSQLConnection.CustomDatabaseProperty("fs.gs.proxy.password", proxySettings.password, true));
            }
        }
        ConnectionWithGoogleAuthCredentials.SerializableGoogleAuthCredentials creds = this.getFullyResolvedCredentials_fsLike(new ConnectionWithBasicCredential.CredentialResolutionContext(authCtx, null), ConnectionWithGoogleAuthCredentials.SerializableGoogleAuthCredentials.class);
        GoogleCredential googleCredential = creds.toGoogleCredential(new ConnectionWithBasicCredential.CredentialResolutionContext(authCtx, null), this);
        switch (creds.authType) {
            case OAUTH: {
                if (this.mustResolveOnBackend() || this.mustResolveOnDSSHost()) {
                    ret.add(new AbstractSQLConnection.CustomDatabaseProperty("fs.gs.auth.access.token.provider.impl", "com.dataiku.dip.hadoop.gcp.RemoteDSSOAuth2Provider", false));
                    ret.add(new AbstractSQLConnection.CustomDatabaseProperty("fs.gs.auth.dss.connection.name", this.name, false));
                    ret.add(new AbstractSQLConnection.CustomDatabaseProperty("fs.gs.auth.access.token", creds.oauthAccessToken, true));
                    ret.add(new AbstractSQLConnection.CustomDatabaseProperty("fs.gs.auth.access.token.expires.on", Long.toString(creds.oauthAccessTokenExpiresOn), false));
                    break;
                }
                String authorizationEndpoint = StringUtils.defaultIfBlank((String)this.params.oauth2AuthorizationEndpoint, (String)"https://accounts.google.com/o/oauth2/v2/auth");
                String tokenEndpoint = StringUtils.defaultIfBlank((String)creds.oauthTokenEndpoint, (String)this.params.getOauth2TokenEndpoint());
                ret.add(new AbstractSQLConnection.CustomDatabaseProperty("fs.gs.auth.access.token.provider.impl", "com.dataiku.dip.hadoop.gcp.RefreshTokenAuth2Provider", false));
                ret.add(new AbstractSQLConnection.CustomDatabaseProperty("fs.gs.auth.refresh.token", creds.oauthRefreshToken, true));
                ret.add(new AbstractSQLConnection.CustomDatabaseProperty("fs.gs.auth.token.endpoint", tokenEndpoint, false));
                if (creds.oauthAccessTokenExpiresOn > 0L) {
                    ret.add(new AbstractSQLConnection.CustomDatabaseProperty("fs.gs.auth.access.token", creds.oauthAccessToken, true));
                    ret.add(new AbstractSQLConnection.CustomDatabaseProperty("fs.gs.auth.access.token.expires.on", "" + creds.oauthAccessTokenExpiresOn, false));
                } else {
                    logger.info((Object)"Get a fresh token with an expiry date");
                    OAuth2Client.AccessTokenResult accessToken = this.getAccessToken(authCtx, proxySettings, false);
                    ret.add(new AbstractSQLConnection.CustomDatabaseProperty("fs.gs.auth.access.token", accessToken.getAccessToken(), true));
                    ret.add(new AbstractSQLConnection.CustomDatabaseProperty("fs.gs.auth.access.token.expires.on", "" + accessToken.getExpiresOn().toInstant().toEpochMilli(), false));
                }
                ret.add(new AbstractSQLConnection.CustomDatabaseProperty("fs.gs.auth.authorization.endpoint", authorizationEndpoint, false));
                ret.add(new AbstractSQLConnection.CustomDatabaseProperty("fs.gs.auth.client.id", creds.oauthAppId, false));
                ret.add(new AbstractSQLConnection.CustomDatabaseProperty("fs.gs.auth.client.secret", creds.oauthAppSecret, true));
                break;
            }
            case KEYPAIR: {
                if (StringUtils.isBlank((String)this.params.appSecretContent)) {
                    throw new CodedRuntimeException((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_INVALID_CONFIG, "Secret key should not be left blank");
                }
                if (StringUtils.isNotBlank((String)this.params.pscEndpointId)) {
                    ret.add(new AbstractSQLConnection.CustomDatabaseProperty("fs.gs.token.server.url", this.params.getOauth2TokenEndpoint(), false));
                }
                ret.add(new AbstractSQLConnection.CustomDatabaseProperty("fs.gs.auth.service.account.enable", "true", false));
                if (StringUtils.isNotBlank((String)creds.keyEmail)) {
                    ret.add(new AbstractSQLConnection.CustomDatabaseProperty("fs.gs.auth.service.account.email", creds.keyEmail, false));
                }
                if (StringUtils.isNotBlank((String)creds.keyJsonData)) {
                    GCSConnection.fillPropertiesFromPrivateKeyJson(ret, (JsonObject)JSON.parse((String)creds.keyJsonData, JsonObject.class));
                    break;
                }
                if (StringUtils.isNotBlank((String)creds.keyBase64Data)) {
                    GCSConnection.fillPropertiesFromPrivateKeyP12(ret, creds.keyBase64Data, creds.keyEmail);
                    break;
                }
                this.buildHadoopExtraConfFromCredentials(googleCredential, ret);
                break;
            }
            default: {
                this.buildHadoopExtraConfFromCredentials(googleCredential, ret);
            }
        }
        return ret;
    }

    private static void fillPropertiesFromPrivateKeyJson(List<AbstractSQLConnection.CustomDatabaseProperty> ret, JsonObject json) {
        if (json.has("client_email")) {
            ret.add(new AbstractSQLConnection.CustomDatabaseProperty("fs.gs.auth.service.account.email", json.get("client_email").getAsString(), false));
        }
        ret.add(new AbstractSQLConnection.CustomDatabaseProperty("fs.gs.auth.service.account.private.key", json.get("private_key").getAsString(), true));
        ret.add(new AbstractSQLConnection.CustomDatabaseProperty("fs.gs.auth.service.account.private.key.id", json.get("private_key_id").getAsString(), false));
    }

    private static void fillPropertiesFromPrivateKeyP12(List<AbstractSQLConnection.CustomDatabaseProperty> ret, String base64Data, String email) throws IOException {
        try {
            GoogleCredentialsBuilder.NewGoogleCredentialsBuilder builder = new GoogleCredentialsBuilder.NewGoogleCredentialsBuilder(null, null, null);
            ServiceAccountCredentials googleCredentials = (ServiceAccountCredentials)builder.buildFromP12(base64Data, email);
            PrivateKey privateKey = googleCredentials.getPrivateKey();
            GCSConnection.fillPropertiesFromPrivateKey(ret, privateKey, googleCredentials.getPrivateKeyId());
        }
        catch (GeneralSecurityException e) {
            throw new IOException("Unable to read P12 data", e);
        }
    }

    private static void fillPropertiesFromPrivateKey(List<AbstractSQLConnection.CustomDatabaseProperty> ret, PrivateKey privateKey, String keyId) {
        String key = "-----BEGIN PRIVATE KEY-----\\n" + new String(Base64.getEncoder().encode(privateKey.getEncoded())) + "\\n-----END PRIVATE KEY-----\\n";
        ret.add(new AbstractSQLConnection.CustomDatabaseProperty("fs.gs.auth.service.account.private.key", key, true));
        ret.add(new AbstractSQLConnection.CustomDatabaseProperty("fs.gs.auth.service.account.private.key.id", keyId, false));
    }

    private void buildHadoopExtraConfFromCredentials(GoogleCredential googleCredential, List<AbstractSQLConnection.CustomDatabaseProperty> ret) throws IOException {
        ret.add(new AbstractSQLConnection.CustomDatabaseProperty("fs.gs.auth.service.account.enable", "true", false));
        if (StringUtils.isNotBlank((String)googleCredential.getServiceAccountId())) {
            ret.add(new AbstractSQLConnection.CustomDatabaseProperty("fs.gs.auth.service.account.email", googleCredential.getServiceAccountId(), false));
        } else if (StringUtils.isNotBlank((String)googleCredential.getServiceAccountUser())) {
            ret.add(new AbstractSQLConnection.CustomDatabaseProperty("fs.gs.auth.service.account.email", googleCredential.getServiceAccountUser(), false));
        }
        PrivateKey privateKey = googleCredential.getServiceAccountPrivateKey();
        if (privateKey != null) {
            GCSConnection.fillPropertiesFromPrivateKey(ret, privateKey, googleCredential.getServiceAccountPrivateKeyId());
        } else {
            String authorizationEndpoint = StringUtils.isNotBlank((String)this.params.oauth2AuthorizationEndpoint) ? this.params.oauth2AuthorizationEndpoint : "https://accounts.google.com/o/oauth2/v2/auth";
            String tokenEndpoint = this.params.getOauth2TokenEndpoint();
            googleCredential.refreshToken();
            ret.add(new AbstractSQLConnection.CustomDatabaseProperty("fs.gs.auth.access.token.provider.impl", "com.dataiku.dip.hadoop.gcp.RefreshTokenAuth2Provider", false));
            ret.add(new AbstractSQLConnection.CustomDatabaseProperty("fs.gs.auth.access.token", googleCredential.getAccessToken(), true));
            if (googleCredential.getExpirationTimeMilliseconds() != null) {
                ret.add(new AbstractSQLConnection.CustomDatabaseProperty("fs.gs.auth.access.token.expires.on", "" + googleCredential.getExpirationTimeMilliseconds(), false));
            }
            ret.add(new AbstractSQLConnection.CustomDatabaseProperty("fs.gs.auth.token.endpoint", tokenEndpoint, false));
            ret.add(new AbstractSQLConnection.CustomDatabaseProperty("fs.gs.auth.authorization.endpoint", authorizationEndpoint, false));
        }
    }

    @Override
    public void decryptFields(PasswordEncryptionService cryptoService) {
        this.params.oauth2ClientSecret = cryptoService.decryptIfEncrypted(this.params.oauth2ClientSecret);
        this.params.appSecretContent = cryptoService.decryptIfEncrypted(this.params.appSecretContent);
    }

    @Override
    public void encryptFields(PasswordEncryptionService cryptoService, GeneralSettingsDAO.SecuritySettings unused) {
        this.params.oauth2ClientSecret = cryptoService.encryptIfNotEncryptedOrEmpty(this.params.oauth2ClientSecret);
        if (StringUtils.isNotBlank((String)this.params.appSecretContent) && ConnectionWithGoogleAuthCredentials.isJson(this.params.appSecretContent)) {
            this.params.appSecretContent = cryptoService.encryptIfNotEncryptedOrEmpty(this.params.appSecretContent);
        }
    }

    public List<AbstractSQLConnection.CustomDatabaseProperty> getSparkConfigForGCSAccess(AuthCtx authCtx) throws IOException, DKUSecurityException {
        List<AbstractSQLConnection.CustomDatabaseProperty> ret = this.getHadoopConfigForGCSAccess(authCtx);
        for (AbstractSQLConnection.CustomDatabaseProperty cdp : ret) {
            cdp.name = "spark.hadoop." + cdp.name;
        }
        return ret;
    }

    @Override
    public String getHDFSScheme() {
        switch (this.params.hdfsInterface) {
            case GS: {
                return "gs";
            }
            case NONE: {
                return null;
            }
        }
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean allowManagedDatasets() {
        return this.allowManagedDatasets;
    }

    @Override
    public String getResolvedHDFSRoot(AuthCtx authCtx, String projectKey) {
        String bucket = StringUtils.isNotBlank((String)this.params.chbucket) ? this.params.chbucket : this.params.defaultManagedBucket;
        switch (this.params.hdfsInterface) {
            case GS: {
                return "gs://" + bucket + PathUtils.makeLeadingNoTrailing((String)StringUtils.defaultIfBlank((String)this.params.chroot, (String)""));
            }
            case NONE: {
                return null;
            }
        }
        throw new Error("unreachable");
    }

    @Override
    public ConnectionsTestService.ConnectionTestResult testConnection(AuthCtx authCtx, ConnectionsTestService connectionsTestService) throws Exception {
        return connectionsTestService.testGCS(this, authCtx);
    }

    public static class Params
    extends ConnectionWithGoogleAuthCredentials.GoogleAuth2Params {
        public String projectId;
        public String bucket;
        public String defaultManagedBucket;
        public String defaultManagedPath;
        public String chbucket;
        public String chroot;
        public HDFSInterface hdfsInterface = HDFSInterface.NONE;
        public String pscEndpointId;
        public String customEndpoint;
        public String snowflakeStorageIntegration;
        public String snowflakeExternalStageName;
        public String snowflakeExternalStagePath;
        public HDFSConnection.HiveSynchronizationMode metastoreSynchronizationMode = HDFSConnection.HiveSynchronizationMode.NO_SYNC;
        public String defaultMetastoreDatabase;
        public FSProviderizableConnection.MetastoreAwareFilesBasedDatasetNamingRule namingRule = new FSProviderizableConnection.MetastoreAwareFilesBasedDatasetNamingRule();
        public List<AbstractSQLConnection.CustomDatabaseProperty> dkuProperties = new ArrayList<AbstractSQLConnection.CustomDatabaseProperty>();

        public String getDefaultManagedBucket() {
            return StringUtils.isNotBlank((String)this.chbucket) ? this.chbucket : this.defaultManagedBucket;
        }

        public Params() {
        }

        public Params(Params other) {
            super(other);
            this.projectId = other.projectId;
            this.bucket = other.bucket;
            this.defaultManagedBucket = other.defaultManagedBucket;
            this.defaultManagedPath = other.defaultManagedPath;
            this.chbucket = other.chbucket;
            this.chroot = other.chroot;
            this.hdfsInterface = other.hdfsInterface;
            this.snowflakeStorageIntegration = other.snowflakeStorageIntegration;
            this.metastoreSynchronizationMode = other.metastoreSynchronizationMode;
            this.snowflakeExternalStageName = other.snowflakeExternalStageName;
            this.snowflakeExternalStagePath = other.snowflakeExternalStagePath;
            this.defaultMetastoreDatabase = other.defaultMetastoreDatabase;
            this.namingRule = other.namingRule;
            this.dkuProperties = other.dkuProperties;
            this.pscEndpointId = other.pscEndpointId;
            this.customEndpoint = other.customEndpoint;
        }

        @Override
        public String getDefaultOauth2Scope() {
            return "https://www.googleapis.com/auth/cloud-platform";
        }

        @Override
        public String getOauth2TokenEndpoint() {
            String userDefinedOauth2TokenEndpoint = super.getOauth2TokenEndpoint();
            if (StringUtils.isBlank((String)userDefinedOauth2TokenEndpoint)) {
                return StringUtils.isBlank((String)this.pscEndpointId) ? "https://oauth2.googleapis.com/token" : String.format("https://oauth2-%s.p.googleapis.com/token", this.pscEndpointId);
            }
            return userDefinedOauth2TokenEndpoint;
        }
    }

    public static enum HDFSInterface {
        GS,
        NONE;

    }
}

