/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.connections.ConnectionUtils;
import com.dataiku.dip.connections.SQLConnectionService;
import com.dataiku.dip.connections.SQLPooledConnectionService;
import com.dataiku.dip.utils.DKULogger;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.pool.BaseKeyedPoolableObjectFactory;

public class SQLConnectionFactory
extends BaseKeyedPoolableObjectFactory<SQLConnectionService.SQLConnectionKey, SQLPooledConnectionService.PooledConnection> {
    private static final AtomicInteger nextConnectionId = new AtomicInteger();
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.sql.connectionfactory");

    static final String connName(SQLConnectionService.SQLConnectionKey key) {
        if (key.sqlConnectionData != null && key.sqlConnectionData.getConnection() != null && key.sqlConnectionData.getConnection().name != null) {
            return key.sqlConnectionData.getConnection().name;
        }
        return "unknown";
    }

    public SQLPooledConnectionService.PooledConnection makeObject(SQLConnectionService.SQLConnectionKey key) throws SQLException {
        try (DSSMetrics.MTimeCtx mt = DSSMetrics.mtimeCtx((String[])new String[]{"dku.connections.sqlPool.overall.makeConnection", "dku.connections.sqlPool." + SQLConnectionFactory.connName(key) + ".makeConnection"});){
            logger.debug((Object)("Making new pooled SQL connection of type=" + String.valueOf((Object)key.sqlConnectionData.getType()) + " for wrapper id=" + key.debugId));
            Connection connection = key.driver.connect(key.jdbcUrl, key.properties);
            String connectionId = key.sqlConnectionData.getConnection().name + "-" + nextConnectionId.getAndIncrement();
            logger.debug((Object)("Created new pooled SQL connection with id=" + connectionId));
            SQLPooledConnectionService.PooledConnection pooledConnection = new SQLPooledConnectionService.PooledConnection(connection, connectionId);
            return pooledConnection;
        }
    }

    public void destroyObject(SQLConnectionService.SQLConnectionKey key, SQLPooledConnectionService.PooledConnection pooledConnection) throws SQLException {
        try (DSSMetrics.MTimeCtx mt = DSSMetrics.mtimeCtx((String[])new String[]{"dku.connections.sqlPool.overall.destroyConnection", "dku.connections.sqlPool." + SQLConnectionFactory.connName(key) + ".destroyConnection"});){
            logger.debug((Object)("Destroying (closing) pooled SQL connection id=" + pooledConnection.connectionId));
            ConnectionUtils.actuallyCloseJdbcConnection(pooledConnection.connection, key.sqlConnectionData.getDialect());
        }
    }

    /*
     * Exception decompiling
     */
    public boolean validateObject(SQLConnectionService.SQLConnectionKey key, SQLPooledConnectionService.PooledConnection pooledConnection) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void passivateObject(SQLConnectionService.SQLConnectionKey key, SQLPooledConnectionService.PooledConnection pooledConnection) throws Exception {
        try {
            if (key.sqlConnectionData.getDialect().supportsCommitAndRollback() && !pooledConnection.connection.getAutoCommit()) {
                logger.debug((Object)("Rolling back SQL connection id=" + pooledConnection.connectionId + " before putting it back in pool"));
                pooledConnection.connection.rollback();
                pooledConnection.lastKnownGood = System.currentTimeMillis();
            } else {
                logger.debug((Object)("Not rolling back SQL connection id=" + pooledConnection.connectionId + " before putting it back in pool, either the connection doesn't support rollback, or auto-commit is enabled"));
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to passivate SQL connection id=" + pooledConnection.connectionId + ", pooled connection will be destroyed"), (Throwable)e);
            throw e;
        }
    }
}

