/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.connections.AbstractCloudStorageConnection;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.AutoFastPathConnection;
import com.dataiku.dip.connections.ConnectionCredentialUtils;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.ConnectionWithEncryptedFields;
import com.dataiku.dip.connections.ConnectionWithPerUserOAuth2Credentials;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.connections.SimpleSQLDSSConnectionWithBasicCredential;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.ConfValidators;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.externalinfras.snowpark.SnowparkUtils;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.model.ICredentialsService;
import com.dataiku.dip.security.model.OAuth2Client;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.connections.ConnectionCodes;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SnowflakeSQLDialect;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.ParseException;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.dataiku.dss.shadelib.org.apache.http.NameValuePair;
import com.dataiku.dss.shadelib.org.apache.http.client.utils.URLEncodedUtils;
import com.dataiku.dss.shadelibgcp.com.google.api.client.util.PemReader;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.sql.SQLException;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class SnowflakeConnection
extends SimpleSQLDSSConnectionWithBasicCredential
implements ConnectionWithEncryptedFields,
ConnectionWithPerUserOAuth2Credentials,
AutoFastPathConnection {
    public static final String connectionType = "Snowflake";
    private static final SnowflakeSQLDialect dialect = new SnowflakeSQLDialect();
    public Params params = new Params();
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.snowflake");

    public String getAccountIdentifier() {
        if (StringUtils.isBlank((String)this.params.host)) {
            return this.params.host;
        }
        String host = this.params.host;
        while (host.endsWith("/")) {
            host = host.substring(0, host.length() - 1);
        }
        if (host.endsWith(".snowflakecomputing.com")) {
            return host.substring(0, host.length() - ".snowflakecomputing.com".length());
        }
        return host;
    }

    @Override
    public boolean useAutoFastConnection() {
        return this.params.useAutoFastPath;
    }

    @Override
    public String getAutoFastPathConnection() {
        return this.params.autoFastPathConnection;
    }

    @Override
    public String getAutoFastPathConnectionPath() {
        return this.params.autoFastPathConnectionPath;
    }

    @Override
    public boolean isSupportedCloudStorage(AbstractCloudStorageConnection connection) {
        return true;
    }

    @Override
    public boolean actuallyHasPerUserOAuth2Credential() {
        return this.credentialsMode == DSSConnection.CredentialsMode.PER_USER && this.params.authType == AuthType.OAUTH2_APP;
    }

    @Override
    public boolean hasRefreshTokenRotation() {
        return this.params.refreshTokenRotation;
    }

    @Override
    public boolean mustResolveOnDSSHost() {
        return StringUtils.isNotEmpty((String)this.params.privateKeyFile);
    }

    @Override
    public boolean mustResolveOnBackend() {
        return this.hasRefreshTokenRotation() || super.mustResolveOnBackend();
    }

    @Override
    public boolean actuallyHasBasicCredential() {
        return this.params.authType == AuthType.PASSWORD;
    }

    @Override
    public OAuth2Client buildOAuth2Client(ProxySettings proxySettings, AuthCtx authCtx) throws DKUSecurityException {
        Object tokenEndpoint;
        Object authorizationEndpoint;
        VariablesService variablesService = (VariablesService)SpringUtils.getBean(VariablesService.class);
        VariablesContext vc = variablesService.getForConnectionAndUser(this, authCtx);
        String scope = vc.expand(this.params.scope);
        String appId = vc.expand(this.params.appId);
        String appSecret = vc.expand(this.params.appSecret);
        if (StringUtils.isEmpty((String)this.params.authorizationEndpoint) && StringUtils.isEmpty((String)this.params.tokenEndpoint)) {
            authorizationEndpoint = "https://" + this.params.host + "/oauth/authorize";
            tokenEndpoint = "https://" + this.params.host + "/oauth/token-request";
        } else {
            authorizationEndpoint = vc.expand(this.params.authorizationEndpoint);
            tokenEndpoint = vc.expand(this.params.tokenEndpoint);
        }
        logger.infoV("Using OAuth2 authorize endpoint: %s", new Object[]{authorizationEndpoint});
        logger.infoV("Using OAuth2 token endpoint: %s", new Object[]{tokenEndpoint});
        boolean isSnowflakeProvider = ((String)tokenEndpoint).contains("snowflakecomputing.com");
        boolean useCache = this.getDkuPropertiesAsParams().getBoolParam("dku.connection.oauth.enableCache", true);
        return new OAuth2Client.Builder().authorizationEndpoint((String)authorizationEndpoint).tokenEndpoint((String)tokenEndpoint).clientId(appId).clientSecret(appSecret).scope(scope).snowflakeOverrideAuthorizationHeader(isSnowflakeProvider).usePkce(true).proxy(proxySettings).useAccessTokenCache(useCache).build();
    }

    @Override
    public ICredentialsService.OAuth2Credential getResolvedOAuth2Credential(AuthCtx authCtx) {
        return new ICredentialsService.OAuth2Credential(this.getAccessToken(authCtx, this.getOAuth2ProxySettings()).getAccessToken());
    }

    public OAuth2Client.AccessTokenResult getAccessToken(AuthCtx authCtx, ProxySettings proxySettings) {
        PasswordEncryptionService cryptoService = (PasswordEncryptionService)SpringUtils.getBean(PasswordEncryptionService.class);
        this.decryptFields(cryptoService);
        boolean useCache = this.getDkuPropertiesAsParams().getBoolParam("dku.connection.oauth.enableCache", true);
        logger.info((Object)"Exchanging user's refresh token for an access token");
        try {
            OAuth2Client oAuth2Client = this.buildOAuth2Client(proxySettings, authCtx);
            if (this.credentialsMode == DSSConnection.CredentialsMode.PER_USER) {
                return this.getAccessTokenFromRefreshTokenAndUpdateIfNeeded(authCtx, oAuth2Client, false);
            }
            return oAuth2Client.acquireAccessTokenResultWithClientCredentialsGrant(useCache);
        }
        catch (DKUSecurityException e) {
            throw new CodedRuntimeException(e.getCode(), "Failed to get OAuth2 access token", (Throwable)e);
        }
        catch (ParseException | IOException | URISyntaxException e) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_INVALID_CONFIG, "Failed to get OAuth2 access token", e);
        }
    }

    @Override
    public SnowflakeSQLDialect getDialect() {
        return dialect;
    }

    @Override
    public Params getParams() {
        return this.params;
    }

    public JsonObject getResolvedParams(AuthCtx authCtx, @Nullable String projectKey) throws IOException {
        Params resolvedParams = (Params)JSON.deepCopy((Object)this.params);
        VariablesService variablesService = (VariablesService)SpringUtils.getBean(VariablesService.class);
        VariablesContext vc = projectKey == null ? variablesService.getForConnectionAndUser(this, authCtx) : variablesService.getForConnectionAndProjectAndUser(this, authCtx, projectKey);
        resolvedParams.host = vc.expand(this.params.host);
        resolvedParams.db = vc.expand(resolvedParams.db);
        resolvedParams.warehouse = vc.expand(resolvedParams.warehouse);
        resolvedParams.role = vc.expand(resolvedParams.role);
        resolvedParams.defaultSchema = vc.expand(resolvedParams.defaultSchema);
        resolvedParams.scope = vc.expand(resolvedParams.scope);
        resolvedParams.appId = vc.expand(resolvedParams.appId);
        resolvedParams.appSecret = vc.expand(resolvedParams.appSecret);
        resolvedParams.tokenEndpoint = vc.expand(resolvedParams.tokenEndpoint);
        resolvedParams.authorizationEndpoint = vc.expand(resolvedParams.authorizationEndpoint);
        resolvedParams.privateKey = vc.expand(resolvedParams.privateKey);
        resolvedParams.privateKeyPassword = vc.expand(resolvedParams.privateKeyPassword);
        JsonObject result = JSON.toJsonObject((Object)resolvedParams);
        if (StringUtils.isNotBlank((String)resolvedParams.postConnectStatements)) {
            String postConnectStatements = vc.expand(resolvedParams.postConnectStatements);
            String[] postConnectStatementExpandedAndSplit = dialect.getSplitter().split(postConnectStatements);
            result.add("postConnectStatementsExpandedAndSplit", (JsonElement)JSON.toJsonArray((Object)postConnectStatementExpandedAndSplit));
        }
        result.addProperty("application", DKUApp.getDataikuApplicationString());
        if (StringUtils.isNotEmpty((String)this.params.privateKeyFile)) {
            result.addProperty("user", this.params.user);
            b64key = Base64.getEncoder().encodeToString(FileUtils.readFileToByteArray((File)new File(this.params.privateKeyFile)));
            result.addProperty("privateKeyB64", b64key);
        } else if (StringUtils.isNotEmpty((String)this.params.privateKey)) {
            result.addProperty("user", this.params.user);
            b64key = Base64.getEncoder().encodeToString(this.params.privateKey.getBytes());
            result.addProperty("privateKeyB64", b64key);
        }
        String privateKeyFile = null;
        String privateKeyFilePwd = null;
        if (resolvedParams.useURL) {
            if (resolvedParams.url != null && resolvedParams.url.startsWith("jdbc:")) {
                try {
                    List urlProperties = URLEncodedUtils.parse((URI)new URI(resolvedParams.url.substring("jdbc:".length())), (Charset)StandardCharsets.UTF_8);
                    privateKeyFile = this.getUrlProperty(urlProperties, "private_key_file");
                    privateKeyFilePwd = this.getUrlProperty(urlProperties, "private_key_file_pwd");
                }
                catch (URISyntaxException e) {
                    logger.warnV((Throwable)e, "Unable to parse Snowflake JDBC URL", new Object[0]);
                }
            } else {
                logger.warn((Object)"Unable to parse Snowflake JDBC URL as it's either empty or does not start with \"jdbc:\".");
            }
        } else {
            privateKeyFile = this.getParamProperty(resolvedParams, "private_key_file");
            privateKeyFilePwd = this.getParamProperty(resolvedParams, "private_key_file_pwd");
        }
        if (StringUtils.isNotBlank((String)privateKeyFile)) {
            try (FileReader fileReader = new FileReader(privateKeyFile);){
                PKCS8EncodedKeySpec keySpec;
                PemReader pemReader = new PemReader((Reader)fileReader);
                PemReader.Section section = pemReader.readNextSection();
                if (StringUtils.isBlank((String)privateKeyFilePwd)) {
                    keySpec = new PKCS8EncodedKeySpec(section.getBase64DecodedBytes());
                } else {
                    EncryptedPrivateKeyInfo pkInfo = new EncryptedPrivateKeyInfo(section.getBase64DecodedBytes());
                    SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(pkInfo.getAlgName());
                    PBEKeySpec passwordKeySpec = new PBEKeySpec(privateKeyFilePwd.toCharArray());
                    keySpec = pkInfo.getKeySpec(secretKeyFactory.generateSecret(passwordKeySpec));
                }
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                PrivateKey privateKey = keyFactory.generatePrivate(keySpec);
                String encodedDecryptedPrivateKey = Base64.getEncoder().encodeToString(privateKey.getEncoded());
                result.addProperty("privateKey", encodedDecryptedPrivateKey);
            }
            catch (Exception e) {
                throw new IOException("Unable to read file denoted by private_key_file property: " + privateKeyFile, e);
            }
        }
        return result;
    }

    @Override
    public String getDefaultCatalog() {
        return this.params.db;
    }

    @Override
    public String getType() {
        return connectionType;
    }

    @Override
    String getDriver() {
        return "net.snowflake.client.jdbc.SnowflakeDriver";
    }

    @Override
    String getJdbcUrl() {
        if (this.params.useURL) {
            if (StringUtils.isBlank((String)this.params.url)) {
                throw ErrorContext.iae((String)"Snowflake connection JDBC URL is not set");
            }
            return this.params.url;
        }
        ConfValidators.checkNotBlankRuntime(this.params.host, ConnectionCodes.ERR_CONNECTION_INVALID_CONFIG, "Host");
        return "jdbc:snowflake://" + this.params.host;
    }

    @Override
    String getJarsDirectory() {
        if (StringUtils.isNotBlank((String)this.params.driver)) {
            return this.params.jarsDirectory;
        }
        switch (this.params.driverMode) {
            case MANAGED: {
                return DKUApp.getInstallFile((String[])new String[]{"lib", "ivy", "jdbc-snowflake"}).getAbsolutePath();
            }
            case CUSTOM: {
                return this.params.jarsDirectory;
            }
        }
        throw new Error("unreachable");
    }

    @Override
    public SQLConnectionProvider.SQLConnectionData getConnectionData_NT(AuthCtx authCtx, String projectKey) throws DKUSecurityException, SQLException {
        SerializableSnowflakeCredentials creds = this.getFullyResolvedCredentials_sqlLike(new ConnectionWithBasicCredential.CredentialResolutionContext(authCtx, projectKey), SerializableSnowflakeCredentials.class);
        SQLConnectionProvider.SnowflakeSQLConnectionData cd = new SQLConnectionProvider.SnowflakeSQLConnectionData(this.getType(), (SQLDialect)this.getDialect(), this, this.getDriver(), this.getJdbcUrl(), this.getJarsDirectory());
        this.fillConnectionData(cd);
        if (StringUtils.isNotBlank((String)this.params.db)) {
            cd.withProperty("db", this.params.db);
        }
        if (StringUtils.isNotBlank((String)this.params.warehouse)) {
            cd.withProperty("warehouse", this.params.warehouse);
        }
        if (StringUtils.isNotBlank((String)this.params.role)) {
            cd.withProperty("role", this.params.role);
        }
        if (StringUtils.isNotBlank((String)this.params.defaultSchema)) {
            cd.withProperty("schema", this.params.defaultSchema);
        }
        cd.withProperty("application", DKUApp.getDataikuApplicationString());
        if (!cd.getProperties(true).containsKey("GEOGRAPHY_OUTPUT_FORMAT")) {
            cd.withPropertyIfNotBlank("GEOGRAPHY_OUTPUT_FORMAT", "WKT");
        }
        switch (creds.authType) {
            case PASSWORD: {
                if (creds.user != null) {
                    cd.withProperty(new AbstractSQLConnection.CustomDatabaseProperty("user", creds.user, false));
                }
                if (creds.password == null) break;
                cd.withProperty(new AbstractSQLConnection.CustomDatabaseProperty("password", creds.password, true));
                break;
            }
            case OAUTH2_APP: {
                cd.withProperty(new AbstractSQLConnection.CustomDatabaseProperty("authenticator", "oauth", false));
                cd.withProperty(new AbstractSQLConnection.CustomDatabaseProperty("token", creds.oauth2AccessToken, true));
                break;
            }
            case KEY_PAIR: {
                cd.withProperty(new AbstractSQLConnection.CustomDatabaseProperty("user", creds.user, false));
                cd.withProperty(new AbstractSQLConnection.CustomDatabaseProperty("private_key_base64", creds.privateKeyB64, true));
                if (!StringUtils.isNotEmpty((String)creds.privateKeyPassword)) break;
                cd.withProperty(new AbstractSQLConnection.CustomDatabaseProperty("private_key_pwd", creds.privateKeyPassword, true));
            }
        }
        ProxySettings proxySettings = this.getSnowflakeProxySettings();
        if (proxySettings.hasProxy()) {
            cd.withProperty(new AbstractSQLConnection.CustomDatabaseProperty("useProxy", "true", false));
            cd.withProperty(new AbstractSQLConnection.CustomDatabaseProperty("proxyHost", proxySettings.host, false));
            cd.withProperty(new AbstractSQLConnection.CustomDatabaseProperty("proxyPort", "" + proxySettings.port, false));
            if (StringUtils.isNotBlank((String)proxySettings.username)) {
                cd.withProperty(new AbstractSQLConnection.CustomDatabaseProperty("proxyUser", proxySettings.username, false));
                cd.withProperty(new AbstractSQLConnection.CustomDatabaseProperty("proxyPassword", proxySettings.password, true));
            }
        }
        return cd;
    }

    @Override
    String getDisplayableJdbcUrl() {
        return this.params.useURL && StringUtils.isNotBlank((String)this.params.displayedUrl) ? this.params.displayedUrl : this.getJdbcUrl();
    }

    @Override
    public ICredentialsService.BasicCredential getGlobalCredential() {
        return new ICredentialsService.BasicCredential(this.params.user, this.params.password);
    }

    @Override
    public void encryptFields(PasswordEncryptionService cryptoService, GeneralSettingsDAO.SecuritySettings unused) {
        this.params.password = cryptoService.encryptIfNotEncryptedOrEmpty(this.params.password);
        this.params.appSecret = cryptoService.encryptIfNotEncryptedOrEmpty(this.params.appSecret);
        this.params.privateKey = cryptoService.encryptIfNotEncryptedOrEmpty(this.params.privateKey);
        this.params.privateKeyPassword = cryptoService.encryptIfNotEncryptedOrEmpty(this.params.privateKeyPassword);
    }

    @Override
    public void decryptFields(PasswordEncryptionService cryptoService) {
        this.params.password = cryptoService.decryptIfEncrypted(this.params.password);
        this.params.appSecret = cryptoService.decryptIfEncrypted(this.params.appSecret);
        this.params.privateKey = cryptoService.decryptIfEncrypted(this.params.privateKey);
        this.params.privateKeyPassword = cryptoService.decryptIfEncrypted(this.params.privateKeyPassword);
    }

    @Override
    protected <T> T getFullyResolvedCredentials_internal(ConnectionWithBasicCredential.CredentialResolutionContext ctx, Class<T> clazz) throws DKUSecurityException, IOException, SQLException {
        assert (clazz.isAssignableFrom(SerializableSnowflakeCredentials.class));
        SerializableSnowflakeCredentials creds = new SerializableSnowflakeCredentials();
        creds.authType = this.params.authType;
        switch (creds.authType) {
            case PASSWORD: {
                ICredentialsService.BasicCredential basicCreds = ConnectionCredentialUtils.getDecryptedBasicCredential_autoTXN(this, ctx.authCtx);
                creds.user = basicCreds.user;
                creds.password = basicCreds.password;
                break;
            }
            case OAUTH2_APP: {
                creds.oauth2AppId = this.params.appId;
                creds.oauth2AppSecret = this.params.appSecret;
                creds.oauth2Scope = this.params.scope;
                if (StringUtils.isEmpty((String)this.params.authorizationEndpoint) && StringUtils.isEmpty((String)this.params.tokenEndpoint)) {
                    creds.oauth2AuthorizationEndpoint = "https://" + this.params.host + "/oauth/authorize";
                    creds.oauth2TokenEndpoint = "https://" + this.params.host + "/oauth/token-request";
                } else {
                    creds.oauth2AuthorizationEndpoint = this.params.authorizationEndpoint;
                    creds.oauth2TokenEndpoint = this.params.tokenEndpoint;
                }
                OAuth2Client.AccessTokenResult tokens = this.getAccessToken(ctx.authCtx, this.getOAuth2ProxySettings());
                if (this.credentialsMode == DSSConnection.CredentialsMode.PER_USER) {
                    creds.oauth2RefreshToken = tokens.getRefreshToken();
                }
                creds.oauth2AccessToken = tokens.getAccessToken();
                break;
            }
            case KEY_PAIR: {
                creds.user = this.params.user;
                creds.privateKeyPassword = this.params.privateKeyPassword;
                if (StringUtils.isNotEmpty((String)this.params.privateKeyFile)) {
                    File keyFile = new File(this.params.privateKeyFile);
                    if (!keyFile.exists() || !keyFile.canRead()) {
                        throw new FileNotFoundException("Cannot read private key file");
                    }
                    creds.privateKeyB64 = Base64.getEncoder().encodeToString(FileUtils.readFileToByteArray((File)keyFile));
                    break;
                }
                creds.privateKeyB64 = Base64.getEncoder().encodeToString(this.params.privateKey.getBytes());
            }
        }
        return clazz.cast(creds);
    }

    private String getUrlProperty(List<NameValuePair> properties, String propertyName) {
        return properties.stream().filter(pair -> propertyName.equalsIgnoreCase(pair.getName())).findFirst().map(NameValuePair::getValue).orElse(null);
    }

    private String getParamProperty(Params resolvedParams, String propertyName) {
        return resolvedParams.properties.stream().filter(property -> propertyName.equalsIgnoreCase(property.name)).findFirst().map(property -> property.value).orElse(null);
    }

    public String getAuthToken(AuthCtx authCtx) throws UnauthorizedException {
        if (!this.isFreelyUsableBy(authCtx)) {
            throw new UnauthorizedException("Access to this connection is not authorized.", "connection-access-denied");
        }
        try {
            SerializableSnowflakeCredentials creds = this.getFullyResolvedCredentials(new ConnectionWithBasicCredential.CredentialResolutionContext(authCtx, null), SerializableSnowflakeCredentials.class);
            switch (creds.authType) {
                case PASSWORD: {
                    return creds.password;
                }
                case OAUTH2_APP: {
                    return creds.oauth2AccessToken;
                }
                case KEY_PAIR: {
                    return SnowparkUtils.getSnowflakeKeyPairToken(this, creds);
                }
            }
            throw new Error("Unreachable");
        }
        catch (DKUSecurityException | IOException | SQLException e) {
            throw new UnauthorizedException("Unable to get credentials", "connection-access-denied", e);
        }
    }

    @Nonnull
    private ProxySettings getProxySettings(List<AbstractSQLConnection.CustomDatabaseProperty> propertyList, String prefix, String connectionType) {
        ProxySettings ret;
        block9: {
            if (this.useGlobalProxy) {
                return ApplicationConfigurator.getProxySettings();
            }
            ret = new ProxySettings();
            try {
                if (!CollectionUtils.isNotEmpty(propertyList)) break block9;
                Map<String, String> properties = AbstractSQLConnection.CustomDatabaseProperty.toMap(propertyList);
                boolean useProxy = Boolean.parseBoolean(properties.get(prefix + "useProxy"));
                if (useProxy) {
                    ret.host = properties.get(prefix + "proxyHost");
                    String portStr = properties.get(prefix + "proxyPort");
                    if (portStr != null) {
                        try {
                            int port = Integer.parseInt(portStr);
                            if (port < 1 || port > 65535) {
                                logger.warnV("Invalid %sproxyPort value '%s' (out of range 1-65535) in %s connection %s", new Object[]{prefix, portStr, connectionType, this.name});
                            } else {
                                ret.port = port;
                            }
                        }
                        catch (NumberFormatException e) {
                            logger.warnV("Invalid %sproxyPort value '%s' (not a number) in %s connection %s", new Object[]{prefix, portStr, connectionType, this.name});
                        }
                    }
                    ret.username = properties.getOrDefault(prefix + "proxyUser", null);
                    ret.password = properties.getOrDefault(prefix + "proxyPassword", null);
                    logger.infoV("Using %s proxy configuration for connection %s: %s:%d", new Object[]{connectionType, this.name, ret.host, ret.port});
                    break block9;
                }
                logger.debugV("No %s proxy configured for connection %s", new Object[]{connectionType, this.name});
            }
            catch (Exception e) {
                logger.errorV((Throwable)e, "Error while analyzing properties of %s connection %s", new Object[]{connectionType, this.name});
            }
        }
        return ret;
    }

    @Nonnull
    public ProxySettings getSnowflakeProxySettings() {
        return this.getProxySettings(this.params.properties, "", connectionType);
    }

    @Nonnull
    public ProxySettings getOAuth2ProxySettings() {
        return this.getProxySettings(this.params.dkuProperties, "dku.connection.oauth.", "OAuth2");
    }

    public static class Params
    extends AbstractSQLConnection.AbstractSQLParamsWithStdFields {
        public AuthType authType = AuthType.PASSWORD;
        public String privateKey;
        public String privateKeyFile;
        public String privateKeyPassword;
        public String appId;
        public String appSecret;
        public String authorizationEndpoint;
        public String tokenEndpoint;
        public String scope;
        public boolean refreshTokenRotation;
        public SnowflakeDriverMode driverMode = SnowflakeDriverMode.MANAGED;
        public String driver;
        public String warehouse;
        public String role;
        public String defaultSchema;
        public boolean useSparkNativeIntegration = false;
        public boolean useJavaUDF = false;
        public String javaUDFStage;
        public String javaUDFPathInStage;
        public boolean useAutoFastPath;
        public String autoFastPathConnection;
        public String autoFastPathConnectionPath;
    }

    public static enum AuthType {
        PASSWORD,
        OAUTH2_APP,
        KEY_PAIR;

    }

    public static enum SnowflakeDriverMode {
        MANAGED,
        CUSTOM;

    }

    public static class SerializableSnowflakeCredentials
    implements ICredentialsService.BasicCredentialConvertible {
        public AuthType authType;
        public String oauth2AppId;
        public String oauth2AppSecret;
        public String oauth2AuthorizationEndpoint;
        public String oauth2TokenEndpoint;
        public String oauth2Scope;
        public String oauth2RefreshToken;
        public String oauth2AccessToken;
        public String user;
        public String password;
        public String privateKeyB64;
        public String privateKeyPassword;

        public ICredentialsService.OAuth2Credential toOAuth2Credential() {
            return new ICredentialsService.OAuth2Credential(this.oauth2AccessToken);
        }

        @Override
        public ICredentialsService.BasicCredential toBasicCredential() {
            return new ICredentialsService.BasicCredential(this.user, this.password);
        }
    }
}

