/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections.aws;

import com.dataiku.dip.connections.ConnectionWithAWSAuthCredentials;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.auth.credentials.AwsCredentials;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import java.io.IOException;

public class ShadedS3ConnectionAWSSessionCredentialsProviderV2
implements AwsCredentialsProvider {
    private final AuthCtx authCtx;
    private final DSSConnection connection;

    public ShadedS3ConnectionAWSSessionCredentialsProviderV2(AuthCtx authCtx, DSSConnection connection) {
        this.authCtx = authCtx;
        this.connection = connection;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AwsCredentials resolveCredentials() {
        TransactionService ts = (TransactionService)SpringUtils.getBean(TransactionService.class);
        try (Transaction t = ts.retrieveOrBeginRead();){
            ConnectionWithAWSAuthCredentials.SerializableAWSCredential sac = this.connection.getFullyResolvedCredentials_fsLike(new ConnectionWithBasicCredential.CredentialResolutionContext(this.authCtx, null), ConnectionWithAWSAuthCredentials.SerializableAWSCredential.class);
            if (sac.sessionToken == null) {
                AwsBasicCredentials awsBasicCredentials = AwsBasicCredentials.create((String)sac.accessKey, (String)sac.secretKey);
                return awsBasicCredentials;
            }
            AwsSessionCredentials awsSessionCredentials = AwsSessionCredentials.create((String)sac.accessKey, (String)sac.secretKey, (String)sac.sessionToken);
            return awsSessionCredentials;
        }
        catch (DKUSecurityException | IOException e) {
            throw new RuntimeException("Failed to get AWS credentials", e);
        }
    }
}

