/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.containers.exec;

import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.stream.Collectors;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.representer.Representer;

public class YamlUtils {
    private final Yaml yamlHandler;

    public YamlUtils() {
        this(false);
    }

    public YamlUtils(boolean skipMissing) {
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        Representer representer = new Representer(dumperOptions);
        representer.getPropertyUtils().setSkipMissingProperties(skipMissing);
        this.yamlHandler = new Yaml(representer, dumperOptions);
    }

    public String yamlToJsonString(String yaml) {
        return JSON.json((Object)this.yamlHandler.load(yaml));
    }

    public String jsonObjectToYamlString(JsonObject json) {
        return this.yamlHandler.dump(JSON.toJavaLongPreserving((JsonElement)json));
    }

    public List<JsonElement> yamlToJsonElements(String yaml) {
        return Lists.newArrayList((Iterable)this.yamlHandler.loadAll(yaml)).stream().map(JSON::toJsonElement).collect(Collectors.toList());
    }

    public String jsonElementsToYam(List<JsonElement> objects) {
        return this.yamlHandler.dumpAll(objects.stream().map(JSON::toJavaLongPreserving).collect(Collectors.toList()).iterator());
    }

    public <T> T readYAML(String yamlStr, Class<T> type) {
        return (T)this.yamlHandler.loadAs(yamlStr, type);
    }
}

