/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.contribs;

import com.dataiku.dip.util.PythonInterpreterFactory;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.python.core.PyFunction;
import org.python.core.PyNone;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.util.PythonInterpreter;

public class PythonContrib {
    ContribType type;
    public String pythoncode;
    public String name;
    public String title;
    public String description;
    public Map<String, PythonParameter> parameters = new HashMap<String, PythonParameter>();
    private static Logger logger = Logger.getLogger((String)"dku");

    public PythonContrib(PyFunction func, File file, String pythoncode) {
        this.pythoncode = pythoncode;
        this.name = file.getName();
        PyObject argcount = func.__getattr__("func_code").__getattr__("co_argcount");
        PyObject paramslist = func.__getattr__("func_code").__getattr__("co_varnames");
        PyObject defaultlist = func.__getattr__("func_defaults");
        int argc = argcount.asInt();
        List args = ((PyTuple)paramslist).subList(0, argc);
        PyTuple defaults = defaultlist instanceof PyNone ? new PyTuple() : (PyTuple)defaultlist;
        int i = 0;
        int ncolumns = args.size() - defaults.size();
        for (String param : args) {
            if (i >= ncolumns) {
                PyObject def = defaults.pyget(i - ncolumns);
                this.parameters.put(param, new PythonParameter(i, param, ParameterType.VALUE, def));
            } else {
                this.parameters.put(param, new PythonParameter(i, param, ParameterType.COLUMN, null));
            }
            ++i;
        }
        PyObject doc = func.getFuncDoc();
        this.description = doc.asString();
        this.title = this.description.split("\n")[0];
    }

    public PythonContribInstance getInstance() {
        return new PythonContribInstance();
    }

    public static class PythonParameter {
        public int position;
        public String name;
        public ParameterType type;
        public String typeName;
        public String defaultValue;

        public PythonParameter(int position, String name, ParameterType type, PyObject def) {
            this.position = position;
            this.name = name;
            this.type = type;
            if (def == null) {
                this.defaultValue = null;
                this.typeName = null;
            } else {
                PyType t = def.getType();
                this.typeName = t.getName();
                this.defaultValue = def.__str__().toString();
            }
        }

        public PyObject getDefaultValue(PythonInterpreter interpreter) {
            return interpreter.eval(this.defaultValue);
        }

        public PyObject getValue(PythonInterpreter interpreter, String value) {
            if (value == null) {
                value = "";
            }
            if (this.typeName == null) {
                return new PyString(value);
            }
            PyObject object = interpreter.eval(this.typeName);
            return ((PyType)object).__call__((PyObject)new PyString(value));
        }
    }

    public static enum ParameterType {
        COLUMN,
        VALUE;

    }

    public class PythonContribInstance {
        PythonInterpreter interpreter;
        PyFunction map_function;
        PyObject[] args;

        public PythonContribInstance() {
            logger.info((Object)("Create Python interpreter for executing contrib " + PythonContrib.this.name));
            this.interpreter = PythonInterpreterFactory.newInstance(true);
            this.interpreter.exec(PythonContrib.this.pythoncode);
            this.map_function = (PyFunction)this.interpreter.get("map");
            this.args = new PyObject[PythonContrib.this.parameters.size()];
            for (PythonParameter value : PythonContrib.this.parameters.values()) {
                if (value.type != ParameterType.VALUE) continue;
                this.args[value.position] = value.getDefaultValue(this.interpreter);
            }
        }

        public void set(String param, String value) {
            PythonParameter p = PythonContrib.this.parameters.get(param);
            this.args[p.position] = p.getValue(this.interpreter, value);
        }

        public String run() {
            PyObject result = this.map_function.__call__(this.args);
            return result.toString();
        }
    }

    public static enum ContribType {
        PYTHON_ROW_MAP;

    }
}

