/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.coremodel;

import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.projectstandards.ProjectStandardsService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.utils.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class ExposedObject {
    public ITaggingService.TaggableType type;
    public String localName;
    public boolean quickSharingEnabled;
    public List<Rule> rules = new ArrayList<Rule>();

    private ExposedObject() {
    }

    public ExposedObject(ITaggingService.TaggableType type, String localName, boolean quickSharingEnabled) {
        this.type = type;
        this.localName = localName;
        this.quickSharingEnabled = quickSharingEnabled;
    }

    public boolean canAccess(String projectKey) {
        String resolvedProjectKey = ProjectStandardsService.getOriginalProjectKey(projectKey);
        for (Rule rule : this.rules) {
            if (!resolvedProjectKey.equals(rule.targetProject)) continue;
            return true;
        }
        return false;
    }

    public boolean isUseless() {
        return !this.quickSharingEnabled && this.rules.isEmpty();
    }

    public boolean addTargetProjects(Collection<String> targetProjectKeys) {
        HashSet<String> targetProjectsSet = new HashSet<String>(targetProjectKeys);
        this.rules.forEach(r -> targetProjectsSet.remove(r.targetProject));
        targetProjectsSet.forEach(targetProjectKey -> {
            Rule newRule = new Rule();
            newRule.appearOnFlow = true;
            newRule.targetProject = targetProjectKey;
            this.rules.add(newRule);
        });
        return !targetProjectsSet.isEmpty();
    }

    public Set<String> getTargetProjectKeys() {
        return this.rules.stream().map(r -> r.targetProject).collect(Collectors.toUnmodifiableSet());
    }

    public boolean removeProject(String projectKey) {
        return this.rules.removeIf(rule -> StringUtils.equals((String)rule.targetProject, (String)projectKey));
    }

    public int hashCode() {
        int ret = 65 * this.type.hashCode() + 33 * (this.quickSharingEnabled ? 1 : 0) + 17 * this.localName.hashCode();
        for (Rule rule : this.rules) {
            ret += rule.hashCode();
        }
        return ret;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ExposedObject)) {
            return false;
        }
        ExposedObject eo = (ExposedObject)obj;
        if (this.type != eo.type || this.quickSharingEnabled != eo.quickSharingEnabled || !StringUtils.equals((String)this.localName, (String)eo.localName) || this.rules.size() != eo.rules.size()) {
            return false;
        }
        for (Rule rule : this.rules) {
            if (eo.rules.contains(rule)) continue;
            return false;
        }
        return true;
    }

    public static class Rule {
        public String targetProject;
        public boolean appearOnFlow = true;

        public int hashCode() {
            return this.targetProject.hashCode() + 17 * (this.appearOnFlow ? 1 : 0);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Rule)) {
                return false;
            }
            Rule r = (Rule)obj;
            return this.appearOnFlow == r.appearOnFlow && StringUtils.equals((String)this.targetProject, (String)r.targetProject);
        }

        public static class RuleWithName
        extends Rule {
            @JSON.FileTransient
            public String targetProjectDisplayName;
            @JSON.FileTransient
            public boolean isProjectDeleted;

            private RuleWithName() {
            }

            public static RuleWithName fromRule(Rule rule, String targetProjectDisplayName, boolean isProjectDeleted) {
                RuleWithName ret = new RuleWithName();
                ret.targetProject = rule.targetProject;
                ret.appearOnFlow = rule.appearOnFlow;
                ret.targetProjectDisplayName = targetProjectDisplayName;
                ret.isProjectDeleted = isProjectDeleted;
                return ret;
            }

            @Override
            public int hashCode() {
                return super.hashCode();
            }

            @Override
            public boolean equals(Object obj) {
                return super.equals(obj);
            }
        }
    }

    public static class ExposedObjectWithName
    extends ExposedObject {
        @JSON.FileTransient
        public String displayName;
        public String savedModelMLCategory;

        public static ExposedObjectWithName fromExposedObject(ExposedObject exposedObject, String displayName) {
            ExposedObjectWithName ret = new ExposedObjectWithName();
            ret.type = exposedObject.type;
            ret.localName = exposedObject.localName;
            ret.quickSharingEnabled = exposedObject.quickSharingEnabled;
            ret.rules = exposedObject.rules;
            ret.displayName = displayName;
            return ret;
        }

        public void setSavedModelMLCategory(SavedModel sm) {
            this.savedModelMLCategory = sm.getMLCategory();
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj);
        }
    }
}

