/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.cuspol;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.autoconfig.ParamDesc;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.coremodel.DkuComponentMetadata;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.cuspol.CustomFieldsDesc;
import com.dataiku.dip.cuspol.LoadedCustomFieldsDesc;
import com.dataiku.dip.custom.AbstractElementService;
import com.dataiku.dip.custom.PluginComponentDescValidator;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.plugins.model.PluginComponentRef;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class CustomFieldsService
extends AbstractElementService<CustomFieldsDesc, LoadedCustomFieldsDesc> {
    @Override
    public String getFolderName() {
        return "custom-fields";
    }

    @Override
    public String getPrefix() {
        return "custom-fields";
    }

    @Override
    public Class<CustomFieldsDesc> getDescClass() {
        return CustomFieldsDesc.class;
    }

    @Override
    public Class<LoadedCustomFieldsDesc> getLoadedDescClass() {
        return LoadedCustomFieldsDesc.class;
    }

    @Override
    protected String getCodeExtension(LoadedCustomFieldsDesc desc) {
        return null;
    }

    @Override
    protected void removeElement(LoadedCustomFieldsDesc desc) {
    }

    @Override
    protected String makeType(String pluginId, String elementId) {
        return "CustomFields" + elementId;
    }

    @Override
    protected LoadedCustomFieldsDesc load(String elementType, String pluginId, String elementId, File file) throws IOException {
        return new LoadedCustomFieldsDesc(elementId, pluginId, elementType, (CustomFieldsDesc)JSON.parseFile((File)file, CustomFieldsDesc.class));
    }

    @Override
    public InfoMessage.InfoMessages validate(String componentId, String pluginId, final CustomFieldsDesc desc) {
        return new PluginComponentDescValidator(componentId){

            @Override
            public InfoMessage.InfoMessages validate() {
                this.genericValidateMeta(desc.meta);
                if (desc.customFields == null || desc.customFields.size() == 0) {
                    this.withFatal("No custom fields specified");
                } else {
                    ArrayList<ParamDesc> fieldsParams = new ArrayList<ParamDesc>(desc.customFields.size());
                    for (CustomFieldsDesc.CustomField f : desc.customFields) {
                        if (f == null) {
                            this.withFatal("Null custom field, make sure there is no trailing comma.");
                            continue;
                        }
                        if (f.field == null) {
                            this.withFatal("Custom field has no descriptor.");
                            continue;
                        }
                        fieldsParams.add(f.field);
                    }
                    this.genericValidateParams(fieldsParams, CustomFieldsService.this.getPrefix(), false);
                }
                return this.messages;
            }
        }.validate();
    }

    public JsonObject getDefaultCustomFields(String objectType) {
        JsonObject ret = new JsonObject();
        for (PluginComponentCustomFields pccf : this.getCustomFieldsMap().get(objectType)) {
            for (ParamDesc customFieldDesc : pccf.customFields) {
                if (customFieldDesc.defaultValue == null) continue;
                ret.add(customFieldDesc.name, JSON.toJsonElement((Object)customFieldDesc.defaultValue));
            }
        }
        return ret;
    }

    public <T extends TaggableObjectsService.TaggableObject> void enrichWithDefaultCustomFieldsForTaggableObject(T t) {
        if (t.customFields == null) {
            t.customFields = this.getDefaultCustomFields(t.getTaggableType().name());
            return;
        }
        for (PluginComponentCustomFields pccf : this.getCustomFieldsMap().get(t.getTaggableType().name())) {
            for (ParamDesc customFieldDesc : pccf.customFields) {
                if (customFieldDesc.defaultValue == null || t.customFields.has(customFieldDesc.name)) continue;
                t.customFields.add(customFieldDesc.name, JSON.toJsonElement((Object)customFieldDesc.defaultValue));
            }
        }
    }

    public void enrichWithDefaultCustomFieldsForConnection(DSSConnection c2) {
        if (c2.customFields == null) {
            c2.customFields = this.getDefaultCustomFields("CONNECTION");
            return;
        }
        for (PluginComponentCustomFields pccf : this.getCustomFieldsMap().get("CONNECTION")) {
            for (ParamDesc customFieldDesc : pccf.customFields) {
                if (customFieldDesc.defaultValue == null || c2.customFields.has(customFieldDesc.name)) continue;
                c2.customFields.add(customFieldDesc.name, JSON.toJsonElement((Object)customFieldDesc.defaultValue));
            }
        }
    }

    private void fillPluginComponent(PluginComponentRef ref, CustomFieldsDesc desc, Map<String, List<PluginComponentCustomFields>> newCustomFieldsMap) {
        if (desc == null) {
            return;
        }
        for (CustomFieldsDesc.CustomField cf : desc.customFields) {
            for (Map.Entry<String, List<PluginComponentCustomFields>> entry : newCustomFieldsMap.entrySet()) {
                boolean addCustomField = false;
                switch (cf.applyToObjects.mode) {
                    case ALL: {
                        addCustomField = true;
                        break;
                    }
                    case SOME: {
                        if (cf.applyToObjects.includedObjectTypes == null || !cf.applyToObjects.includedObjectTypes.contains(entry.getKey())) break;
                        addCustomField = true;
                        break;
                    }
                    case EXCLUDING: {
                        if (cf.applyToObjects.excludedObjectTypes != null && cf.applyToObjects.excludedObjectTypes.contains(entry.getKey())) break;
                        addCustomField = true;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unreachable");
                    }
                }
                if (!addCustomField) continue;
                PluginComponentCustomFields pccf = null;
                for (PluginComponentCustomFields p : entry.getValue()) {
                    if (!p.ref.equals(ref)) continue;
                    pccf = p;
                    break;
                }
                if (pccf == null) {
                    pccf = new PluginComponentCustomFields(ref, desc.meta, new ArrayList<ParamDesc>());
                    entry.getValue().add(pccf);
                }
                pccf.customFields.add(cf.field);
            }
        }
    }

    public Map<String, List<PluginComponentCustomFields>> getCustomFieldsMap() {
        HashMap<String, List<PluginComponentCustomFields>> newCustomFieldsMap = new HashMap<String, List<PluginComponentCustomFields>>();
        for (ITaggingService.TaggableType tt : ITaggingService.TaggableType.values()) {
            if (tt.isFakeType()) continue;
            newCustomFieldsMap.put(tt.name(), new ArrayList());
        }
        newCustomFieldsMap.put("CONNECTION", new ArrayList());
        newCustomFieldsMap.put("COLUMN", new ArrayList());
        HashMap<PluginComponentRef, CustomFieldsDesc> pluginDescMap = new HashMap<PluginComponentRef, CustomFieldsDesc>();
        for (LoadedCustomFieldsDesc loadedDesc : this.loadedDescs.values()) {
            PluginComponentRef ref = new PluginComponentRef(loadedDesc.getOwnerPluginId(), loadedDesc.getId());
            pluginDescMap.put(ref, loadedDesc.desc);
        }
        HashSet<PluginComponentRef> browsedRefs = new HashSet<PluginComponentRef>();
        GeneralSettingsDAO.GeneralSettings gs = ApplicationConfigurator.getGeneralSettings();
        for (PluginComponentRef ref : gs.customFieldsPluginComponentOrder) {
            browsedRefs.add(ref);
            this.fillPluginComponent(ref, (CustomFieldsDesc)pluginDescMap.get(ref), newCustomFieldsMap);
        }
        for (LoadedCustomFieldsDesc loadedDesc : this.loadedDescs.values()) {
            PluginComponentRef ref = new PluginComponentRef(loadedDesc.getOwnerPluginId(), loadedDesc.getId());
            if (browsedRefs.contains(ref)) continue;
            this.fillPluginComponent(ref, (CustomFieldsDesc)pluginDescMap.get(ref), newCustomFieldsMap);
        }
        return newCustomFieldsMap;
    }

    public List<PluginComponentRef> getPluginComponentRefs() {
        ArrayList<PluginComponentRef> ret = new ArrayList<PluginComponentRef>();
        for (LoadedCustomFieldsDesc loadedDesc : this.loadedDescs.values()) {
            PluginComponentRef ref = new PluginComponentRef(loadedDesc.getOwnerPluginId(), loadedDesc.getId());
            ret.add(ref);
        }
        return ret;
    }

    public static class PluginComponentCustomFields {
        public final PluginComponentRef ref;
        public final DkuComponentMetadata meta;
        public final List<ParamDesc> customFields;

        public PluginComponentCustomFields(PluginComponentRef ref, DkuComponentMetadata meta, List<ParamDesc> customFields) {
            this.ref = ref;
            this.meta = meta;
            this.customFields = customFields;
        }
    }
}

