/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dao;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.projects.apps.AppsService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dss.shadelib.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.com.google.common.io.ByteStreams;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.mutable.MutableLong;
import org.springframework.stereotype.Service;

@Service
public class ImagesDAO {
    private static final String PROMOTED_CONTENT_PICTURES_FOLDER = "promoted-content-pictures";

    private File resizedCacheObjectFolder(String projectKey, String type, String id) {
        if ("APP".equals(type) || "APPFULL".equals(type)) {
            if (id.startsWith("PROJECT_")) {
                projectKey = AppsService.getProjectKey(id);
                return ApplicationConfigurator.getFile((String[])new String[]{"caches", "pictures", projectKey, type.toLowerCase() + "-template"});
            }
            throw new IllegalArgumentException("AppId not recognized: " + id);
        }
        return ApplicationConfigurator.getFile((String[])new String[]{"caches", "pictures", projectKey, type + "-" + id});
    }

    private RelFile originalPictureFile(String projectKey, String type, String id) {
        switch (type) {
            case "PROJECT": {
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project key is not specified");
                return new RelFile(new String[]{"projects", projectKey, "pictures", "project-original.png"});
            }
            case "PUBLISHED_PROJECT": {
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Published project key is not specified");
                return new RelFile(new String[]{"project-deployer", "projects", "pictures", projectKey + "-original.png"});
            }
            case "USER": {
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)id), (Object)"User id is not specified");
                return new RelFile(new String[]{"user-pictures", id + "-original.png"});
            }
            case "APP": 
            case "APPFULL": {
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)id), (Object)"App id is not specified");
                if (id.startsWith("PROJECT_")) {
                    projectKey = AppsService.getProjectKey(id);
                    return new RelFile(new String[]{"projects", projectKey, "pictures", type.toLowerCase() + "-original.png"});
                }
                throw new IllegalArgumentException("AppId not recognized: " + id);
            }
            case "ARTICLE": {
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)id), (Object)"Article id is not specified");
                return new RelFile(new String[]{"projects", projectKey, "thumbnails", "wikis", id + "-original.png"});
            }
            case "DASHBOARD": {
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)id), (Object)"Dashboard id is not specified");
                return new RelFile(new String[]{"projects", projectKey, "thumbnails", "dashboards", id + "-original.png"});
            }
            case "WEB_APP": {
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)id), (Object)"WebApp id is not specified");
                return new RelFile(new String[]{"projects", projectKey, "thumbnails", "webapps", id + "-original.png"});
            }
            case "DATASET": {
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)id), (Object)"Dataset id is not specified");
                return new RelFile(new String[]{"projects", projectKey, "thumbnails", "datasets", id + "-original.png"});
            }
            case "PROMOTED_CONTENT": {
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)id), (Object)"Promoted content image id is not specified");
                return new RelFile(new String[]{PROMOTED_CONTENT_PICTURES_FOLDER, id + "-original.png"});
            }
        }
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project key is not specified");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)id), (Object)(type + " id is not specified"));
        return new RelFile(new String[]{"projects", projectKey, "pictures", type + "-" + id, "original.png"});
    }

    private File resizedPictureFile(String projectKey, String type, String id, String size) {
        if (type.equals("USER")) {
            return ApplicationConfigurator.getFile((String[])new String[]{"caches", "user-pictures", id, size + ".png"});
        }
        if (type.equals("PROMOTED_CONTENT")) {
            return ApplicationConfigurator.getFile((String[])new String[]{"caches", PROMOTED_CONTENT_PICTURES_FOLDER, id, size + ".png"});
        }
        return DKUFileUtils.getWithin((File)this.resizedCacheObjectFolder(projectKey, type, id), (String[])new String[]{size + ".png"});
    }

    public synchronized String clearCachedPictures(String projectKey, String type, String id) throws IOException {
        File f = null;
        f = type.equals("USER") ? ApplicationConfigurator.getFile((String[])new String[]{"caches", "user-pictures", id}) : (type.equals("PROMOTED_CONTENT") ? ApplicationConfigurator.getFile((String[])new String[]{"caches", PROMOTED_CONTENT_PICTURES_FOLDER, id}) : this.resizedCacheObjectFolder(projectKey, type, id));
        if (f.isDirectory()) {
            DKUFileUtils.deleteDirectory((File)f);
            return f.getAbsolutePath();
        }
        return "";
    }

    public synchronized void clearProjectCachedPictures(String projectKey) throws IOException {
        File f = ApplicationConfigurator.getFile((String[])new String[]{"caches", "pictures", projectKey});
        if (f.isDirectory()) {
            DKUFileUtils.deleteDirectory((File)f);
        }
    }

    public InputStream getResizedImage(String projectKey, String type, String id, String size, MutableLong lastModified) throws IOException {
        File f = this.resizedPictureFile(projectKey, type, id, size);
        if (f.isFile()) {
            lastModified.setValue(f.lastModified());
            return new FileInputStream(f);
        }
        return null;
    }

    public InputStream getOriginalImage(String projectKey, String type, String id, MutableLong lastModified) throws IOException {
        RelFile rf;
        TransactionRef t = TransactionContext.retrieveRead();
        if (t.isFile(rf = this.originalPictureFile(projectKey, type, id))) {
            lastModified.setValue(t.getLastModified(rf));
            return new ByteArrayInputStream(t.readBytes(rf));
        }
        return null;
    }

    public long getOriginalImageHash(String projectKey, String type, String id) throws IOException {
        RelFile rf;
        TransactionRef t = TransactionContext.retrieveRead();
        if (t.isFile(rf = this.originalPictureFile(projectKey, type, id))) {
            return t.getLastModified(rf);
        }
        return 0L;
    }

    public void setResizedImage(String projectKey, String type, String id, InputStream imgData, String size) throws IOException {
        File f = this.resizedPictureFile(projectKey, type, id, size);
        DKUFileUtils.mkdirsParent((File)f);
        try (FileOutputStream fos = new FileOutputStream(f);){
            IOUtils.copy((InputStream)imgData, (OutputStream)fos);
        }
    }

    public void setOriginalImage(String projectKey, String type, String id, InputStream imgData) throws IOException {
        RelFile file;
        RWTransactionRef t = TransactionContext.retrieveWrite();
        if (t.exists(file = this.originalPictureFile(projectKey, type, id))) {
            t.deleteFile(file);
        }
        if (imgData != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)imgData, (OutputStream)baos);
            t.writeBytes(file, baos.toByteArray());
        }
    }

    public Set<String> cleanupPromotedContentImages(Set<String> imagesToKeep) throws IOException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        HashSet<String> deletedFilesAndDirectories = new HashSet<String>();
        RelFile folder = new RelFile(new String[]{PROMOTED_CONTENT_PICTURES_FOLDER});
        if (t.isDirectory(folder)) {
            for (RelFile file : t.listFilesUnordered(folder)) {
                int suffixIndex;
                String imageId;
                String fileName = file.getLeafName();
                if (StringUtils.isBlank((String)fileName) || !fileName.endsWith("-original.png") || !StringUtils.isNotBlank((String)(imageId = fileName.substring(0, suffixIndex = fileName.lastIndexOf("-original.png")))) || imagesToKeep.contains(imageId)) continue;
                String deletedCacheDirectory = this.clearCachedPictures("", "PROMOTED_CONTENT", imageId);
                if (StringUtils.isNotBlank((String)deletedCacheDirectory)) {
                    deletedFilesAndDirectories.add(deletedCacheDirectory);
                }
                t.deleteFile(file);
                deletedFilesAndDirectories.add(fileName);
            }
        }
        return deletedFilesAndDirectories;
    }

    public void removeOriginalImage(String projectKey, String type, String id) throws IOException {
        this.clearCachedPictures(projectKey, type, id);
        RWTransactionRef t = TransactionContext.retrieveWrite();
        RelFile file = this.originalPictureFile(projectKey, type, id);
        if (t.exists(file)) {
            t.deleteFile(file);
        }
    }

    public InputStream getCapturedThumbnail(String projectKey, String type, String id) throws IOException {
        File thumbnailFile = this.capturedThumbnailFile(projectKey, type, id);
        if (thumbnailFile != null && thumbnailFile.isFile()) {
            return new FileInputStream(thumbnailFile);
        }
        return null;
    }

    public long getCapturedThumbnailLastModified(String projectKey, String type, String id) {
        File rf = this.capturedThumbnailFile(projectKey, type, id);
        return rf != null && rf.isFile() ? rf.lastModified() : 0L;
    }

    public void setCapturedThumbnail(String projectKey, String type, String id, InputStream imgData) throws IOException {
        Preconditions.checkNotNull((Object)imgData, (Object)"imgData cannot be null");
        File file = this.capturedThumbnailFile(projectKey, type, id);
        if (file != null) {
            if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
                throw new IOException("Unable to create directory");
            }
            try (FileOutputStream outputStream = new FileOutputStream(file);){
                ByteStreams.copy((InputStream)imgData, (OutputStream)outputStream);
            }
        }
    }

    private File capturedThumbnailFile(String projectKey, String type, String id) {
        switch (type) {
            case "ARTICLE": {
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)id), (Object)"Article id is not specified");
                return ApplicationConfigurator.getFile((String[])new String[]{"thumbnails", projectKey, "wikis", id + ".png"});
            }
            case "DASHBOARD": {
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)id), (Object)"Dashboard id is not specified");
                return ApplicationConfigurator.getFile((String[])new String[]{"thumbnails", projectKey, "dashboards", id + ".png"});
            }
            case "WEB_APP": {
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)id), (Object)"WebApp id is not specified");
                return ApplicationConfigurator.getFile((String[])new String[]{"thumbnails", projectKey, "webapps", id + ".png"});
            }
            case "DATASET": {
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)id), (Object)"Dataset id is not specified");
                return ApplicationConfigurator.getFile((String[])new String[]{"thumbnails", projectKey, "datasets", id + ".png"});
            }
        }
        return null;
    }
}

