/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dao;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.MiscCodes;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dao.IPersistentNotificationsInternalDB;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.db.AbstractDSSDBService;
import com.dataiku.dip.db.DSSDBConnection;
import com.dataiku.dip.exceptions.CodedSQLException;
import com.dataiku.dip.server.notifications.DSSEvent;
import com.dataiku.dip.server.notifications.backend.UserEvent;
import com.dataiku.dip.sql.queries.CreateIndexQueryBuilder;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PersistentNotificationsInternalDB
extends AbstractDSSDBService
implements IPersistentNotificationsInternalDB {
    private static final int SCHEMA_VERSION = 3;
    private final String insert = "INSERT INTO " + this.getQuotedFullResolvedTableName(this.getName()) + " VALUES (?,?,?,?,?,?)";
    private final String update = "UPDATE " + this.getQuotedFullResolvedTableName(this.getName()) + " SET " + this.quote("BODY") + "=?, " + this.quote("TIMESTAMP") + "=? WHERE " + this.quote("USER") + "=? AND " + this.quote("OBJECT_ID") + "=? AND " + this.quote("TIMESTAMP") + "=?";
    private final String getForAllUsers = "SELECT * FROM " + this.getQuotedFullResolvedTableName(this.getName()) + " ORDER BY " + this.quote("TIMESTAMP") + " DESC";
    private final String getForUser = "SELECT * FROM " + this.getQuotedFullResolvedTableName(this.getName()) + " WHERE " + this.quote("USER") + "=? ORDER BY " + this.quote("TIMESTAMP") + " DESC LIMIT ?";
    private final String getLatestForUserAndObject = "SELECT * FROM " + this.getQuotedFullResolvedTableName(this.getName()) + " WHERE " + this.quote("USER") + "=? AND " + this.quote("OBJECT_ID") + "=? ORDER BY " + this.quote("TIMESTAMP") + " DESC LIMIT 1";
    private final String getCountsForUser = "SELECT SUM(" + this.quote("UNREAD") + ") FROM " + this.getQuotedFullResolvedTableName(this.getName()) + " WHERE " + this.quote("USER") + "=?";
    private final String acknowledge = "UPDATE " + this.getQuotedFullResolvedTableName(this.getName()) + " SET " + this.quote("UNREAD") + "=0 WHERE " + this.quote("USER") + "=? AND " + this.quote("UNREAD") + "=1";
    private final String acknowledgeObject = "UPDATE " + this.getQuotedFullResolvedTableName(this.getName()) + " SET " + this.quote("UNREAD") + "=0 WHERE " + this.quote("USER") + "=? AND " + this.quote("OBJECT_ID") + "=? AND " + this.quote("UNREAD") + "=1";
    private final String updateTask = "UPDATE " + this.getQuotedFullResolvedTableName(this.getName()) + " SET " + this.quote("BODY") + "=? WHERE " + this.quote("OBJECT_ID") + "=?";
    private final String garbageCollectForUser = "DELETE FROM " + this.getQuotedFullResolvedTableName(this.getName()) + " WHERE " + this.quote("USER") + "=? AND " + this.quote("TIMESTAMP") + "<?";
    private final String deleteForUser = "DELETE FROM " + this.getQuotedFullResolvedTableName(this.getName()) + " WHERE " + this.quote("USER") + "=?";
    private int maxNotificationsPerUser = 5;
    public static final String notificationsTable = "NOTIFICATIONS";
    private static final String USER_COLUMN = "USER";
    private static final SchemaColumn USER_SCHEMA_COLUMN = new SchemaColumn("USER", Type.STRING);
    private static final String OBJECT_ID_COLUMN = "OBJECT_ID";
    private static final SchemaColumn OBJECT_ID_SCHEMA_COLUMN = new SchemaColumn("OBJECT_ID", Type.STRING);
    private static final String TIMESTAMP_COLUMN = "TIMESTAMP";
    private static final String CLAZZ_COLUMN = "CLAZZ";
    private static final String BODY_COLUMN = "BODY";
    private static final String UNREAD_COLUMN = "UNREAD";
    private static final SchemaColumn[] notificationsColumns = new SchemaColumn[]{USER_SCHEMA_COLUMN, new SchemaColumn("TIMESTAMP", Type.BIGINT), new SchemaColumn("CLAZZ", Type.STRING), new SchemaColumn("BODY", Type.STRING), OBJECT_ID_SCHEMA_COLUMN, new SchemaColumn("UNREAD", Type.TINYINT)};
    private ConcurrentHashMap<String, Integer> cachedUnreadCountPerUser = new ConcurrentHashMap();
    private static DKULogger logger = DKULogger.getLogger((String)"dku.pnotifications");

    public PersistentNotificationsInternalDB(String name, int maxNotificationsPerUser) {
        super(ApplicationConfigurator.getDatabaseFile(name), name.toUpperCase() + "_NOTIFICATIONS", name, 3, false);
        this.maxNotificationsPerUser = maxNotificationsPerUser;
    }

    @Override
    protected void initDB(int currentSchemaVersion, DSSDBConnection conn) throws CodedSQLException {
        block16: {
            try {
                Statement st2;
                if (currentSchemaVersion == 0) {
                    st2 = conn.createStatement();
                    try {
                        this.createTable(this.getName(), notificationsColumns, null, st2);
                    }
                    finally {
                        if (st2 != null) {
                            st2.close();
                        }
                    }
                }
                if (currentSchemaVersion >= 3) break block16;
                st2 = conn.createStatement();
                try {
                    logger.info((Object)("Create indexes for " + this.getName()));
                    CreateIndexQueryBuilder.createAnonymousIndex(this.resolveTable(this.getName())).addColumns(USER_COLUMN).execute(st2, this.getDialect());
                    CreateIndexQueryBuilder.createAnonymousIndex(this.resolveTable(this.getName())).addColumns(OBJECT_ID_COLUMN).execute(st2, this.getDialect());
                }
                finally {
                    if (st2 != null) {
                        st2.close();
                    }
                }
            }
            catch (SQLException e) {
                throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, "Failed to access internal database", (Throwable)e);
            }
        }
    }

    @Override
    public void insert(String user, String id, DSSEvent evt, boolean markAsRead) {
        try (DSSDBConnection conn = this.acquireConnection();){
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.insert);
            ps2.setString(1, user);
            ps2.setLong(2, System.currentTimeMillis());
            ps2.setString(3, evt.getClass().getCanonicalName());
            ps2.setString(4, JSON.json((Object)evt));
            ps2.setString(5, id);
            ps2.setInt(6, markAsRead ? 0 : 1);
            ps2.execute();
            conn.commit();
            if (!markAsRead) {
                this.cachedUnreadCountPerUser.merge(user, 1, (c2, n) -> c2 + 1);
            }
        }
        catch (Exception e) {
            logger.info((Object)("Failed to insert notification for user " + user), (Throwable)e);
        }
    }

    @Override
    public void update(String user, String id, long timestamp, DSSEvent evt) {
        try (DSSDBConnection conn = this.acquireConnection();){
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.update);
            ps2.setString(1, JSON.json((Object)evt));
            ps2.setLong(2, System.currentTimeMillis());
            ps2.setString(3, user);
            ps2.setString(4, id);
            ps2.setLong(5, timestamp);
            ps2.execute();
            conn.commit();
        }
        catch (Exception e) {
            logger.info((Object)("Failed to update notification for user " + user), (Throwable)e);
        }
    }

    @Override
    public boolean acknowledge(String user, long timestamp) {
        boolean bl;
        block8: {
            DSSDBConnection conn = this.acquireConnection();
            try {
                PreparedStatement ps2 = this.getPreparedStatement(conn, this.acknowledge);
                ps2.setString(1, user);
                int count = ps2.executeUpdate();
                conn.commit();
                this.cachedUnreadCountPerUser.put(user, 0);
                logger.info((Object)("Acknowledged " + count + " notifications"));
                boolean bl2 = bl = count > 0;
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    this.cachedUnreadCountPerUser.remove(user);
                    logger.info((Object)("Failed to acknowledge notifications for user " + user), (Throwable)e);
                    return false;
                }
            }
            conn.close();
        }
        return bl;
    }

    @Override
    public boolean acknowledgeObject(String user, String id) {
        boolean bl;
        block9: {
            DSSDBConnection conn = this.acquireConnection();
            try {
                PreparedStatement ps2 = this.getPreparedStatement(conn, this.acknowledgeObject);
                ps2.setString(1, user);
                ps2.setString(2, id);
                int count = ps2.executeUpdate();
                conn.commit();
                if (count > 0) {
                    this.cachedUnreadCountPerUser.computeIfPresent(user, (u, c2) -> c2 - count);
                    logger.debug((Object)("Acknowledged " + count + " notifications for user " + user + " object " + id));
                }
                boolean bl2 = bl = count > 0;
                if (conn == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    this.cachedUnreadCountPerUser.remove(user);
                    logger.info((Object)("Failed to acknowledge notifications for user " + user), (Throwable)e);
                    return false;
                }
            }
            conn.close();
        }
        return bl;
    }

    @Override
    public void updateTask(String id, DSSEvent evt) {
        try (DSSDBConnection conn = this.acquireConnection();){
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.updateTask);
            ps2.setString(1, JSON.json((Object)evt));
            ps2.setString(2, id);
            ps2.execute();
            conn.commit();
        }
        catch (Exception e) {
            logger.info((Object)("Failed to update notification " + id), (Throwable)e);
        }
    }

    @Override
    public void deleteForUser(String user) {
        try (DSSDBConnection conn = this.acquireConnection();){
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.deleteForUser);
            ps2.setString(1, user);
            ps2.execute();
            conn.commit();
            this.cachedUnreadCountPerUser.put(user, 0);
        }
        catch (Exception e) {
            this.cachedUnreadCountPerUser.remove(user);
            logger.info((Object)("Failed to delete notifications for user " + user), (Throwable)e);
        }
    }

    private List<IPersistentNotificationsInternalDB.PersistentNotification> readResultSet(ResultSet rs2) throws SQLException {
        ArrayList<IPersistentNotificationsInternalDB.PersistentNotification> ret = new ArrayList<IPersistentNotificationsInternalDB.PersistentNotification>();
        while (rs2.next()) {
            try {
                ret.add(this.readNotification(rs2));
            }
            catch (Exception e) {
                logger.error((Object)"Failed to parse notification ", (Throwable)e);
            }
        }
        return ret;
    }

    private IPersistentNotificationsInternalDB.PersistentNotification readNotification(ResultSet rs2) throws Exception {
        IPersistentNotificationsInternalDB.PersistentNotification pn = new IPersistentNotificationsInternalDB.PersistentNotification();
        pn.timestamp = rs2.getLong("timestamp");
        pn.evt = (UserEvent)JSON.parse((String)rs2.getString("body"), Class.forName(rs2.getString("clazz")));
        pn.evtType = pn.evt.getName();
        pn.unread = rs2.getInt("unread") == 1;
        return pn;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<IPersistentNotificationsInternalDB.PersistentNotification> getForUser(String user) {
        try (DSSDBConnection conn = this.acquireConnection();){
            List<IPersistentNotificationsInternalDB.PersistentNotification> list;
            block14: {
                PreparedStatement ps2 = this.getPreparedStatement(conn, this.getForUser);
                ps2.setString(1, user);
                ps2.setInt(2, this.maxNotificationsPerUser);
                ps2.execute();
                ResultSet rs2 = ps2.getResultSet();
                try {
                    list = this.readResultSet(rs2);
                    if (rs2 == null) break block14;
                }
                catch (Throwable throwable) {
                    if (rs2 != null) {
                        try {
                            rs2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs2.close();
            }
            return list;
        }
        catch (Exception e) {
            logger.info((Object)("Failed to get notifications for user " + user), (Throwable)e);
            return new ArrayList<IPersistentNotificationsInternalDB.PersistentNotification>();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IPersistentNotificationsInternalDB.PersistentNotification getLatestForUserAndObject(String user, String id) {
        try (DSSDBConnection conn = this.acquireConnection();){
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.getLatestForUserAndObject);
            ps2.setString(1, user);
            ps2.setString(2, id);
            ps2.execute();
            try (ResultSet rs2 = ps2.getResultSet();){
                if (!rs2.next()) return null;
                IPersistentNotificationsInternalDB.PersistentNotification persistentNotification = this.readNotification(rs2);
                return persistentNotification;
            }
        }
        catch (Exception e) {
            logger.info((Object)("Failed to get notification for user " + user), (Throwable)e);
        }
        return null;
    }

    @Override
    public int getUnreadCountForUser(String user) throws Exception {
        int cachedCount = this.cachedUnreadCountPerUser.getOrDefault(user, -1);
        if (cachedCount != -1) {
            return cachedCount;
        }
        try (DSSDBConnection conn = this.acquireConnection();){
            int n;
            block13: {
                PreparedStatement ps2 = this.getPreparedStatement(conn, this.getCountsForUser);
                ps2.setString(1, user);
                ps2.execute();
                ResultSet rs2 = ps2.getResultSet();
                try {
                    int count = rs2.next() ? rs2.getInt(1) : 0;
                    this.cachedUnreadCountPerUser.put(user, count);
                    n = count;
                    if (rs2 == null) break block13;
                }
                catch (Throwable throwable) {
                    if (rs2 != null) {
                        try {
                            rs2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs2.close();
            }
            return n;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, List<IPersistentNotificationsInternalDB.PersistentNotification>> getForAllUsers() {
        try (DSSDBConnection conn = this.acquireConnection();){
            HashMap<String, List<IPersistentNotificationsInternalDB.PersistentNotification>> hashMap;
            block18: {
                PreparedStatement ps2 = this.getPreparedStatement(conn, this.getForAllUsers);
                ps2.execute();
                ResultSet rs2 = ps2.getResultSet();
                try {
                    HashMap<String, List<IPersistentNotificationsInternalDB.PersistentNotification>> ret = new HashMap<String, List<IPersistentNotificationsInternalDB.PersistentNotification>>();
                    while (rs2.next()) {
                        try {
                            String user = rs2.getString("user");
                            if (!ret.containsKey(user)) {
                                ret.put(user, new ArrayList());
                            }
                            ((List)ret.get(user)).add(this.readNotification(rs2));
                        }
                        catch (Exception e) {
                            logger.error((Object)"Failed to parse notification ", (Throwable)e);
                        }
                    }
                    hashMap = ret;
                    if (rs2 == null) break block18;
                }
                catch (Throwable throwable) {
                    if (rs2 != null) {
                        try {
                            rs2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs2.close();
            }
            return hashMap;
        }
        catch (Exception e) {
            logger.info((Object)"Failed to get notifications for all users", (Throwable)e);
            return new HashMap<String, List<IPersistentNotificationsInternalDB.PersistentNotification>>();
        }
    }

    public void garbageCollect() throws Exception {
        final HashMap<String, Integer> usersCounters = new HashMap<String, Integer>();
        HashMap<String, Long> usersTimestamps = new HashMap<String, Long>();
        try (DSSDBConnection conn = this.acquireConnection();){
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.getForAllUsers);
            ps2.execute();
            int i = 0;
            try (ResultSet rs2 = ps2.getResultSet();){
                while (rs2.next()) {
                    ++i;
                    String user = rs2.getString("user");
                    if (!usersCounters.containsKey(user)) {
                        usersCounters.put(user, 1);
                    } else {
                        usersCounters.put(user, (Integer)usersCounters.get(user) + 1);
                    }
                    if ((Integer)usersCounters.get(user) != this.maxNotificationsPerUser) continue;
                    long timestamp = rs2.getLong("timestamp");
                    usersTimestamps.put(user, timestamp);
                }
            }
            Map usersTimestamps2 = Maps.filterKeys(usersTimestamps, (Predicate)new Predicate<String>(){

                public boolean apply(String user) {
                    return (Integer)usersCounters.get(user) >= 2 * PersistentNotificationsInternalDB.this.maxNotificationsPerUser;
                }
            });
            logger.info((Object)("Currently " + i + " notifications."));
            if (usersTimestamps2.isEmpty()) {
                logger.info((Object)"Nothing to garbage collect. Done.");
            } else {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Garbage collect for users: " + String.valueOf(usersTimestamps2.keySet())));
                }
                for (Map.Entry entry : usersTimestamps2.entrySet()) {
                    this.garbageCollectForUser((String)entry.getKey(), (Long)entry.getValue());
                }
                logger.info((Object)"Garbage collection done.");
            }
        }
    }

    private void garbageCollectForUser(String user, long timestamp) throws SQLException {
        try (DSSDBConnection conn = this.acquireConnection();){
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.garbageCollectForUser);
            ps2.setString(1, user);
            ps2.setLong(2, timestamp);
            ps2.execute();
            conn.commit();
        }
        catch (Exception e) {
            logger.info((Object)("Failed to garbage collect for user:" + ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
        this.cachedUnreadCountPerUser.remove(user);
    }
}

