/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dao;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.dao.UsersDAO;
import com.dataiku.dip.exceptions.IllegalConfigurationException;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.unifiedmonitoring.alerting.UnifiedMonitoringAlertConfig;
import com.dataiku.dip.unifiedmonitoring.externalendpoint.UnifiedMonitoringExternalEndpointsScope;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.j2ts.annotations.UIModel;
import java.io.IOException;
import java.time.Period;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

@UIModel
public class UnifiedMonitoringSettings {
    public static final int DATABRICKS_BATCH_FREQUENCY_IN_MINUTES = 1;
    public static final int SYSTEM_METRICS_BATCH_FREQUENCY_DEFAULT_MIN_IN_SECONDS = 30;
    @Deprecated
    public int batchFrequencyInMinutes;
    public int systemMetricsBatchFrequencyInSeconds = 60;
    public int endpointsBatchFrequencyInMinutes = 5;
    public int projectsBatchFrequencyInMinutes = 5;
    @Nonnull
    public Period windowPeriod;
    @Nonnull
    public List<UnifiedMonitoringExternalEndpointsScope> externalEndpointsScopes = new ArrayList<UnifiedMonitoringExternalEndpointsScope>();
    @Nonnull
    public List<String> unmonitoredProjectInfrastructures = new ArrayList<String>();
    @Nonnull
    public List<String> unmonitoredEndpointInfrastructures = new ArrayList<String>();
    @Nonnull
    public List<String> unmonitoredExternalEndpointsScopes = new ArrayList<String>();
    @Nonnull
    public Map<String, String> overrideConnectionPerInfra = new HashMap<String, String>();
    @Nullable
    public String apiRunAsUserLogin;
    @Nonnull
    public List<UnifiedMonitoringAlertConfig> alertConfigs = new ArrayList<UnifiedMonitoringAlertConfig>();
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.unifiedmonitoring.settings");

    public UnifiedMonitoringSettings() {
        this.windowPeriod = Period.ofDays(1);
    }

    public void validate() {
        if (this.endpointsBatchFrequencyInMinutes < 1) {
            throw new IllegalConfigurationException("The endpoints batch frequency must be greater than 1 minute");
        }
        if (this.projectsBatchFrequencyInMinutes < 1) {
            throw new IllegalConfigurationException("The projects batch frequency must be greater than 1 minute");
        }
        int systemMetricsBatchFrequencyMinInSeconds = ApplicationConfigurator.getParams().getIntParam("dku.deployer.systemMetricsBatchFrequencyMinInSeconds", Integer.valueOf(30));
        if (this.systemMetricsBatchFrequencyInSeconds < systemMetricsBatchFrequencyMinInSeconds) {
            throw ErrorContext.icef((String)"The system metrics batch frequency must be greater than %s seconds", (Object)systemMetricsBatchFrequencyMinInSeconds, (Object[])new Object[0]);
        }
        this.externalEndpointsScopes.forEach(UnifiedMonitoringExternalEndpointsScope::validate);
    }

    @Nonnull
    public DSSAuthCtx getAPIRunAsUser() throws IOException, IllegalArgumentException {
        UsersDAO.User user;
        if (StringUtils.isBlank((String)this.apiRunAsUserLogin)) {
            return DSSAuthCtx.internalAdminAuth();
        }
        try {
            user = ((UsersDAO)SpringUtils.getBean(UsersDAO.class)).getMandatory(this.apiRunAsUserLogin);
        }
        catch (Exception e) {
            logger.warnV((Throwable)e, "Error when retrieving API Monitoring User.", new Object[0]);
            throw e;
        }
        return DSSAuthCtx.forUserLogin(user);
    }
}

