/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dao.impl;

import com.dataiku.dip.dao.AbstractStandardDAO;
import com.dataiku.dip.dao.StreamingEndpointsDAO;
import com.dataiku.dip.dataflow.FlowGraphService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.utils.FileFilter;
import com.dataiku.dip.transactions.fs.utils.RelFileFilter;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.utils.DKUtils;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FilesBasedStreamingEndpointsDAO
extends AbstractStandardDAO<StreamingEndpoint>
implements StreamingEndpointsDAO {
    @Autowired
    private FlowGraphService graphService;

    @Override
    protected String getHumanReadableType() {
        return ITaggingService.TaggableType.STREAMING_ENDPOINT.toHumanReadableString();
    }

    @Override
    protected StreamingEndpoint getOrNull_noTag(String projectKey, String id, boolean unsafe) throws IOException {
        RelFile rf;
        TransactionRef tr = TransactionContext.retrieveRead();
        if (!tr.isFile(rf = this.streamingEndpointFile(projectKey, id))) {
            return null;
        }
        StreamingEndpoint sm = unsafe ? (StreamingEndpoint)tr.readObjectUnsafe(rf, StreamingEndpoint.class) : (StreamingEndpoint)tr.readObject(rf, StreamingEndpoint.class);
        if (sm != null) {
            sm.id = id;
            sm.projectKey = projectKey;
        }
        return sm;
    }

    @Override
    public int approximateCount(String projectKey) throws IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project key is not specified");
        TransactionRef tr = TransactionContext.retrieveRead();
        RelFile folder = this.streamingEndpointsFolder(projectKey);
        if (!tr.isDirectory(folder)) {
            return 0;
        }
        return tr.listFiles(folder).size();
    }

    @Override
    protected List<StreamingEndpoint> list_noTag(String projectKey, boolean unsafe) throws IOException {
        RelFile folder = this.streamingEndpointsFolder(projectKey);
        TransactionRef tr = TransactionContext.retrieveRead();
        ArrayList<StreamingEndpoint> ret = new ArrayList<StreamingEndpoint>();
        if (tr.isDirectory(folder)) {
            for (RelFile f : tr.listFiles(folder)) {
                try {
                    String id = StringUtils.removeEnd((String)f.getLeafName(), (String)".json");
                    StreamingEndpoint sr = (StreamingEndpoint)this.getMandatory(projectKey, id, unsafe);
                    ret.add(sr);
                }
                catch (Exception e) {
                    this.logger.error((Object)("Failed to read saved model file: " + String.valueOf(f)), (Throwable)e);
                }
            }
        }
        return ret;
    }

    @Override
    public void save(StreamingEndpoint sm) throws IOException {
        this.graphService.invalidateCache();
        super.save(sm);
    }

    @Override
    public void delete(String projectKey, String id) throws IOException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        this.graphService.invalidateCache();
        t.deleteFile(this.streamingEndpointFile(projectKey, id));
    }

    private RelFile streamingEndpointFile(String projectKey, String id) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project key is not specified");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)id), (Object)"Endpoint id is not specified");
        return new RelFile(new String[]{"projects", projectKey, "streaming-endpoints", id + ".json"});
    }

    private RelFile streamingEndpointsFolder(String projectKey) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project key is not specified");
        return new RelFile(new String[]{"projects", projectKey, "streaming-endpoints"});
    }

    @Override
    protected RelFile getDAOFile(String projectKey, String id) {
        return this.streamingEndpointFile(projectKey, id);
    }

    @Override
    public List<String> listUsedNames(String projectKey) throws IOException {
        ArrayList<String> names = new ArrayList<String>();
        TransactionRef t = TransactionContext.retrieveRead();
        RelFile streamingEndpointsFolder = new RelFile(new String[]{"projects", projectKey, "streaming-endpoints"});
        if (!t.isDirectory(streamingEndpointsFolder)) {
            return names;
        }
        for (RelFile rf : t.listFiles(streamingEndpointsFolder, (RelFileFilter)FileFilter.json())) {
            String fileName = rf.getLeafName();
            if (!StringUtils.endsWith((String)fileName, (String)".json")) {
                this.logger.error((Object)("Expected a file with .json extension, got '" + fileName + "'. Skipping."));
            }
            names.add(fileName.substring(0, fileName.length() - 5));
        }
        return names;
    }

    static {
        DKUtils.forceInit(StreamingEndpoint.class);
    }
}

