/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dashboards;

import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.cuspol.CustomFieldsService;
import com.dataiku.dip.cuspol.CustomPolicyHooksRegistry;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dashboards.DashboardsDAO;
import com.dataiku.dip.dashboards.DashboardsUtils;
import com.dataiku.dip.dashboards.export.DashboardsExportService;
import com.dataiku.dip.dashboards.insights.InsightsService;
import com.dataiku.dip.dashboards.insights.chart.ChartInsightTileParams;
import com.dataiku.dip.dashboards.insights.tiles.TextTileParams;
import com.dataiku.dip.dashboards.model.Dashboard;
import com.dataiku.dip.dashboards.model.DashboardPage;
import com.dataiku.dip.dashboards.model.Insight;
import com.dataiku.dip.dashboards.model.Tile;
import com.dataiku.dip.dashboards.model.TileParams;
import com.dataiku.dip.dashboards.model.ui.EnrichedDashboardPage;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.scheduler.scenarios.ScenarioRun;
import com.dataiku.dip.scheduler.scenarios.ScenarioRunContext;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.services.GeneralSettingsService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsDAO;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TaggableObjectDiffService;
import com.dataiku.dip.server.services.TaggableObjectsDeletionService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.licensing.LicenseEnforcementService;
import com.dataiku.dip.theming.service.DSSVisualizationThemeService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DashboardsService {
    @Autowired
    private DashboardsDAO dao;
    @Autowired
    private PubSubService pubSub;
    @Autowired
    private ITaggingService taggingService;
    @Autowired
    private CustomFieldsService customFieldsService;
    @Autowired
    private InsightsService insightsService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private CustomPolicyHooksRegistry customPolicyHooksRegistry;
    @Autowired
    private TaggableObjectsService taggableObjectsService;
    @Autowired
    private ProjectsDAO projectsDAO;
    @Autowired
    private GeneralSettingsService generalSettingsService;
    @Autowired
    private GeneralSettingsDAO generalSettingsDAO;
    @Autowired
    private DSSVisualizationThemeService themeService;
    @Autowired
    private VariablesService variablesService;
    @Autowired
    private LicenseEnforcementService licenseEnforcementService;
    @Autowired
    private ScenarioRunContext scenarioRunContext;
    static DKULogger logger = DKULogger.getLogger((String)"dku.dashboards.service");

    public Dashboard getMandatory(String projectKey, String id) throws IOException {
        return (Dashboard)this.dao.getMandatory(projectKey, id);
    }

    public Dashboard getMandatoryUnsafe(String projectKey, String id) throws IOException {
        return (Dashboard)this.dao.getMandatoryUnsafe(projectKey, id);
    }

    public Dashboard getOrNull(String projectKey, String id) throws IOException {
        return (Dashboard)this.dao.getOrNull(projectKey, id);
    }

    public Dashboard getOrNullUnsafe(String projectKey, String id) throws IOException {
        return (Dashboard)this.dao.getOrNullUnsafe(projectKey, id);
    }

    public boolean exists(String projectKey, String id) throws IOException {
        return this.dao.getOrNullUnsafe(projectKey, id) != null;
    }

    public List<Dashboard> list(String projectKey, AuthCtx user) throws IOException {
        List<Dashboard> dashboardList = this.dao.list(projectKey);
        dashboardList.forEach(dashboard -> this.expandVariablesForDashboard((Dashboard)dashboard, user));
        return dashboardList;
    }

    public List<Dashboard> listUnsafe(String projectKey) throws IOException {
        return this.dao.listUnsafe(projectKey);
    }

    public int approximateCount(String projectKey) throws IOException {
        return this.dao.approximateCount(projectKey);
    }

    public Dashboard save(Dashboard dashboard, boolean creation) throws IOException, CodedException {
        TaggableObjectChangedEvent.ActionType action;
        Preconditions.checkArgument((dashboard.projectKey != null ? 1 : 0) != 0, (Object)"No dashboard's project key");
        Preconditions.checkArgument((dashboard.id != null ? 1 : 0) != 0, (Object)"No dashboard ID");
        RWTransactionRef t = TransactionContext.retrieveWrite();
        Dashboard existing = this.getOrNullUnsafe(dashboard.projectKey, dashboard.id);
        this.taggableObjectsService.handleCreationVersionTagOnObjectUpdateNullAllowed(dashboard, existing);
        for (DashboardPage page : dashboard.pages) {
            if (page.id != null) continue;
            page.id = SecretKeyGenerator.generateSmall();
        }
        if (creation) {
            this.customFieldsService.enrichWithDefaultCustomFieldsForTaggableObject(dashboard);
        }
        this.customPolicyHooksRegistry.onPreObjectSave(t.getUser(), this.getOrNull(dashboard.projectKey, dashboard.id), dashboard);
        this.dao.save(dashboard);
        JsonObject details = new JsonObject();
        details.addProperty("objectDisplayName", dashboard.name);
        if (creation) {
            action = TaggableObjectChangedEvent.ActionType.DASHBOARD_CREATE;
        } else if (dashboard.name != null && existing != null && !dashboard.name.equals(existing.name)) {
            action = TaggableObjectChangedEvent.ActionType.DASHBOARD_RENAME;
            details.addProperty("newName", dashboard.name);
            details.addProperty("oldName", existing.name);
        } else if (existing != null && dashboard.listed != existing.listed) {
            action = dashboard.listed ? TaggableObjectChangedEvent.ActionType.DASHBOARD_LISTED : TaggableObjectChangedEvent.ActionType.DASHBOARD_UNLISTED;
        } else {
            action = TaggableObjectChangedEvent.ActionType.DASHBOARD_EDIT;
            TaggableObjectDiffService.addTagEditInfoIfNeeded(existing, dashboard, details);
        }
        this.taggingService.onObjectSaved(dashboard.projectKey, dashboard.tags);
        this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.DASHBOARD, dashboard.projectKey, dashboard.id, t.getUser(), action).withDetails(details));
        return dashboard;
    }

    public void delete(String projectKey, String id) throws IOException, CodedException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        JsonObject details = new JsonObject();
        try {
            Dashboard dash = (Dashboard)this.dao.getOrNull(projectKey, id);
            this.customPolicyHooksRegistry.onPreObjectDelete(t.getUser(), dash);
            if (dash != null) {
                details.addProperty("objectDisplayName", dash.name);
            }
        }
        catch (CodedException e) {
            throw e;
        }
        catch (Exception e) {
            logger.info((Object)("Failed to delete dashboard. " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
        this.dao.delete(projectKey, id);
        this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.DASHBOARD, projectKey, id, t.getUser(), TaggableObjectChangedEvent.ActionType.DASHBOARD_DELETE).withDetails(details));
    }

    public TaggableObjectsDeletionService.DeletionImpact computeDeletionImpact(Set<TaggableObjectsDeletionService.DeletionRequestItem> deletionRequests, Set<TaggableObjectsService.TaggableObjectRef> ignored, AuthCtx authCtx) throws DKUSecurityException, IOException {
        TaggableObjectsDeletionService.DeletionImpact impact = new TaggableObjectsDeletionService.DeletionImpact();
        HashSet<TaggableObjectsDeletionService.DeletionRequestItem> dashboardsDeletionRequests = new HashSet<TaggableObjectsDeletionService.DeletionRequestItem>();
        String projectKey = null;
        for (TaggableObjectsDeletionService.DeletionRequestItem dr : deletionRequests) {
            if (dr.type != ITaggingService.TaggableType.DASHBOARD) continue;
            TaggableObjectsDeletionService.AvailableDeletionOptions availableOptions = new TaggableObjectsDeletionService.AvailableDeletionOptions();
            availableOptions.deleteOrphanInsights = true;
            impact.availableOptions.put(dr.projectKey + "." + dr.id, availableOptions);
            projectKey = dr.projectKey;
            TaggableObjectsDeletionService.DeletionRequestItem dr2 = (TaggableObjectsDeletionService.DeletionRequestItem)JSON.deepCopy((Object)dr);
            dr2.options.deleteOrphanInsights = true;
            dashboardsDeletionRequests.add(dr2);
        }
        if (!dashboardsDeletionRequests.isEmpty()) {
            Set<Insight> insights = this.getInsightsToDeleteWithDashboards(authCtx, projectKey, dashboardsDeletionRequests, ignored);
            for (Insight insight : insights) {
                TaggableObjectsDeletionService.ImpactedInsight ii = new TaggableObjectsDeletionService.ImpactedInsight(insight);
                ii.optional = true;
                impact.deletedInsights.add(ii);
                logger.info((Object)("Add insight: " + ii.id));
            }
        }
        return impact;
    }

    public Set<Insight> getInsightsToDeleteWithDashboards(AuthCtx authCtx, String projectKey, Collection<TaggableObjectsDeletionService.DeletionRequestItem> requestedDeletions, Set<TaggableObjectsService.TaggableObjectRef> ignored) throws IOException, DKUSecurityException {
        SerializedProject project = this.projectsDAO.getMandatoryUnsafe(projectKey);
        boolean canModerateDashboards = this.permissionsService.hasProjectPrivilege(authCtx, projectKey, project.permissionsVersion == SerializedProject.PermissionsVersion.LEGACY ? Privileges.ProjectLevelPrivilegeType.MODERATE_DASHBOARDS : Privileges.ProjectLevelPrivilegeType.WRITE_DASHBOARDS);
        HashSet<Insight> impactDeletions = new HashSet<Insight>();
        HashMap<String, Insight> insightsToDeleteById = new HashMap<String, Insight>();
        if (!requestedDeletions.isEmpty()) {
            HashMap insightsHostedInDeletedDatasets = new HashMap();
            HashSet<String> toDeleteIfOrphan = new HashSet<String>();
            HashSet<String> deleteOrphanInsightsFromDashboards = new HashSet<String>();
            HashSet<String> dashboardIds = new HashSet<String>();
            for (TaggableObjectsDeletionService.DeletionRequestItem dr : requestedDeletions) {
                if (dr.type != ITaggingService.TaggableType.DASHBOARD) continue;
                dashboardIds.add(dr.id);
                Dashboard dashboard = this.getMandatoryUnsafe(dr.projectKey, dr.id);
                if (dr.options.deleteOrphanInsights) {
                    deleteOrphanInsightsFromDashboards.add(dr.id);
                }
                for (DashboardPage page : dashboard.pages) {
                    for (Tile tile : page.grid.tiles) {
                        if (!insightsHostedInDeletedDatasets.containsKey(tile.insightId)) {
                            insightsHostedInDeletedDatasets.put(tile.insightId, new ArrayList());
                        }
                        ((List)insightsHostedInDeletedDatasets.get(tile.insightId)).add(dr.id);
                        if (toDeleteIfOrphan.contains(tile.insightId) || !dr.options.deleteOrphanInsights) continue;
                        toDeleteIfOrphan.add(tile.insightId);
                    }
                }
            }
            for (Insight insight : this.insightsService.listUnsafe(projectKey)) {
                TaggableObjectsService.TaggableObjectRef ref = new TaggableObjectsService.TaggableObjectRef(insight);
                if (!canModerateDashboards && !insight.owner.equals(authCtx.getIdentifier())) continue;
                if (insightsHostedInDeletedDatasets.containsKey(insight.id) && toDeleteIfOrphan.contains(insight.id) && !ignored.contains(ref)) {
                    impactDeletions.add(insight);
                    insightsToDeleteById.put(insight.id, insight);
                }
                if (!deleteOrphanInsightsFromDashboards.contains(insight.dashboardCreationId) || ignored.contains(ref)) continue;
                impactDeletions.add(insight);
                insightsToDeleteById.put(insight.id, insight);
            }
            for (Dashboard dashboard : this.listUnsafe(projectKey)) {
                if (dashboardIds.contains(dashboard.id)) continue;
                for (DashboardPage page : dashboard.pages) {
                    for (Tile tile : page.grid.tiles) {
                        if (insightsToDeleteById.get(tile.insightId) == null) continue;
                        impactDeletions.remove(insightsToDeleteById.get(tile.insightId));
                    }
                }
            }
        }
        return impactDeletions;
    }

    public void makeListed(String projectKey, String id, boolean listed) throws IOException, CodedException {
        Preconditions.checkArgument((projectKey != null ? 1 : 0) != 0, (Object)"No project key");
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"No dashboard ID");
        Dashboard dashboard = this.getMandatory(projectKey, id);
        dashboard.listed = listed;
        this.save(dashboard, false);
    }

    public EnrichedDashboardPage getEnrichedPageForUser(String projectKey, String id, int pageIdx, String exportId, AuthCtx user) throws IOException, DKUSecurityException {
        Dashboard dashboard = this.getDashboardWithExpandedContent(projectKey, id, exportId, user);
        EnrichedDashboardPage page = EnrichedDashboardPage.fromPage(dashboard.pages.get(pageIdx));
        this.setDashboardPageInsightsData(projectKey, page, user);
        return page;
    }

    public List<Dashboard> getDashboardsUsingInsight(String projectKey, String insightId) throws IOException {
        Preconditions.checkArgument((projectKey != null ? 1 : 0) != 0, (Object)"Project key not specified");
        Preconditions.checkArgument((insightId != null ? 1 : 0) != 0, (Object)"Insight id not specified");
        ArrayList<Dashboard> ret = new ArrayList<Dashboard>();
        for (Dashboard dashboard : this.listUnsafe(projectKey)) {
            for (DashboardPage page : dashboard.pages) {
                for (Tile tile : page.grid.tiles) {
                    if (tile.tileType == Tile.TileType.INSIGHT) {
                        if (!insightId.equals(tile.insightId)) continue;
                        ret.add(dashboard);
                        continue;
                    }
                    if (tile.clickAction != Tile.TileClickAction.OPEN_OTHER_INSIGHT || !insightId.equals(tile.targetInsightId)) continue;
                    ret.add(dashboard);
                }
            }
        }
        return ret;
    }

    public Set<SerializedProject.ReaderAuthorization> getMissingReaderAuthorizations(Dashboard dashboard) throws IOException {
        HashMap<Integer, SerializedProject.ReaderAuthorization> missingReaderAuthorizationsMap = new HashMap<Integer, SerializedProject.ReaderAuthorization>();
        HashSet<String> visitedInsightIds = new HashSet<String>();
        for (DashboardPage page : dashboard.pages) {
            for (Tile tile : page.grid.tiles) {
                if (tile.tileType != Tile.TileType.INSIGHT || visitedInsightIds.contains(tile.insightId)) continue;
                visitedInsightIds.add(tile.insightId);
                Insight insight = this.insightsService.getOrNullUnsafe(dashboard.projectKey, tile.insightId);
                if (insight == null) continue;
                for (SerializedProject.ReaderAuthorization mra : this.insightsService.getMissingReaderAuthorizations(insight)) {
                    Integer key = mra.objectRef.hashCode();
                    SerializedProject.ReaderAuthorization mergeMra = (SerializedProject.ReaderAuthorization)missingReaderAuthorizationsMap.get(key);
                    if (missingReaderAuthorizationsMap.get(key) != null) {
                        mergeMra.modes.addAll(mra.modes);
                        continue;
                    }
                    missingReaderAuthorizationsMap.put(key, mra);
                }
            }
        }
        return new HashSet<SerializedProject.ReaderAuthorization>(missingReaderAuthorizationsMap.values());
    }

    public boolean hasMissingReaderAuthorizations(Dashboard dashboard) throws IOException {
        HashSet<String> visitedInsightIds = new HashSet<String>();
        for (DashboardPage page : dashboard.pages) {
            for (Tile tile : page.grid.tiles) {
                if (tile.tileType != Tile.TileType.INSIGHT || visitedInsightIds.contains(tile.insightId)) continue;
                visitedInsightIds.add(tile.insightId);
                Insight insight = this.insightsService.getOrNullUnsafe(dashboard.projectKey, tile.insightId);
                if (insight == null || this.insightsService.getInsightAccessState(insight) != EnrichedDashboardPage.InsightAccessState.ANALYST) continue;
                return true;
            }
        }
        return false;
    }

    public Dashboard copy(String projectKey, String dashboardId, @Nullable String name, boolean deepCopy) throws IOException, CodedException {
        Dashboard dashboard = this.getMandatory(projectKey, dashboardId);
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"No dashboard name for copy");
        JsonObject details = new JsonObject();
        details.addProperty("objectDisplayName", name);
        TaggableObjectChangedEvent.ActionType action = TaggableObjectChangedEvent.ActionType.DASHBOARD_CREATE;
        details.addProperty("copy", Boolean.valueOf(true));
        details.addProperty("originalObjectName", dashboard.name);
        details.addProperty("originalObjectId", dashboard.id);
        AuthCtx user = TransactionContext.retrieveWrite().getUser();
        dashboard.id = SecretKeyGenerator.generateSmall();
        dashboard.creationTag = null;
        dashboard.listed = false;
        if (StringUtils.isNotBlank((String)name)) {
            dashboard.name = name;
        }
        dashboard.creationTag = dashboard.versionTag = VersionTag.increment(null, user.getIdentifier());
        dashboard.owner = user.getIdentifier();
        if (deepCopy) {
            for (DashboardPage page : dashboard.pages) {
                for (Tile tile : page.grid.tiles) {
                    if (tile.tileType != Tile.TileType.INSIGHT || tile.insightId == null) continue;
                    try {
                        tile.insightId = this.insightsService.copy((String)dashboard.projectKey, (String)tile.insightId, null, (String)dashboard.id, (String)user.getIdentifier()).id;
                    }
                    catch (NotFoundException e) {
                        logger.error((Object)("Insight not found during dashboard deep-copy: " + tile.insightId + ". " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
                    }
                }
            }
        }
        this.customPolicyHooksRegistry.onPreObjectSave(user, null, dashboard);
        this.dao.save(dashboard);
        this.taggingService.onObjectSaved(dashboard.projectKey, dashboard.tags);
        this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.DASHBOARD, dashboard.projectKey, dashboard.id, user, action).withDetails(details));
        return dashboard;
    }

    public String copyPage(String projectKey, DashboardPage page, String targetedDashboardId, String copyPageName, boolean pointerMode, String userIdentifier) throws IOException, CodedException {
        Dashboard targetedDashboard = this.getMandatory(projectKey, targetedDashboardId);
        DashboardPage copyPage = new DashboardPage();
        copyPage.grid = page.grid;
        if (!pointerMode) {
            for (Tile tile : copyPage.grid.tiles) {
                if (tile.tileType != Tile.TileType.INSIGHT) continue;
                Insight copyInsight = this.insightsService.copy(projectKey, tile.insightId, null, targetedDashboardId, userIdentifier);
                tile.insightId = copyInsight.id;
            }
        }
        copyPage.title = copyPageName;
        targetedDashboard.pages.add(copyPage);
        this.save(targetedDashboard, false);
        return copyPage.id;
    }

    public void addToDashboard(DashboardsUtils.PinningOrder pinningOrder, Tile tile, String projectKey) throws IOException, CodedException {
        Dashboard dashboard = this.getMandatory(projectKey, pinningOrder.dashboardId);
        for (DashboardPage page : dashboard.pages) {
            if (!page.id.equals(pinningOrder.pageId)) continue;
            if ("chart".equals(tile.insightType)) {
                ((ChartInsightTileParams)tile.tileParams).useInsightTheme = Objects.requireNonNullElse(pinningOrder.useInsightTheme, false);
            }
            page.grid.tiles.add(tile);
            break;
        }
        this.save(dashboard, false);
    }

    public void addToDashboard(Insight insight, DashboardsUtils.PinningOrder pinningOrder, Tile tile, boolean pointerMode, AuthCtx user) throws IOException, UnauthorizedException, CodedException {
        if (pointerMode) {
            this.addToDashboard(pinningOrder, tile, insight.projectKey);
        } else {
            ArrayList<String> insightIds = new ArrayList<String>();
            String payload = this.insightsService.getPayload(insight);
            insight.dashboardCreationId = pinningOrder.dashboardId;
            insight.id = null;
            this.insightsService.setIdAndOwnerOnNewInsight(insight, user);
            this.insightsService.save(insight, true, payload);
            tile.insightId = insight.id;
            this.addToDashboard(pinningOrder, tile, insight.projectKey);
            insightIds.add(insight.id);
        }
    }

    public void createDefaultDashboardForProject(SerializedProject project) throws IOException, CodedException {
        Dashboard dashboard = new Dashboard();
        String selectedDSSVisualizationThemeId = this.generalSettingsDAO.getUnsafe().selectedDSSVisualizationThemeId;
        try {
            dashboard.theme = this.themeService.get(StringUtils.isBlank((String)selectedDSSVisualizationThemeId) ? "__dku_dss_default_theme__" : selectedDSSVisualizationThemeId);
        }
        catch (Exception e) {
            logger.error((Object)"Error occurred during retrival of theme for default dashboard, will not use theming", (Throwable)e);
        }
        dashboard.id = this.dao.generateUniqueId(project.projectKey);
        dashboard.owner = project.creationTag.getLastAuthor();
        dashboard.projectKey = project.projectKey;
        dashboard.name = String.format("%s's default dashboard", project.name);
        dashboard.listed = true;
        this.save(dashboard, true);
    }

    public String generateUniqueId(String projectKey) throws IOException {
        return this.dao.generateUniqueId(projectKey);
    }

    public List<Dashboard> listDashboards(AuthCtx user, String projectKey) throws IOException, DKUSecurityException {
        List<Dashboard> allDashboards = this.list(projectKey, user);
        ArrayList<Dashboard> dashboards = new ArrayList<Dashboard>(allDashboards.size());
        SerializedProject project = this.projectsDAO.getMandatoryUnsafe(projectKey);
        for (Dashboard dashboard : allDashboards) {
            if (!this.isDashboardReturned(dashboard, user, project.permissionsVersion)) continue;
            dashboards.add(dashboard);
        }
        return dashboards;
    }

    public boolean isDashboardReturned(Dashboard dashboard, AuthCtx user, SerializedProject.PermissionsVersion permissionsVersion) throws DKUSecurityException {
        if (dashboard.listed || dashboard.owner.equals(user.getIdentifier())) {
            return true;
        }
        return this.permissionsService.hasProjectPrivilege(user, dashboard.projectKey, permissionsVersion == SerializedProject.PermissionsVersion.LEGACY ? Privileges.ProjectLevelPrivilegeType.MODERATE_DASHBOARDS : Privileges.ProjectLevelPrivilegeType.WRITE_DASHBOARDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dashboard getDashboardWithExpandedContent(String projectKey, String id, String exportId, AuthCtx user) throws IOException {
        Dashboard dashboard = (Dashboard)this.dao.getMandatory(projectKey, id);
        if (StringUtils.isNotBlank((String)exportId)) {
            File scenarioRunFile = new File(DashboardsExportService.retrieveTmpExportDirectory(projectKey, exportId), "scenario-run.json");
            if (scenarioRunFile.exists()) {
                DashboardsExportService.ScenarioContext scenarioContext = (DashboardsExportService.ScenarioContext)JSON.parseFile((File)scenarioRunFile, DashboardsExportService.ScenarioContext.class);
                ScenarioRun scenarioRun = new ScenarioRun();
                scenarioRun.withTrigger(scenarioContext.trigger);
                scenarioRun.variables = scenarioContext.variables;
                this.scenarioRunContext.setScenarioRun(scenarioRun);
                try {
                    this.expandVariablesForDashboard(dashboard, user);
                }
                finally {
                    this.scenarioRunContext.clearScenarioRun();
                }
            }
        } else {
            this.expandVariablesForDashboard(dashboard, user);
        }
        return dashboard;
    }

    public Dashboard getDashboardWithExpandedContent(String projectKey, String id, AuthCtx user) throws IOException {
        return this.getDashboardWithExpandedContent(projectKey, id, null, user);
    }

    private void setDashboardPageInsightsData(String projectKey, EnrichedDashboardPage page, AuthCtx user) throws IOException, DKUSecurityException {
        ArrayList<String> insightIds = new ArrayList<String>();
        if (page == null || page.grid == null || page.grid.tiles == null) {
            return;
        }
        for (Tile tile : page.grid.tiles) {
            if (tile == null) continue;
            if (tile.tileType == Tile.TileType.GROUP) {
                insightIds.addAll(this.getChildTilesInsightIds(tile));
                continue;
            }
            if (tile.tileType != Tile.TileType.INSIGHT || tile.insightId == null) continue;
            insightIds.add(tile.insightId);
        }
        for (String insightId : insightIds) {
            Insight insight = this.insightsService.getOrNullUnsafe(projectKey, insightId);
            EnrichedDashboardPage.InsightAccessState accessState = this.insightsService.getInsightAccessState(insight);
            page.insightAccessData.put(insightId, accessState);
            if (accessState != EnrichedDashboardPage.InsightAccessState.READER && (accessState != EnrichedDashboardPage.InsightAccessState.ANALYST || !this.permissionsService.hasProjectPrivilege(user, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF))) continue;
            page.insightsData.put(insight.id, insight);
        }
    }

    private List<String> getChildTilesInsightIds(Tile tile) {
        ArrayList<String> insightIds = new ArrayList<String>();
        if (tile.grid == null || tile.grid.tiles == null) {
            return insightIds;
        }
        for (Tile nestedTile : tile.grid.tiles) {
            if (nestedTile == null || nestedTile.tileType != Tile.TileType.INSIGHT || nestedTile.insightId == null) continue;
            insightIds.add(nestedTile.insightId);
        }
        return insightIds;
    }

    private void expandVariablesForDashboard(Dashboard dashboard, AuthCtx user) {
        VariablesContext vc = this.variablesService.getForProject(dashboard.projectKey);
        try {
            boolean canWriteDashboard = this.permissionsService.hasProjectPrivilege(user, dashboard.projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_DASHBOARDS) && this.licenseEnforcementService.getUserProfileByNameOrFallback((String)user.getUserProfile()).mayWriteDashboards;
            dashboard.pages.forEach(page -> {
                page.displayedTitle = this.getDisplayedText(page.title, vc);
                if (!canWriteDashboard) {
                    page.title = page.displayedTitle;
                }
                page.grid.tiles.forEach(tile -> {
                    TileParams patt31837$temp;
                    tile.titleOptions.displayedTitle = this.getDisplayedText(tile.titleOptions.title, vc);
                    if (!canWriteDashboard) {
                        tile.titleOptions.title = tile.titleOptions.displayedTitle;
                    }
                    if ((patt31837$temp = tile.tileParams) instanceof TextTileParams) {
                        TextTileParams textTileParams = (TextTileParams)patt31837$temp;
                        textTileParams.displayedText = this.getDisplayedText(textTileParams.text, vc);
                        if (!canWriteDashboard) {
                            textTileParams.text = textTileParams.displayedText;
                        }
                    }
                });
            });
        }
        catch (DKUSecurityException e) {
            logger.error((Object)"Permission denied to expand variables in dashboard. ", (Throwable)e);
        }
    }

    private String getDisplayedText(String expr, VariablesContext vc) {
        if (expr == null || !expr.contains("${")) {
            return expr;
        }
        return vc.expandAllowUnresolved(expr, true);
    }
}

