/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dashboards.insights;

import com.dataiku.dip.SmartObjectRef;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dashboards.insights.InsightsDAO;
import com.dataiku.dip.dashboards.model.Insight;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.ITaggingService;
import java.io.IOException;
import java.util.List;

public abstract class InsightHandler {
    public abstract void checkSavePermissions(AuthCtx var1, Insight var2) throws UnauthorizedException;

    public abstract List<RequiredPermission> getRequiredPermissions();

    public abstract void savePayload(String var1, InsightsDAO var2) throws IOException;

    public abstract String getPayload() throws IOException;

    public void beforeDelete() throws IOException {
    }

    public static class RequiredPermission {
        public SmartObjectRef objectRef;
        public SerializedProject.ReaderAuthorization.Mode mode;

        public RequiredPermission(SmartObjectRef objectRef, SerializedProject.ReaderAuthorization.Mode mode) {
            this.objectRef = objectRef;
            this.mode = mode;
        }

        public static RequiredPermission read(ITaggingService.TaggableType objectType, String objectSmartName) {
            return new RequiredPermission(SmartObjectRef.fromSmartName(objectType, objectSmartName), SerializedProject.ReaderAuthorization.Mode.READ);
        }

        public static RequiredPermission run(ITaggingService.TaggableType objectType, String objectSmartName) {
            return new RequiredPermission(SmartObjectRef.fromSmartName(objectType, objectSmartName), SerializedProject.ReaderAuthorization.Mode.RUN);
        }
    }
}

