/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.lsfolder;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.RunnableSubgraph;
import com.dataiku.dip.dataflow.exec.lsfolder.ListFolderContentsRecipeExecutor;
import com.dataiku.dip.dataflow.exec.lsfolder.ListFolderContentsRecipeParams;
import com.dataiku.dip.dataflow.exec.lsfolder.MetadataExtractor;
import com.dataiku.dip.dataflow.exec.stream.ToDatasetStreamer;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowManagedFolder;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderHandler;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.common.collect.Lists;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class ListFolderContentsRecipeStreamExecutor
implements ListFolderContentsRecipeExecutor {
    @Autowired
    private DatasetsDAO datasetsDAO;
    private final JobActivity activity;
    private final ListFolderContentsRecipeParams params;
    private final StreamColumnFactory cf = new StreamColumnFactory();
    private final StreamRowFactory rf = new StreamRowFactory();
    private final AuthCtx authCtx;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.flow.recipe.executor.stream.list_folder_contents");

    public ListFolderContentsRecipeStreamExecutor(AuthCtx authCtx, JobActivity activity, ListFolderContentsRecipeParams params) {
        SpringUtils.getInstance().autowire((Object)this);
        this.authCtx = authCtx;
        this.activity = activity;
        this.params = params;
    }

    @Override
    public void run() throws Exception {
        RunnableSubgraph subgraph = this.activity.getSubgraph();
        FlowRecipe recipe = ((RecipeRunnableSubgraph)subgraph).getRecipe();
        MetadataExtractor defaultMetadataExtractor = new MetadataExtractor(this.params);
        FlowDataset outputFD = subgraph.getTargetsDatasets().get(0);
        Dataset outputDS = outputFD.getMandatory(this.datasetsDAO);
        Partition targetPartition = subgraph.getTargetPartition(outputFD);
        SerializedRecipe.RecipeOutput recipeOutput = recipe.getModel().getSingleOutput("main");
        Output.WriteMode writeMode = recipeOutput.getWriteMode();
        try (DatasetHandler outputDatasetHandler = DatasetHandlerFactory.build(this.authCtx, outputDS);){
            if (writeMode == Output.WriteMode.OVERWRITE && !outputDatasetHandler.outputHandlesClear()) {
                if (outputDatasetHandler.getMeta().isFSLike()) {
                    outputDatasetHandler.clearPartitions(Lists.newArrayList((Object[])new Partition[]{targetPartition}));
                }
                writeMode = Output.WriteMode.APPEND;
            }
        }
        WarningsContext warnContext = this.activity.warnContext;
        ToDatasetStreamer streamer = ToDatasetStreamer.newWithAutoBucketing(this.authCtx, outputDS, targetPartition, (ColumnFactory)this.cf, warnContext, writeMode);
        ProcessorOutput out = streamer.getAsOutput();
        FlowComputable input = recipe.getSources().get(0);
        if (input.getType() != FlowComputable.FCType.MANAGED_FOLDER) {
            throw new IllegalStateException("List Folder Contents recipe only accepts folder as input");
        }
        ManagedFolder mf = ((FlowManagedFolder)input).getManagedFolder();
        try (ManagedFolderHandler inputHandler = (ManagedFolderHandler)mf.buildHandler(this.authCtx);){
            List<Partition> sources = subgraph.getSourcePartitions(input);
            for (Partition source : sources) {
                ManagedFolderHandler.ManagedFolderListing sourceFiles = inputHandler.listFS(source, true, false);
                logger.info((Object)("Copying partition " + source.toString()));
                for (ManagedFolderHandler.ManagedFolderListingItem item : sourceFiles.items) {
                    Row row = defaultMetadataExtractor.buildRow(this.rf, this.cf, item);
                    out.emitRow(row);
                }
            }
            out.lastRowEmitted();
        }
    }

    @Override
    public void notifyBeforeAborting() {
    }
}

