/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.sampling;

import com.dataiku.dip.containers.exec.ContainerExecSelection;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.sampling.SamplingRecipeCreator;
import com.dataiku.dip.dataflow.exec.sampling.SamplingRecipeRunner;
import com.dataiku.dip.dataflow.exec.sampling.SamplingRecipeSchemaComputer;
import com.dataiku.dip.dataflow.exec.sampling.SamplingRecipeStatusComputer;
import com.dataiku.dip.dataflow.pipeline.RecipePipelineHelper;
import com.dataiku.dip.dataflow.pipeline.SamplingRecipePipelineHelper;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.datasets.StreamableDatasetSelection;
import com.dataiku.dip.i18n.TranslationService;
import com.dataiku.dip.recipes.AbstractSparkRecipeParams;
import com.dataiku.dip.recipes.BasicRecipeLineageHandler;
import com.dataiku.dip.recipes.ParamsWithContainerizable;
import com.dataiku.dip.recipes.RecipeDesc;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.RecipeParams;
import com.dataiku.dip.recipes.RecipeRunner;
import com.dataiku.dip.recipes.RecipeSchemaComputer;
import com.dataiku.dip.recipes.code.hive.HiveRecipeMeta;
import com.dataiku.dip.recipes.common.RecipeCreator;
import com.dataiku.dip.recipes.common.RecipeStatusComputer;
import com.dataiku.dip.recipes.visualsql.VisualSQLRecipeEngineParams;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.DataLineageService;
import com.dataiku.dip.spark.InputDatasetsReadParams;
import com.dataiku.dip.spark.SparkOverrideConfig;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.j2ts.annotations.UIModel;

public class SamplingRecipeMeta
extends RecipeMeta
implements BasicRecipeLineageHandler {
    public static final SamplingRecipeMeta META = new SamplingRecipeMeta();
    private static final DKULogger logger = DKULogger.getLogger((String)"dip.recipe.sampling");

    @Override
    public Class<? extends RecipeParams> paramsClass() {
        return SamplingRecipeParams.class;
    }

    @Override
    public String getType() {
        return "sampling";
    }

    @Override
    public RecipeMeta.OutputSchemaComputability getOutputSchemasComputability() {
        return RecipeMeta.OutputSchemaComputability.RELIABLE_STATIC;
    }

    @Override
    public RecipeSchemaComputer buildSchemaComputer(AuthCtx authCtx, JobActivity activity) {
        return new SamplingRecipeSchemaComputer(authCtx, activity);
    }

    @Override
    public RecipeCreator buildCreator(AuthCtx authCtx) {
        return new SamplingRecipeCreator(authCtx, this);
    }

    @Override
    public RecipeRunner buildRunner(JobActivity activity) {
        return new SamplingRecipeRunner(activity);
    }

    @Override
    public RecipeStatusComputer buildStatusComputer(SerializedRecipe recipe, String payload) {
        return new SamplingRecipeStatusComputer(recipe, payload);
    }

    @Override
    public RecipeDesc getRecipeDesc() {
        return this.getRecipeDesc("en");
    }

    @Override
    public RecipeDesc getRecipeDesc(String lang) {
        TranslationService ts = (TranslationService)SpringUtils.getBean(TranslationService.class);
        return RecipeDesc.newSisoDesc(ts.translateNoContext(lang, "RECIPE.SAMPLING.NAME", "sample / filter", new Object[0]), null).multiEngine(true);
    }

    @Override
    public RecipeMeta.RecipeCategoryFlags getCategoryFlags() {
        return new RecipeMeta.RecipeCategoryFlags().withVisualRecipe();
    }

    @Override
    public boolean hasJsonPayload() {
        return true;
    }

    @Override
    public SparkOverrideConfig getSparkConf(SerializedRecipe sr, String payload) {
        SamplingRecipeParams params = sr.getParamsAs(SamplingRecipeParams.class);
        return params.engineParams.sparkSQL.sparkConfig;
    }

    @Override
    public String setSparkConf(SerializedRecipe sr, String payload, SparkOverrideConfig config) {
        SamplingRecipeParams params = sr.getParamsAs(SamplingRecipeParams.class);
        params.engineParams.sparkSQL.sparkConfig = config;
        return payload;
    }

    @Override
    public String setEngine(SerializedRecipe sr, String payload, String engine) {
        SamplingRecipeParams params = sr.getParamsAs(SamplingRecipeParams.class);
        params.engineType = engine;
        return payload;
    }

    @Override
    public String setImpalaMode(SerializedRecipe sr, String payload, boolean runInStreamMode) {
        SamplingRecipeParams params = sr.getParamsAs(SamplingRecipeParams.class);
        params.engineParams.impala.forceStreamMode = runInStreamMode;
        return payload;
    }

    @Override
    public HiveRecipeMeta.HiveExecutionEngine getHiveEngine(SerializedRecipe sr, String payload) {
        SamplingRecipeParams params = sr.getParamsAs(SamplingRecipeParams.class);
        return params.engineParams.hive.executionEngine;
    }

    @Override
    public String setHiveEngine(SerializedRecipe sr, String payload, HiveRecipeMeta.HiveExecutionEngine executionEngine) {
        SamplingRecipeParams params = sr.getParamsAs(SamplingRecipeParams.class);
        params.engineParams.hive.executionEngine = executionEngine;
        return payload;
    }

    @Override
    public String setSparkEngine(SerializedRecipe sr, String payload, AbstractSparkRecipeParams.SparkExecutionEngine executionEngine) {
        SamplingRecipeParams params = sr.getParamsAs(SamplingRecipeParams.class);
        params.engineParams.sparkSQL.executionEngine = executionEngine;
        return payload;
    }

    @Override
    public InputDatasetsReadParams getInputDatasetsReadParams(SerializedRecipe sr, String payload) {
        return sr.getParamsAs(SamplingRecipeParams.class).engineParams.sparkSQL.readParams;
    }

    @Override
    public String setInputDatasetsReadParams(SerializedRecipe sr, String payload, InputDatasetsReadParams inputDatasetsReadParams) {
        SamplingRecipeParams params = sr.getParamsAs(SamplingRecipeParams.class);
        params.engineParams.sparkSQL.readParams = inputDatasetsReadParams;
        return payload;
    }

    @Override
    public RecipePipelineHelper buildPipelineHelper(SerializedRecipe recipe, String payload, RecipePipelineHelper.PipelineType pipelineType, AuthCtx authCtx, JobActivity jobActivity) {
        return new SamplingRecipePipelineHelper(authCtx, recipe, payload, pipelineType, jobActivity);
    }

    @Override
    public RecipeLineage getRecipeLineage(DataLineageService.SerializedGraphNodes predecessors, DataLineageService.SerializedGraphNodes successors, String payload, AuthCtx authCtx, JobActivity activity, SerializedRecipe serializedRecipe) {
        SamplingRecipeParams params = (SamplingRecipeParams)JSON.parse((String)payload, SamplingRecipeParams.class);
        return this.getBasicValidRecipeLineage(params, predecessors.datasets, successors.datasets);
    }

    @UIModel
    public static class SamplingRecipeParams
    extends RecipeParams
    implements ParamsWithContainerizable,
    BasicRecipeLineageHandler.Params {
        public StreamableDatasetSelection selection = StreamableDatasetSelection.full();
        public String engineType;
        public SamplingRecipeEngineParams engineParams = new SamplingRecipeEngineParams();

        @Override
        public ContainerExecSelection getContainerSelection() {
            return this.engineParams.containerSelection;
        }

        @Override
        public void setContainerSelection(ContainerExecSelection selection) {
            this.engineParams.containerSelection = selection;
        }
    }

    public static class SamplingRecipeEngineParams
    extends VisualSQLRecipeEngineParams {
        public int dssEngineMaxThreads = 4;
    }
}

