/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.sampling;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.RecipeEnginesPreferenceConfig;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.filter.FilterDesc;
import com.dataiku.dip.dataflow.exec.sampling.SamplingRecipeMeta;
import com.dataiku.dip.datasets.DatasetSparkInspector;
import com.dataiku.dip.datasets.SamplingParam;
import com.dataiku.dip.datasets.SchemaUtils;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.queries.ExecutionPlanService;
import com.dataiku.dip.recipes.FakeJobActivityFromRecipeBuilder;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.recipes.common.BigQueryRecipeEngineHelper;
import com.dataiku.dip.recipes.common.RecipeConfigUtils;
import com.dataiku.dip.recipes.common.RecipeEngineStatus;
import com.dataiku.dip.recipes.common.RecipeStatus;
import com.dataiku.dip.recipes.common.VisualSQLRecipeStatusComputer;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.recipes.visualsql.VisualSQLRecipeEngineParams;
import com.dataiku.dip.recipes.visualsql.VisualSQLRecipeStatus;
import com.dataiku.dip.recipes.visualsql.VisualSQLRecipesBaseService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.recipes.SamplingRecipeService;
import com.dataiku.dip.server.recipes.ServiceUtils;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SparkSQLDialect;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class SamplingRecipeStatusComputer
extends VisualSQLRecipeStatusComputer {
    @Autowired
    private SamplingRecipeService service;
    @Autowired
    private VisualSQLRecipesBaseService visualSQLRecipesBaseService;
    private static Logger logger = Logger.getLogger((String)"dku.sampling.status");

    public SamplingRecipeStatusComputer(SerializedRecipe recipe, String payload) {
        super(recipe, payload);
        SpringUtils.getInstance().autowire((Object)this);
    }

    @Override
    public SamplingRecipeStatus getFullStatus_NT(AuthCtx authCtx, String requestData) {
        SamplingRecipeStatus status;
        StatusInitializer init = new StatusInitializer();
        try (Transaction t = this.transactionService.beginRead();){
            status = this.fastStatusIgnorePartitions(init, false, authCtx);
        }
        if (status.isInvalid()) {
            return status;
        }
        RecipeEngineStatus engine = status.selectedEngine;
        this.visualRecipesService.checkFilterAnyEngine(init.filter, init.inputDS, status.filter, engine.type, init.dialect);
        if (init.filter != null && init.filter.enabled || init.params.selection != null && init.params.selection.samplingMethod != SamplingParam.SamplingMethod.FULL) {
            VisualSQLRecipeStatus.VisualSQLRecipeStatusRequest request = new VisualSQLRecipeStatus.VisualSQLRecipeStatusRequest();
            request.reallyNeedsExecutionPlan = false;
            if (engine instanceof VisualSQLRecipesBaseService.SQLBasedEngineStatus && this.needToComputeExecutionPlan((VisualSQLRecipesBaseService.SQLBasedEngineStatus)engine, status, request)) {
                try {
                    status.executionPlan = this.getExecutionPlan(authCtx, init.inputDS, (VisualSQLRecipesBaseService.SQLBasedEngineStatus)engine, status.sql, (VisualSQLRecipeEngineParams)init.params.engineParams);
                }
                catch (ExecutionPlanService.HiveTableNotFound e) {
                    logger.error((Object)"Failed to compute execution plan", (Throwable)e);
                    status.output.withFatalV(RecipeCodes.ERR_RECIPE_EXECUTION_PLAN_COMPUTATION_FAILED, "Table not found in Hive global metastore: %s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to compute execution plan", (Throwable)e);
                    logger.info((Object)("Query: \n" + status.sql));
                    status.output.withFatalV(RecipeCodes.ERR_RECIPE_EXECUTION_PLAN_COMPUTATION_FAILED, "%s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
                }
            }
        }
        if (init.error != null && !status.isInvalid()) {
            status.output.withFatal(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, init.error);
        }
        return status;
    }

    @Override
    public SamplingRecipeStatus fastStatusIgnorePartitions(AuthCtx authCtx) throws Exception {
        return this.fastStatusIgnorePartitions(new StatusInitializer(), true, authCtx);
    }

    private SamplingRecipeStatus fastStatusIgnorePartitions(StatusInitializer init, boolean reportUnknownErrorsToStatus, AuthCtx authCtx) {
        SamplingRecipeStatus status;
        block7: {
            status = new SamplingRecipeStatus();
            try {
                this.performBasicStructureChecks(status, authCtx);
                init.activity = new FakeJobActivityFromRecipeBuilder().buildFakeJobActivity(this.recipe);
                init.params = RecipeRegistry.getParamsAs(init.activity, SamplingRecipeMeta.SamplingRecipeParams.class);
                init.inputDS = init.activity.getSubgraph().getSourceDatasets().get(0).getMandatory(this.datasetsDAO);
                init.outputDS = init.activity.getSubgraph().getTargetsDatasets().get(0).getMandatory(this.datasetsDAO);
                status.output = new RecipeStatus.StepStatus();
                status.filter = new RecipeStatus.StepStatus();
                SamplingRecipeMeta.SamplingRecipeParams params = (SamplingRecipeMeta.SamplingRecipeParams)this.recipe.params;
                status.engineParams = params.engineParams;
                status.engines = this.getEnginesStatus(authCtx, init);
                status.selectedEngine = this.selectEngine(authCtx, init.activity, params.engineType, status.engines);
                this.visualRecipesService.adjustEngineStatus(authCtx, init.activity, status, "Filter in-database then streaming of results");
                init.dialect = this.visualRecipesService.getDialect(authCtx, init.activity, status.getSelectedSQLBasedEngine());
                if (StringUtils.isNotBlank((String)this.payload)) {
                    init.filter = this.service.loadParams(this.payload, this.recipe);
                }
                status.engines = this.getEnginesStatus(authCtx, init);
                this.performBasicCDEChecks(status, authCtx);
                status.selectedEngine = this.selectEngine(authCtx, init.activity, params.engineType, status.engines);
                this.visualRecipesService.adjustEngineStatus(authCtx, init.activity, status, "Filter in-database then streaming of results");
                status.outputSchema = init.inputDS.getSchema();
                if (status.getSelectedSQLBasedEngine().lowercasesColumnNames) {
                    status.outputSchema = SchemaUtils.lowerCase(status.outputSchema);
                }
                this.recipesValidationService.checkComplianceWithRecipeDesc(authCtx, this.recipe);
                this.recipesValidationService.checkTargetsAreWritable(init.activity);
            }
            catch (Exception e) {
                logger.error((Object)"Failed to compute recipe status", (Throwable)e);
                status.output.withFatal(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, ExceptionUtils.getMessageWithCauses((Throwable)e));
            }
            try {
                init.dialect = this.visualRecipesService.getDialect(authCtx, init.activity, status.getSelectedSQLBasedEngine());
                if (init.dialect != null) {
                    status.sql = this.service.generateSQLIgnorePartitions(init.dialect, init.params.selection, init.filter, init.inputDS, init.params.engineParams);
                }
            }
            catch (Exception e) {
                logger.info((Object)"Failed to generate SQL", (Throwable)e);
                init.error = e.getMessage();
                if (!reportUnknownErrorsToStatus) break block7;
                status.output.withFatal(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, ExceptionUtils.getMessageWithCauses((Throwable)e));
            }
        }
        return status;
    }

    public List<RecipeEngineStatus> getEnginesStatus(AuthCtx authCtx, StatusInitializer init) throws Exception {
        ArrayList<RecipeEngineStatus> ret = new ArrayList<RecipeEngineStatus>();
        JobActivity activity = init.activity;
        SamplingRecipeMeta.SamplingRecipeParams params = init.params;
        Dataset inputDataset = init.inputDS;
        Dataset outputDataset = init.outputDS;
        FilterDesc filter = init.filter;
        VisualSQLRecipesBaseService.AppConfig appConfig = this.visualRecipesService.getAppConfig(authCtx, this.recipe.projectKey);
        VisualSQLRecipesBaseService.SQLBasedEngineStatus stream = this.visualRecipesService.makeDSSBasedEngineStatus();
        VisualSQLRecipesBaseService.SQLBasedEngineStatus hive = this.visualRecipesService.makeHiveEngineStatus(authCtx, activity, appConfig);
        VisualSQLRecipesBaseService.SQLBasedEngineStatus impala = this.visualRecipesService.makeImpalaEngineStatus(authCtx, activity, appConfig);
        VisualSQLRecipesBaseService.SQLBasedEngineStatus spark = this.visualRecipesService.makeSparkSQLEngineStatus(authCtx, this.recipe.projectKey);
        VisualSQLRecipesBaseService.SQLBasedEngineStatus sql = this.visualRecipesService.makeSQLEngineStatus(authCtx, activity);
        BigQueryRecipeEngineHelper.disableEngineForBigQuery(hive, outputDataset);
        BigQueryRecipeEngineHelper.disableEngineForBigQuery(impala, outputDataset);
        SQLDialect sqlDialect = this.visualRecipesService.getDialect(authCtx, init.activity, sql);
        if (params.selection.samplingMethod != SamplingParam.SamplingMethod.FULL && params.selection.samplingMethod != SamplingParam.SamplingMethod.HEAD_SEQUENTIAL) {
            RecipeEngineStatus.setErrorStatus("Can't be used with this sampling mode", hive, impala, spark);
            if (!this.service.canSampleInDatabase(params.selection, sqlDialect)) {
                RecipeEngineStatus.setErrorStatus("Can't be used with this sampling mode and/or sampling params", sql);
            }
        }
        if (this.recipe.getSingleOutput((String)"main").appendMode) {
            RecipeEngineStatus.setErrorStatus("Not compatible with append mode", hive, impala, spark, sql);
        }
        boolean sparkTestOnly = false;
        if (sqlDialect == null && spark.isSelectable) {
            sqlDialect = new SparkSQLDialect();
            sparkTestOnly = true;
        }
        if (sqlDialect != null && filter != null && filter.enabled) {
            try {
                this.service.generateSQLIgnorePartitions(sqlDialect, params.selection, filter, inputDataset, init.params.engineParams);
            }
            catch (Exception e) {
                logger.error((Object)"Failed to generate SQL query", (Throwable)e);
                if (sparkTestOnly) {
                    RecipeEngineStatus.setErrorStatus("The filter cannot be translated to Spark SQL", spark);
                }
                RecipeEngineStatus.setErrorStatus("The filter cannot be translated to SQL", hive, impala, spark, sql);
            }
        }
        ret.add(stream);
        ret.add(hive);
        ret.add(impala);
        ret.add(spark);
        ret.add(sql);
        return ret;
    }

    /*
     * WARNING - void declaration
     */
    private RecipeEngineStatus selectEngine(AuthCtx authCtx, JobActivity activity, String userSelected, List<RecipeEngineStatus> statusList) throws IOException, DKUSecurityException {
        void var9_25;
        void var9_23;
        void var9_21;
        RecipeEngineStatus spark;
        void var9_19;
        RecipeEngineStatus hive;
        void var9_17;
        RecipeEngineStatus sql;
        RecipeEnginesPreferenceConfig resolvedPrefs = new RecipeConfigUtils().getResolvedPreferenceConfig(this.recipe.projectKey, this.recipe.type, null);
        HashMap<String, RecipeEngineStatus> enginesIndex = new HashMap<String, RecipeEngineStatus>();
        for (RecipeEngineStatus recipeEngineStatus : statusList) {
            enginesIndex.put(recipeEngineStatus.type, recipeEngineStatus);
        }
        List<String> forbiddenEngines = resolvedPrefs.getEffectiveForbidden(this.recipe.type);
        for (String string : forbiddenEngines) {
            RecipeEngineStatus engine = (RecipeEngineStatus)enginesIndex.get(string);
            if (engine == null) continue;
            engine.isSelectable = false;
            engine.statusWarnLevel = RecipeEngineStatus.WarningLevel.ERROR;
            engine.statusMessage = "Forbidden by configuration";
        }
        if (userSelected != null) {
            logger.info((Object)("User selected engine: " + userSelected));
            RecipeEngineStatus recipeEngineStatus = RecipeEngineStatus.getByType(statusList, userSelected);
            Validate.isTrue((boolean)recipeEngineStatus.isSelectable);
            return recipeEngineStatus;
        }
        List<String> list2 = resolvedPrefs.getEffectivePreference(this.recipe.type);
        list2 = RecipeStatus.filterToActualEngines(list2, RecipeStatus.toEngineTypes(statusList));
        logger.info((Object)("Applicable user preference: " + JSON.json(list2)));
        for (String type : list2) {
            RecipeEngineStatus res = RecipeStatus.getEngineByType(statusList, type);
            if (!res.isSelectable || res.statusWarnLevel != RecipeEngineStatus.WarningLevel.OK) continue;
            logger.info((Object)"Using user-prefered engine");
            return res;
        }
        logger.info((Object)"No user preference was usable, using heuristic");
        Object var9_15 = null;
        if (var9_15 == null && this.visualSQLRecipesBaseService.areAllInputDatasetsRealSQL(activity) && (sql = (RecipeEngineStatus)enginesIndex.get("SQL")) != null && sql.isOK()) {
            logger.info((Object)"SQL is possible and inputs are real SQL, using it");
            RecipeEngineStatus recipeEngineStatus = sql;
        }
        if (var9_17 == null && this.visualSQLRecipesBaseService.areAllInputDatasetsHDFS(activity) && (hive = (RecipeEngineStatus)enginesIndex.get("HIVE")) != null && hive.isOK()) {
            logger.info((Object)"Using Hive because input is HDFS");
            RecipeEngineStatus recipeEngineStatus = hive;
        }
        if (var9_19 == null && (spark = (RecipeEngineStatus)enginesIndex.get("SPARK")) != null && spark.isOK()) {
            DatasetSparkInspector.SparkFastPathStatus sparkFPS = ServiceUtils.canLikelySparkFastPathRead(authCtx, activity, this.datasetsDAO);
            logger.info((Object)("Spark fast-path status: " + JSON.json((Object)sparkFPS)));
            if (sparkFPS.ok) {
                logger.info((Object)"Using possible Spark because spark-fast-path-able");
                RecipeEngineStatus recipeEngineStatus = spark;
            }
        }
        if (var9_21 == null) {
            logger.info((Object)"Heuristics did not find a first-choice engine");
            ArrayList<String> remainingEnginesToTry = new ArrayList<String>();
            if (this.visualSQLRecipesBaseService.areAllInputDatasetsRealSQL(activity)) {
                remainingEnginesToTry.add("HIVE");
                remainingEnginesToTry.add("SQL");
                remainingEnginesToTry.add("DSS");
                remainingEnginesToTry.add("SPARK");
                remainingEnginesToTry.add("IMPALA");
            } else if (this.visualSQLRecipesBaseService.areAllInputDatasetsHDFS(activity)) {
                remainingEnginesToTry.add("HIVE");
                remainingEnginesToTry.add("SPARK");
                remainingEnginesToTry.add("IMPALA");
                remainingEnginesToTry.add("DSS");
                remainingEnginesToTry.add("SQL");
            } else {
                remainingEnginesToTry.add("HIVE");
                remainingEnginesToTry.add("DSS");
                remainingEnginesToTry.add("SPARK");
                remainingEnginesToTry.add("IMPALA");
                remainingEnginesToTry.add("SQL");
            }
            for (String type : remainingEnginesToTry) {
                if (enginesIndex.get(type) == null || ((RecipeEngineStatus)enginesIndex.get((Object)type)).statusWarnLevel == RecipeEngineStatus.WarningLevel.ERROR) continue;
                RecipeEngineStatus recipeEngineStatus = (RecipeEngineStatus)enginesIndex.get(type);
                logger.info((Object)("Auto-selected recipe engine: " + recipeEngineStatus.type));
                break;
            }
        }
        if (var9_23 == null) {
            logger.info((Object)"No engine could be auto-selected. Select DSS engine.");
            RecipeEngineStatus recipeEngineStatus = (RecipeEngineStatus)enginesIndex.get("DSS");
            assert (recipeEngineStatus != null);
        }
        return var9_25;
    }

    @Override
    public SamplingRecipeStatus getStatusForConversion_NT(AuthCtx authCtx) throws Exception {
        SamplingRecipeStatus status;
        StatusInitializer init = new StatusInitializer();
        try (Transaction t = this.transactionService.beginRead();){
            status = this.fastStatusIgnorePartitions(init, true, authCtx);
            if (status.isInvalid()) {
                logger.warn((Object)"Recipe status is invalid. Try to generate query anyway:");
            }
            if (init.dialect == null) {
                throw new IllegalArgumentException("No SQL dialect selected");
            }
            status.sql = this.service.generateSQL(init.activity, init.dialect, init.params.selection, init.filter, init.params.engineParams);
        }
        return status;
    }

    static class StatusInitializer {
        public Dataset inputDS;
        public Dataset outputDS;
        public JobActivity activity;
        public SamplingRecipeMeta.SamplingRecipeParams params;
        public FilterDesc filter;
        public SQLDialect dialect;
        public String error;

        StatusInitializer() {
        }
    }

    public static class SamplingRecipeStatus
    extends VisualSQLRecipeStatus {
        RecipeStatus.StepStatus filter;

        @Override
        public InfoMessage.InfoMessages gatherAllMessages() {
            InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
            ret.mergeFrom(this.topLevelMessages);
            if (this.filter != null) {
                ret.mergeFrom((InfoMessage.InfoMessages)this.filter);
            }
            if (this.output != null) {
                ret.mergeFrom((InfoMessage.InfoMessages)this.output);
            }
            return ret;
        }

        @Override
        public boolean isInvalid() {
            return this.filter != null && this.filter.anyFatal() || this.output != null && this.output.anyFatal();
        }
    }
}

