/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.sort;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.RecipeEnginesPreferenceConfig;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.VisualSQLRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.sort.SortRecipePayloadParams;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetUtils;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.queries.ExecutionPlanService;
import com.dataiku.dip.recipes.common.RecipeConfigUtils;
import com.dataiku.dip.recipes.common.RecipeEngineStatus;
import com.dataiku.dip.recipes.common.RecipeStatus;
import com.dataiku.dip.recipes.common.VisualSQLRecipeStatusComputer;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.recipes.visualsql.VisualSQLRecipeStatus;
import com.dataiku.dip.recipes.visualsql.VisualSQLRecipesBaseService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.recipes.SortRecipeService;
import com.dataiku.dip.sql.DummySQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import java.io.IOException;
import java.util.HashSet;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class SortRecipeStatusComputer
extends VisualSQLRecipeStatusComputer {
    @Autowired
    private SortRecipeService service;
    private static final Logger logger = Logger.getLogger((String)"dip.recipe.sort.status.computer");

    public SortRecipeStatusComputer(SerializedRecipe recipe, String payload) {
        super(recipe, payload);
    }

    @Override
    public SortRecipeStatus fastStatusIgnorePartitions(AuthCtx authCtx) throws Exception {
        return this.fastStatusIgnorePartitions(authCtx, new StatusInitializer(), true);
    }

    private SortRecipeStatus getEngineIndependentBaseStatus(AuthCtx authCtx, StatusInitializer init) throws IOException {
        SortRecipePayloadParams params;
        SortRecipeStatus status = new SortRecipeStatus();
        try {
            FlowRecipe flowRecipe = new FlowRecipe(this.recipe);
            init.activity = new JobActivity(this.recipesValidationService.getSampleSubgraph(flowRecipe));
            params = this.service.loadParams(this.payload, this.recipe);
            assert (params != null);
            status.params = params;
            status.engineParams = params.engineParams;
            init.inputDS = init.activity.getSubgraph().getSingleSourceDataset().getMandatoryUnsafe(this.datasetsDAO);
            this.recipesValidationService.checkComplianceWithRecipeDesc(authCtx, this.recipe);
            this.recipesValidationService.checkTargetsAreWritable(init.activity);
        }
        catch (Exception e) {
            logger.error((Object)"Invalid recipe", (Throwable)e);
            status.output.withFatal(RecipeCodes.ERR_RECIPE_INCONSISTENT_RECIPE, ExceptionUtils.getMessageWithCauses((Throwable)e));
            return status;
        }
        Dataset outputDataset = init.activity.getSubgraph().getSingleTargetDataset().getMandatoryUnsafe(this.datasetsDAO);
        DatasetHandler.DatasetMeta<?, ?> meta = DatasetHandlerFactory.getMeta(outputDataset);
        SerializedDataset.ReadWriteOptions rwOptions = outputDataset.getModel().readWriteOptions;
        if (!meta.supportsOrderPreservation()) {
            status.output.withWarning(RecipeCodes.WARN_RECIPE_SORT_OUTPUT_DS_ORDER_NOT_SUPPORTED, "The output dataset type does not support order preservation, it seems that the sort recipe will be useless. More information available in the doc.");
        } else if (rwOptions == null || !rwOptions.preserveOrder && rwOptions.writeBuckets > 1) {
            status.output.withWarning(RecipeCodes.WARN_RECIPE_SORT_OUTPUT_DS_NO_ORDER_SETTING, "The output dataset is not configured to preserve order or the output will be written parallely, it seems that the sort recipe will be useless. More information available in the doc.");
        }
        this.checkParams(init, params, status);
        return status;
    }

    private SortRecipeStatus fastStatusIgnorePartitions(AuthCtx authCtx, StatusInitializer init, boolean reportUnknownErrorsToStatus) throws IOException {
        SortRecipePayloadParams params;
        SortRecipeStatus status;
        block8: {
            block7: {
                status = this.getEngineIndependentBaseStatus(authCtx, init);
                params = status.params;
                RecipeEnginesPreferenceConfig repc = new RecipeConfigUtils().getResolvedPreferenceConfig(this.recipe.projectKey, this.recipe.type, params.enginesPreferences);
                try {
                    this.visualRecipesService.initEngines(authCtx, init.activity, status, this.recipe.projectKey);
                    this.performBasicCDEChecks(status, authCtx);
                    this.visualRecipesService.selectEngine(authCtx, init.activity, params.engineType, status, this.recipe.type, repc);
                    this.visualRecipesService.adjustEngineStatus(authCtx, init.activity, status, "Order in-database, then streaming of rows");
                    this.makeRecipeSpecificEnginesStatus(authCtx, init, status, params);
                    this.visualRecipesService.selectEngine(authCtx, init.activity, params.engineType, status, this.recipe.type, repc);
                    this.visualRecipesService.adjustEngineStatus(authCtx, init.activity, status, "Order in-database, then streaming of rows");
                    if (status.selectedEngine == null && !status.isInvalid()) {
                        status.output.withFatalV(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "No engine selected", new Object[0]);
                        return status;
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to init engine", (Throwable)e);
                    if (status.isInvalid()) break block7;
                    status.output.withFatalV(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Failed to init engine: %s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
                }
            }
            if (!status.isInvalid() && status.getSelectedSQLBasedEngine().queryBased) {
                try {
                    init.dialect = this.visualRecipesService.getDialect(authCtx, init.activity, status.getSelectedSQLBasedEngine());
                    status.sql = this.service.generateSQL(init.activity, init.dialect, params, true);
                }
                catch (Exception e) {
                    logger.info((Object)"Failed to generate SQL", (Throwable)e);
                    init.error = ExceptionUtils.getMessageWithCauses((Throwable)e);
                    if (!reportUnknownErrorsToStatus) break block8;
                    status.output.withFatalV(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Failed to generate SQL: %s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
                }
            }
        }
        if (!status.isInvalid() && params.computedColumns != null && !params.computedColumns.isEmpty()) {
            status.computedColumns = new RecipeStatus.StepStatus();
            boolean mustLowercaseColumns = this.visualRecipesService.mustLowerCaseColumnsNames((VisualSQLRecipePayloadParams)params, status.getSelectedSQLBasedEngine());
            this.visualRecipesService.checkComputedColumns(params.computedColumns, init.inputDS.getSchema(), status.getSelectedSQLBasedEngine(), init.dialect, mustLowercaseColumns, status.computedColumns);
        }
        return status;
    }

    private void checkParams(StatusInitializer init, SortRecipePayloadParams params, SortRecipeStatus status) {
        if (params.preFilter != null && (params.preFilter.enabled || params.preFilter.distinct)) {
            status.preFilter = new RecipeStatus.StepStatus();
            this.visualRecipesService.checkFilter(params.preFilter, init.inputDS, new DummySQLDialect(), status.preFilter, false);
        }
        status.sort = new RecipeStatus.StepStatus();
        if (params.orders == null || params.orders.isEmpty()) {
            status.sort.withFatal(RecipeCodes.ERR_RECIPE_SORT_NO_ORDER, "No order column is set.");
        }
    }

    @Override
    public VisualSQLRecipeStatus getStatusForConversion_NT(AuthCtx authCtx) throws Exception {
        SortRecipeStatus status;
        StatusInitializer init = new StatusInitializer();
        try (Transaction t = this.transactionService.beginRead();){
            status = this.fastStatusIgnorePartitions(authCtx, init, true);
            if (status.isInvalid()) {
                logger.warn((Object)"Recipe status is invalid. Try to generate query anyway:");
            }
            status.sql = this.service.generateSQL(init.activity, init.dialect, status.params, true);
        }
        return status;
    }

    @Override
    public RecipeStatus getFullStatus_NT(AuthCtx authCtx, String requestData) throws Exception {
        boolean lowerCaseColumnsNames;
        SortRecipeStatus status;
        StatusInitializer init = new StatusInitializer();
        try (Transaction t = this.transactionService.beginRead();){
            status = this.fastStatusIgnorePartitions(authCtx, init, false);
            if (status.isInvalid()) {
                this.fixupStatusOutputInvalid(status);
                SortRecipeStatus sortRecipeStatus = status;
                return sortRecipeStatus;
            }
        }
        SortRecipePayloadParams params = status.params;
        VisualSQLRecipesBaseService.SQLBasedEngineStatus selectedEngine = status.getSelectedSQLBasedEngine();
        Dataset inputDS = init.inputDS;
        SQLDialect dialect = init.dialect;
        VisualSQLRecipeStatus.VisualSQLRecipeStatusRequest request = (VisualSQLRecipeStatus.VisualSQLRecipeStatusRequest)JSON.parse((String)requestData, VisualSQLRecipeStatus.VisualSQLRecipeStatusRequest.class);
        if (request != null && !request.exactPlan) {
            this.visualRecipesService.enableSimplifiedExplainPlan(selectedEngine, params);
        }
        String preFilterSQLExpression = null;
        if (dialect != null && params.preFilter != null && (params.preFilter.enabled || params.preFilter.distinct)) {
            status.preFilter = new RecipeStatus.StepStatus();
            preFilterSQLExpression = this.visualRecipesService.checkFilter(params.preFilter, inputDS, dialect, status.preFilter, selectedEngine.queryBased);
        }
        try {
            lowerCaseColumnsNames = this.visualRecipesService.mustLowerCaseColumnsNames((VisualSQLRecipePayloadParams)params, selectedEngine);
            status.outputSchemaBeforeOverride = this.service.getOutputSchemaBeforeOverride(inputDS, params, lowerCaseColumnsNames);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to compute output schema", (Throwable)e);
            status.output.withFatalV(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Failed to compute output schema: %s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
            return status;
        }
        if (status.isInvalid()) {
            this.fixupStatusOutputInvalid(status);
            return status;
        }
        try {
            this.checkOutputSchema(status, params, lowerCaseColumnsNames);
        }
        catch (Exception e) {
            status.output.withFatalV(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Error computing schema: %s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
        }
        if (this.needToComputeExecutionPlan(selectedEngine, status, request)) {
            boolean executionPlanFailed = false;
            String executionPlanErrMsg = null;
            try {
                status.executionPlan = this.getExecutionPlan(authCtx, inputDS, selectedEngine, status.sql, params.engineParams);
            }
            catch (ExecutionPlanService.HiveTableNotFound e) {
                logger.error((Object)"Failed to compute execution plan", (Throwable)e);
                status.output.withFatalV(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Failed to compute execution plan, table not found in Hive metastore %s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
            }
            catch (Exception e) {
                logger.error((Object)"Failed to compute execution plan", (Throwable)e);
                logger.info((Object)("Query:\n" + status.sql));
                executionPlanFailed = true;
                executionPlanErrMsg = ExceptionUtils.getMessageWithCauses((Throwable)e);
                status.output.withFatalV(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Failed to compute execution plan: %s", new Object[]{executionPlanErrMsg});
            }
            if (executionPlanFailed) {
                try {
                    this.investigateExecutionPlanFailure(status, init, executionPlanErrMsg, authCtx, preFilterSQLExpression);
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to determine execution plan error cause", (Throwable)e);
                }
            }
        }
        if (init.error != null && !status.isInvalid()) {
            status.output.withFatalV(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Unknown error: %s", new Object[]{init.error});
        }
        this.fixupStatusOutputInvalid(status);
        return status;
    }

    private void fixupStatusOutputInvalid(VisualSQLRecipeStatus status) {
        if (status.isInvalid() && !status.output.anyFatal()) {
            status.output.withFatal(RecipeCodes.ERR_RECIPE_GENERIC_ERROR, "Failed to validate all recipe steps");
        }
    }

    private void makeRecipeSpecificEnginesStatus(AuthCtx authCtx, StatusInitializer init, SortRecipeStatus status, SortRecipePayloadParams params) throws Exception {
        logger.info((Object)"Computing engine status for sort recipe");
        for (VisualSQLRecipesBaseService.SQLBasedEngineStatus engine : status.getEngines()) {
            boolean skipCurrentEngine = false;
            if (!engine.isSelectable) {
                skipCurrentEngine = true;
            }
            if (!skipCurrentEngine && !engine.canDistinctSelect && params.preFilter != null && params.preFilter.distinct) {
                RecipeEngineStatus.setErrorStatus("Cannot use DISTINCT in pre-filter", engine);
                skipCurrentEngine = true;
            }
            if (skipCurrentEngine || !engine.queryBased) continue;
            try {
                SQLDialect dialect = this.visualRecipesService.getDialect(authCtx, init.activity, engine);
                this.service.generateSQL(init.activity, dialect, status.params, false);
            }
            catch (Exception e) {
                if (engine.type.equals("DSS")) {
                    RecipeEngineStatus.setErrorStatus("Recipe configuration is not supported: " + ExceptionUtils.getMessageWithCauses((Throwable)e), engine);
                    continue;
                }
                RecipeEngineStatus.setErrorStatus("Recipe cannot be translated to SQL: " + ExceptionUtils.getMessageWithCauses((Throwable)e), engine);
            }
        }
    }

    private void checkOutputSchema(SortRecipeStatus status, SortRecipePayloadParams params, boolean lowerCaseColumnsNames) {
        if (status.outputSchemaBeforeOverride != null) {
            status.outputSchema = new Schema(status.outputSchemaBeforeOverride);
            if (params.outputColumnNameOverrides != null) {
                HashSet<String> usedNames = new HashSet<String>();
                for (SchemaColumn sc : status.outputSchema.columns) {
                    String colName = sc.getName();
                    String overrideName = params.outputColumnNameOverrides.get(sc.getName());
                    if (StringUtils.isNotBlank((String)overrideName)) {
                        colName = lowerCaseColumnsNames ? overrideName.toLowerCase() : overrideName;
                        sc.setName(overrideName);
                    }
                    if (StringUtils.isNotBlank((String)(colName = colName.toLowerCase())) && usedNames.contains(colName)) {
                        status.output.withFatalV(RecipeCodes.ERR_RECIPE_SORT_DUPLICATE_OUTPUT, "Duplicate name: '" + colName + "'", new Object[0]);
                    }
                    usedNames.add(colName);
                }
            }
            if (status.outputSchema.columns.isEmpty()) {
                status.output.withFatalV(RecipeCodes.ERR_RECIPE_EMPTY_OUTPUT_SCHEMA, "Empty output schema", new Object[0]);
            }
        }
    }

    private void investigateExecutionPlanFailure(SortRecipeStatus status, StatusInitializer init, String executionPlanErrMsg, AuthCtx authCtx, String preFilterSQLExpression) throws Exception {
        if (status.getSelectedSQLBasedEngine().type.equals("HIVE")) {
            status.output.withFatal(RecipeCodes.ERR_RECIPE_EXECUTION_PLAN_COMPUTATION_FAILED, executionPlanErrMsg);
            return;
        }
        boolean errorOriginFound = false;
        ExpressionBuilder.ExpressionBuilderFactory ef = new ExpressionBuilder.ExpressionBuilderFactory();
        SQLUtils.SQLTable table = DatasetUtils.getResolvedTableWithSparkSQLFallback(init.inputDS, init.dialect, status.params.engineParams);
        if (preFilterSQLExpression != null) {
            SelectQueryBuilder qb = new SelectQueryBuilder();
            qb.from(table, null);
            qb.where(ef.expr(preFilterSQLExpression));
            String sql = qb.toSQL(init.dialect);
            try {
                this.getExecutionPlan(authCtx, init.inputDS, status.getSelectedSQLBasedEngine(), sql, status.params.engineParams);
            }
            catch (Exception e) {
                logger.error((Object)"Prefilter execution failed:", (Throwable)e);
                logger.error((Object)sql);
                status.preFilter.addMessage(InfoMessage.fatal((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_GROUPING_INVALID_FILTER, (String)this.formatDatabaseErrorMsg(e.getMessage(), init.dialect)).withPos(1, 0));
                errorOriginFound = true;
            }
        }
        if (!errorOriginFound) {
            status.output.withFatal(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, executionPlanErrMsg);
        }
    }

    private static class StatusInitializer {
        public Dataset inputDS;
        public SQLDialect dialect;
        public JobActivity activity;
        public String error;

        private StatusInitializer() {
        }
    }

    public static class SortRecipeStatus
    extends VisualSQLRecipeStatus {
        RecipeStatus.StepStatus preFilter;
        RecipeStatus.StepStatus computedColumns;
        RecipeStatus.StepStatus sort;
        SortRecipePayloadParams params;

        @Override
        public InfoMessage.InfoMessages gatherAllMessages() {
            InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
            ret.mergeFrom(this.topLevelMessages);
            if (this.preFilter != null) {
                ret.mergeFrom((InfoMessage.InfoMessages)this.preFilter);
            }
            if (this.computedColumns != null) {
                ret.mergeFrom((InfoMessage.InfoMessages)this.computedColumns);
            }
            if (this.sort != null) {
                ret.mergeFrom((InfoMessage.InfoMessages)this.sort);
            }
            ret.mergeFrom((InfoMessage.InfoMessages)this.output);
            return ret;
        }

        @Override
        public boolean isInvalid() {
            return this.gatherAllMessages().anyFatal();
        }
    }
}

