/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.split;

import com.dataiku.dip.dataflow.exec.computedcolumn.ComputedColumn;
import com.dataiku.dip.dataflow.exec.split.SplitRecipePayloadParams;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.expressions.Expression;

public abstract class AbstractSplitProcessorOutput
implements ProcessorOutput {
    protected SplitRecipePayloadParams params;
    protected ProcessorOutput defaultOutput;
    protected ColumnFactory cf;
    protected RowFactory rf;
    protected Row rowCopy;

    public void setDefaultOutput(ProcessorOutput output) {
        this.defaultOutput = output;
    }

    public void setFactories(ColumnFactory cf, RowFactory rf) {
        this.cf = cf;
        this.rf = rf;
    }

    public void setParams(SplitRecipePayloadParams params) {
        this.params = params;
    }

    protected void enrichRowWithComputedColumns(Row row) throws Exception {
        this.rowCopy = row;
        if (this.params.hasComputedColumns()) {
            if (!this.params.writeComputedColumnsInOutput) {
                this.rowCopy = this.copyRow(row);
            }
            for (ComputedColumn computedColumn : this.params.computedColumns) {
                Expression expr = new Expression(computedColumn.expr);
                expr.setColumnFactory(this.cf);
                expr.setVariablesContext(computedColumn.exprVariablesContext);
                Object value = expr.evaluate(this.rowCopy);
                this.rowCopy.put(this.cf.column(computedColumn.name), value.toString());
            }
        }
    }

    private Row copyRow(Row row) throws InstantiationException, IllegalAccessException {
        Row row2 = this.rf.row();
        for (Column col : this.cf.columns()) {
            row2.put(col, row.get(col));
        }
        return row2;
    }

    public void lastRowEmitted() throws Exception {
    }
}

