/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.split;

import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.JobAuthCtxService;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.cde.ContainerizedDSSEngineAble;
import com.dataiku.dip.dataflow.exec.AbortableRecipeRunner;
import com.dataiku.dip.dataflow.exec.FlowRunnable;
import com.dataiku.dip.dataflow.exec.PreRunSchemaPropagationHandler;
import com.dataiku.dip.dataflow.exec.RecipeRunnerWithPayload;
import com.dataiku.dip.dataflow.exec.VisualSQLRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.split.ContainerizedSplitExecutor;
import com.dataiku.dip.dataflow.exec.split.SplitRecipeExecutor;
import com.dataiku.dip.dataflow.exec.split.SplitRecipeHiveExecutor;
import com.dataiku.dip.dataflow.exec.split.SplitRecipeImpalaExecutor;
import com.dataiku.dip.dataflow.exec.split.SplitRecipeMySQLExecutor;
import com.dataiku.dip.dataflow.exec.split.SplitRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.split.SplitRecipeSQLExecutor;
import com.dataiku.dip.dataflow.exec.split.SplitRecipeSparkExecutor;
import com.dataiku.dip.dataflow.exec.split.SplitRecipeStatusComputer;
import com.dataiku.dip.dataflow.exec.split.SplitRecipeStreamExecutor;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.jobrunner.JobContext;
import com.dataiku.dip.recipes.RecipeRunner;
import com.dataiku.dip.recipes.common.RecipeEngineStatus;
import com.dataiku.dip.recipes.consistency.CDECompatibilityCheckerService;
import com.dataiku.dip.recipes.visualsql.VisualSQLRecipesBaseService;
import com.dataiku.dip.server.recipes.SplitRecipeService;
import com.dataiku.dip.sql.MySQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.utils.JSON;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class SplitRecipeRunner
implements FlowRunnable,
RecipeRunner,
RecipeRunnerWithPayload,
ContainerizedDSSEngineAble,
AbortableRecipeRunner {
    @Autowired
    private SplitRecipeService service;
    @Autowired
    protected VisualSQLRecipesBaseService visualSQLService;
    @Autowired
    private JobAuthCtxService authCtxService;
    @Autowired
    private CDECompatibilityCheckerService cdeCompatibilityCheckerService;
    private JobActivity activity;
    private FlowRecipe recipe;
    private SplitRecipePayloadParams params;
    private SplitRecipeExecutor executor;
    private String payload;
    private boolean isRunningInContainer;
    private static Logger logger = Logger.getLogger((String)"dku.recipe.split");

    public SplitRecipeRunner(JobActivity activity) {
        this.activity = activity;
        this.recipe = ((RecipeRunnableSubgraph)activity.getSubgraph()).getRecipe();
        this.activity.initStatus();
    }

    @Override
    public void setPayload(String payload) {
        this.payload = payload;
        this.params = this.service.loadParams(payload, this.activity, this.recipe.getProjectKey());
    }

    @Override
    public void setIsRunningInContainer() {
        this.isRunningInContainer = true;
    }

    @Override
    public void init() throws Exception {
        assert (this.params != null);
        this.params.check();
        this.recipe.validateExactly1Source();
        SerializedRecipe.SerializedRecipeAndPayload srp = new PreRunSchemaPropagationHandler(this.activity, this.recipe).propagateIfNeeded();
        if (srp != null && srp.payload != null) {
            this.setPayload(srp.payload);
        }
        this.executor = this.getExecutor();
        logger.info((Object)("Using executor: " + this.executor.getClass().getName()));
        this.executor.init();
    }

    private SplitRecipeExecutor getExecutor() throws Exception {
        SplitRecipeStatusComputer sc = new SplitRecipeStatusComputer(this.recipe.getModel(), this.payload);
        SplitRecipeStatusComputer.SplitRecipeStatus recipeStatus = sc.fastStatusIgnorePartitions(this.authCtxService.getAuthCtx());
        RecipeEngineStatus engineToUse = recipeStatus.selectedEngine;
        logger.info((Object)("Selected engine: " + engineToUse.type));
        JobContext.getCurrentActivitySummary().engineType = engineToUse.type;
        if (!engineToUse.isSelectable) {
            throw new Exception("No allowed engine could be selected");
        }
        boolean lowerCaseColumns = false;
        if (engineToUse instanceof VisualSQLRecipesBaseService.SQLBasedEngineStatus) {
            lowerCaseColumns = this.visualSQLService.mustLowerCaseColumnsNames((VisualSQLRecipePayloadParams)this.params, (VisualSQLRecipesBaseService.SQLBasedEngineStatus)engineToUse);
        }
        switch (engineToUse.type) {
            case "SQL": {
                SQLDialect engineDialect = this.visualSQLService.getDialect(this.authCtxService.getAuthCtx(), this.activity, recipeStatus.selectedEngine);
                if (engineDialect instanceof MySQLDialect) {
                    return new SplitRecipeMySQLExecutor(this.activity, this.params, lowerCaseColumns, engineDialect);
                }
                return new SplitRecipeSQLExecutor(this.activity, this.params, lowerCaseColumns, engineDialect);
            }
            case "SPARK": {
                return new SplitRecipeSparkExecutor(this.activity, this.params, this.params.engineParams.sparkSQL, lowerCaseColumns);
            }
            case "IMPALA": {
                return new SplitRecipeImpalaExecutor(this.activity, this.params, this.params.engineParams.impala, lowerCaseColumns);
            }
            case "HIVE": {
                return new SplitRecipeHiveExecutor(this.activity, this.params, this.params.engineParams.hive, lowerCaseColumns);
            }
            case "DSS": {
                ContainerExecRuntimeConfig containerConfig = this.cdeCompatibilityCheckerService.getContainerConfig(this.isRunningInContainer, this.authCtxService.getAuthCtx(), this.activity.warnContext, this.params.engineParams.containerSelection, this.recipe.getModel(), this.payload);
                if (containerConfig != null) {
                    logger.info((Object)"Run in container");
                    return new ContainerizedSplitExecutor(this.recipe, this.activity, containerConfig);
                }
                return new SplitRecipeStreamExecutor(this.activity, this.params, lowerCaseColumns);
            }
        }
        throw new IllegalArgumentException("No engine selected");
    }

    @Override
    public void run() throws Exception {
        logger.info((Object)"Run split recipe");
        try {
            logger.info((Object)("Params: " + JSON.pretty((Object)this.params)));
        }
        catch (Exception e) {
            logger.error((Object)"Params could not be printed.", (Throwable)e);
        }
        assert (this.executor != null);
        this.executor.run();
    }

    @Override
    public void notifyBeforeAborting() {
        this.executor.notifyBeforeAborting();
    }
}

