/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.sync;

import com.dataiku.dip.connections.AzureConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.dataflow.exec.sync.FastPathDatasetTypeStraightener;
import com.dataiku.dip.dataflow.exec.sync.TrinoSupport;
import com.dataiku.dip.dataflow.exec.sync.TrinoToCloud;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.fs.AzureBlobDatasetHandler;
import com.dataiku.dip.datasets.sql.BuiltinSQLDatasets;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.partitioning.FilePartitioner;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.recipes.common.RecipeEngineStatus;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKULogger;
import java.io.IOException;

public class TrinoToAzure
extends TrinoToCloud<AzureBlobDatasetHandler> {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.sync.trinotoazure");

    public static void setCompatible(AuthCtx authCtx, Dataset inputDS, Dataset outputDS, RecipeEngineStatus status) throws IOException, DKUSecurityException {
        DatasetHandler.DatasetMeta<?, ?> inputMeta = DatasetHandlerFactory.getMeta(inputDS);
        status.isSelectable = true;
        try {
            if (!new FastPathDatasetTypeStraightener().isEquivalentTo(outputDS, "Azure")) {
                throw new TrinoSupport.TrinoCloudFastpathImpossibleException("Output dataset is not in Azure");
            }
            if (inputMeta != BuiltinSQLDatasets.TRINO_META) {
                throw new TrinoSupport.TrinoCloudFastpathImpossibleException("Input dataset is not in Trino");
            }
            AzureConnection azureConnection = (AzureConnection)new FastPathDatasetTypeStraightener().getMandatoryConnectionUnsafeUnexpanded(authCtx, outputDS, "Azure");
            TrinoSupport.setCompatible(authCtx, outputDS, inputDS, status, false);
        }
        catch (TrinoSupport.TrinoCloudFastpathImpossibleException e) {
            status.markAsNonSelectable(e.getMessage(), RecipeEngineStatus.WarningLevel.ERROR);
        }
    }

    @Override
    protected String getPartitionRootPath(AzureBlobDatasetHandler datasetHandler, Partition partition) throws DKUSecurityException, CodedException, IOException {
        Object partitionPath;
        String rootPath = datasetHandler.getFullyQualifiedRootPath(AzureBlobDatasetHandler.HDFSInterface.ABFS);
        while (rootPath.endsWith("/")) {
            rootPath = rootPath.substring(0, rootPath.length() - 1);
        }
        if (partition == null || partition.isNP()) {
            partitionPath = "/";
        } else {
            partitionPath = FilePartitioner.computePartitionRelPathAsFolder(partition, datasetHandler.getDataset().getPartitioningSchema());
            if (!((String)partitionPath).startsWith("/")) {
                partitionPath = "/" + (String)partitionPath;
            }
        }
        return rootPath + (String)partitionPath;
    }
}

