/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.graphtools;

import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.ModelEvaluationStoresDAO;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dao.SavedModelsDAO;
import com.dataiku.dip.dao.StreamingEndpointsDAO;
import com.dataiku.dip.dataflow.FlowGraphService;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.FutureThread;
import com.dataiku.dip.labeling.LabelingTasksDAO;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledgeDAO;
import com.dataiku.dip.managedfolder.ManagedFolderDAO;
import com.dataiku.dip.scheduler.ScenariosDAO;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TaggingService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.utils.DKULogger;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractFlowTool {
    @Autowired
    protected DatasetsDAO datasetsDAO;
    @Autowired
    protected ManagedFolderDAO managedFolderDAO;
    @Autowired
    protected SavedModelsDAO savedModelsDAO;
    @Autowired
    protected ModelEvaluationStoresDAO modelEvaluationStoresDAO;
    @Autowired
    protected RetrievableKnowledgeDAO retrievableKnowledgeDAO;
    @Autowired
    protected LabelingTasksDAO labelingTasksDAO;
    @Autowired
    protected StreamingEndpointsDAO streamingEndpointsDAO;
    @Autowired
    protected RecipesDAO recipesDAO;
    @Autowired
    protected ScenariosDAO scenariosDAO;
    @Autowired
    protected TransactionService transactionService;
    @Autowired
    protected FutureService futureService;
    @Autowired
    protected FlowGraphService graphService;
    @Autowired
    protected TaggingService taggingService;
    protected final AuthCtx authCtx;
    protected final String projectKey;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.flow.tools");

    public AbstractFlowTool(AuthCtx authCtx, String projectKey) {
        this.authCtx = authCtx;
        this.projectKey = projectKey;
        SpringUtils.getInstance().autowire((Object)this);
    }

    public abstract FlowState getFlowState(JsonObject var1) throws Exception;

    public void stop() {
    }

    public static class UserSessions {
        public Map<String, UserSessionsInProject> projects = new HashMap<String, UserSessionsInProject>();
    }

    public static class ActiveFlowTool {
        public FlowToolType type;
        public String id;
        public JsonObject toolInitialData;
        public transient AbstractFlowTool handler;
    }

    public static class UserSessionsInProject {
        public Map<String, ActiveFlowTool> active = new HashMap<String, ActiveFlowTool>();
        public String currentId;
    }

    public static enum FlowToolType {
        FLOW_ZONES,
        TAGS,
        CUSTOM_FIELDS,
        CONNECTIONS,
        COUNT_OF_RECORDS,
        FILESIZE,
        FILEFORMATS,
        RECIPES_ENGINES,
        RECIPES_CODE_ENVS,
        IMPALA_WRITE_MODE,
        HIVE_MODE,
        SPARK_CONFIG,
        SPARK_PIPELINES,
        SQL_PIPELINES,
        PARTITIONING,
        PARTITIONS,
        SCENARIOS,
        CREATION,
        LAST_MODIFICATION,
        LAST_BUILD,
        LAST_BUILD_DURATION,
        RECENT_ACTIVITY,
        WATCH,
        COLUMN_USAGE,
        COPY,
        PROPAGATE_SCHEMA,
        CHECK_CONSISTENCY,
        DATA_QUALITY;

    }

    public static interface FlowState {
    }

    public static abstract class FlowTool
    extends AbstractFlowTool {
        public FlowTool(AuthCtx authCtx, String projectKey) {
            super(authCtx, projectKey);
        }

        public abstract void update(JsonObject var1) throws IOException, InterruptedException;

        public FutureResponse<FlowState> getUpdateFuture(AuthCtx u, JsonObject options) throws Exception {
            AsynchronousFlowToolUpdateThread thread = new AsynchronousFlowToolUpdateThread((DSSAuthCtx)u, options);
            return this.futureService.runFuture(thread, 0L, new TypeToken<FutureResponse<FlowState>>(){});
        }

        private FuturePayload buildFuturePayload() {
            FuturePayload fp = new FuturePayload();
            fp.action = "update_flow_tool";
            fp.displayName = "Compute flow tool state";
            return fp;
        }

        class AsynchronousFlowToolUpdateThread
        extends FutureThread<FlowState> {
            private final FuturePayload futurePayload;
            final JsonObject options;
            boolean done;

            public AsynchronousFlowToolUpdateThread(DSSAuthCtx owner, JsonObject options) {
                super(owner);
                this.options = options;
                this.futurePayload = FlowTool.this.buildFuturePayload();
            }

            public FlowState getResult() {
                if (this.done) {
                    try {
                        return FlowTool.this.getFlowState(null);
                    }
                    catch (Exception e) {
                        logger.info((Object)"Failed to get flow tool state", (Throwable)e);
                    }
                }
                return null;
            }

            public void execute() throws Exception {
                FlowTool.this.update(this.options);
                this.done = true;
            }

            public FuturePayload getPayload() {
                return this.futurePayload;
            }

            public double getDangerosity() {
                return 0.0;
            }
        }
    }

    public static abstract class FlowView
    extends AbstractFlowTool {
        public FlowView(AuthCtx authCtx, String projectKey) {
            super(authCtx, projectKey);
        }

        public void setFocus(Collection<String> focusedItems, String mode) throws Exception {
            this.setFocus(focusedItems);
        }

        public abstract void setFocus(Collection<String> var1) throws Exception;

        public abstract FlowState computeState() throws Exception;
    }
}

