/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.graphtools;

import com.dataiku.dip.coremodel.Zone;
import com.dataiku.dip.dao.ZonesDAO;
import com.dataiku.dip.dataflow.graph.utils.GraphIds;
import com.dataiku.dip.dataflow.graphtools.AbstractFlowTool;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.FlowZonesService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TaggableObjectsReadService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class FlowZonesView
extends AbstractFlowTool.FlowView {
    @Autowired
    private FlowZonesService flowZonesService;
    @Autowired
    private TaggableObjectsReadService taggableObjectsReadService;
    @Autowired
    private ZonesDAO zonesDAO;
    @Autowired
    private ProjectsService projectsService;
    private FlowZonesViewState state;

    public FlowZonesView(AuthCtx authCtx, String projectKey) {
        super(authCtx, projectKey);
    }

    @Override
    public AbstractFlowTool.FlowState getFlowState(JsonObject options) throws Exception {
        if (this.state != null) {
            Collection<String> currentFocus = this.state.focused;
            this.computeState();
            this.state.focused = currentFocus;
        } else {
            this.computeState();
        }
        return this.state;
    }

    @Override
    public void setFocus(Collection<String> focusedItems) throws Exception {
        if (this.state == null) {
            this.computeState();
        }
        this.state.focused = focusedItems == null ? new HashSet<String>() : focusedItems;
    }

    @Override
    public AbstractFlowTool.FlowState computeState() throws Exception {
        this.state = new FlowZonesViewState();
        try (Transaction t = this.transactionService.beginRead();){
            this.state.valueByNode = this.getZoneNodeMap(this.projectKey);
        }
        return this.state;
    }

    public Map<String, Zone> getZoneNodeMap(String projectKey) throws Exception {
        HashMap<String, Zone> nodeMap = new HashMap<String, Zone>();
        List zoneList = this.zonesDAO.list(projectKey);
        if (zoneList.isEmpty()) {
            return nodeMap;
        }
        for (Zone zone : zoneList) {
            FutureProgressState.checkInterrupt();
            this.state.zonesMap.put(zone.getId(), zone);
            nodeMap.put("zone_" + zone.getId(), zone);
        }
        for (ITaggingService.TaggableType type : ITaggingService.TaggableType.values()) {
            FutureProgressState.checkInterrupt();
            if (!type.isFlowItem()) continue;
            for (TaggableObjectsService.TaggableObject to : this.taggableObjectsReadService.listUnsafe(projectKey, type)) {
                nodeMap.put(GraphIds.forRef(to.getRef()), this.state.zonesMap.get(this.flowZonesService.retrieveZone(projectKey, to)));
            }
        }
        for (ProjectsService.AnyLocWithType loc : this.projectsService.getAllExposedObjects(projectKey)) {
            TaggableObjectsService.TaggableObject to;
            FutureProgressState.checkInterrupt();
            if (loc.type == null || !loc.type.isFlowItem() || (to = this.taggableObjectsReadService.getOrNullUnsafe(loc.getProjectKey(), loc.type, loc.getId())) == null) continue;
            nodeMap.put(GraphIds.forRef(to.getRef()), this.state.zonesMap.get(this.flowZonesService.retrieveZone(projectKey, to)));
        }
        return nodeMap;
    }

    public class FlowZonesViewState
    implements AbstractFlowTool.FlowState {
        Map<String, Zone> valueByNode = new HashMap<String, Zone>();
        Map<String, Zone> zonesMap = new HashMap<String, Zone>();
        public Collection<String> focused = new HashSet<String>();
    }
}

