/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.graphtools;

import com.dataiku.dip.coremodel.JobDef;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dataflow.FlowGraph;
import com.dataiku.dip.dataflow.ImplicitDependencyRunnableSubgraph;
import com.dataiku.dip.dataflow.Job;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.RunnableSubgraph;
import com.dataiku.dip.dataflow.commands.PartitionRefreshCommand;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowImplicitRecipe;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.graph.utils.JobPrinter;
import com.dataiku.dip.dataflow.graphtools.PipelinesView;
import com.dataiku.dip.dataflow.kernel.master.BuildUtils;
import com.dataiku.dip.dataflow.pipeline.BuildPipelines;
import com.dataiku.dip.dataflow.pipeline.RecipePipelineHelper;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ProjectsDAO;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;

public class PipelinesViewFakeJobComputer {
    @Autowired
    private ProjectsDAO projectsDAO;
    private JobActivity topLevelActivity;
    private final JobDef def;
    private final FlowGraph graph;
    private final Map<String, JobActivity> alreadyBuiltActivities = new HashMap<String, JobActivity>();
    private final AuthCtx authCtx;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.flow.fakeJobComputer");

    PipelinesViewFakeJobComputer(AuthCtx authCtx, JobDef def, FlowGraph graph) {
        this.authCtx = authCtx;
        SpringUtils.getInstance().autowire((Object)this);
        this.def = def;
        this.graph = graph;
    }

    public Job compute(RecipePipelineHelper.PipelineType pipelineType) throws Exception {
        logger.info((Object)("Job project: " + this.def.projectKey));
        SerializedProject sp = this.projectsDAO.getOrNullUnsafe(this.def.projectKey);
        assert (sp != null);
        PipelinesView.checkPipelinesEnabled(sp, pipelineType);
        this.topLevelActivity = this.computeUnprunedJobActivity();
        logger.info((Object)("Before prune, job looks like:\n" + JobPrinter.print(new Job(this.def, this.topLevelActivity), 0)));
        this.cleanupImplicitActivities(this.topLevelActivity);
        logger.info((Object)("After cleanup of implicit recipes, job looks like:\n" + JobPrinter.print(new Job(this.def, this.topLevelActivity), 0)));
        logger.info((Object)"Evaluating pipeline merging");
        this.topLevelActivity = new BuildPipelines(this.authCtx, pipelineType).visit(this.topLevelActivity);
        logger.info((Object)"Done building final job graph");
        return new Job(this.def, this.topLevelActivity);
    }

    private FlowRecipe getRecipeForTarget(String targetId) {
        for (FlowRecipe _r : this.graph.recipes) {
            for (FlowComputable target : _r.getTargets()) {
                if (!target.getFullId().equals(targetId)) continue;
                return _r;
            }
        }
        return null;
    }

    private FlowImplicitRecipe getImplicitRecipeForTarget(String targetId) {
        for (FlowImplicitRecipe _r : this.graph.implicitRecipes) {
            for (FlowComputable target : _r.getTargets()) {
                if (!target.getFullId().equals(targetId)) continue;
                return _r;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleActivityRec(JobActivity activity, PartitionRefreshCommand currentCommand, String originalProjectKey) {
        String sgId;
        JobActivity newActivity;
        RunnableSubgraph subgraph;
        FlowRecipe recipe = this.getRecipeForTarget(currentCommand.target.getFullId());
        FlowImplicitRecipe implicitRecipe = this.getImplicitRecipeForTarget(currentCommand.target.getFullId());
        if (recipe == null && implicitRecipe == null) {
            logger.info((Object)"End of tree reached");
            return;
        }
        if (implicitRecipe != null) {
            logger.infoV("Refreshing %s/%s with implicit recipe %s", new Object[]{currentCommand.target.getFullId(), currentCommand.partition.id(), implicitRecipe.getName()});
            subgraph = new ImplicitDependencyRunnableSubgraph(implicitRecipe);
            newActivity = new JobActivity(subgraph);
            ErrorContext.pushWithNDC((String)("activity " + newActivity.getSubgraph().getName() + "_" + String.valueOf(currentCommand.partition)));
            try {
                HashMap requiredPartitions = Maps.newHashMap();
                requiredPartitions.put(implicitRecipe.getPredecessor().getFullId(), Lists.newArrayList((Object[])new Partition[]{Partition.newNP()}));
                subgraph.getSourcePartitions().putAll(requiredPartitions);
                for (FlowComputable target : ((ImplicitDependencyRunnableSubgraph)subgraph).getTargets()) {
                    subgraph.getTargetPartitions().put(target.getFullId(), Partition.newNP());
                }
            }
            finally {
                ErrorContext.popWithNDC();
            }
        }
        logger.infoV("Refreshing %s/%s with recipe %s", new Object[]{currentCommand.target.getFullId(), currentCommand.partition.id(), recipe.getName()});
        subgraph = new RecipeRunnableSubgraph(recipe);
        newActivity = new JobActivity(subgraph);
        ErrorContext.pushWithNDC((String)("activity " + ((RecipeRunnableSubgraph)subgraph).getName() + "_" + String.valueOf(currentCommand.partition)));
        try {
            if (!recipe.isGenerator() && !recipe.getPredecessors().isEmpty()) {
                for (FlowComputable flowComputable : ((RecipeRunnableSubgraph)subgraph).getSources()) {
                    newActivity.getSubgraph().getSourcePartitions().put(flowComputable.getFullId(), Lists.newArrayList((Object[])new Partition[]{Partition.newNP()}));
                }
            }
            for (FlowComputable flowComputable : ((RecipeRunnableSubgraph)subgraph).getTargets()) {
                subgraph.getTargetPartitions().put(flowComputable.getFullId(), Partition.newNP());
            }
        }
        finally {
            ErrorContext.popWithNDC();
        }
        if (this.alreadyBuiltActivities.containsKey(sgId = newActivity.id())) {
            logger.info((Object)"This activity is an alias!");
            activity.dependencies.add(this.alreadyBuiltActivities.get(sgId));
            return;
        }
        this.alreadyBuiltActivities.put(newActivity.id(), newActivity);
        for (FlowComputable flowComputable : newActivity.getSubgraph().getSources()) {
            AnyLoc sourceLoc = AnyLoc.resolveFull(flowComputable.getFullId());
            if (!sourceLoc.getProjectKey().equals(originalProjectKey)) continue;
            if (newActivity.getSubgraph().getSourcePartitions().containsKey(flowComputable.getFullId())) {
                for (Partition partition : newActivity.getSubgraph().getSourcePartitions().get(flowComputable.getFullId())) {
                    PartitionRefreshCommand newCommand = new PartitionRefreshCommand(flowComputable, partition);
                    this.handleActivityRec(newActivity, newCommand, originalProjectKey);
                }
                continue;
            }
            logger.info((Object)"End of partitions dependencies");
        }
        activity.dependencies.add(newActivity);
    }

    private void handleOneOutput(JobDef.JobOutput o) throws Exception {
        ArrayList<Partition> partitionsToRefresh = new ArrayList<Partition>();
        logger.info((Object)("O type " + String.valueOf((Object)o.type)));
        o.type = BuildUtils.detectOutputType(o);
        logger.info((Object)("O type " + String.valueOf((Object)o.type)));
        FlowComputable computableToRefresh = this.graph.getComputable(o.targetDatasetProjectKey + "." + o.targetDataset);
        partitionsToRefresh.add(new Partition(null));
        if (computableToRefresh == null) {
            throw ErrorContext.iaef((String)"Target to refresh '%s' not found as target of one of the loaded recipes", (Object)o.targetDataset, (Object[])new Object[0]);
        }
        for (Partition partitionToRefresh : partitionsToRefresh) {
            logger.infoV("computing job from target %s partition %s", new Object[]{computableToRefresh.getFullId(), partitionToRefresh.id()});
            this.handleActivityRec(this.topLevelActivity, new PartitionRefreshCommand(computableToRefresh, partitionToRefresh), o.targetDatasetProjectKey);
            for (JobActivity ja : this.topLevelActivity.dependencies) {
                ja.topLevelActivity = true;
            }
        }
    }

    private JobActivity computeUnprunedJobActivity() throws Exception {
        this.topLevelActivity = new JobActivity(null);
        for (JobDef.JobOutput o : this.def.outputs) {
            this.handleOneOutput(o);
        }
        return this.topLevelActivity;
    }

    private void cleanupImplicitActivities(JobActivity activity) {
        this.cleanupImplicitActivities(activity, new HashSet<String>());
    }

    private void cleanupImplicitActivities(JobActivity activity, Set<String> alreadyVisited) {
        if (alreadyVisited.contains(activity.id())) {
            return;
        }
        alreadyVisited.add(activity.id());
        ArrayList activities = Lists.newArrayList();
        for (JobActivity subActivity : activity.dependencies) {
            this.cleanupImplicitActivities(subActivity, alreadyVisited);
            if (subActivity.getSubgraph() instanceof ImplicitDependencyRunnableSubgraph) {
                activities.addAll(subActivity.dependencies);
                continue;
            }
            activities.add(subActivity);
        }
        activity.dependencies.clear();
        activity.dependencies.addAll(activities);
    }
}

