/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.pdep;

import com.dataiku.dip.dataflow.pdep.DimensionDependencyEvaluator;
import com.dataiku.dip.partitioning.DimensionValue;
import com.dataiku.dip.partitioning.TimeDimension;
import com.dataiku.dip.partitioning.TimeDimensionValue;
import com.dataiku.dip.utils.DKUtils;
import com.google.common.base.Preconditions;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class AbstractTimeEvaluator
extends DimensionDependencyEvaluator {
    protected Set<Date> blacklist;
    protected static Logger logger = Logger.getLogger((String)"dku.pdep.time");

    AbstractTimeEvaluator(Set<Date> blacklist) {
        this.blacklist = blacklist;
    }

    protected boolean isBlacklisted(Date d) {
        return this.blacklist.contains(d);
    }

    protected static boolean isSameMonth(Calendar a, Calendar b) {
        return a.get(1) == b.get(1) && a.get(2) == b.get(2);
    }

    protected static Date parseyyyyMMDDHH(TimeDimensionValue tdv) {
        return AbstractTimeEvaluator.parseyyyyMMDDHH(tdv.id());
    }

    protected static Date parseyyyyMMDD(TimeDimensionValue tdv) {
        return AbstractTimeEvaluator.parseyyyyMMDD(tdv.id());
    }

    protected static Date parseyyyyMM(TimeDimensionValue tdv) {
        return AbstractTimeEvaluator.parseyyyyMM(tdv.id());
    }

    protected static Date parseyyyy(TimeDimensionValue tdv) {
        return AbstractTimeEvaluator.parseyyyy(tdv.id());
    }

    protected static Date parseyyyyMMDDHH(String tdvValue) {
        SimpleDateFormat sdf = DKUtils.getSimpleDateFormatUTCStrict((String)"yyyy-MM-dd-HH");
        sdf.setLenient(false);
        try {
            return sdf.parse(tdvValue);
        }
        catch (ParseException e) {
            throw new Error("The impossible happened : invalid partition id", e);
        }
    }

    protected static Date parseyyyyMMDD(String tdvValue) {
        SimpleDateFormat sdf = DKUtils.getSimpleDateFormatUTCStrict((String)"yyyy-MM-dd");
        sdf.setLenient(false);
        try {
            return sdf.parse(tdvValue);
        }
        catch (ParseException e) {
            throw new Error("The impossible happened : invalid partition id", e);
        }
    }

    protected static Date parseyyyyMM(String tdvValue) {
        SimpleDateFormat sdf = DKUtils.getSimpleDateFormatUTCStrict((String)"yyyy-MM");
        sdf.setLenient(false);
        try {
            return sdf.parse(tdvValue);
        }
        catch (ParseException e) {
            throw new Error("The impossible happened : invalid partition id", e);
        }
    }

    protected static Date parseyyyy(String tdvValue) {
        SimpleDateFormat sdf = DKUtils.getSimpleDateFormatUTCStrict((String)"yyyy");
        sdf.setLenient(false);
        try {
            return sdf.parse(tdvValue);
        }
        catch (ParseException e) {
            throw new Error("The impossible happened : invalid partition id", e);
        }
    }

    public Calendar getDayLevelCalendar(DimensionValue target) {
        Preconditions.checkArgument((boolean)(target instanceof TimeDimensionValue), (Object)"Partitioning dimension is not a time dimension");
        Calendar cal = DKUtils.getUTCCalendar();
        TimeDimensionValue ttarget = (TimeDimensionValue)target;
        switch (ttarget.getDimension().mappedPeriod) {
            case DAY: {
                cal.setTime(AbstractTimeEvaluator.parseyyyyMMDD(ttarget));
                break;
            }
            case HOUR: {
                cal.setTime(AbstractTimeEvaluator.parseyyyyMMDDHH(ttarget));
                break;
            }
            case MONTH: {
                throw new IllegalArgumentException("Cannot compute dependency of type " + this.getClass().getName() + " on a month-level partitioning");
            }
            case YEAR: {
                throw new IllegalArgumentException("Cannot compute dependency of type " + this.getClass().getName() + " on a year-level partitioning");
            }
        }
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal;
    }

    public Calendar getDayLevelCalendarNOW() {
        Calendar cal = DKUtils.getUTCCalendar();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal;
    }

    public Calendar getMonthLevelCalendar(DimensionValue target) {
        Preconditions.checkArgument((boolean)(target instanceof TimeDimensionValue), (Object)"Partitioning dimension is not a time dimension");
        Calendar cal = DKUtils.getUTCCalendar();
        TimeDimensionValue ttarget = (TimeDimensionValue)target;
        switch (ttarget.getDimension().mappedPeriod) {
            case DAY: {
                cal.setTime(AbstractTimeEvaluator.parseyyyyMMDD(ttarget));
                break;
            }
            case HOUR: {
                cal.setTime(AbstractTimeEvaluator.parseyyyyMMDDHH(ttarget));
                break;
            }
            case MONTH: {
                cal.setTime(AbstractTimeEvaluator.parseyyyyMM(ttarget));
                break;
            }
            case YEAR: {
                throw new IllegalArgumentException("Cannot compute dependency of type " + this.getClass().getName() + " on a year-level partitioning");
            }
        }
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal;
    }

    public static TimeDimensionValue getValueFromCalendar(Calendar cal, TimeDimension dim) {
        assert (cal.getTimeZone().getID().equals("UTC"));
        switch (dim.mappedPeriod) {
            case DAY: {
                return new TimeDimensionValue(dim, cal.get(1), cal.get(2) + 1, cal.get(5));
            }
            case HOUR: {
                return new TimeDimensionValue(dim, cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11));
            }
            case MONTH: {
                return new TimeDimensionValue(dim, cal.get(1), cal.get(2) + 1);
            }
            case YEAR: {
                return new TimeDimensionValue(dim, cal.get(1));
            }
        }
        throw new Error("unreachable");
    }
}

