/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.pdep;

import com.dataiku.dip.dataflow.pdep.AbstractTimeEvaluator;
import com.dataiku.dip.partitioning.Dimension;
import com.dataiku.dip.partitioning.DimensionValue;
import com.dataiku.dip.partitioning.TimeDimension;
import com.dataiku.dip.partitioning.TimeDimensionValue;
import com.dataiku.dip.utils.DKUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class WholeMonthEvaluator
extends AbstractTimeEvaluator {
    private Date flowEpoch;

    public WholeMonthEvaluator(Set<Date> srcBlacklist, Date flowEpoch) {
        super(srcBlacklist);
        this.flowEpoch = flowEpoch;
    }

    @Override
    public List<DimensionValue> getDependent(DimensionValue target, Dimension srcDim) {
        Preconditions.checkArgument((boolean)(srcDim instanceof TimeDimension), (Object)"Partitioning dimension is not a time dimension");
        Calendar initialCal = this.getMonthLevelCalendar(target);
        Calendar movingCal = DKUtils.getUTCCalendar();
        movingCal.setTime(initialCal.getTime());
        ArrayList<TimeDimensionValue> ov = new ArrayList<TimeDimensionValue>();
        while (WholeMonthEvaluator.isSameMonth(movingCal, initialCal)) {
            if (movingCal.getTime().after(this.flowEpoch) && !this.isBlacklisted(movingCal.getTime())) {
                ov.add(WholeMonthEvaluator.getValueFromCalendar(movingCal, (TimeDimension)srcDim));
            }
            movingCal.add(5, 1);
        }
        return Lists.reverse(ov);
    }
}

