/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.pipeline;

import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.RunnableSubgraph;
import com.dataiku.dip.dataflow.graph.ComputableWithPartition;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.pipeline.AbstractPipelineRunnableSubgraph;
import com.dataiku.dip.dataflow.pipeline.AccessibilityGraph;
import com.dataiku.dip.dataflow.pipeline.MergeabilityGraph;
import com.dataiku.dip.dataflow.pipeline.RecipePipelineHelper;
import com.dataiku.dip.dataflow.pipeline.SparkPipelineRunnableSubgraph;
import com.dataiku.dip.dataflow.pipeline.SqlPipelineRunnableSubgraph;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BuildPipelines {
    private final AuthCtx authCtx;
    private final RecipePipelineHelper.PipelineType pipelineType;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.flow.pipelines");

    public BuildPipelines(AuthCtx authCtx, RecipePipelineHelper.PipelineType pipelineType) {
        this.authCtx = authCtx;
        this.pipelineType = pipelineType;
        SpringUtils.getInstance().autowire((Object)this);
    }

    public JobActivity visit(JobActivity activity) throws Exception {
        HashSet effectiveActivities = Sets.newHashSet();
        HashMap computablesWithPartitionConsumers = Maps.newHashMap();
        HashMap computablesWithPartitionProducers = Maps.newHashMap();
        this.recursiveListSourceAndTargetUsages(activity, effectiveActivities, computablesWithPartitionConsumers, computablesWithPartitionProducers);
        MergeabilityGraph mergeability = new MergeabilityGraph(this.authCtx, activity, this.pipelineType);
        HashSet pipelinabilityTests = Sets.newHashSet();
        pipelinabilityTests.add(new SingleTargetPerComputableTest(computablesWithPartitionConsumers));
        List<Set<JobActivity>> components = mergeability.merge(pipelinabilityTests, new HashSet<MergeabilityGraph.SetMergeabilityTest>());
        ArrayList candidates = Lists.newArrayList();
        for (Set<JobActivity> component : components) {
            if (component.size() <= 1) continue;
            candidates.add(component);
        }
        if (candidates.isEmpty()) {
            logger.info((Object)"Nothing to pipeline, activity unchanged");
            return activity;
        }
        logger.infoV("Found %d pipelines to build", new Object[]{candidates.size()});
        for (Object candidate : candidates) {
            JobActivity jobActivity = this.convert((Set<JobActivity>)candidate, computablesWithPartitionProducers, computablesWithPartitionConsumers);
            components.remove(candidate);
            this.replaceByPipelineActivity(components, (Set<JobActivity>)candidate, jobActivity);
            components.add(Sets.newHashSet((Object[])new JobActivity[]{jobActivity}));
        }
        ArrayList allActivities = Lists.newArrayList();
        for (Set set : components) {
            allActivities.addAll(set);
        }
        AccessibilityGraph accessibility = new AccessibilityGraph(allActivities);
        List<JobActivity> list = accessibility.getRoots();
        boolean activityIsTopLevel = activity.topLevelActivity || "ROOT".equals(activity.id());
        for (JobActivity root : list) {
            root.topLevelActivity = activityIsTopLevel;
        }
        return list.size() == 1 ? list.get(0) : new JobActivity(null).withDependencies(list);
    }

    private void recursiveListSourceAndTargetUsages(JobActivity a, Set<JobActivity> effectiveActivities, Map<String, Set<JobActivity>> computablesWithPartitionConsumers, Map<String, JobActivity> computablesWithPartitionProducers) {
        if (effectiveActivities.contains(a)) {
            return;
        }
        if (a.getSubgraph() != null) {
            String id;
            effectiveActivities.add(a);
            for (ComputableWithPartition target : a.getSubgraph().getAllTargets()) {
                id = target.getIdWithPartition();
                computablesWithPartitionProducers.put(id, a);
            }
            for (ComputableWithPartition source : a.getSubgraph().getAllSources()) {
                id = source.getIdWithPartition();
                if (!computablesWithPartitionConsumers.containsKey(id)) {
                    computablesWithPartitionConsumers.put(id, new HashSet());
                }
                computablesWithPartitionConsumers.get(id).add(a);
            }
        }
        for (JobActivity dep : a.dependencies) {
            this.recursiveListSourceAndTargetUsages(dep, effectiveActivities, computablesWithPartitionConsumers, computablesWithPartitionProducers);
        }
    }

    private void replaceByPipelineActivity(List<Set<JobActivity>> components, Set<JobActivity> toPipeline, JobActivity pipeline) {
        for (Set<JobActivity> component : components) {
            for (JobActivity a : component) {
                a.dependencies = this.replaceActivitiesByPipeline(a.dependencies, toPipeline, pipeline);
            }
        }
    }

    private List<JobActivity> replaceActivitiesByPipeline(List<JobActivity> activities, Set<JobActivity> toPipeline, JobActivity pipeline) {
        ArrayList ret = Lists.newArrayList();
        boolean pipelineAdded = false;
        for (JobActivity a : activities) {
            if (toPipeline.contains(a)) {
                if (pipelineAdded) continue;
                ret.add(pipeline);
                pipelineAdded = true;
                continue;
            }
            ret.add(a);
        }
        return ret;
    }

    private List<String> mapToIds(Collection<JobActivity> activities) {
        ArrayList ret = Lists.newArrayList();
        for (JobActivity node : activities) {
            ret.add(node.id());
        }
        return ret;
    }

    private JobActivity convert(Set<JobActivity> activities, Map<String, JobActivity> cwpProducers, Map<String, Set<JobActivity>> cwpConsumers) throws IOException {
        logger.infoV("Convert %d activities to a pipeline : %s", new Object[]{activities.size(), Joiner.on((String)",").join(this.mapToIds(activities))});
        AccessibilityGraph accessibility = new AccessibilityGraph(activities);
        JobActivity root = accessibility.getRoots().get(0);
        List<JobActivity> activitiesInRunOrder = accessibility.orderDepthFirst();
        AbstractPipelineRunnableSubgraph pipelineRunnableSubgraph = switch (this.pipelineType) {
            case RecipePipelineHelper.PipelineType.SPARK -> new SparkPipelineRunnableSubgraph(root);
            case RecipePipelineHelper.PipelineType.SQL -> new SqlPipelineRunnableSubgraph(root);
            default -> throw new IllegalStateException(String.format("%s is not supported. Only Spark and Sql pipelines are.", new Object[]{this.pipelineType}));
        };
        pipelineRunnableSubgraph.addIncludedActivities(activitiesInRunOrder);
        JobActivity pipeline = new JobActivity(pipelineRunnableSubgraph);
        for (JobActivity jobActivity : activities) {
            boolean add;
            RunnableSubgraph subgraph = jobActivity.getSubgraph();
            if (subgraph == null) {
                logger.info((Object)"Activity without subgraph, unexpected at this stage");
                continue;
            }
            for (ComputableWithPartition target : subgraph.getAllTargets()) {
                Set<JobActivity> consumers = cwpConsumers.get(target.getIdWithPartition());
                if (consumers == null || consumers.isEmpty() || jobActivity.topLevelActivity) {
                    logger.infoV("Target added because it's a target of the job : %s", new Object[]{target.getIdWithPartition()});
                    add = true;
                } else if (BuildPipelines.onlyUsedByPipeline(consumers, activities)) {
                    if (BuildPipelines.isVirtualizable(target)) {
                        logger.infoV("Target not added because it's virtualized and only used inside the pipeline : %s", new Object[]{target.getIdWithPartition()});
                        add = false;
                    } else {
                        logger.infoV("Target added because it's only used inside the pipeline but not virtualized : %s", new Object[]{target.getIdWithPartition()});
                        add = true;
                    }
                } else {
                    logger.infoV("Target added because it's not used only by the pipeline : %s", new Object[]{target.getIdWithPartition()});
                    add = true;
                }
                if (!add) continue;
                if (!pipelineRunnableSubgraph.getTargets().contains(target.computable)) {
                    pipelineRunnableSubgraph.addTarget_NoRole(target.computable);
                }
                pipelineRunnableSubgraph.getTargetPartitions().put(target.computable.getFullId(), target.partition);
            }
            for (ComputableWithPartition source : subgraph.getAllSources()) {
                JobActivity producer = cwpProducers.get(source.getIdWithPartition());
                if (producer == null) {
                    logger.infoV("Source added because it's a source of the job : %s", new Object[]{source.getIdWithPartition()});
                    add = true;
                } else if (activities.contains(producer)) {
                    logger.infoV("Source not added because it's produced by the pipeline : %s", new Object[]{source.getIdWithPartition()});
                    add = false;
                } else {
                    logger.infoV("Source added because it's not produced by the pipeline : %s", new Object[]{source.getIdWithPartition()});
                    add = true;
                }
                if (!add) continue;
                if (!pipelineRunnableSubgraph.getSources().contains(source.computable)) {
                    pipelineRunnableSubgraph.addSource_NoRole(source.computable);
                }
                if (pipelineRunnableSubgraph.getSourcePartitions().containsKey(source.computable.getFullId())) {
                    pipelineRunnableSubgraph.getSourcePartitions().get(source.computable.getFullId()).add(source.partition);
                    continue;
                }
                pipelineRunnableSubgraph.getSourcePartitions().put(source.computable.getFullId(), Lists.newArrayList((Object[])new Partition[]{source.partition}));
            }
        }
        logger.infoV("At end of pipeline build, sources of the subgraph are:", new Object[0]);
        for (FlowComputable flowComputable : pipelineRunnableSubgraph.getSources()) {
            logger.infoV("  %s %s", new Object[]{flowComputable.getType(), flowComputable.getFullId()});
        }
        pipelineRunnableSubgraph.freeze();
        HashSet pipelineDependencies = Sets.newHashSet();
        for (JobActivity activity : activities) {
            for (JobActivity dependency : activity.dependencies) {
                if (activities.contains(dependency)) continue;
                pipelineDependencies.add(dependency);
            }
        }
        pipeline.dependencies = Lists.newArrayList((Iterable)pipelineDependencies);
        logger.infoV("Pipeline depends on %d activities : %s", new Object[]{pipelineDependencies.size(), Joiner.on((String)",").join(this.mapToIds(pipelineDependencies))});
        return pipeline;
    }

    private static boolean isVirtualizable(ComputableWithPartition cwp) throws IOException {
        return cwp.computable.getType() == FlowComputable.FCType.DATASET && ((FlowDataset)cwp.computable).isVirtualizable();
    }

    private static boolean onlyUsedByPipeline(Set<JobActivity> usages, Set<JobActivity> pipeline) {
        return pipeline.containsAll(usages);
    }

    private static class SingleTargetPerComputableTest
    implements MergeabilityGraph.SetPipelineabilityTest {
        private final Map<String, Set<JobActivity>> computablesWithPartitionConsumers;

        SingleTargetPerComputableTest(Map<String, Set<JobActivity>> computablesWithPartitionConsumers) {
            this.computablesWithPartitionConsumers = computablesWithPartitionConsumers;
        }

        private void addToOutputs(Map<String, List<String>> outputs, ComputableWithPartition target) {
            if (!outputs.containsKey(target.computable.getFullId())) {
                outputs.put(target.computable.getFullId(), new ArrayList());
            }
            outputs.get(target.computable.getFullId()).add(target.partition.id());
        }

        @Override
        public String canBePipelined(Set<JobActivity> activities) throws IOException {
            HashMap pipelineOutputs = Maps.newHashMap();
            for (JobActivity jobActivity : activities) {
                if (jobActivity.getSubgraph() == null) continue;
                for (ComputableWithPartition target : jobActivity.getSubgraph().getAllTargets()) {
                    String computableWithPartition = target.getIdWithPartition();
                    Set<JobActivity> consumers = this.computablesWithPartitionConsumers.get(computableWithPartition);
                    if (consumers == null || consumers.isEmpty()) {
                        this.addToOutputs(pipelineOutputs, target);
                        continue;
                    }
                    if (BuildPipelines.onlyUsedByPipeline(consumers, activities)) {
                        if (BuildPipelines.isVirtualizable(target)) continue;
                        this.addToOutputs(pipelineOutputs, target);
                        continue;
                    }
                    this.addToOutputs(pipelineOutputs, target);
                }
            }
            for (Map.Entry entry : pipelineOutputs.entrySet()) {
                if (((List)entry.getValue()).size() <= 1) continue;
                logger.info((Object)("Found conflict : " + (String)entry.getKey() + " / " + Joiner.on((String)",").join((Iterable)entry.getValue())));
                return "would have several partitions of " + (String)entry.getKey() + " as output";
            }
            return null;
        }
    }
}

