/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.utils;

import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Maps;
import java.util.HashMap;

public class FakeJobActivityBuilder {
    private final JobActivity activity;
    private final FlowRecipe recipe;

    private FakeJobActivityBuilder(JobActivity activity) {
        this.activity = activity;
        this.recipe = ((RecipeRunnableSubgraph)activity.getSubgraph()).getRecipe();
    }

    public static FakeJobActivityBuilder fakeJobActivity(JobActivity activity) {
        return new FakeJobActivityBuilder(activity);
    }

    public JobActivity build(String targetFullName) {
        String smartName = DatasetLocUtils.resolveFull(targetFullName).getSmartName(this.recipe.getProjectKey());
        SerializedRecipe sr = (SerializedRecipe)JSON.deepCopy((Object)this.recipe.getModel());
        sr.clearOutputs();
        sr.addOutput("main", smartName, this.recipe.getModel().getOutputAnyRole((String)smartName).appendMode);
        FlowRecipe recipeCopy = new FlowRecipe(sr);
        for (FlowComputable src : this.recipe.getSources()) {
            recipeCopy.addPredecessor(src, null);
        }
        FlowComputable target = this.recipe.getTargetsMap().get(targetFullName);
        Partition targetPartition = this.activity.getSubgraph().getTargetPartitions().get(targetFullName);
        if (target == null) {
            throw ErrorContext.iae((String)("Target not found:" + targetFullName));
        }
        if (targetPartition == null) {
            throw ErrorContext.iae((String)("Target partition not found:" + targetFullName));
        }
        recipeCopy.clearSuccessors();
        recipeCopy.addSuccessor(target, null);
        RecipeRunnableSubgraph subgraph2 = new RecipeRunnableSubgraph(recipeCopy);
        HashMap targetPartitions = Maps.newHashMap();
        targetPartitions.put(targetFullName, targetPartition);
        subgraph2.setTargetPartitions(targetPartitions);
        subgraph2.setSourcePartitions(this.activity.getSubgraph().getSourcePartitions());
        JobActivity ret = new JobActivity(subgraph2);
        ret.dependencies = this.activity.dependencies;
        ret.warnContext = this.activity.warnContext;
        return ret;
    }
}

