/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datalayer.memimpl;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.RowInputStream;
import com.dataiku.dip.datalayer.memimpl.MemColumn;
import com.dataiku.dip.datalayer.memimpl.MemRow;
import com.dataiku.dip.datalayer.memimpl.MemTableAppendingOutput;
import com.dataiku.dip.datalayer.memimpl.MemTableTracking;
import com.dataiku.dip.input.formats.ArchiveCapableFormatExtractor;
import com.dataiku.dip.input.formats.InputFormatsDetector;
import com.dataiku.dip.input.formats.LineOrientedInputSample;
import com.dataiku.dip.input.formats.csv.CSVFormatConfig;
import com.dataiku.dip.input.formats.csv.CSVFormatExtractor;
import com.dataiku.dip.input.formats.csv.CSVInputFormatDetector;
import com.dataiku.dip.input.stream.InputStreamLineReader;
import com.dataiku.dip.input.stream.LineReader;
import com.dataiku.dip.shaker.ProcessorWithRecordedReport;
import com.dataiku.dip.shaker.model.ScriptStep;
import com.dataiku.dip.shaker.types.DataTypeMatch;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.org.apache.commons.io.input.CloseShieldInputStream;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import gnu.trove.list.array.TIntArrayList;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MemTable
implements ColumnFactory,
RowFactory,
Serializable {
    private static final long serialVersionUID = -1L;
    public static final byte STATE_UNCHANGED = 0;
    public static final byte STATE_NEW = 1;
    public static final byte STATE_CHANGED = 2;
    public static final byte STATE_DELETED = 3;
    public boolean changeTracking;
    public List<MemColumn> columnsList = new ArrayList<MemColumn>();
    public Map<String, MemColumn> columns = new LinkedHashMap<String, MemColumn>();
    public List<MemRow> rows = new ArrayList<MemRow>();
    int resetableImpactDepth = -1;
    private List<String> unknownInputColumnsBuffer = new ArrayList<String>();
    private int nextColIndex;
    private TIntArrayList colsDeletedInCurrentContextByDepth = new TIntArrayList();
    private static DKULogger logger = DKULogger.getLogger((String)"dku.table");

    public RowInputStream stream() {
        return new MTRowInputStream();
    }

    void renameColumn(MemColumn c2, String newName) {
        this.columns.remove(c2.getName());
        c2.name = newName;
        this.columns.put(newName, c2);
    }

    public int nrows() {
        return this.rows.size();
    }

    public int ncols() {
        return this.columns.size();
    }

    public int nrowsNotDeleted() {
        int nnd = 0;
        for (MemRow row : this.rows) {
            if (row.isDeleted()) continue;
            ++nnd;
        }
        return nnd;
    }

    public long nbDistinctValues(MemColumn col) {
        HashSet<String> vals = new HashSet<String>();
        for (MemRow row : this.rows) {
            String v = row.get(col);
            if (v == null || v.isEmpty()) continue;
            vals.add(v);
        }
        return vals.size();
    }

    public Iterable<Column> columns() {
        ArrayList<Column> l = new ArrayList<Column>();
        l.addAll(this.columnsList);
        return l;
    }

    public void appendRow(Row row) {
        this.rows.add((MemRow)row);
    }

    public void trackChanges() {
        this.resetChanges();
        this.changeTracking = true;
        for (MemRow row : this.rows) {
            row.flags |= 2;
        }
    }

    public void increaseImpactDepth() {
        ++this.resetableImpactDepth;
        this.colsDeletedInCurrentContextByDepth.add(0);
    }

    public boolean hasNonDeletedColumn(String name) {
        MemColumn mc = this.columns.get(name);
        return mc != null && mc.state != 3;
    }

    public void resetChanges() {
        for (MemColumn ecd : this.columns.values()) {
            ecd.state = 0;
        }
        for (MemRow row : this.rows) {
            row.flags &= 0xFFFFFFFD;
            row.cellStates = null;
            row.rowState = 0;
        }
        this.changeTracking = false;
    }

    public MemTableChange createMemTableChange() {
        ArrayList<String> columnsBeforeStep = new ArrayList<String>();
        for (Column column : this.columns()) {
            String columnName = column.getName();
            columnsBeforeStep.add(columnName);
        }
        MemTableChange mtc = new MemTableChange(columnsBeforeStep);
        mtc.rowsBefore = this.rows.size();
        mtc.colsBefore = columnsBeforeStep.size();
        return mtc;
    }

    public void addDumbRowsIfEmpty() {
        if (this.columns.size() == 0) {
            MemColumn mc = this.column("__dku_no_data_col__");
            for (MemRow row : this.rows) {
                row.put((Column)mc, "__no_data__");
            }
        }
    }

    public void addRowFromJsonObject(JsonObject jsonObject) {
        Row row = this.row();
        for (Map.Entry feat : jsonObject.getAsJsonObject().entrySet()) {
            if (((JsonElement)feat.getValue()).isJsonNull()) continue;
            row.with((Column)this.column((String)feat.getKey()), ((JsonElement)feat.getValue()).getAsString());
        }
        this.appendRow(row);
    }

    public void keepOnlyImpactedRows() {
        int depthImpactedMask = 4 << this.resetableImpactDepth;
        int depthCreatedMask = 64 << this.resetableImpactDepth;
        int depthDeletedMask = 1024 << this.resetableImpactDepth;
        ArrayList<MemRow> newList = new ArrayList<MemRow>();
        for (MemRow row : this.rows) {
            if (!row.hasFlag(depthImpactedMask) && !row.hasFlag(depthCreatedMask) && !row.hasFlag(depthDeletedMask)) continue;
            newList.add(row);
        }
        this.rows = newList;
    }

    public void getChangeNoModify(MemTableChange change) {
        assert (this.resetableImpactDepth >= 0);
        int depthImpactedMask = 4 << this.resetableImpactDepth;
        int depthCreatedMask = 64 << this.resetableImpactDepth;
        int depthDeletedMask = 1024 << this.resetableImpactDepth;
        for (MemRow row : this.rows) {
            if (!row.isDeleted()) {
                ++change.rowsAfter;
                if (row.hasFlag(depthImpactedMask)) {
                    ++change.modifiedRows;
                }
            }
            if (row.hasFlag(depthCreatedMask)) {
                ++change.createdRows;
            }
            if (!row.hasFlag(depthDeletedMask)) continue;
            ++change.deletedRows;
        }
        change.colsAfter = 0;
        for (MemColumn col : this.columns.values()) {
            if ((col.state & 3) == 0) {
                ++change.colsAfter;
            }
            if ((col.flags & depthCreatedMask) == depthCreatedMask) {
                ++change.createdCols;
                continue;
            }
            if ((col.flags & depthImpactedMask) != depthImpactedMask) continue;
            ++change.modifiedCols;
        }
        change.deletedCols = this.colsDeletedInCurrentContextByDepth.get(this.resetableImpactDepth);
    }

    public void resetImpacts() {
        assert (this.resetableImpactDepth >= 0);
        int depthImpactedMask = 4 << this.resetableImpactDepth;
        int depthCreatedMask = 64 << this.resetableImpactDepth;
        int depthDeletedMask = 1024 << this.resetableImpactDepth;
        for (MemRow row : this.rows) {
            row.flags &= ~depthImpactedMask;
            row.flags &= ~depthCreatedMask;
            row.flags &= ~depthDeletedMask;
        }
    }

    public void decDepth() {
        this.colsDeletedInCurrentContextByDepth.remove(this.resetableImpactDepth, 1);
        --this.resetableImpactDepth;
    }

    public void getAndResetChanges(MemTableChange change) {
        assert (this.resetableImpactDepth >= 0);
        int depthImpactedMask = 4 << this.resetableImpactDepth;
        int depthCreatedMask = 64 << this.resetableImpactDepth;
        int depthDeletedMask = 1024 << this.resetableImpactDepth;
        for (MemRow row : this.rows) {
            if (!row.isDeleted()) {
                ++change.rowsAfter;
                if (row.hasFlag(depthImpactedMask)) {
                    ++change.modifiedRows;
                }
            }
            if (row.hasFlag(depthCreatedMask)) {
                ++change.createdRows;
            }
            if (row.hasFlag(depthDeletedMask)) {
                ++change.deletedRows;
            }
            row.flags &= ~depthImpactedMask;
            row.flags &= ~depthCreatedMask;
            row.flags &= ~depthDeletedMask;
        }
        change.colsAfter = 0;
        for (MemColumn col : this.columns.values()) {
            if ((col.state & 3) == 0) {
                ++change.colsAfter;
            }
            if ((col.flags & depthCreatedMask) == depthCreatedMask) {
                ++change.createdCols;
                continue;
            }
            if ((col.flags & depthImpactedMask) != depthImpactedMask) continue;
            ++change.modifiedCols;
        }
        change.deletedCols = this.colsDeletedInCurrentContextByDepth.get(this.resetableImpactDepth);
    }

    public boolean hasAnyPreviouslyDeletedColumns() {
        return !this.colsDeletedInCurrentContextByDepth.isEmpty() && this.colsDeletedInCurrentContextByDepth.getQuick(0) > 0;
    }

    public void addAndResetMessages(MemTableChange change) {
        InfoMessage unknownInputColumnInfoMessage;
        if (change.messages == null) {
            change.messages = new ArrayList<InfoMessage>();
        }
        if ((unknownInputColumnInfoMessage = this.getUnknownInputColumnInfoMessage()) != null) {
            change.messages.add(unknownInputColumnInfoMessage);
        }
        this.unknownInputColumnsBuffer = new ArrayList<String>();
    }

    private MemColumn newCol(String name) {
        MemColumn cd = new MemColumn();
        cd.name = name;
        cd.table = this;
        cd.index = this.nextColIndex++;
        cd.state = 1;
        cd.flags = MemTableTracking.addCreationFlags(cd.flags, this.resetableImpactDepth);
        return cd;
    }

    public MemColumn column(String name) {
        return this.column(name, null);
    }

    public MemColumn column(String name, Processor.ProcessorRole role) {
        if (name == null) {
            throw new IllegalArgumentException("Empty column name");
        }
        MemColumn cd = this.columns.get(name);
        if (cd == null) {
            cd = this.newCol(name);
            this.columnsList.add(cd);
            this.columns.put(name, cd);
            if (role == Processor.ProcessorRole.INPUT_COLUMN) {
                this.bufferUnknownInputColumn(name);
            }
        }
        return cd;
    }

    public MemColumn getColumn(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Empty column name");
        }
        return this.columns.get(name);
    }

    public MemColumn columnAfter(String before, String after) {
        return this.columnAfter(before, after, null);
    }

    public MemColumn columnAfter(String before, String after, Processor.ProcessorRole role) {
        MemColumn cd = this.columns.get(after);
        if (cd == null) {
            cd = this.newCol(after);
            MemColumn beforeCD = this.columns.get(before);
            if (beforeCD != null) {
                int index = this.columnsList.indexOf(beforeCD);
                this.columnsList.add(index + 1, cd);
            } else {
                this.columnsList.add(cd);
            }
            this.columns.put(after, cd);
            if (role == Processor.ProcessorRole.INPUT_COLUMN) {
                this.bufferUnknownInputColumn(after);
            }
        }
        return cd;
    }

    public MemColumn columnBefore(String after, String newCol) {
        return this.columnBefore(after, newCol, null);
    }

    public MemColumn columnBefore(String after, String newCol, Processor.ProcessorRole role) {
        if (after == null) {
            return this.column(newCol);
        }
        MemColumn cd = this.columns.get(newCol);
        if (cd == null) {
            cd = this.newCol(newCol);
            MemColumn afterCD = this.columns.get(after);
            if (afterCD != null) {
                int index = this.columnsList.indexOf(afterCD);
                this.columnsList.add(index, cd);
            } else {
                this.columnsList.add(cd);
            }
            this.columns.put(newCol, cd);
            if (role == Processor.ProcessorRole.INPUT_COLUMN) {
                this.bufferUnknownInputColumn(newCol);
            }
        }
        return cd;
    }

    public void moveAtStart(String name) {
        MemColumn column = this.columns.get(name);
        if (column == null) {
            this.bufferUnknownInputColumn(name);
            return;
        }
        int index = this.columnsList.indexOf(column);
        if (index > 0) {
            this.columnsList.remove(index);
            this.columnsList.add(0, column);
            this.reorderColumns();
        }
    }

    public void moveAtEnd(String name) {
        MemColumn column = this.columns.get(name);
        if (column == null) {
            this.bufferUnknownInputColumn(name);
            return;
        }
        int index = this.columnsList.indexOf(column);
        if (index < this.columnsList.size() - 1) {
            this.columnsList.remove(index);
            this.columnsList.add(column);
            this.reorderColumns();
        }
    }

    public void moveBefore(String after, String name) {
        int afterColumnIndex;
        MemColumn column = this.columns.get(name);
        if (column == null) {
            this.bufferUnknownInputColumn(name);
            return;
        }
        MemColumn afterColumn = this.columns.get(after);
        if (afterColumn == null) {
            this.bufferUnknownInputColumn(after);
            return;
        }
        int columnIndex = this.columnsList.indexOf(column);
        if (columnIndex != (afterColumnIndex = this.columnsList.indexOf(afterColumn)) - 1) {
            this.columnsList.remove(columnIndex);
            if (columnIndex < afterColumnIndex) {
                --afterColumnIndex;
            }
            this.columnsList.add(afterColumnIndex, column);
            this.reorderColumns();
        }
    }

    public void moveAfter(String before, String name) {
        int beforeColumnIndex;
        MemColumn column = this.columns.get(name);
        if (column == null) {
            this.bufferUnknownInputColumn(name);
            return;
        }
        MemColumn beforeColumn = this.columns.get(before);
        if (beforeColumn == null) {
            this.bufferUnknownInputColumn(before);
            return;
        }
        int columnIndex = this.columnsList.indexOf(column);
        if (columnIndex != (beforeColumnIndex = this.columnsList.indexOf(beforeColumn)) + 1) {
            this.columnsList.remove(columnIndex);
            if (columnIndex < beforeColumnIndex) {
                --beforeColumnIndex;
            }
            if (beforeColumnIndex < this.columnsList.size() - 1) {
                this.columnsList.add(beforeColumnIndex + 1, column);
            } else {
                this.columnsList.add(column);
            }
            this.reorderColumns();
        }
    }

    public MemColumn getColumnAfter(String before) {
        int index;
        MemColumn beforeCD = this.columns.get(before);
        if (beforeCD != null && (index = this.columnsList.indexOf(beforeCD)) + 1 < this.columnsList.size()) {
            return this.columnsList.get(index + 1);
        }
        return null;
    }

    public void deleteColumn(String name) {
        if (this.changeTracking && this.columns.containsKey(name)) {
            this.columns.get((Object)name).state = (byte)3;
        } else {
            this.columnsList.remove(this.columns.get(name));
            this.columns.remove(name);
        }
        for (int i = 0; i <= this.resetableImpactDepth; ++i) {
            this.colsDeletedInCurrentContextByDepth.set(i, this.colsDeletedInCurrentContextByDepth.get(i) + 1);
        }
    }

    private void bufferUnknownInputColumn(String col) {
        if (!this.unknownInputColumnsBuffer.contains(col)) {
            this.unknownInputColumnsBuffer.add(col);
        }
    }

    private InfoMessage getUnknownInputColumnInfoMessage() {
        if (this.unknownInputColumnsBuffer.isEmpty()) {
            return null;
        }
        StringBuilder detailsBuilder = new StringBuilder();
        detailsBuilder.append(this.unknownInputColumnsBuffer.size() > 1 ? "Input columns " : "Input column ");
        detailsBuilder.append("<b>").append(this.unknownInputColumnsBuffer.get(0)).append("</b>");
        if (this.unknownInputColumnsBuffer.size() > 1) {
            for (int i = 1; i < this.unknownInputColumnsBuffer.size(); ++i) {
                detailsBuilder.append(", <b>").append(this.unknownInputColumnsBuffer.get(i)).append("</b>");
            }
            detailsBuilder.append(",");
        }
        detailsBuilder.append(this.unknownInputColumnsBuffer.size() > 1 ? " do not exist, this might lead to erratic outcome." : " does not exist, this might lead to erratic outcome.");
        return InfoMessage.warning((InfoMessage.MessageCode)ScriptStep.StepCodes.WARN_SCRIPTSTEP_UNKNOWN_INPUT_COLUMN, (String)detailsBuilder.toString());
    }

    protected MemRow initNewRow(MemRow mr) {
        mr.rowState = 1;
        if (this.changeTracking) {
            mr.flags |= 2;
        }
        mr.flags = MemTableTracking.addCreationFlags(mr.flags, this.resetableImpactDepth);
        return mr;
    }

    public Row row() {
        return this.initNewRow(new MemRow(this));
    }

    public Row row(int[] cellLengths, char[] buffer) {
        return this.initNewRow(new MemRow(this, cellLengths, buffer));
    }

    public void compact() {
        long totalWritePos = 0L;
        long totalLost = 0L;
        long totalAllocated = 0L;
        long allocatedColumnRelatedMemory = 0L;
        long usefulColumnRelatedMemory = 0L;
        int columnsListLength = this.columnsList.size();
        ArrayList<MemRow> newList = new ArrayList<MemRow>();
        for (MemRow r : this.rows) {
            if (r.isDeleted()) continue;
            newList.add(r);
            totalWritePos += (long)r.bufferWritePos;
            totalLost += (long)r.lostChars;
            totalAllocated += (long)r.buffer.length;
            long allocatedCMem = r.getAllocatedColumnRelatedMemory();
            allocatedColumnRelatedMemory += allocatedCMem;
            usefulColumnRelatedMemory += Math.min(r.getNewColumnRelatedMemory(columnsListLength), allocatedCMem);
        }
        this.rows = newList;
        long usefulChars = totalWritePos - totalLost;
        long allocatedMemory = 2L * totalAllocated + allocatedColumnRelatedMemory;
        long usefulMemory = 2L * usefulChars + usefulColumnRelatedMemory;
        long absoluteTotalGain = allocatedMemory - usefulMemory;
        logger.info((Object)("MemTable stats nrows=" + this.nrows() + " ncols=" + this.ncols() + " allocChars=" + totalAllocated + " usefulChars=" + usefulChars + " allocColMem=" + allocatedColumnRelatedMemory + " usefulColMem=" + usefulColumnRelatedMemory + " estimatedMem=" + this.approximateMemUsage()));
        if (absoluteTotalGain > 30000000L || allocatedMemory > 0L && (double)usefulMemory / (double)allocatedMemory < 0.7) {
            boolean withColumnCompaction;
            logger.info((Object)("Compacting table: allocChars=" + totalAllocated + " usefulChars=" + usefulChars + " allocColMem=" + allocatedColumnRelatedMemory + " usefulColMem=" + usefulColumnRelatedMemory));
            totalAllocated = 0L;
            boolean bl = withColumnCompaction = allocatedColumnRelatedMemory - usefulColumnRelatedMemory > absoluteTotalGain / 3L;
            if (withColumnCompaction) {
                int[] oldColumnIndexes = this.columnsList.stream().mapToInt(c2 -> c2.index).toArray();
                for (int i = 0; i < columnsListLength; ++i) {
                    this.columnsList.get((int)i).index = i;
                }
                this.nextColIndex = columnsListLength;
                for (MemRow r : this.rows) {
                    totalAllocated += (long)r.rewrite(oldColumnIndexes);
                }
            } else {
                for (MemRow r : this.rows) {
                    totalAllocated += (long)r.compact();
                }
            }
            logger.info((Object)("After compact, allocChars=" + totalAllocated + " estimatedMem=" + this.approximateMemUsage()));
        }
    }

    public String getStats() {
        int totalWritePos = 0;
        int totalLost = 0;
        int totalAllocated = 0;
        for (MemRow r : this.rows) {
            totalWritePos += r.bufferWritePos;
            totalLost += r.lostChars;
            totalAllocated += r.buffer.length;
        }
        int usefulChars = totalWritePos - totalLost;
        return "MemTable stats nrows=" + this.nrows() + " ncols=" + this.ncols() + " allocChars=" + totalAllocated + " usefulChars=" + usefulChars + " estimatedMem=" + this.approximateMemUsage();
    }

    public long approximateMemUsage() {
        long total = 0L;
        for (MemRow r : this.rows) {
            total += r.getMemoryUsed();
        }
        return total;
    }

    public void dump() {
        this.dump(System.out);
    }

    public String dumpToString() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.dump(new PrintStream(out));
        return new String(out.toByteArray());
    }

    private void dump(PrintStream stream) {
        stream.print("#");
        for (Column column : this.columnsList) {
            stream.print(column.getName() + "\t");
        }
        stream.println("");
        for (MemRow memRow : this.rows) {
            if (memRow.isDeleted()) {
                stream.print("**D**");
            }
            for (Column column : this.columnsList) {
                String v = memRow.get(column);
                if (v == null) {
                    v = "EMPTY";
                }
                stream.print(v + "\t");
            }
            stream.println("");
        }
        for (MemColumn memColumn : this.columnsList) {
            stream.println("COLUMN " + memColumn.getName());
            for (DataTypeMatch dataTypeMatch : memColumn.candidateTypes) {
                stream.println("  TYPE " + String.valueOf(dataTypeMatch.type.getClass()) + " ok=" + dataTypeMatch.nbParses + " nok=" + dataTypeMatch.nbFails + " e=" + dataTypeMatch.nbEmpty + " trust=" + dataTypeMatch.trustScore());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MemTable fromCSV(InputStream input, String charset) throws Exception {
        assert (input.markSupported());
        try {
            input.mark((int)(300000.0f * Charset.forName(charset).newDecoder().averageCharsPerByte()));
            CloseShieldInputStream csis = new CloseShieldInputStream(input);
            LineOrientedInputSample sample = InputFormatsDetector.getLinesSampleWithCharset((InputStream)csis, charset);
            input.reset();
            CSVFormatConfig config = CSVInputFormatDetector.detectConf(sample);
            CSVFormatExtractor extractor = new CSVFormatExtractor(config);
            MemTable mt = new MemTable();
            extractor.doExtractStream(null, (LineReader)new InputStreamLineReader(input, charset), (ProcessorOutput)new MemTableAppendingOutput(mt), (ColumnFactory)mt, (RowFactory)mt, new ArchiveCapableFormatExtractor.ArchiveCapableObserver(){

                @Override
                public boolean checkLimit(long streamRecords) {
                    return true;
                }

                @Override
                public void onInterval(long streamRecords) throws InterruptedException {
                }

                @Override
                public void onEnd(long streamRecords) throws InterruptedException {
                }
            });
            MemTable memTable = mt;
            return memTable;
        }
        finally {
            input.close();
        }
    }

    public RowsIterator getInterruptibleRows() {
        return new RowsIterator(this.rows.iterator());
    }

    private void reorderColumns() {
        HashMap<String, MemColumn> existingColumns = new HashMap<String, MemColumn>(this.columns);
        this.columns.clear();
        for (MemColumn column : this.columnsList) {
            this.columns.put(column.name, (MemColumn)existingColumns.get(column.name));
        }
    }

    public class MTRowInputStream
    implements RowInputStream {
        int idx = 0;

        public Row next() {
            if (this.idx >= MemTable.this.rows.size()) {
                return null;
            }
            return MemTable.this.rows.get(this.idx++);
        }
    }

    public static class MemTableChange {
        public int rowsBefore = 0;
        public int colsBefore = 0;
        public int rowsAfter = 0;
        public int colsAfter = 0;
        public int createdRows = 0;
        public int modifiedRows = 0;
        public int deletedRows = 0;
        public int createdCols = 0;
        public int modifiedCols = 0;
        public int deletedCols = 0;
        final Collection<String> columnsBeforeStep;
        public List<InfoMessage> messages = new ArrayList<InfoMessage>();
        public ProcessorWithRecordedReport.ProcessorRecordedReport recordedReport;
        public List<MemTableChange> groupStepsChanges = new ArrayList<MemTableChange>();

        MemTableChange(Collection<String> colummnsBeforeStep) {
            this.columnsBeforeStep = colummnsBeforeStep;
        }
    }

    public class RowsIterator
    implements Iterator<MemRow> {
        int checkInterrupt = 0;
        private Iterator<MemRow> actualIterator;

        RowsIterator(Iterator<MemRow> actualIterator) {
            this.actualIterator = actualIterator;
        }

        public boolean hasNextInterruptible() throws InterruptedException {
            if (this.checkInterrupt-- <= 0) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                this.checkInterrupt = 500;
            }
            return this.hasNext();
        }

        @Override
        public boolean hasNext() {
            return this.actualIterator.hasNext();
        }

        @Override
        public MemRow next() {
            return this.actualIterator.next();
        }

        @Override
        public void remove() {
            this.actualIterator.remove();
        }
    }
}

