/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datalayer.window;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.window.WindowAggregation;
import com.dataiku.dip.datasets.Type;

public class CountAggregation
extends WindowAggregation {
    private long count;

    public static SchemaColumn buildOutputSchemaColumn(String name, SchemaColumn schemaColumn) {
        return new SchemaColumn(name, Type.BIGINT);
    }

    public CountAggregation(Column column, Column result, SchemaColumn schemaColumn) {
        super(column, result, schemaColumn, CountAggregation.buildOutputSchemaColumn(result.getName(), schemaColumn));
    }

    @Override
    public boolean needsReset() {
        return false;
    }

    @Override
    public void reset() {
        this.count = 0L;
    }

    @Override
    public void expandInternal(Object value) {
        this.count += value == null ? 0L : 1L;
    }

    @Override
    public void shrinkInternal(Object value) {
        this.count -= value == null ? 0L : 1L;
    }

    @Override
    public Object produceValueInternal() {
        return this.count;
    }
}

