/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datalayer.window;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.window.WindowAggregation;
import com.dataiku.dip.datasets.Type;

public class SumAggregation
extends WindowAggregation {
    private double sumD;
    private long sumL;
    private long cnt;
    private final Type type;

    private static SchemaColumn makeSumOutputSchemaColumn(String name, Type type) {
        if (type.isNumeric() && type.isFloatingPoint()) {
            return new SchemaColumn(name, Type.DOUBLE);
        }
        if (type.isNumeric() && !type.isFloatingPoint()) {
            return new SchemaColumn(name, Type.BIGINT);
        }
        if (type == Type.BOOLEAN) {
            return new SchemaColumn(name, Type.BIGINT);
        }
        throw new RuntimeException("Cannot sum non-numeric column " + name + " of type " + String.valueOf(type));
    }

    public static SchemaColumn buildOutputSchemaColumn(String name, SchemaColumn schemaColumn) {
        return SumAggregation.makeSumOutputSchemaColumn(name, schemaColumn.getType());
    }

    public SumAggregation(Column column, Column result, SchemaColumn schemaColumn) {
        super(column, result, schemaColumn, SumAggregation.buildOutputSchemaColumn(result.getName(), schemaColumn));
        if (schemaColumn.getType().isNumeric()) {
            this.type = schemaColumn.getType().isFloatingPoint() ? Type.DOUBLE : Type.BIGINT;
        } else if (schemaColumn.getType() == Type.BOOLEAN) {
            this.type = Type.BOOLEAN;
        } else {
            throw new RuntimeException("unreachable");
        }
    }

    @Override
    public boolean needsReset() {
        return false;
    }

    @Override
    public void reset() {
        this.sumD = 0.0;
        this.sumL = 0L;
        this.cnt = 0L;
    }

    @Override
    public void expandInternal(Object value) {
        if (value != null) {
            if (this.type == Type.DOUBLE) {
                this.sumD += ((Double)value).doubleValue();
            } else if (this.type == Type.BIGINT) {
                this.sumL += ((Long)value).longValue();
            } else if (this.type == Type.BOOLEAN) {
                this.sumL += (Boolean)value != false ? 1L : 0L;
            }
            ++this.cnt;
        }
    }

    @Override
    public void shrinkInternal(Object value) {
        if (value != null) {
            if (this.cnt == 1L) {
                this.reset();
                return;
            }
            if (this.type == Type.DOUBLE) {
                this.sumD -= ((Double)value).doubleValue();
            } else if (this.type == Type.BIGINT) {
                this.sumL -= ((Long)value).longValue();
            } else if (this.type == Type.BOOLEAN) {
                this.sumL -= (Boolean)value != false ? 1L : 0L;
            }
            --this.cnt;
        }
    }

    @Override
    public Object produceValueInternal() {
        if (this.type == Type.DOUBLE) {
            return this.cnt == 0L ? null : Double.valueOf(this.sumD);
        }
        if (this.type == Type.BIGINT) {
            return this.cnt == 0L ? null : Long.valueOf(this.sumL);
        }
        if (this.type == Type.BOOLEAN) {
            return this.cnt == 0L ? null : Long.valueOf(this.sumL);
        }
        throw new RuntimeException("unreachable");
    }
}

