/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datalineage;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.datalineage.ColumnRelation;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class DatasetPairLineage {
    @Nonnull
    private final String inputDatasetFullName;
    @Nonnull
    private final Schema inputDatasetSchema;
    private String outputDatasetFullName;
    private Schema outputDatasetSchema;
    @Nonnull
    private final Map<String, Set<ColumnRelation>> relationsByOutputColumn;

    public DatasetPairLineage(String inputDatasetFullName, Schema inputDatasetSchema, String outputDatasetFullName, Schema outputDatasetSchema, Set<ColumnRelation> relations) {
        Preconditions.checkArgument((boolean)relations.stream().allMatch(relation -> Objects.equals(inputDatasetFullName, relation.inputDataset)), (Object)"Inconsistent input dataset in lineage relations");
        Preconditions.checkArgument((boolean)relations.stream().allMatch(relation -> Objects.equals(outputDatasetFullName, relation.outputDataset)), (Object)"Inconsistent output dataset in lineage relations");
        this.inputDatasetFullName = inputDatasetFullName;
        this.inputDatasetSchema = inputDatasetSchema;
        this.outputDatasetFullName = outputDatasetFullName;
        this.outputDatasetSchema = outputDatasetSchema;
        this.relationsByOutputColumn = new HashMap<String, Set<ColumnRelation>>();
        relations.forEach(relation -> this.relationsByOutputColumn.computeIfAbsent(relation.outputColumn, x -> new HashSet()).add(relation));
    }

    public DatasetPairLineage(SerializedDataset inputDataset, SerializedDataset outputDataset) {
        this(inputDataset.getFullName(), inputDataset.getSchema(), outputDataset.getFullName(), outputDataset.getSchema(), Collections.emptySet());
    }

    public DatasetPairLineage(String inputDatasetFullName, Schema inputDatasetSchema, String outputDatasetFullName, Schema outputDatasetSchema) {
        this(inputDatasetFullName, inputDatasetSchema, outputDatasetFullName, outputDatasetSchema, Collections.emptySet());
    }

    public DatasetPairLineage(DatasetPairLineage other) {
        this(other.inputDatasetFullName, other.inputDatasetSchema, other.outputDatasetFullName, other.outputDatasetSchema, other.getRelations());
    }

    @Nonnull
    public String getInputDatasetFullName() {
        return this.inputDatasetFullName;
    }

    public String getOutputDatasetFullName() {
        return this.outputDatasetFullName;
    }

    public Schema getInputDatasetSchema() {
        return this.inputDatasetSchema;
    }

    public Schema getOutputDatasetSchema() {
        return this.outputDatasetSchema;
    }

    public void initializeDirectColumnRelations() {
        this.inputDatasetSchema.getColumns().stream().map(SchemaColumn::getName).forEach(column -> this.addRelation((String)column, (String)column, false));
    }

    public Set<ColumnRelation> getRelations() {
        return this.relationsByOutputColumn.values().stream().flatMap(Collection::stream).map(ColumnRelation::new).collect(Collectors.toSet());
    }

    public void keepValidRelations() {
        if (this.outputDatasetSchema != null) {
            this.relationsByOutputColumn.entrySet().removeIf(entry -> !this.outputDatasetSchema.hasColumn((String)entry.getKey()));
        }
        this.relationsByOutputColumn.forEach((outputColumn, columnRelations) -> columnRelations.removeIf(columnRelation -> !this.inputDatasetSchema.hasColumn(columnRelation.inputColumn)));
    }

    public void setOutputDataset(@Nonnull String outputDatasetFullName, @Nonnull Schema outputDatasetSchema) {
        this.outputDatasetFullName = outputDatasetFullName;
        this.outputDatasetSchema = outputDatasetSchema;
        this.relationsByOutputColumn.forEach((outputColumn, columnRelations) -> columnRelations.forEach(columnRelation -> {
            columnRelation.outputDataset = outputDatasetFullName;
        }));
    }

    public void addRelation(String inputColumnName, String outputColumnName, Boolean indirect) {
        Set columnRelations = this.relationsByOutputColumn.computeIfAbsent(outputColumnName, x -> new HashSet());
        ColumnRelation columnRelationToAdd = new ColumnRelation(inputColumnName, this.inputDatasetFullName, outputColumnName, this.outputDatasetFullName, indirect);
        if (Boolean.TRUE.equals(indirect)) {
            ColumnRelation directRelation = new ColumnRelation(inputColumnName, this.inputDatasetFullName, outputColumnName, this.outputDatasetFullName, false);
            if (!columnRelations.contains(directRelation)) {
                columnRelations.add(columnRelationToAdd);
            }
        } else {
            ColumnRelation indirectRelation = new ColumnRelation(inputColumnName, this.inputDatasetFullName, outputColumnName, this.outputDatasetFullName, true);
            columnRelations.remove(indirectRelation);
            columnRelations.add(columnRelationToAdd);
        }
    }

    public void removeRelation(ColumnRelation relation) {
        Set columnRelations = this.relationsByOutputColumn.getOrDefault(relation.outputColumn, Collections.emptySet());
        ColumnRelation directRelation = new ColumnRelation(relation);
        directRelation.indirect = false;
        ColumnRelation indirectRelation = new ColumnRelation(relation);
        indirectRelation.indirect = true;
        columnRelations.remove(directRelation);
        columnRelations.remove(indirectRelation);
    }

    public void removeRelationsOnColumn(String column) {
        this.relationsByOutputColumn.remove(column);
    }

    public boolean hasOutputColumn(String column) {
        return !this.getRelationsOnOutputColumn(column).isEmpty();
    }

    @Nonnull
    public Set<ColumnRelation> getRelationsOnOutputColumn(String column) {
        Set<ColumnRelation> relations = this.relationsByOutputColumn.get(column);
        if (relations == null) {
            relations = new HashSet<ColumnRelation>();
        }
        return relations;
    }

    public Set<String> getOutputColumns() {
        return new HashSet<String>(this.relationsByOutputColumn.keySet());
    }

    public void addFactorizedColumnRelations(String fromColumn, String toColumn, boolean indirect) {
        if (!Objects.equals(fromColumn, toColumn)) {
            this.getRelationsOnOutputColumn(fromColumn).forEach(relation -> this.addRelation(relation.inputColumn, toColumn, indirect || Boolean.TRUE.equals(relation.indirect)));
        }
    }

    public void addFactorizedColumnRelations(String fromColumn, String toColumn) {
        this.addFactorizedColumnRelations(fromColumn, toColumn, false);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatasetPairLineage that = (DatasetPairLineage)o;
        return Objects.equals(this.inputDatasetFullName, that.inputDatasetFullName) && Objects.equals(this.inputDatasetSchema, that.inputDatasetSchema) && Objects.equals(this.outputDatasetFullName, that.outputDatasetFullName) && Objects.equals(this.outputDatasetSchema, that.outputDatasetSchema) && Objects.equals(this.relationsByOutputColumn, that.relationsByOutputColumn);
    }

    public int hashCode() {
        return Objects.hash(this.inputDatasetFullName, this.inputDatasetSchema, this.outputDatasetFullName, this.outputDatasetSchema, this.relationsByOutputColumn);
    }

    public String toString() {
        return "DatasetPairLineage {inputDatasetFullName='" + this.inputDatasetFullName + "', inputDatasetSchema=" + String.valueOf(this.inputDatasetSchema) + ", outputDatasetFullName='" + this.outputDatasetFullName + "', outputDatasetSchema=" + String.valueOf(this.outputDatasetSchema) + ", relationsByOutputColumn=" + String.valueOf(this.relationsByOutputColumn) + "}";
    }
}

