/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataquality;

import com.dataiku.dip.dataquality.DataQualityTemplate;
import com.dataiku.dip.dataquality.DataQualityTemplatesDAO;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.utils.FileFilter;
import com.dataiku.dip.transactions.fs.utils.RelFileFilter;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.utils.DKULogger;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class FileBasedDataQualityTemplatesDAO
implements DataQualityTemplatesDAO {
    private static final RelFile DATA_QUALITY_TEMPLATES_FOLDER = new RelFile(new String[]{"data-quality-templates"});
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.dataquality.templates");

    @Override
    public DataQualityTemplate getOrNull(String id, boolean unsafe) throws IOException {
        RelFile f = FileBasedDataQualityTemplatesDAO.getDataQualityTemplateFile(id);
        TransactionRef t = TransactionContext.retrieveRead();
        if (!t.isFile(f)) {
            return null;
        }
        DataQualityTemplate dataQualityTemplate = unsafe ? (DataQualityTemplate)t.readObjectUnsafe(f, DataQualityTemplate.class) : (DataQualityTemplate)t.readObject(f, DataQualityTemplate.class);
        dataQualityTemplate.id = id;
        return dataQualityTemplate;
    }

    @Override
    public DataQualityTemplate getOrNull(String id) throws IOException {
        return this.getOrNull(id, false);
    }

    @Override
    public DataQualityTemplate getOrNullUnsafe(String id) throws IOException {
        return this.getOrNull(id, true);
    }

    @Override
    public DataQualityTemplate getMandatory(String id, boolean unsafe) throws IOException {
        DataQualityTemplate dataQualityTemplate = this.getOrNull(id, unsafe);
        if (dataQualityTemplate == null) {
            throw new NotFoundException("Rule template does not exist: " + id);
        }
        return dataQualityTemplate;
    }

    @Override
    public DataQualityTemplate getMandatoryUnsafe(String id) throws IOException {
        return this.getMandatory(id, true);
    }

    @Override
    public DataQualityTemplate getMandatory(String id) throws IOException {
        return this.getMandatory(id, false);
    }

    @Override
    public List<DataQualityTemplate> list() throws IOException {
        return this.list(false);
    }

    @Override
    public List<DataQualityTemplate> listUnsafe() throws IOException {
        return this.list(true);
    }

    @Override
    public List<DataQualityTemplate> list(boolean unsafe) throws IOException {
        ArrayList<DataQualityTemplate> dataQualityTemplates = new ArrayList<DataQualityTemplate>();
        TransactionRef t = TransactionContext.retrieveRead();
        if (!t.isDirectory(DATA_QUALITY_TEMPLATES_FOLDER)) {
            return dataQualityTemplates;
        }
        for (RelFile rf : t.listFiles(DATA_QUALITY_TEMPLATES_FOLDER, (RelFileFilter)FileFilter.json())) {
            String fileName = rf.getLeafName();
            String id = fileName.substring(0, fileName.length() - 5);
            try {
                dataQualityTemplates.add(this.getOrNull(id, unsafe));
            }
            catch (JsonSyntaxException e) {
                logger.warn((Object)("Unable to read data quality template " + id), (Throwable)e);
            }
        }
        return dataQualityTemplates;
    }

    @Override
    public void save(DataQualityTemplate dataQualityTemplate) throws IOException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        t.writeObject(FileBasedDataQualityTemplatesDAO.getDataQualityTemplateFile(dataQualityTemplate.getId()), (Object)dataQualityTemplate);
    }

    @Override
    public void delete(String id) throws IOException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        t.deleteFile(FileBasedDataQualityTemplatesDAO.getDataQualityTemplateFile(id));
    }

    private static RelFile getDataQualityTemplateFile(String id) {
        return new RelFile(DATA_QUALITY_TEMPLATES_FOLDER, new String[]{id + ".json"});
    }
}

