/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.custompython;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.dataflow.ComputableHashComputer;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.datasets.DatasetReadiness;
import com.dataiku.dip.datasets.StreamableDatasetSelection;
import com.dataiku.dip.datasets.UniversalSingleThreadPusher;
import com.dataiku.dip.datasets.custompython.CCDRODatasetHandler;
import com.dataiku.dip.datasets.custompython.CustomDatasetDesc;
import com.dataiku.dip.datasets.custompython.CustomDatasetHandler;
import com.dataiku.dip.datasets.custompython.CustomDatasetParams;
import com.dataiku.dip.datasets.custompython.CustomDatasetTestHandler;
import com.dataiku.dip.input.DatasetTestHandler;
import com.dataiku.dip.input.InputSplit;
import com.dataiku.dip.input.InputSplitProgressListener;
import com.dataiku.dip.input.filter.FilterResultWithSplits;
import com.dataiku.dip.input.filter.InputFilter;
import com.dataiku.dip.input.formats.ExtractionLimit;
import com.dataiku.dip.input.row.RowOrientedDatasetHandler;
import com.dataiku.dip.input.row.RowSequenceInputSplit;
import com.dataiku.dip.input.row.RowsInputSplit;
import com.dataiku.dip.input.utils.CountingProcessorOutput;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitionFactory;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.plugins.LoadedCustomDataset;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class AbstractCustomDatasetHandler<Desc extends CustomDatasetDesc>
extends CCDRODatasetHandler
implements CustomDatasetHandler<Desc>,
AutoCloseable {
    protected final AuthCtx authCtx;
    protected final CustomDatasetParams params;
    protected final LoadedCustomDataset<Desc> desc;
    protected PartitioningScheme forcedPartitioningScheme;
    protected boolean useReadInfoSchemaRatherThanDatasetSchema = false;
    private static Logger logger = Logger.getLogger((String)"dku.datasets.custom.abstract");

    public AbstractCustomDatasetHandler(AuthCtx authCtx, LoadedCustomDataset<Desc> desc, Dataset dataset) {
        super(dataset);
        this.desc = desc;
        this.authCtx = authCtx;
        this.params = dataset.getParamsAs(CustomDatasetParams.class);
    }

    @Override
    public LoadedCustomDataset<Desc> getLoaded() {
        return this.desc;
    }

    public Desc getDesc() {
        return this.desc.desc;
    }

    @Override
    public void checkConfiguration() {
    }

    @Override
    public String suggestName() {
        return this.desc.id;
    }

    @Override
    public boolean executeFastPostCreateOperations() throws Exception {
        return false;
    }

    @Override
    public boolean executeSlowPostCreateOperations_NT() throws Exception {
        return false;
    }

    @Override
    public void executePreRenameOperations() {
    }

    @Override
    public void createManaged() throws Exception {
    }

    @Override
    public DatasetTestHandler buildTestHandler() throws IOException {
        return new CustomDatasetTestHandler(this.authCtx, this.dataset, this);
    }

    @Override
    public boolean outputHandlesClear() {
        return true;
    }

    @Override
    public DatasetReadiness getReadiness(Partition p, @Nullable ComputableHashComputer.ReadinessComputationSession session) {
        if (this.dataset.getParams().isNotReadyIfEmpty()) {
            try {
                logger.info((Object)("Checking whether partition " + p.id() + " is empty"));
                return RowOrientedDatasetHandler.Utils.getReadinessNotEmpty((RowsInputSplit)this.getPartitionSplit(p));
            }
            catch (Exception e) {
                return DatasetReadiness.error(e);
            }
        }
        return DatasetReadiness.ready(null);
    }

    @Override
    public void clearAllData() throws Exception {
        throw new NotImplementedException();
    }

    @Override
    public void clearPartitions(List<Partition> partitions) throws Exception {
        throw new NotImplementedException();
    }

    @Override
    public void clearAllDataAndStructure() throws Exception {
        throw new NotImplementedException();
    }

    @Override
    public void setUseReadInfoSchemaRatherThanDatasetSchema() {
        this.useReadInfoSchemaRatherThanDatasetSchema = true;
    }

    @Override
    public void setForcedPartitioningScheme(PartitioningScheme forcedPartitioningScheme) {
        this.forcedPartitioningScheme = forcedPartitioningScheme;
    }

    protected abstract PartitioningScheme getRemotePartitioningScheme() throws Exception;

    @Override
    public PartitioningScheme getCodeDefinedPartitioning() throws Exception {
        switch (((CustomDatasetDesc)this.desc.desc).partitioningMode) {
            case CODE_DEFINED_LISTABLE: 
            case CODE_DEFINED_UNLISTABLE: {
                return this.getRemotePartitioningScheme();
            }
        }
        return null;
    }

    @Override
    public List<Partition> listPartitions() throws Exception {
        assert (this.forcedPartitioningScheme == null);
        return this.listPartitions(this.dataset.getPartitioningSchema());
    }

    private List<Partition> listPartitions(PartitioningScheme schemeToUse) throws Exception {
        logger.info((Object)("Listing partitions on custom dataset: " + String.valueOf((Object)((CustomDatasetDesc)this.desc.desc).partitioningMode)));
        if (((CustomDatasetDesc)this.desc.desc).partitioningMode == CustomDatasetDesc.PartitioningMode.NOT_PARTITIONABLE) {
            return Lists.newArrayList((Object[])new Partition[]{new Partition(null)});
        }
        if (!StringUtils.isBlank((String)this.params.explicitPartitionsList)) {
            return PartitionFactory.fromPartitionSpec(schemeToUse, this.params.explicitPartitionsList);
        }
        if (((CustomDatasetDesc)this.desc.desc).partitioningMode == CustomDatasetDesc.PartitioningMode.CODE_DEFINED_UNLISTABLE || ((CustomDatasetDesc)this.desc.desc).partitioningMode == CustomDatasetDesc.PartitioningMode.USER_DEFINED_UNLISTABLE) {
            throw ErrorContext.iaef((String)"Dataset %s cannot list partitions, and no explicit list has been given.You might need to specify an explicit partition", (Object)this.dataset.getName(), (Object[])new Object[0]);
        }
        List<String> partitionIds = this.getRemoteListPartitions(schemeToUse);
        ArrayList partitions = Lists.newArrayList();
        for (String partitionId : partitionIds) {
            partitions.add(PartitionFactory.fromIdentifier(schemeToUse, partitionId));
        }
        return partitions;
    }

    protected abstract List<String> getRemoteListPartitions(PartitioningScheme var1) throws Exception;

    @Override
    public long getRecords() throws Exception {
        if (((CustomDatasetDesc)this.desc.desc).canCountRecords) {
            return this.getRemoteCountRecords();
        }
        CountingProcessorOutput counting = new CountingProcessorOutput();
        UniversalSingleThreadPusher.push(this.authCtx, this.dataset, (ProcessorOutput)counting, (ColumnFactory)new StreamColumnFactory(), (RowFactory)new StreamRowFactory());
        return counting.getCount();
    }

    protected abstract long getRemoteCountRecords() throws Exception;

    @Override
    public long getPartitionRecords(Partition p) throws Exception {
        assert (this.forcedPartitioningScheme == null);
        if (((CustomDatasetDesc)this.desc.desc).canCountRecords) {
            return this.getRemotePartitionCountRecords(p);
        }
        CountingProcessorOutput counting = new CountingProcessorOutput();
        StreamableDatasetSelection sel = StreamableDatasetSelection.full();
        sel.withSelectedPartitions(Lists.newArrayList((Object[])new Partition[]{p}));
        UniversalSingleThreadPusher.push(this.authCtx, this.dataset, sel, (ProcessorOutput)counting, (ColumnFactory)new StreamColumnFactory(), (RowFactory)new StreamRowFactory());
        return counting.getCount();
    }

    protected abstract long getRemotePartitionCountRecords(Partition var1) throws Exception;

    @Override
    public boolean partitionExists(Partition p) throws Exception {
        assert (this.forcedPartitioningScheme == null);
        if (((CustomDatasetDesc)this.desc.desc).canCheckPartitionExistence) {
            return this.getRemotePartitionExists(this.dataset.getPartitioningSchema(), p);
        }
        if ((((CustomDatasetDesc)this.desc.desc).partitioningMode == CustomDatasetDesc.PartitioningMode.CODE_DEFINED_UNLISTABLE || ((CustomDatasetDesc)this.desc.desc).partitioningMode == CustomDatasetDesc.PartitioningMode.USER_DEFINED_UNLISTABLE) && StringUtils.isBlank((String)this.params.explicitPartitionsList)) {
            return true;
        }
        List<Partition> partitions = this.listPartitions();
        for (Partition pl : partitions) {
            if (!pl.equals((Object)p)) continue;
            return true;
        }
        return false;
    }

    protected abstract boolean getRemotePartitionExists(PartitioningScheme var1, Partition var2) throws Exception;

    protected abstract long remotePush(ProcessorOutput var1, ColumnFactory var2, RowFactory var3, long var4, Partition var6) throws Exception;

    @Override
    public RowsInputSplit getSingleSplit() throws Exception {
        ArrayList<Split> splits = new ArrayList<Split>();
        if (this.dataset.getPartitioningSchema().isPartitioned()) {
            for (Partition part : this.listPartitions()) {
                Split split = new Split(part);
                splits.add(split);
            }
        } else {
            splits.add(new Split());
        }
        return new RowSequenceInputSplit(splits);
    }

    @Override
    public RowsInputSplit getSampleSplit() throws Exception {
        PartitioningScheme schemeToUse = this.dataset.getPartitioningSchema();
        if (this.forcedPartitioningScheme != null) {
            schemeToUse = this.forcedPartitioningScheme;
        }
        if (schemeToUse.isPartitioned()) {
            if (StringUtils.isBlank((String)this.params.previewPartition) && !this.params.previewAllPartitions) {
                throw ErrorContext.iae((String)"Please specify a partition for preview or check 'preview all partitions'");
            }
            if (this.params.previewAllPartitions) {
                ArrayList<Split> splits = new ArrayList<Split>();
                for (Partition part : this.listPartitions(schemeToUse)) {
                    Split split = new Split(part);
                    splits.add(split);
                }
                return new RowSequenceInputSplit(splits);
            }
            return new Split(PartitionFactory.fromIdentifier(schemeToUse, this.params.previewPartition));
        }
        return new Split();
    }

    @Override
    public InputSplit getPartitionSplit(Partition partition) throws Exception {
        assert (this.forcedPartitioningScheme == null);
        if (this.dataset.getPartitioningSchema().isPartitioned()) {
            return new Split(partition);
        }
        return new Split();
    }

    @Override
    public FilterResultWithSplits getFilterSplits(InputFilter filter) throws Exception {
        assert (this.forcedPartitioningScheme == null);
        FilterResultWithSplits frws = new FilterResultWithSplits();
        if (this.dataset.getPartitioningSchema().isPartitioned()) {
            if (filter.hasPartitionsFiltering()) {
                for (Partition partition : filter.getPartitionsClause()) {
                    frws.withMatchingPartition(partition).withSplit((InputSplit)new Split(partition));
                }
            } else {
                for (Partition partition : this.listPartitions()) {
                    frws.withMatchingPartition(partition).withSplit((InputSplit)new Split(partition));
                }
            }
        } else {
            frws.withSplit((InputSplit)new Split());
        }
        frws.setNeedsRefilter(true);
        return frws;
    }

    class Split
    extends RowsInputSplit {
        private Partition partition;

        Split() {
            this.partition = null;
        }

        Split(Partition partition) {
            this.partition = partition;
        }

        public String getDesc() {
            return null;
        }

        @Override
        public long push(ProcessorOutput out, ColumnFactory cf, RowFactory rf, ExtractionLimit limit, InputSplitProgressListener listener, WarningsContext warningsContext) throws Exception {
            return AbstractCustomDatasetHandler.this.remotePush(out, cf, rf, limit == null ? -1L : limit.maxRecords, this.partition);
        }
    }
}

