/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.sql;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.connections.MetastoreDBBasedConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.datalayer.memimpl.MemTableAppendingOutput;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.SchemaDetection;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetTestHandler;
import com.dataiku.dip.datasets.sql.bigquery.BigQueryDatasetConfig;
import com.dataiku.dip.exceptions.SchemaMismatchException;
import com.dataiku.dip.input.DatasetTestHandler;
import com.dataiku.dip.input.formats.ExtractionLimit;
import com.dataiku.dip.input.row.RowOrientedDatasetHandler;
import com.dataiku.dip.input.row.RowsInputSplit;
import com.dataiku.dip.partitioning.Dimension;
import com.dataiku.dip.partitioning.ExactValueDimension;
import com.dataiku.dip.partitioning.TimeDimension;
import com.dataiku.dip.resourceusage.ComputeResourceUsageContext;
import com.dataiku.dip.resourceusage.CurrentComputeResourceUsageContext;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.shaker.server.SerializedMemTableSimple;
import com.dataiku.dip.shaker.services.TypeInferrer2;
import com.dataiku.dip.sql.BigQueryUtils;
import com.dataiku.dip.sql.OracleSQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.SchemaReader;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import org.apache.commons.lang.StringUtils;

public class ManagedSQLTableDatasetTestHandler
extends AbstractSQLDatasetTestHandler {
    private TypeInferrer2 inferer = new TypeInferrer2();
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.datasets.sql");

    public ManagedSQLTableDatasetTestHandler(AuthCtx authCtx, Dataset dataset, DatasetHandler dh) {
        super(authCtx, dataset, dh);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ManagedSQLDatasetTestResult test(boolean connectionOnly, AuthCtx liu) throws Exception {
        assert (DatasetInspector.isSQL(this.dataset));
        CurrentComputeResourceUsageContext.setInCurrentThreadIfNull((ComputeResourceUsageContext)ComputeResourceUsageContext.forDatasetOrConnectionTesting((AuthCtx)this.authCtx, (String)this.dataset.getProjectKey(), (String)this.dataset.getName()));
        ManagedSQLDatasetTestResult ret = new ManagedSQLDatasetTestResult();
        ret.testedConnectionOnly = connectionOnly;
        try (AbstractSQLDatasetTestHandler.ConnRet cr = this.checkConfigDriverAndConnection(ret);){
            Object object;
            if (!cr.cd.getConnection().isFreelyUsableBy(liu)) {
                throw new SecurityException("You may not test on connection " + cr.cd.getConnection().name);
            }
            if (StringUtils.isBlank((String)this.config.table)) {
                ManagedSQLDatasetTestResult managedSQLDatasetTestResult = ret;
                return managedSQLDatasetTestResult;
            }
            ret.tableSpecified = true;
            SQLUtils.SQLTable tableConf = SQLUtils.resolveAndExpandSQLCatalogAndSchema(cr.cd, this.dataset.getProjectKey(), this.config.catalog, this.config.schema);
            String resolvedCatalog = tableConf.getCatalog();
            String resolvedSchema = tableConf.getSchemaNullIfBlank();
            SQLDialect dialect = cr.cd.getDialect();
            try {
                ret.autogeneratedCreateStatement = dialect.generateTableStatementSQL(cr.cd.getConnection(), this.dataset, new InfoMessage.InfoMessages(), false);
            }
            catch (Exception e) {
                ret.connectionOK = false;
                ret.connectionError = new SerializedError((Throwable)e, false);
                ManagedSQLDatasetTestResult managedSQLDatasetTestResult = ret;
                if (cr == null) return managedSQLDatasetTestResult;
                cr.close();
                return managedSQLDatasetTestResult;
            }
            ret.tableExists = dialect.tableExists(this.authCtx, cr.cd, cr.jdbcConn, resolvedCatalog, resolvedSchema, this.config.table, this.dataset.getProjectKey());
            ret.connectionOK = true;
            if (!ret.tableExists) {
                logger.info((Object)("Table " + this.config.table + " does not exist"));
                ManagedSQLDatasetTestResult e = ret;
                return e;
            }
            AbstractSQLDatasetHandler.ReadTemporalMode datetimenotzReadMode = this.config.datetimenotzReadMode;
            AbstractSQLDatasetHandler.ReadTemporalMode dateonlyReadMode = this.config.dateonlyReadMode;
            if (this.dataset.isManaged()) {
                if (this.dataset.getTypeSystemVersion() == SerializedDataset.TypeSystemVersion.V1) {
                    datetimenotzReadMode = AbstractSQLDatasetHandler.ReadTemporalMode.AS_STRING;
                    dateonlyReadMode = AbstractSQLDatasetHandler.ReadTemporalMode.AS_DATE;
                } else {
                    datetimenotzReadMode = AbstractSQLDatasetHandler.ReadTemporalMode.AS_IS;
                    dateonlyReadMode = AbstractSQLDatasetHandler.ReadTemporalMode.AS_IS;
                }
            }
            dateonlyReadMode = OracleSQLDialect.adjustDateonlyReadMode(dateonlyReadMode, datetimenotzReadMode, cr.cd.getDialect(), this.dataset);
            SQLUtils.SQLTable sqlTable = null;
            if (dialect.isSchemaAware() && StringUtils.isBlank((String)resolvedSchema) || dialect.isCatalogAware() && StringUtils.isBlank((String)resolvedCatalog)) {
                MetastoreDBBasedConnection metastoreConnection;
                String schema = resolvedSchema;
                object = cr.cd.getConnection();
                if (object instanceof MetastoreDBBasedConnection && StringUtils.isBlank((String)(schema = (metastoreConnection = (MetastoreDBBasedConnection)object).getDatabaseName()))) {
                    schema = null;
                }
                try {
                    sqlTable = SQLUtils.getTableMetadata(cr.cd, cr.jdbcConn, resolvedCatalog, schema, this.config.table);
                }
                catch (Exception e) {
                    logger.error((Object)"Could not retrieve table", (Throwable)e);
                }
            }
            SchemaReader.SchemaWithInfo sch = SchemaReader.tryGetTableSchemaWithInfoAndComments(this.authCtx, cr.cd, cr.jdbcConn, resolvedCatalog, resolvedSchema, this.config.table, datetimenotzReadMode, dateonlyReadMode, null, sqlTable);
            this.dataset.fixupSchemaPerDatasetConstraint(this.authCtx, sch.schema);
            ret.currentTableSchema = new Schema(sch.schema);
            ret.nativePartitioningMatchesTable = true;
            ret.datasetPartitioningMatchesTable = true;
            if (dialect.supportsTablePartitionInfoRetrieval() && (object = this.config) instanceof BigQueryDatasetConfig) {
                BigQueryDatasetConfig bigQueryDatasetConfig = (BigQueryDatasetConfig)object;
                boolean remoteTableIsPartitioned = sch.tablePartitionInfo != null && sch.tablePartitionInfo.dimension != null;
                boolean bigQueryTablePartitioningEnabled = bigQueryDatasetConfig.useBigQueryPartitioning && StringUtils.isNotBlank((String)bigQueryDatasetConfig.bigQueryPartitioningField);
                boolean bl = ret.nativePartitioningMatchesTable = bigQueryTablePartitioningEnabled == remoteTableIsPartitioned;
                if (ret.nativePartitioningMatchesTable && remoteTableIsPartitioned) {
                    Dimension dimension;
                    ret.nativePartitioningMatchesTable = bigQueryDatasetConfig.bigQueryPartitioningField.equals(sch.tablePartitionInfo.dimension.getName());
                    if (ret.nativePartitioningMatchesTable && (dimension = sch.tablePartitionInfo.dimension) instanceof TimeDimension) {
                        TimeDimension remoteTimeDimension = (TimeDimension)dimension;
                        BigQueryDatasetConfig.DatePartitioningPeriod timeDimensionPeriod = BigQueryDatasetConfig.DatePartitioningPeriod.fromTimeDimensionPeriod(remoteTimeDimension.mappedPeriod);
                        ret.nativePartitioningMatchesTable = bigQueryDatasetConfig.bigQueryPartitioningPeriod == timeDimensionPeriod;
                    } else if (ret.nativePartitioningMatchesTable && (dimension = sch.tablePartitionInfo.dimension) instanceof ExactValueDimension) {
                        ExactValueDimension remoteExactValueDimension = (ExactValueDimension)dimension;
                        ret.nativePartitioningMatchesTable = remoteExactValueDimension.integerRangeInfo != null && bigQueryDatasetConfig.bigQueryPartitioningRangeInterval == remoteExactValueDimension.integerRangeInfo.interval() && bigQueryDatasetConfig.bigQueryPartitioningRangeStart == remoteExactValueDimension.integerRangeInfo.start() && bigQueryDatasetConfig.bigQueryPartitioningRangeEnd == remoteExactValueDimension.integerRangeInfo.end();
                    }
                }
                ret.datasetPartitioningMatchesTable = !BigQueryUtils.hasPartitioningConsistencyMismatch(sch.tablePartitionInfo, this.dataset.getPartitioningSchema());
            }
            try {
                SchemaDetection.addCustomFieldsToDetectedSchema(this.dataset.getSchema(), ret.currentTableSchema);
                SchemaReader.isManagedSchemaCompatible(this.dataset.getSchema(), this.dataset, cr.jdbcConn, resolvedCatalog, resolvedSchema, this.config.table, cr.cd);
                ret.schemaMatchesTable = true;
                ret.schemaDetection = new SchemaDetection.SchemaDetectionResult();
                ret.schemaDetection.detectedSchema = ret.currentTableSchema;
                SchemaDetection.updateDetectionResultWithCommentCheck(ret.schemaDetection, this.dataset.getSchema(), ret.schemaDetection.detectedSchema);
            }
            catch (SchemaMismatchException e) {
                ret.schemaMismatchMsg = ExceptionUtils.getMessageWithCauses((Throwable)e);
            }
            this.dataset.setSchema(null);
        }
        catch (Exception e) {
            ret.connectionOK = false;
            ret.connectionError = new SerializedError((Throwable)e, false);
            return ret;
        }
        if (connectionOnly) {
            return ret;
        }
        logger.info((Object)"Gathering SQL table preview");
        try {
            RowsInputSplit split = ((RowOrientedDatasetHandler)this.dh).getSampleSplit();
            MemTable mt = new MemTable();
            if (split != null) {
                split.push((ProcessorOutput)new MemTableAppendingOutput(mt), mt, mt, new ExtractionLimit(100L), null, null);
            }
            this.inferer.processFullAuto(null, mt);
            SerializedMemTableSimple smt = new SerializedMemTableSimple();
            smt.fromMemTable(mt, 0, mt.nrows());
            ret.preview = smt;
            return ret;
        }
        catch (Exception e) {
            logger.error((Object)"Failed to get preview", (Throwable)e);
            ret.previewErrorMsg = ExceptionUtils.getMessageWithCauses((Throwable)e);
        }
        return ret;
    }

    @Override
    public DatasetTestHandler.SchemaConsistencyResult testSchemaConsistency() throws Exception {
        DatasetTestHandler.SchemaConsistencyResult ret = new DatasetTestHandler.SchemaConsistencyResult();
        Schema datasetSchema = this.dataset.getSchema().getCopy();
        ManagedSQLDatasetTestResult result = this.test(false, null);
        boolean bl = ret.empty = !result.tableExists;
        if (result.schemaDetection != null && result.schemaDetection.needsCommentSynchronization) {
            ret.result = result.schemaDetection;
            ret.result.type = SchemaDetection.SchemaHandlingType.FIXED_TYPE_AND_SCHEMA;
            ret.result.newSchema = datasetSchema;
            ret.result.detectedSchema = result.currentTableSchema;
            return ret;
        }
        ret.result = new SchemaDetection.SchemaDetectionResult();
        ret.result.type = SchemaDetection.SchemaHandlingType.FIXED_TYPE_AND_SCHEMA;
        if (!ret.empty && !result.schemaMatchesTable) {
            ret.result.setWarningLevel(SchemaDetection.WarningLevel.FATAL);
            ret.result.textReasons.add(result.schemaMismatchMsg);
            ret.result.newSchema = result.currentTableSchema;
            ret.result.detectedSchema = result.currentTableSchema;
        }
        return ret;
    }

    @Override
    public InfoMessage.InfoMessages checkManagedDatasetNameSafety(String newDatasetName) throws Exception {
        InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
        if (StringUtils.isBlank((String)newDatasetName)) {
            ret.withFatal((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_NAME, "Empty dataset name");
            return ret;
        }
        ManagedSQLDatasetTestResult tr = new ManagedSQLDatasetTestResult();
        try (AbstractSQLDatasetTestHandler.ConnRet cr = this.checkConfigDriverAndConnection(tr);){
            int maxLength = cr.cd.getDialect().getIdentifiersMaxLength();
            if (maxLength > 0 && newDatasetName.length() > maxLength) {
                ret.withWarningV((InfoMessage.MessageCode)DatasetCodes.WARN_DATASET_UNSAFE_NAME, "Your database does not seem to support identifiers with more than %d characters.", new Object[]{maxLength});
            }
            if (StringUtils.isBlank((String)this.config.table)) {
                ret.withFatalV((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_CONFIG, "No table specified for '%s'.", new Object[]{newDatasetName});
            } else {
                SQLDialect dialect = cr.cd.getDialect();
                if (dialect.tableExists(this.authCtx, cr.cd, cr.jdbcConn, this.config.catalog, this.config.schema, this.config.table, this.dataset.getProjectKey())) {
                    ret.withWarningV((InfoMessage.MessageCode)DatasetCodes.WARN_DATASET_MANAGED_UNSAFE_NAME, "Table '%s' already exists in the database. It will be overwritten and may need to be dropped even if partitioned.", new Object[]{newDatasetName});
                }
            }
        }
        catch (Exception e) {
            logger.info((Object)"Failed to check if the new dataset name is safe", (Throwable)e);
            ret.withWarning((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_GENERIC_ERROR, "Failed to check if the new dataset name is safe, there could be a problem with the database: " + ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
        return ret;
    }

    public static class ManagedSQLDatasetTestResult
    extends AbstractSQLDatasetTestHandler.SQLDatasetTestResult {
        public boolean tableSpecified = false;
        public String autogeneratedCreateStatement;
        public boolean queryOK;
        public boolean tableExists;
        public Schema currentTableSchema;
        public boolean schemaMatchesTable;
        public String schemaMismatchMsg;
        public boolean nativePartitioningMatchesTable;
        public boolean datasetPartitioningMatchesTable;
    }
}

