/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.sql;

import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.memimpl.MemTableAppendingOutput;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.sql.AbstractSQLQueryDatasetHandler;
import com.dataiku.dip.exceptions.DataStoreIOException;
import com.dataiku.dip.input.InputSplit;
import com.dataiku.dip.input.InputSplitProgressListener;
import com.dataiku.dip.input.filter.FilterResultWithSplits;
import com.dataiku.dip.input.filter.InputFilter;
import com.dataiku.dip.input.formats.ExtractionLimit;
import com.dataiku.dip.input.row.RowsInputSplit;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.warnings.WarningsContext;
import com.dataiku.dss.shadelib.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.commons.lang3.StringUtils;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;

public class UnpartitionedSQLQueryDatasetHandler
extends AbstractSQLQueryDatasetHandler {
    public UnpartitionedSQLQueryDatasetHandler(AuthCtx authCtx, Dataset dataset, DatasetHandler.DatasetMeta<?, ?> meta) {
        super(authCtx, dataset, meta);
    }

    @Override
    public void checkConfiguration() throws IllegalArgumentException, IOException {
    }

    @Override
    public List<Partition> listPartitions() throws Exception {
        return Lists.newArrayList((Object[])new Partition[]{new Partition(null)});
    }

    @Override
    public boolean partitionExists(Partition p) throws Exception {
        return true;
    }

    @Override
    public InputSplit getPartitionSplit(Partition partition) throws Exception {
        return this.getSingleSplit();
    }

    @Override
    public FilterResultWithSplits getFilterSplits(InputFilter filter) throws Exception {
        return new FilterResultWithSplits().withMatchingPartition(new Partition(null)).withSplit((InputSplit)this.getSingleSplit());
    }

    @Override
    public RowsInputSplit getSingleSplit() throws Exception {
        return new AbstractSQLQueryDatasetHandler.QueryBasedSplit(this.expandQueryForPartition(null));
    }

    @Override
    public RowsInputSplit getSampleSplit() throws Exception {
        return new AbstractSQLQueryDatasetHandler.QueryBasedSplit(this.expandQueryForPartition(null));
    }

    @Override
    public long getPartitionRecords(Partition p) throws Exception {
        return this.getRecords();
    }

    @Override
    protected RowsInputSplit getHasDataSplit() throws Exception {
        return new HasDataSplit(this.expandQueryForPartition(null));
    }

    class HasDataSplit
    extends RowsInputSplit {
        private final String query;

        HasDataSplit(String query) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)query));
            this.query = query;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long push(ProcessorOutput out, ColumnFactory cf, RowFactory rf, ExtractionLimit limit, InputSplitProgressListener listener, WarningsContext warningsContext) throws Exception {
            long l;
            String q = limit != null && limit.maxRecords > 0L ? UnpartitionedSQLQueryDatasetHandler.this.insertLimitClause(this.query, limit.maxRecords) : this.query;
            SQLConnectionProvider.SQLConnectionWrapper conn = UnpartitionedSQLQueryDatasetHandler.this.newConnection();
            try {
                l = UnpartitionedSQLQueryDatasetHandler.this.executePush(conn, q, out, cf, rf, limit, listener, warningsContext, false);
            }
            catch (Throwable throwable) {
                try {
                    SQLUtils.unsafeRollbackAndClose(conn);
                    throw throwable;
                }
                catch (MemTableAppendingOutput.MemTableSizeLimitReachedException e) {
                    throw e;
                }
                catch (IOException e) {
                    throw new DataStoreIOException("Failed to read data from table", (Throwable)e);
                }
            }
            SQLUtils.unsafeRollbackAndClose(conn);
            return l;
        }

        public String getDesc() {
            return "SQLQuery hasData";
        }
    }
}

