/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.sql.bigquery;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionUtils;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.dataflow.exec.filter.FilterDescUtils;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.dynamic.VariablesExpansionLoopItemsIterable;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.datasets.sql.AbstractSQLTableDatasetHandler;
import com.dataiku.dip.datasets.sql.GenericSQLDatasetMeta;
import com.dataiku.dip.datasets.sql.PartitionedSQLQueryDatasetHandler;
import com.dataiku.dip.datasets.sql.PartitionedSQLTableDatasetHandler;
import com.dataiku.dip.datasets.sql.SQLExceptionsParser;
import com.dataiku.dip.datasets.sql.SQLViaCloudAutoFastPathBuilder;
import com.dataiku.dip.datasets.sql.SQLViaCloudAutoFastPathOutput;
import com.dataiku.dip.datasets.sql.UnpartitionedSQLQueryDatasetHandler;
import com.dataiku.dip.datasets.sql.UnpartitionedSQLTableDatasetHandler;
import com.dataiku.dip.datasets.sql.bigquery.BigQueryDatasetConfig;
import com.dataiku.dip.datasets.sql.bigquery.BigQuerySQLTableOutput;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.DataStoreIOException;
import com.dataiku.dip.input.InputSplit;
import com.dataiku.dip.input.InputSplitProgressListener;
import com.dataiku.dip.input.filter.InputFilter;
import com.dataiku.dip.input.formats.ExtractionLimit;
import com.dataiku.dip.input.row.RowSequenceInputSplit;
import com.dataiku.dip.input.row.RowsInputSplit;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.partitioning.Dimension;
import com.dataiku.dip.partitioning.DimensionValue;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.partitioning.TimeDimension;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.sql.BigQueryUtils;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.SchemaReader;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.ExpressionUtils;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.variables.DynamicLevelsStack;
import com.dataiku.dip.warnings.WarningsContext;
import com.dataiku.dss.shadelib.com.google.common.base.Joiner;
import com.dataiku.dss.shadelib.com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class BigQuerySQLDatasetMeta
extends GenericSQLDatasetMeta {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.datasets.sql");

    @Override
    public Class<? extends DatasetHandler.DatasetParams> paramsClass() {
        return BigQueryDatasetConfig.class;
    }

    @Override
    public String getType() {
        return "BigQuery";
    }

    @Override
    public DatasetHandler build(AuthCtx authCtx, Dataset dataset) {
        AbstractSQLDatasetHandler.AbstractSQLConfig config = (AbstractSQLDatasetHandler.AbstractSQLConfig)dataset.getParams();
        String mode = config.mode == null ? "table" : config.mode;
        boolean partitioned = dataset.getPartitioningSchema() != null && dataset.getPartitioningSchema().isPartitioned();
        switch (mode) {
            case "table": {
                if (partitioned) {
                    return new BigQueryPartitionedSQLTableDatasetHandler(authCtx, dataset, this);
                }
                return new BigQueryUnpartitionedSQLTableDatasetHandler(authCtx, dataset, this);
            }
            case "query": {
                if (partitioned) {
                    return new PartitionedSQLQueryDatasetHandler(authCtx, dataset, this);
                }
                return new UnpartitionedSQLQueryDatasetHandler(authCtx, dataset, this);
            }
        }
        throw ErrorContext.iaef((String)"Invalid SQL dataset mode : '%s' expected 'query' or 'table'", (Object)mode, (Object[])new Object[0]);
    }

    protected static String getPreviewTablePseudoSQL(ExtractionLimit limit, String catalog, String schema, String table, boolean forbidPreviewFallbackToSelect) throws SQLException {
        return BigQuerySQLDatasetMeta.getPreviewTablePseudoSQL(limit, catalog, schema, table, forbidPreviewFallbackToSelect, null, null);
    }

    protected static String getPreviewTablePseudoSQL(ExtractionLimit limit, String catalog, String schema, String table, boolean forbidPreviewFallbackToSelect, @Nullable Partition partition, @Nullable String partitionWhereClause) throws SQLException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)schema), (Object)"BigQuery dataset Id cannot be empty or null.");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)table), (Object)"BigQuery table Id cannot be empty or null.");
        ArrayList<String> parts = new ArrayList<String>();
        parts.add("PREVIEW TABLE");
        parts.add((String)StringUtils.defaultIfBlank((CharSequence)catalog, (CharSequence)""));
        parts.add(schema);
        parts.add(table);
        parts.add(String.valueOf(limit != null ? limit.maxRecords : -1L));
        parts.add(String.valueOf(forbidPreviewFallbackToSelect));
        if (partition != null && !partition.getScheme().getDimensionNames().isEmpty() && partitionWhereClause != null) {
            String dimensionName = (String)partition.getScheme().getDimensionNames().get(0);
            Dimension dimension = partition.getScheme().getDimension(dimensionName);
            if (dimension != null && partition.getDimensionValues().containsKey(dimensionName)) {
                parts.add(dimension.getType());
                parts.add(dimensionName);
                parts.add(((DimensionValue)partition.getDimensionValues().get(dimensionName)).id());
                parts.add(partitionWhereClause);
            } else {
                throw new SQLException("Invalid dimension information for " + dimensionName + " in partition for preview table pseudo-SQL. Partition WHERE clause was: " + partitionWhereClause);
            }
        }
        return Joiner.on((String)"\n").join(parts);
    }

    private static boolean canUseDirectTablePreview(ExtractionLimit limit, SQLConnectionProvider.SQLConnectionData connectionData, InputFilter filter) {
        boolean useDriver = ((SQLConnectionProvider.BigQuerySQLConnectionData)connectionData).useDriver;
        return !useDriver && !BigQuerySQLDatasetMeta.hasOrdering(limit) && !BigQuerySQLDatasetMeta.hasLargeMaxRecords(limit) && !BigQuerySQLDatasetMeta.hasFilter(filter);
    }

    private static boolean hasLargeMaxRecords(ExtractionLimit limit) {
        return limit != null && limit.maxRecords >= Integer.MAX_VALUE;
    }

    private static boolean hasOrdering(ExtractionLimit limit) {
        return limit != null && limit.ordering != null && limit.ordering.enabled && !limit.ordering.rules.isEmpty();
    }

    private static boolean hasFilter(InputFilter filter) {
        return filter != null && FilterDescUtils.willFilter(filter.getFilter());
    }

    private static boolean shouldForbidPreviewFallbackToSelect(AbstractSQLDatasetHandler.AbstractSQLConfig abstractSQLConfig) {
        if (abstractSQLConfig instanceof BigQueryDatasetConfig) {
            return ((BigQueryDatasetConfig)abstractSQLConfig).forbidPreviewFallbackToSelect;
        }
        return false;
    }

    private static class BigQueryPartitionedSQLTableDatasetHandler
    extends PartitionedSQLTableDatasetHandler {
        public static final String PARTITIONS_TABLE = "INFORMATION_SCHEMA.PARTITIONS";
        public static final String PARTITION_ID_COL = "PARTITION_ID";
        private static final Pattern INTEGER_PATTERN = Pattern.compile("[0-9]+");
        private volatile Boolean storedPartitionSchemeMatchesBigQuery;

        public BigQueryPartitionedSQLTableDatasetHandler(AuthCtx authCtx, Dataset dataset, DatasetHandler.DatasetMeta<?, ?> meta) {
            super(authCtx, dataset, meta);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        protected String getListPartitionQuery() throws DKUSecurityException {
            block4: {
                block3: {
                    builder = new SelectQueryBuilder();
                    builder.selectDistinct();
                    builder.limit(BigQueryPartitionedSQLTableDatasetHandler.MAX_PARTITIONS + 1L);
                    if (!this.partitionSchemeMatchesBigQuery()) break block3;
                    builder.from(this.resolvedAbstractConfig.catalog, this.resolvedAbstractConfig.schema, "INFORMATION_SCHEMA.PARTITIONS", null);
                    expressionBuilderFactory = new ExpressionBuilder.ExpressionBuilderFactory();
                    whereTable = expressionBuilderFactory.col("table_name").eq(this.resolvedAbstractConfig.table);
                    builder.where(new ExpressionBuilder[]{whereTable});
                    builder.select("PARTITION_ID");
                    break block4;
                }
                var4_6 = this.resolvedAbstractConfig;
                if (!(var4_6 instanceof BigQueryDatasetConfig)) ** GOTO lbl-1000
                bigQueryConfig = (BigQueryDatasetConfig)var4_6;
                if (bigQueryConfig.requiresPartitionFilter) {
                    v0 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v0 = false;
                }
                needDummyPartitionFilter = v0;
                builder.from(this.resolvedAbstractConfig.catalog, this.resolvedAbstractConfig.schema, this.resolvedAbstractConfig.table, null);
                for (String dimensionName : this.dataset.getPartitioningSchema().getDimensionNames()) {
                    partitioningExpression = ExpressionUtils.getPartitionColumnExpression(dimensionName, this.dataset, this.getDialect());
                    builder.select(partitioningExpression, dimensionName);
                    if (!needDummyPartitionFilter) continue;
                    expressionBuilderFactory = new ExpressionBuilder.ExpressionBuilderFactory();
                    builder.where(new ExpressionBuilder[]{expressionBuilderFactory.col(dimensionName).isnotnull()});
                }
            }
            return builder.toSQL(this.getDialect());
        }

        @Override
        public RowsInputSplit getSingleSplit() throws Exception {
            this.throwIfVELoopConfigEnabled();
            return new BigQueryTableClauseSplit(null);
        }

        @Override
        public RowsInputSplit getSampleSplit() throws Exception {
            return new BigQueryTableClauseSplit(null);
        }

        @Override
        public InputSplit getPartitionSplit(@Nullable Partition partition, @Nullable InputFilter filter) {
            return new BigQueryTablePartitionSplit(partition, filter);
        }

        @Override
        protected List<Partition> gatherPartitionsFromResultSet(ResultSet rs2, SQLDialect dialect) throws SQLException, DataStoreIOException {
            if (!this.partitionSchemeMatchesBigQuery()) {
                return super.gatherPartitionsFromResultSet(rs2, dialect);
            }
            PartitioningScheme partitionScheme = this.dataset.getPartitioningSchema();
            Dimension partitionDimension = partitionScheme.getSingleDimension();
            ArrayList<Partition> res = new ArrayList<Partition>();
            long nbPartitions = 0L;
            while (rs2.next()) {
                String formattedPartitionString;
                if (++nbPartitions > MAX_PARTITIONS) {
                    throw new DataStoreIOException("Maximum number of partitions has been reached (current limit is " + MAX_PARTITIONS + " partitions).");
                }
                String rawPartitionString = rs2.getString(PARTITION_ID_COL);
                if (StringUtils.isBlank((CharSequence)rawPartitionString)) {
                    throw ErrorContext.iae((String)("One of the partition values for " + this.dataset.getFullName() + " is null or empty, unsupported"));
                }
                if ("__UNPARTITIONED__".equals(rawPartitionString) || "__NULL__".equals(rawPartitionString)) continue;
                if (!INTEGER_PATTERN.matcher(rawPartitionString).matches()) {
                    logger.warn((Object)("Invalid partition value for " + this.dataset.getFullName() + ": " + rawPartitionString));
                    continue;
                }
                if (partitionDimension instanceof TimeDimension) {
                    TimeDimension timeDim = (TimeDimension)partitionDimension;
                    formattedPartitionString = this.formatTimeDimensionFromBigQueryPartitionId(rawPartitionString, timeDim);
                } else {
                    formattedPartitionString = rawPartitionString;
                }
                DimensionValue dimensionValue = partitionDimension.getValueFromId(formattedPartitionString);
                Partition partition = new Partition(partitionScheme);
                partition.setDimensionValue(partitionDimension.getName(), dimensionValue);
                res.add(partition);
            }
            return res;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean partitionSchemeMatchesBigQuery() {
            if (this.storedPartitionSchemeMatchesBigQuery == null) {
                BigQueryPartitionedSQLTableDatasetHandler bigQueryPartitionedSQLTableDatasetHandler = this;
                synchronized (bigQueryPartitionedSQLTableDatasetHandler) {
                    if (this.storedPartitionSchemeMatchesBigQuery == null) {
                        try {
                            AbstractSQLConnection sqlConnection = this.getDSSConnection();
                            SQLDialect dialect = sqlConnection.getDialect();
                            SchemaReader.TablePartitionInfo bigQueryPartitionInfo = dialect.retrieveTablePartitionInfo(this.authCtx, sqlConnection, this.resolvedAbstractConfig.catalog, this.resolvedAbstractConfig.schema, this.resolvedAbstractConfig.table);
                            this.storedPartitionSchemeMatchesBigQuery = BigQueryUtils.partitionSchemeMatches(this.dataset, bigQueryPartitionInfo);
                        }
                        catch (Exception e) {
                            logger.warn((Object)("Could not gather partitioning info for BigQuery table for dataset " + this.dataset.getName()), (Throwable)e);
                            this.storedPartitionSchemeMatchesBigQuery = false;
                        }
                    }
                }
            }
            return this.storedPartitionSchemeMatchesBigQuery;
        }

        private String formatTimeDimensionFromBigQueryPartitionId(String rawString, TimeDimension dim) {
            return switch (dim.mappedPeriod) {
                default -> throw new IncompatibleClassChangeError();
                case TimeDimension.Period.YEAR -> rawString.substring(0, 4);
                case TimeDimension.Period.MONTH -> rawString.substring(0, 4) + "-" + rawString.substring(4, 6);
                case TimeDimension.Period.DAY -> rawString.substring(0, 4) + "-" + rawString.substring(4, 6) + "-" + rawString.substring(6, 8);
                case TimeDimension.Period.HOUR -> rawString.substring(0, 4) + "-" + rawString.substring(4, 6) + "-" + rawString.substring(6, 8) + "-" + rawString.substring(8, 10);
            };
        }

        @Override
        public Output buildOutput(Partition targetPartition, int targetSplit, int resplitFactor, WarningsContext warningsContext) throws Exception {
            ConnectionUtils.checkConnectionWritable(this.authCtx, this.resolvedAbstractConfig.connection);
            assert (targetSplit == 0);
            SQLViaCloudAutoFastPathOutput fp = new SQLViaCloudAutoFastPathBuilder().buildIfCanUseAutoFastPath(this, targetPartition, warningsContext);
            if (fp != null) {
                logger.info((Object)"Using automatic fast-write SQL output");
                return fp;
            }
            logger.info((Object)"Using SQL output based on the BigQuery Storage Write API");
            return new BigQuerySQLTableOutput(this, targetPartition, warningsContext);
        }

        class BigQueryTableClauseSplit
        extends AbstractSQLTableDatasetHandler.TableClauseSplit {
            protected BigQueryTableClauseSplit(InputFilter filter) {
                super(filter);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long push(ProcessorOutput out, ColumnFactory cf, RowFactory rf, ExtractionLimit limit, InputSplitProgressListener listener, WarningsContext warningsContext) throws Exception {
                if (BigQuerySQLDatasetMeta.canUseDirectTablePreview(limit, BigQueryPartitionedSQLTableDatasetHandler.this.getConnectionData(), this.filter) && !BigQueryPartitionedSQLTableDatasetHandler.this.handlesSamplingMethodDuringPush(limit)) {
                    long l;
                    SQLConnectionProvider.SQLConnectionWrapper conn = BigQueryPartitionedSQLTableDatasetHandler.this.newConnection();
                    try {
                        boolean forbidPreviewFallbackToSelect = BigQuerySQLDatasetMeta.shouldForbidPreviewFallbackToSelect(BigQueryPartitionedSQLTableDatasetHandler.this.rawAbstractConfig);
                        String previewTablePseudoSQL = BigQuerySQLDatasetMeta.getPreviewTablePseudoSQL(limit, ((BigQueryPartitionedSQLTableDatasetHandler)BigQueryPartitionedSQLTableDatasetHandler.this).resolvedAbstractConfig.catalog, ((BigQueryPartitionedSQLTableDatasetHandler)BigQueryPartitionedSQLTableDatasetHandler.this).resolvedAbstractConfig.schema, ((BigQueryPartitionedSQLTableDatasetHandler)BigQueryPartitionedSQLTableDatasetHandler.this).resolvedAbstractConfig.table, forbidPreviewFallbackToSelect);
                        l = BigQueryPartitionedSQLTableDatasetHandler.this.executePush(conn, previewTablePseudoSQL, out, cf, rf, limit, listener, warningsContext, true);
                    }
                    catch (Throwable throwable) {
                        try {
                            logger.info((Object)"Exited push");
                            SQLUtils.unsafeRollbackAndClose(conn);
                            throw throwable;
                        }
                        catch (SQLException e) {
                            throw SQLExceptionsParser.newDatastoreIOException("Failed to read data from table", BigQueryPartitionedSQLTableDatasetHandler.this.getConnectionData(), e, true);
                        }
                    }
                    logger.info((Object)"Exited push");
                    SQLUtils.unsafeRollbackAndClose(conn);
                    return l;
                }
                return super.push(out, cf, rf, limit, listener, warningsContext);
            }
        }

        class BigQueryTablePartitionSplit
        extends PartitionedSQLTableDatasetHandler.TablePartitionSplit {
            BigQueryTablePartitionSplit(@Nullable Partition partition, InputFilter filter) {
                super(partition, filter);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long push(ProcessorOutput out, ColumnFactory cf, RowFactory rf, ExtractionLimit limit, InputSplitProgressListener listener, WarningsContext warningsContext) throws Exception {
                if (BigQueryPartitionedSQLTableDatasetHandler.this.partitionSchemeMatchesBigQuery() && BigQuerySQLDatasetMeta.canUseDirectTablePreview(limit, BigQueryPartitionedSQLTableDatasetHandler.this.getConnectionData(), this.filter) && !BigQueryPartitionedSQLTableDatasetHandler.this.handlesSamplingMethodDuringPush(limit)) {
                    long l;
                    String partitionWhereClause = "";
                    try {
                        List<ExpressionBuilder> partitionClauses = super.generateClauses(QueryAst.SampleClause.sampleClause(limit));
                        if (partitionClauses.size() != 1) {
                            logger.warnV("Expected exactly one partition dimension for BigQuery preview, but found {}", new Object[]{partitionClauses.size()});
                        } else {
                            partitionWhereClause = partitionClauses.get(0).toSQL(BigQueryPartitionedSQLTableDatasetHandler.this.getDialect());
                        }
                    }
                    catch (SQLException e) {
                        logger.warnV("Failed to generate the partition WHERE clause for preview table pseudo-SQL", new Object[]{e});
                    }
                    catch (DKUSecurityException e) {
                        logger.warnV("Failed to get dialect to generate partition WHERE clause for preview table pseudo-SQL", new Object[]{e});
                    }
                    if (StringUtils.isBlank((CharSequence)partitionWhereClause)) {
                        logger.warn((Object)"Could not generate the partition WHERE clause for preview table pseudo-SQL, falling back to standard SQL query");
                        return super.push(out, cf, rf, limit, listener, warningsContext);
                    }
                    SQLConnectionProvider.SQLConnectionWrapper conn = BigQueryPartitionedSQLTableDatasetHandler.this.newConnection();
                    try {
                        boolean forbidPreviewFallbackToSelect = BigQuerySQLDatasetMeta.shouldForbidPreviewFallbackToSelect(BigQueryPartitionedSQLTableDatasetHandler.this.rawAbstractConfig);
                        String previewTablePseudoSQL = BigQuerySQLDatasetMeta.getPreviewTablePseudoSQL(limit, ((BigQueryPartitionedSQLTableDatasetHandler)BigQueryPartitionedSQLTableDatasetHandler.this).resolvedAbstractConfig.catalog, ((BigQueryPartitionedSQLTableDatasetHandler)BigQueryPartitionedSQLTableDatasetHandler.this).resolvedAbstractConfig.schema, ((BigQueryPartitionedSQLTableDatasetHandler)BigQueryPartitionedSQLTableDatasetHandler.this).resolvedAbstractConfig.table, forbidPreviewFallbackToSelect, this.partition, partitionWhereClause);
                        l = BigQueryPartitionedSQLTableDatasetHandler.this.executePush(conn, previewTablePseudoSQL, out, cf, rf, limit, listener, warningsContext, true);
                    }
                    catch (Throwable throwable) {
                        try {
                            logger.info((Object)"Exited push");
                            SQLUtils.unsafeRollbackAndClose(conn);
                            throw throwable;
                        }
                        catch (SQLException e) {
                            throw SQLExceptionsParser.newDatastoreIOException("Failed to read data from table", BigQueryPartitionedSQLTableDatasetHandler.this.getConnectionData(), e, true);
                        }
                    }
                    logger.info((Object)"Exited push");
                    SQLUtils.unsafeRollbackAndClose(conn);
                    return l;
                }
                return super.push(out, cf, rf, limit, listener, warningsContext);
            }
        }
    }

    private static class BigQueryUnpartitionedSQLTableDatasetHandler
    extends UnpartitionedSQLTableDatasetHandler {
        public BigQueryUnpartitionedSQLTableDatasetHandler(AuthCtx authCtx, Dataset dataset, DatasetHandler.DatasetMeta<?, ?> meta) {
            super(authCtx, dataset, meta);
        }

        @Override
        public RowsInputSplit getSingleSplit() throws Exception {
            if (!this.rawAbstractConfig.variablesExpansionLoopConfig.isEnabled()) {
                return new BigQueryTableClauseSplit(null);
            }
            ArrayList<BigQueryTableClauseSplit> loopIterations = new ArrayList<BigQueryTableClauseSplit>();
            for (JsonObject jo : new VariablesExpansionLoopItemsIterable(this.authCtx, this.dataset.getProjectKey(), this.rawAbstractConfig.variablesExpansionLoopConfig)) {
                AutoCloseable ignored = DynamicLevelsStack.withLevel(jo);
                try {
                    loopIterations.add(new BigQueryTableClauseSplit(null));
                }
                finally {
                    if (ignored == null) continue;
                    ignored.close();
                }
            }
            return new RowSequenceInputSplit(loopIterations);
        }

        @Override
        public RowsInputSplit getSampleSplit() throws Exception {
            try (AutoCloseable ignored = DynamicLevelsStack.withLevel(this.createVELoopSampleIterationFailIfNone());){
                BigQueryTableClauseSplit bigQueryTableClauseSplit = new BigQueryTableClauseSplit(null);
                return bigQueryTableClauseSplit;
            }
        }

        @Override
        public Output buildOutput(Partition targetPartition, int targetSplit, int resplitFactor, WarningsContext warningsContext) throws Exception {
            ConnectionUtils.checkConnectionWritable(this.authCtx, this.resolvedAbstractConfig.connection);
            assert (targetSplit == 0);
            SQLViaCloudAutoFastPathOutput fp = new SQLViaCloudAutoFastPathBuilder().buildIfCanUseAutoFastPath(this, targetPartition, warningsContext);
            if (fp != null) {
                logger.info((Object)"Using automatic fast-write SQL output");
                return fp;
            }
            logger.info((Object)"Using SQL output based on the BigQuery Storage Write API");
            return new BigQuerySQLTableOutput(this, targetPartition, warningsContext);
        }

        class BigQueryTableClauseSplit
        extends AbstractSQLTableDatasetHandler.TableClauseSplit {
            protected BigQueryTableClauseSplit(InputFilter filter) {
                super(filter);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long push(ProcessorOutput out, ColumnFactory cf, RowFactory rf, ExtractionLimit limit, InputSplitProgressListener listener, WarningsContext warningsContext) throws Exception {
                if (BigQuerySQLDatasetMeta.canUseDirectTablePreview(limit, BigQueryUnpartitionedSQLTableDatasetHandler.this.getConnectionData(), this.filter) && !BigQueryUnpartitionedSQLTableDatasetHandler.this.handlesSamplingMethodDuringPush(limit)) {
                    long l;
                    SQLConnectionProvider.SQLConnectionWrapper conn = BigQueryUnpartitionedSQLTableDatasetHandler.this.newConnection();
                    try {
                        boolean forbidPreviewFallbackToSelect = BigQuerySQLDatasetMeta.shouldForbidPreviewFallbackToSelect(BigQueryUnpartitionedSQLTableDatasetHandler.this.rawAbstractConfig);
                        String previewTablePseudoSQL = BigQuerySQLDatasetMeta.getPreviewTablePseudoSQL(limit, this.configWithJITResolvedTableLoc.catalog, this.configWithJITResolvedTableLoc.schema, this.configWithJITResolvedTableLoc.table, forbidPreviewFallbackToSelect);
                        l = BigQueryUnpartitionedSQLTableDatasetHandler.this.executePush(conn, previewTablePseudoSQL, out, cf, rf, limit, listener, warningsContext, true);
                    }
                    catch (Throwable throwable) {
                        try {
                            logger.info((Object)"Exited push");
                            SQLUtils.unsafeRollbackAndClose(conn);
                            throw throwable;
                        }
                        catch (SQLException e) {
                            throw SQLExceptionsParser.newDatastoreIOException("Failed to read data from table", BigQueryUnpartitionedSQLTableDatasetHandler.this.getConnectionData(), e, true);
                        }
                    }
                    logger.info((Object)"Exited push");
                    SQLUtils.unsafeRollbackAndClose(conn);
                    return l;
                }
                return super.push(out, cf, rf, limit, listener, warningsContext);
            }
        }
    }
}

