/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.db;

import com.dataiku.dip.db.AbstractDSSDBService;
import com.dataiku.dip.db.DSSDBConnection;
import com.dataiku.dip.db.DSSDBConnectionsManagementService;
import com.dataiku.dip.db.InsertBatchStatementBuilder;
import com.dataiku.dip.db.SingleH2DatabaseConnectionsFactory;
import com.dataiku.dip.exceptions.CodedSQLException;
import com.dataiku.dip.sql.H2SQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import java.io.File;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class FromH2Copier {
    private final AbstractDSSDBService involvedService;
    private final String name;
    private final DSSDBConnectionsManagementService.ConnectionPool sourceDBConnectionPool;
    private boolean h2DBFileExists;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.internal.db.migration");

    public FromH2Copier(AbstractDSSDBService involvedService, File sourceH2File) throws Exception {
        this.involvedService = involvedService;
        this.name = involvedService.getName();
        logger.debugV("Initialize FromH2Copier from %s for service %s", new Object[]{sourceH2File, this.name});
        String jdbcUrl = DSSDBConnectionsManagementService.buildH2JdbcUrl(this.name, false, involvedService.getDBRef().h2File, involvedService.getDBRef().lockTimeout, involvedService.getDBRef().nameForConfigKey);
        SingleH2DatabaseConnectionsFactory sourceDBConnectionsFactory = new SingleH2DatabaseConnectionsFactory("copy-" + this.name, "copy-" + involvedService.getDBRef().nameForConfigKey, jdbcUrl);
        this.sourceDBConnectionPool = new DSSDBConnectionsManagementService.ConnectionPool(sourceDBConnectionsFactory);
        try {
            this.h2DBFileExists = sourceDBConnectionsFactory.getDBFile(sourceH2File).exists();
        }
        catch (CodedSQLException e) {
            logger.debug((Object)"No H2 db file found.", (Throwable)e);
            this.h2DBFileExists = false;
        }
        logger.debugV("Retrieving current version for H2 database %s", new Object[]{sourceH2File});
        this.retrieveCurrentH2DBVersion();
    }

    private DSSDBConnection getH2Connection() throws Exception {
        return this.sourceDBConnectionPool.borrowObject();
    }

    public void copyToTarget(String sourceTableName, SQLUtils.SQLTable targetTable, DSSDBConnection targetConnection, SQLDialect targetDialect) throws Exception {
        if (!this.h2DBFileExists) {
            logger.debugV("No existing H2 timeline db to migrate for: %s.", new Object[]{this.name});
            return;
        }
        logger.debugV("Starting to copy table %s -> %s of connection %s", new Object[]{sourceTableName, targetTable, targetConnection});
        try (DSSDBConnection newH2DBConnection = this.getH2Connection();){
            int count;
            try (Statement st2 = newH2DBConnection.createStatement();
                 ResultSet rs2 = st2.executeQuery("SELECT count(*) from " + new H2SQLDialect().quoteIdentifier(sourceTableName));){
                boolean ret = rs2.next();
                assert (ret);
                count = rs2.getInt(1);
            }
            logger.infoV("Have %d records to copy", new Object[]{count});
            SelectQueryBuilder selectAllQueryBuilder = new SelectQueryBuilder();
            selectAllQueryBuilder.from(sourceTableName);
            selectAllQueryBuilder.select("*");
            PreparedStatement ps2 = newH2DBConnection.prepareNonPersistedStatement(selectAllQueryBuilder.toSQL(new H2SQLDialect()));
            ps2.execute();
            ResultSet recordsFromH2DB = ps2.getResultSet();
            try {
                InsertBatchStatementBuilder.insert(recordsFromH2DB).to(targetConnection, targetTable, targetDialect).exec("table=" + String.valueOf(targetTable), count, sourceTableName);
                targetConnection.commit();
            }
            catch (SQLException e) {
                throw ExceptionUtils.newSQLExceptionWithNestedMessages((SQLException)e);
            }
        }
        logger.debugV("Finished migration of existing db: %s.", new Object[]{this.name});
    }

    public void createTablesIfNeeded() throws SQLException {
        int targetCurrentSchemaVersion = this.getTargetCurrentSchemaVersion();
        if (targetCurrentSchemaVersion == 0) {
            logger.debugV("Create tables for %s before import", new Object[]{this.involvedService.getName()});
            this.involvedService.create();
            logger.debugV("Tables created for %s before import.", new Object[]{this.involvedService.getName()});
        }
    }

    private int getTargetCurrentSchemaVersion() throws SQLException {
        try (DSSDBConnection connectionToExternalDB = this.involvedService.acquireConnection();){
            String internalId = AbstractDSSDBService.getInternalId(this.involvedService.getName());
            int currentExternalTableVersion = DSSDBConnectionsManagementService.getCurrentSchemaVersion(connectionToExternalDB, this.involvedService.resolveTable("DSS_SCHEMA_INFO"), internalId, this.involvedService.getDialect());
            logger.debugV("Current version for %s external table is: %s", new Object[]{internalId, currentExternalTableVersion});
            int n = currentExternalTableVersion;
            return n;
        }
    }

    private void retrieveCurrentH2DBVersion() throws Exception {
        if (!this.h2DBFileExists) {
            return;
        }
        try (DSSDBConnection newH2DBConnection = this.getH2Connection();){
            int currentH2Version = DSSDBConnectionsManagementService.getCurrentSchemaVersion(newH2DBConnection, new SQLUtils.SQLTable(null, null, "DSS_SCHEMA_INFO", true), AbstractDSSDBService.getInternalId(this.name), new H2SQLDialect());
            logger.debugV("Current version for H2 db is: %s", new Object[]{currentH2Version});
        }
    }
}

