/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.docgen.flow.placeholders.folder;

import com.dataiku.dip.docgen.flow.FlowDocumentContext;
import com.dataiku.dip.docgen.flow.FlowPlaceholder;
import com.dataiku.dip.docgen.helpers.PlaceholderOutputFactory;
import com.dataiku.dip.docgen.resolver.IterableDescription;
import com.dataiku.dip.docgen.resolver.PlaceholderExpectedException;
import com.dataiku.dip.docgen.resolver.PlaceholderOutput;
import com.dataiku.dip.managedfolder.KernelsManagedFolderService;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderHandler;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.DKUNumberUtils;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.Callable;
import org.springframework.beans.factory.annotation.Autowired;

public class FolderFileListIterable
implements FlowPlaceholder.IterablePlaceholder<ManagedFolder, ManagedFolderHandler.ManagedFolderListingItem> {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private KernelsManagedFolderService kernelsManagedFolderService;

    public FolderFileListIterable() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    @Override
    public IterableDescription<ManagedFolder, ManagedFolderHandler.ManagedFolderListingItem> getDescription() {
        return IterableDescription.iterablePlaceholder(ManagedFolder.class, ManagedFolderHandler.ManagedFolderListingItem.class, "$file");
    }

    @Override
    public Collection<ManagedFolderHandler.ManagedFolderListingItem> resolve(FlowDocumentContext flowDocumentContext, ManagedFolder folder) throws PlaceholderExpectedException {
        try {
            Callable<ManagedFolderHandler.ManagedFolderListing> listFS;
            try (Transaction t = this.transactionService.beginRead();){
                listFS = this.kernelsManagedFolderService.handleListFSRequest(null, folder.getProjectKey(), folder.getId());
            }
            return listFS.call().items;
        }
        catch (Exception e) {
            throw PlaceholderExpectedException.createWithLog("Error while listing file in the managed folder " + folder.getDisplayName(), e);
        }
    }

    public static class LastModifiedPlaceholder
    implements FilePlaceholder {
        @Override
        public PlaceholderOutput.Text resolve(FlowDocumentContext flowDocumentContext, ManagedFolderHandler.ManagedFolderListingItem file) throws PlaceholderExpectedException {
            return PlaceholderOutputFactory.makeDate(new Date(file.lastModified));
        }
    }

    public static class SizePlaceholder
    implements FilePlaceholder {
        @Override
        public PlaceholderOutput.Text resolve(FlowDocumentContext flowDocumentContext, ManagedFolderHandler.ManagedFolderListingItem file) throws PlaceholderExpectedException {
            return new PlaceholderOutput.Text(DKUNumberUtils.printSmartBytesSize(file.size, flowDocumentContext.reportLocale));
        }
    }

    public static class PathPlaceholder
    implements FilePlaceholder {
        @Override
        public PlaceholderOutput.Text resolve(FlowDocumentContext flowDocumentContext, ManagedFolderHandler.ManagedFolderListingItem file) throws PlaceholderExpectedException {
            return new PlaceholderOutput.Text(file.path);
        }
    }

    private static interface FilePlaceholder
    extends FlowPlaceholder.TextPlaceholder<ManagedFolderHandler.ManagedFolderListingItem> {
        @Override
        default public Class<ManagedFolderHandler.ManagedFolderListingItem> getInputType() {
            return ManagedFolderHandler.ManagedFolderListingItem.class;
        }
    }
}

