/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.compute.computations.univariate;

import com.dataiku.dip.eda.compute.computations.AvailableResult;
import com.dataiku.dip.eda.compute.computations.Computation;
import com.dataiku.dip.eda.compute.distributions.Distribution;
import com.dataiku.dip.utils.ImmutableValueObject;
import javax.annotation.Nullable;

public class TestDistribution
extends Computation.UnivariateComputation {
    public static final String TYPE = "test_distribution";
    public Distribution.FittedDistribution distribution;

    public TestDistribution(String column, Distribution.FittedDistribution distribution) {
        this.column = column;
        this.distribution = distribution;
    }

    private TestDistribution() {
    }

    public static class TestDistributionResult
    extends AvailableResult {
        public StatTests test;
        public PlotData plot;

        @Override
        public int getEstimatedMemoryUsageBytes() {
            int nDoubles = this.plot.qq.empirical.length + this.plot.qq.percentile.length + this.plot.qq.theoretical.length;
            if (this.plot.pmf != null) {
                nDoubles += this.plot.pmf.probs.length + this.plot.pmf.xvals.length;
            }
            if (this.plot.pdf != null) {
                nDoubles += this.plot.pdf.probs.length + this.plot.pdf.xvals.length;
            }
            return 32 + 8 * nDoubles;
        }
    }

    public static class PlotData
    extends ImmutableValueObject {
        @Nullable
        public ProbabilityMassFunction pmf;
        @Nullable
        public ProbabilityDensityFunction pdf;
        public QQPlotData qq;
    }

    public static class QQPlotData
    extends ImmutableValueObject {
        double[] theoretical;
        double[] empirical;
        double[] percentile;
    }

    public static class StatTests
    extends ImmutableValueObject {
        @Nullable
        public KolmogorovSmirnovTestResult ks;
        public LikelihoodTestsResult ll;
    }

    public static class ProbabilityMassFunction
    extends ImmutableValueObject {
        public long[] xvals;
        public double[] probs;
    }

    public static class ProbabilityDensityFunction
    extends ImmutableValueObject {
        public double[] xvals;
        public double[] probs;
    }

    public static class LikelihoodTestsResult
    extends ImmutableValueObject {
        @Nullable
        public Double ll;
        @Nullable
        public Double bic;
        @Nullable
        public Double aic;
        @Nullable
        public Double aicc;
    }

    public static class KolmogorovSmirnovTestResult
    extends ImmutableValueObject {
        public double statistic;
        public double pvalue;
    }
}

