/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets.cards;

import com.dataiku.dip.eda.compute.computations.Computation;
import com.dataiku.dip.eda.compute.computations.ComputationResult;
import com.dataiku.dip.eda.compute.computations.univariate.MoodTestNSamp;
import com.dataiku.dip.eda.compute.grouping.Grouping;
import com.dataiku.dip.eda.worksheets.cards.bivariate_header.BivariateHistogramCard;
import com.dataiku.dip.eda.worksheets.cards.common.AbstractNSampTestCard;
import com.dataiku.dip.eda.worksheets.cards.common.CompiledCard;
import com.dataiku.dip.eda.worksheets.cards.common.RecipeCompatibleCard;
import com.dataiku.dip.eda.worksheets.models.Variable;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class MoodTestNSampCard
extends AbstractNSampTestCard
implements RecipeCompatibleCard {
    public static final String TYPE = "mood_nsamp";

    public MoodTestNSampCard(Variable xColumn, Variable yColumn, List<String> yValues, int maxGroups) {
        this.xColumn = xColumn;
        this.yColumn = yColumn;
        this.yValues = yValues;
        this.maxGroups = maxGroups;
    }

    private MoodTestNSampCard() {
    }

    @Override
    protected CompiledCard compileNoSplitNoFilter() {
        return new AbstractNSampTestCard.AbstractCompiledNSampTestCard(){

            @Override
            protected Computation getTestComputation(Grouping grouping) {
                return new MoodTestNSamp(MoodTestNSampCard.this.xColumn.name, grouping);
            }

            @Override
            protected MoodTestNSampCardResult buildTestCardResult(ComputationResult result, List<String> warnings, List<AbstractNSampTestCard.GroupInfo> groups, AbstractNSampTestCard.GroupInfo allGroups, BivariateHistogramCard.BivariateHistogramData histogramData) {
                MoodTestNSamp.MoodTestNSampResult mood = result.as(MoodTestNSamp.MoodTestNSampResult.class);
                ImmutableList allWarnings = ImmutableList.builder().addAll(result.collectWarnings()).addAll(warnings).build();
                return new MoodTestNSampCardResult((List<String>)allWarnings, groups, allGroups, histogramData, mood.pvalue, mood.statistic);
            }
        };
    }

    public static class MoodTestNSampCardResult
    extends AbstractNSampTestCard.AbstractNSampleTestCardResult {
        public double pvalue;
        public double statistic;

        public MoodTestNSampCardResult(List<String> warnings, List<AbstractNSampTestCard.GroupInfo> groups, AbstractNSampTestCard.GroupInfo allGroups, BivariateHistogramCard.BivariateHistogramData histogramData, double pvalue, double statistic) {
            this.warnings = warnings;
            this.groups = groups;
            this.allGroups = allGroups;
            this.histogramData = histogramData;
            this.pvalue = pvalue;
            this.statistic = statistic;
        }

        private MoodTestNSampCardResult() {
        }
    }
}

